# -*- coding: UTF-8 -*-
from cbb.frame.base import baseUtil
from cbb.frame.context import contextUtil
from cbb.frame.tlv import tlvData

from cbb.business.operate.fru.common import common
from cbb.business.operate.fru.common.checkItem.check_cli_host_red_link import CheckItem


def execute(context, **kwargs):
    """检查前端链路冗余

    :param context(dict): python执行上下文
    :param kwargs(dict): 可变参数dict
    :return: dict: 检查结果 ,格式：{"succ":True,"errMsg":"","suggestion":""}
    """
    logger = baseUtil.getLogger(context.get("logger"), __file__)
    try:
        LIMIT_TIME = 120
        # 进度条
        common.threadUpProcess(context, LIMIT_TIME)

        resultDict = {"flag": True, "errMsg": "", "suggestion": ""}
        rest = contextUtil.getRest(context)
        cli = contextUtil.getCli(context)

        if not kwargs:
            return resultDict
        fruType = kwargs.get("fruType", "")
        fruId = kwargs.get("fruId", "")
        location = kwargs.get("location", "")

        contextUtil.setItem(context, "FRU_OBJ", int(fruType))
        contextUtil.setItem(context, "FRU_LOCATION", location)
        contextUtil.setItem(context, "FRU_ID", fruId)
        item = CheckItem(cli, rest, context)
        item.check()
        result, errMsg, suggustion = item.getResult()
        if not result:
            logger.logNoPass("The front link is not redunt.")
            resultDict["flag"] = False
            resultDict["errMsg"] = errMsg
            resultDict["suggestion"] = suggustion
            contextUtil.handleFailure(context, resultDict)
            return

        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
    finally:
        # 进度条刷为完成状态
        common.finishProcess(context)
