# -*- coding: UTF-8 -*-
from cbb.business.operate.fru.common import BaseFactory
from cbb.business.operate.fru.common import FuncFactory
from cbb.business.operate.fru.common import constData
from cbb.frame.rest import restData
from cbb.frame.rest import restUtil

'''
冗余控制器检查

'''


def execute(context, **kwargs):
    """冗余控制器检查
    检查模块所在的控制器是否具有冗余控制器。

    :param context(dict): python执行上下文
    :param kwargs(dict): 可变参数dict
    :return: dict: 检查结果 ,格式：{"succ":True,"errMsg":"","suggestion":""}
    """

    fru_type = kwargs.get("fruType", "") if kwargs else ""
    ctr_id = kwargs.get("ctrId", "") if kwargs else ""
    if not all([fru_type, ctr_id]):
        BaseFactory.result.setResultPass(context)
        return

    BaseFactory.log.info(context, "ctrId = " + str(ctr_id))
    # 获取冗余控制器，若不存在则检查不通过
    pro_model = FuncFactory.getSystemProductType(context)
    if BaseFactory.const.SYSMODEL["V3_18000"] == pro_model:  # 框下冗余
        red_cntr_recs = FuncFactory.getUsableRedCntr(context, ctr_id, falseEngTrueEnc=True,
                                                   fruType=restData.Enum.ObjEnum.FAN)
    else:  # 引擎内冗余
        red_cntr_recs = FuncFactory.getUsableRedCntr(context, ctr_id, falseEngTrueEnc=False,
                                                   fruType=restData.Enum.ObjEnum.FAN)

    BaseFactory.log.info(context, "redCntrRecs is :" + str(red_cntr_recs))
    if None != red_cntr_recs:
        BaseFactory.result.setResultPass(context)
        return True
    else:
        BaseFactory.result.setResultFailByKey(context, FuncFactory.LangKey.CNTR_EXISTED_NONE_REDT_CNTR)
        return False
