# -*- coding: UTF-8 -*-
from cbb.business.operate.fru.common import BaseFactory
from cbb.business.operate.fru.common import FuncFactory
from cbb.business.operate.fru.common import QuorumFunction
from cbb.frame.rest import restData
from cbb.frame.context import contextUtil

def execute(context, **kwargs):
    """冗余仲裁链路检查
    检查前端接口模块是否存在冗余仲裁链路

    :param context(dict): python执行上下文
    :param kwargs(dict): 可变参数dict
    :return: dict: 检查结果 ,格式：{"succ":True,"errMsg":"","suggestion":""}
    """
    BaseFactory.log.info(context, u"==========begin checkRedundantQuorumLink==========")

    try:
        rest = contextUtil.getRest(context)
        fruId = kwargs.get("fruId", "") if kwargs else ""
        fruType = kwargs.get("fruType", "") if kwargs else ""
        BaseFactory.log.info(context, "fru id: %s, fru type: %s" % (fruId, fruType))
        if not fruId:
            BaseFactory.result.setResultPass(context)
            return
        checkRes = QuorumFunction.QuorumCommon.checkRedundantQuorumServLink(rest, fruType, fruId)
        BaseFactory.log.info(context, "QuorumServLink is : %s" % str(checkRes))
        if checkRes[0]:
            BaseFactory.result.setResultPass(context)
        else:
            errorParam = ", ".join(checkRes[1])
            BaseFactory.result.setResultFailByKey(context, FuncFactory.LangKey.PUBSUG_REDT_QUORUM_LINK_NOT_EXIST,
                                                  errorParam)

    except Exception as ex:
        BaseFactory.exception.handler(context, ex)

    return
