# -*- coding: UTF-8 -*-
from cbb.business.operate.fru.common import BaseFactory
from cbb.business.operate.fru.common import FuncFactory
from cbb.frame.cli import cliUtil
from cbb.frame.context import contextUtil
from cbb.business.operate.checkitems.check_required_hot_patch import get_patch_ver_digital


RISK_VERSION = ("6.0.RC1", "6.0.0")
REQUIRED_VERSION = "6.0.1"
REQUIRED_PATCH = "SPH2"
HOT_PATCH_NOT_EXISTS = ("", "--")


def execute(context, location_id):
    """
    接口模块运行模式检查
    检查接口卡运行模式（Run Mode）
    :param context: 上下文
    :param location_id: 待更换接口卡ID
    :return:
    """
    try:
        BaseFactory.log.info(context,
                             "check the run mode of interface modules")
        cli = contextUtil.getCli(context)
        lang = contextUtil.getLang(context)

        # 检查版本
        cli_result, is_pass = check_version(cli, lang, context)
        if cli_result and is_pass:
            BaseFactory.result.setResultPass(context)
            return
        if not cli_result and not is_pass:
            return

        # 检查接口卡运行模式（Run Mode）
        if check_run_mode(cli, lang, context, location_id):
            BaseFactory.result.setResultPass(context)
        return
    except Exception as exception:
        BaseFactory.log.error(
            context,
            "failed to check the run mode of interface modules, exception={}"
            .format(str(exception)))
        BaseFactory.result.setResultFailByKey(
            context, FuncFactory.LangKey.PUBERR_UNEXPECTED_TOOL_ERROR)
        return


def check_run_mode(cli, lang, context, location_id):
    """
    检查接口卡运行模式（Run Mode）
    :param cli: ssh连接
    :param lang: 语言
    :param context: 上下文
    :param location_id: 待更换接口卡ID
    :return: 是否通过
    """
    cmd = "show interface_module interface_module_id=%s"

    flag, cli_ret, error_msg = cliUtil.execCmdInCliMode(
        cli, cmd % location_id, True, lang)
    if not flag:
        BaseFactory.log.info(context, "failed to query the interface_module.")
        BaseFactory.result.setResultFailByKey(
            context, FuncFactory.LangKey.EXEC_CLI_CMD_FAIL)
        return False

    # 解析回显
    line_list = cliUtil.getVerticalCliRet(cli_ret)
    run_mode = line_list[0].get("Run Mode")
    if run_mode == "RoCE":
        BaseFactory.result.setResultFailByKey(
            context, FuncFactory.LangKey.FRU_INTERFACE_MODULE_NEED_UPG_SPH2
        )
        return False
    return True


def check_version(cli, lang, context):
    """
    检查软件的版本
    :param cli: ssh连接
    :param lang: 语言
    :param context: 上下文
    :return: 布尔类型，第一个为回显是否异常，第二个为是否通过
    """
    flag, software_version, hot_patch_version = cliUtil.getSystemVersion(cli,
                                                                         lang)
    if not flag:
        BaseFactory.log.info(context, "failed to query the soft_version.")
        BaseFactory.result.setResultFailByKey(
            context, FuncFactory.LangKey.EXEC_CLI_CMD_FAIL)
        return False, False
    if any([software_version in RISK_VERSION,
            software_version == REQUIRED_VERSION and
            (get_patch_ver_digital(hot_patch_version) < get_patch_ver_digital(REQUIRED_PATCH) or
             hot_patch_version in HOT_PATCH_NOT_EXISTS)
            ]):
        return True, False
    return True, True
