# -*- coding: UTF-8 -*-
from cbb.frame.checkitem.base_dsl_check import CheckStatus
from cbb.business.operate.fru.common import BaseFactory
from cbb.frame.context import contextUtil

# 此为统一context而存在，统一的context格式如下
# context={"dev": "xx"}


class InspectContext:
    def __init__(self, java_env, cli=None):
        self.origin_context = java_env
        self.tool_type = "inspect"
        self.logger = java_env.get("logger")
        self.cli = cli

    def get_context(self):
        import com.huawei.ism.tool.obase.entity.EntityUtils as EntityUtils
        from com.huawei.ism.tool.bizpack.wizardparse.util import DevNodeUtil
        new_context = contextUtil.getContext(self.origin_context)
        if not new_context:
            new_context = dict()
        self.origin_context['tool_type'] = self.tool_type
        new_context["logger"] = self.logger

        new_context["lang"] = self.origin_context.get("lang")
        dev_node = self.origin_context.get("devInfo")
        new_dev_node = EntityUtils.toNewDev(dev_node)
        new_context['newEncBom'] = self.origin_context.get("newEncBom")
        new_context['newCtrlBom'] = self.origin_context.get("newCtrlBom")
        new_context['dev'] = DevNodeUtil.getDevMapDict(new_dev_node)
        new_context['devInfo'] = new_dev_node
        new_context['cli'] = self.cli
        new_context["tool_type"] = self.tool_type
        return new_context

    def get_logger(self):
        return self.logger

    def get_result(self, status, err_msg, cli_ret):
        result_dict = {
            CheckStatus.PASS: True,
            CheckStatus.NOTPASS: False,
            CheckStatus.NOCHECK: "NOCHECK",
            CheckStatus.NO_SUPPORT: "NOSUPPORT",
            CheckStatus.WARNING: "WARNING",
        }
        return result_dict.get(status), cli_ret, err_msg


class UpgradeEvalContext:
    def __init__(self, context):
        self.context = context
        self.logger = context.get("logger")
        self.tool_type = "upgrade_eval"

    def get_context(self):
        self.context['tool_type'] = self.tool_type
        self.context["cli"] = contextUtil.getCliCommon(self.context)
        return self.context

    def get_logger(self):
        return self.logger

    def get_result(self, status, err_msg, cli_ret):
        result_dict = {
            CheckStatus.PASS: "0",
            CheckStatus.NOTPASS: "1",
            CheckStatus.NOCHECK: "2",
            CheckStatus.NO_SUPPORT: "3",
            CheckStatus.WARNING: "4",
        }
        return result_dict.get(status), cli_ret, err_msg


class FruContext:
    def __init__(self, context):
        self.origin_context = context
        self.logger = context.get("logger")
        self.tool_type = "fru"
        self.fru_context = {
            "logger": context.get("logger"),
            "lang": context.get("lang"),
            "dev": context.get("dev"),
            "devNode0": context.get("devNode0")
        }

    def get_context(self):
        self.origin_context['tool_type'] = self.tool_type
        self.origin_context["cli"] = contextUtil.getCli(self.origin_context)
        return self.origin_context

    def get_logger(self):
        return self.logger

    def get_result(self, status, err_msg, suggestion):
        from cbb.frame.context import contextUtil
        if status in [CheckStatus.PASS, CheckStatus.NO_SUPPORT]:
            BaseFactory.result.setResultPass(self.origin_context)
            return
        result_dict = dict()
        result_dict["flag"] = False
        result_dict["errMsg"] = err_msg
        result_dict["suggestion"] = suggestion
        contextUtil.handleFailure(self.origin_context, result_dict)


class PatchContext:
    def __init__(self, context):
        self.origin_context = context
        self.logger = context.get("logger")
        self.tool_type = "patch"

    def get_context(self):
        self.origin_context['tool_type'] = self.tool_type
        self.origin_context["cli"] = contextUtil.getCliCommon(self.origin_context)
        return self.origin_context

    def get_logger(self):
        return self.logger

    def get_result(self, status, err_msg):
        result_dict = {
            CheckStatus.PASS: True,
            CheckStatus.NOTPASS: False,
            CheckStatus.NOCHECK: False,
            CheckStatus.NO_SUPPORT: True,
            CheckStatus.WARNING: False,
        }
        return result_dict.get(status), err_msg


class ExpansionContext:
    def __init__(self, context):
        self.origin_context = context
        self.logger = context.get("logger")
        self.tool_type = "expansion"

    def get_context(self):
        return self.origin_context

    def get_logger(self):
        return self.logger

    def get_result(self, status, err_msg):
        raise NotImplementedError
