# -*- coding: UTF-8 -*-

#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

import cbb.frame.base.resource as resource

NEED_NEW_CTRL_CONN = "need_new_ctrl_conn"


def get_vertical_ret(cli_ret):
    from cbb.frame.cli.cliUtil import getVerticalCliRet
    ret = getVerticalCliRet(cli_ret)
    if isinstance(ret, list) and len(ret) > 0:
        return ret[0]
    return {}


def get_vertical_list_ret(cli_ret):
    from cbb.frame.cli.cliUtil import getVerticalCliRet
    ret = getVerticalCliRet(cli_ret)
    if isinstance(ret, list) and len(ret) > 0:
        return ret
    return []


def get_horizontal_ret(cli_ret):
    from cbb.frame.cli.cliUtil import getHorizontalCliRet
    return getHorizontalCliRet(cli_ret)


def get_diagnose_desc(logger, lang, diagnose):
    from cbb.frame.base.baseUtil import getPyResource
    logger.info(str(diagnose.error_code))
    error_key = "diagnose.code." + str(diagnose.error_code)
    err_msg = getPyResource(lang, error_key)
    if diagnose.params and len(diagnose.params) > 0:
        err_msg = getPyResource(lang, error_key).format(diagnose.params)
    controller = "[{}]:".format(diagnose.ctrl)
    return controller + err_msg


def get_con(context, allow_not_admin=False, conn_to_ctrl=True):
    """
    获取cli连接
    :param context: context
    :param allow_not_admin: 是否允许获取到非admin模式下的连接
    :param conn_to_ctrl 是否需要连接至控制器
    如果允许，则获取到的cli可能处于debug/minisystem/developer/admin模式；
    如果不允许，则获取到的cli如果处于非admin/developer模式时会进行一次断开再重新连接的操作
    :return:
    """
    from cbb.frame.cli.cli_con_mgr import get_ctrl_cli, get_available_conn
    cli = context.get('cli')
    if conn_to_ctrl:
        return get_ctrl_cli(context, cli, allow_not_admin)
    return get_available_conn(context, cli, allow_not_admin)


def exec_cli(cli, cmd, lang="zh"):
    from cbb.frame.cli.cli_helper import exec_cli
    lock = cli.getLock()
    try:
        lock.lock()
        flag, cli_ret, err_msg = exec_cli(cli, cmd, lang)
        return flag, cli_ret
    finally:
        lock.unlock()


def exec_developer(cli, cmd, lang="zh"):
    from cbb.frame.cli.cli_helper import exec_developer
    lock = cli.getLock()
    try:
        lock.lock()
        flag, cli_ret, err_msg = exec_developer(cli, cmd, lang, None)
        return flag, cli_ret
    finally:
        lock.unlock()


def exec_diagnose(cli, cmd, lang="zh"):
    from cbb.frame.cli.cli_helper import exec_diagnose
    lock = cli.getLock()
    try:
        lock.lock()
        flag, cli_ret, err_msg = exec_diagnose(cli, cmd, lang, None)
        return flag, cli_ret
    finally:
        lock.unlock()


def exec_mini_system(cli, cmd, lang="zh"):
    from cbb.frame.cli.cli_helper import exec_mini_system
    lock = cli.getLock()
    try:
        lock.lock()
        flag, cli_ret, err_msg = exec_mini_system(cli, cmd, lang, None)
        return flag, cli_ret
    finally:
        lock.unlock()


def exec_log_dsl(context, cause_id, log_type='DEFAULT'):
    sn = get_sn(context)
    result = context.get("treeAnalyser").queryAnalyseResult(sn, cause_id, log_type)

    if result and result.getMatchLogs():
        return True, [log.getContent() for log in result.getMatchLogs()], result.getVariables()
    return False, "", ""


def exec_rest(context, uri, method):
    from cbb.frame.context.contextUtil import getRest
    from cbb.frame.rest.restUtil import CommonRestService
    rest = getRest(context)
    if method == "get":
        return CommonRestService.get(rest, uri)
    raise Exception


def get_logger(context):
    return context.get("logger")


def get_lang(context):
    from cbb.frame.context.contextUtil import getLang
    return getLang(context)


def get_dev_type(context):
    return get_dev(context).get("type")


def get_dev_version(context):
    return get_dev(context).get("version")


def get_dev_patch_version(context):
    return get_dev(context).get("patchVersion")


def save_result(sn, cmd, value, node=""):
    # noinspection PyUnresolvedReferences
    from com.huawei.ism.tool.fdt.cache import CommandRecordService
    CommandRecordService.getInstance().saveWithDelDuplicated(sn, cmd, value, node)
    CommandRecordService.getInstance().commit()


def get_result(sn, cmd, node=""):
    # noinspection PyUnresolvedReferences
    from com.huawei.ism.tool.fdt.cache import CommandRecordService
    return CommandRecordService.getInstance().getCmdRet(sn, cmd, node)


def get_dev(context):
    """获取上下文对象中dev对象

    :param context: 上下文对象
    :return:
    """
    from java.util import Map
    dev_obj = context.get("dev")
    if isinstance(dev_obj, Map):
        return dev_obj
    return context.get('newDev')


def get_sn(context):
    return get_dev(context).get("sn")


def get_msg(lang, msg, args="", resource=resource.MESSAGES_DICT):
    """消息国际化

    :param lang: 语言lang
    :param msg: 消息
    :param args: 消息参数
    :param resource: 消息字典
    :return: 经过国际化处理后的消息
    """
    errMsg = "--"
    # noinspection PyBroadException
    try:
        if msg not in resource.keys():
            return errMsg

        localeDict = resource.get(msg)
        if lang not in localeDict.keys():
            return errMsg

        localeMsg = localeDict.get(lang)
        if "%s" in localeMsg or "%i" in localeMsg:
            return localeMsg % args
        else:
            return localeMsg

    except Exception:
        return errMsg


def exec_on_all(dsl_context):
    from cbb.frame.base import baseUtil
    from cbb.frame.context import contextUtil
    from cbb.frame.cli import cli_helper
    from cbb.frame.cli.execute_on_all_controllers import (
        ExecuteOnAllControllers,
        ExeOnAllCtrlContext,
        FuncResult,
        ResultType
    )

    trans_node_id = False
    if "need_node_id" in dsl_context.kwargs:
        trans_node_id = dsl_context.kwargs.get("need_node_id")

    @ExecuteOnAllControllers
    def _fun(exe_context):
        # 从原始context中取出传入的实际参数，包括函数名和函数的入参
        context = exe_context.original_context
        args = context["args"]
        func = args[0]
        params = args[1:]
        logger = contextUtil.getLogger(context)
        ctrl_num = context["ctrl_num"]
        ctrl_id = ""
        dsl_context.context['current_exec_node'] = exe_context.cur_ctrl_id
        try:
            result = func(*params)
            logger.info(
                "exe_context.cur_ctrl_id:{},ctrl_num:{}".format(
                    exe_context.cur_ctrl_id, ctrl_num))
            if trans_node_id is True:
                ctrl_id = baseUtil.get_ctrl_id_by_node_id(
                    int(exe_context.cur_ctrl_id),
                    int(ctrl_num))
            else:
                ctrl_id = exe_context.cur_ctrl_id
            logger.info("ctrl_id:{}".format(ctrl_id))
            context["ctrl_results"][ctrl_id] = result
        except Exception as exception:
            logger.error("Exception:{}".format(exception))
            context["ctrl_results"][ctrl_id] = None
        finally:
            dsl_context.context['current_exec_node'] = ''
        return FuncResult(ResultType.SUCCESS, need_continue_exe=True)

    lang = contextUtil.getLang(dsl_context.context)
    cli = get_con(dsl_context.context, True)
    ctrl_num = get_ctrl_num_one_engine(dsl_context, cli)
    dsl_context.context["ctrl_num"] = ctrl_num
    cli_helper.enter_target_mode(cli, cli_helper.CliMode.CLI, lang)
    dsl_context.context["ctrl_results"] = {}
    dsl_context.context["args"] = dsl_context.args
    exe_context = ExeOnAllCtrlContext(dsl_context.context)
    if "target_ctrl" in dsl_context.kwargs:
        target_ctrl = dsl_context.kwargs.get("target_ctrl")
        if isinstance(target_ctrl, dict):
            exe_context.set_target_ctrl_dict(target_ctrl)
        if "master" == target_ctrl:
            exe_context.set_target_engine_ctrl()
    if "mode" in dsl_context.kwargs:
        exe_context.set_cur_mode(dsl_context.kwargs.get("mode"))

    _fun(exe_context)
    return dsl_context.context["ctrl_results"]


def exec_on_all_of_mini_sys(dsl_context):
    from cbb.frame.base import baseUtil
    from cbb.frame.context import contextUtil
    from cbb.frame.cli.exec_on_all_even_mini_sys import (
        ExecuteOnAllControllers,
        ExeOnAllCtrlContext,
        FuncResult,
        ResultType
    )

    trans_node_id = False
    if "need_node_id" in dsl_context.kwargs:
        trans_node_id = dsl_context.kwargs.get("need_node_id")

    @ExecuteOnAllControllers
    def _fun(exe_context):
        # 从原始context中取出传入的实际参数，包括函数名和函数的入参
        context = exe_context.original_context
        args = context["args"]
        func = args[0]
        params = args[1:]
        logger = contextUtil.getLogger(context)
        ctrl_num = context["ctrl_num"]
        ctrl_id = ""
        dsl_context.context['current_exec_node'] = exe_context.cur_ctrl_id
        try:
            result = func(*params)
            logger.info(
                "exe_context.cur_ctrl_id:{},ctrl_num:{}".format(
                    exe_context.cur_ctrl_id, ctrl_num))
            if trans_node_id is True:
                ctrl_id = baseUtil.get_ctrl_id_by_node_id(
                    int(exe_context.cur_ctrl_id),
                    int(ctrl_num))
            else:
                ctrl_id = exe_context.cur_ctrl_id
            logger.info("ctrl_id:{}".format(ctrl_id))
            context["ctrl_results"][ctrl_id] = result
        except Exception as exception:
            logger.error("Exception:{}".format(exception))
            context["ctrl_results"][ctrl_id] = None
        finally:
            dsl_context.context['current_exec_node'] = ''
        return FuncResult(ResultType.SUCCESS, need_continue_exe=True)

    logger = contextUtil.getLogger(dsl_context.context)
    logger.info('enter exec_launch_fail_on_all_of_mini_sys dsl ...')
    cli = get_launch_fail_cli(dsl_context.context)
    # 获取当前控制器的数
    ctrl_num = get_ctrl_num_by_node_cfg(cli)
    logger.info('exec_on_all_of_mini_sys ctrl_num is {}'.format(ctrl_num))
    dsl_context.context["ctrl_num"] = ctrl_num

    dsl_context.context["ctrl_results"] = {}
    dsl_context.context["args"] = dsl_context.args
    exe_context = ExeOnAllCtrlContext(dsl_context.context)
    if "target_ctrl" in dsl_context.kwargs:
        target_ctrl = dsl_context.kwargs.get("target_ctrl")
        if isinstance(target_ctrl, dict):
            exe_context.set_target_ctrl_dict(target_ctrl)
        if "master" == target_ctrl:
            exe_context.set_target_engine_ctrl()

    _fun(exe_context)
    return dsl_context.context["ctrl_results"]


def get_ctrl_num_one_engine(dsl_context, cli):
    from cbb.frame.base import baseUtil
    from cbb.frame.cli import cliUtil
    if dsl_context.context.get('command_cache_enabled') is not True:
        flag, cli_response = exec_diagnose(cli, 'sys showcls')
    else:
        sn = get_sn(dsl_context.context)
        cli_response = get_result(sn, 'sys showcls')
        if not cli_response:
            flag, cli_response = exec_diagnose(cli, 'sys showcls')
            if flag is True:
                save_result(sn, 'sys showcls', cli_response)
    ctrl_rows = cliUtil.getHorizontalCliRet(cli_response)
    grouped_rows = baseUtil.group_by(ctrl_rows, 'engine')
    max_val = 2
    for key in grouped_rows:
        max_val = max(max_val, len(grouped_rows.get(key)))
    return max_val


def get_launch_fail_cli(context):
    from cbb.frame.cli.exec_on_all_even_mini_sys import ExeOnAllCtrlException
    cli = context.get('cli')
    from cbb.frame.context import contextUtil
    if cli is not None:
        return cli
    cli = contextUtil.getCliCommon(context)
    if cli is not None:
        return cli
    # fru
    cli = contextUtil.get_new_cli(context)
    if cli is not None:
        return cli
    raise ExeOnAllCtrlException("The cli and context's cli is None.")


def get_ctrl_num_by_node_cfg(cli):
    from cbb.frame.cli.exec_on_all_even_mini_sys import ExeOnAllCtrlException
    flag, cli_ret = exec_mini_system(cli, 'showsysstatus')
    if not flag:
        raise ExeOnAllCtrlException("Get ctrl num is fail.")
    ctrl_column = get_vertical_ret(cli_ret)
    return ctrl_column.get('node cfg', 2)
