# -*- coding: UTF-8 -*-
from cbb.frame.tlv import tlvDataType

REST_CMD_TIMEOUT = 120
REST_SCOPE_DEFAULT = "0"


##----------对象属性----------
class PublicAttributes():
    TYPE = {"key": "TYPE", "type": tlvDataType.DATA_TYPE_UNSIGN_INT}
    ID = {"key": "ID", "type": tlvDataType.DATA_TYPE_STRING}
    NAME = {"key": "NAME", "type": tlvDataType.DATA_TYPE_STRING}
    PARENT_TYPE = {"key": "PARENTTYPE", "type": tlvDataType.DATA_TYPE_ENUM}
    PARENT_ID = {"key": "PARENTID", "type": tlvDataType.DATA_TYPE_STRING}
    LOCATION = {"key": "LOCATION", "type": tlvDataType.DATA_TYPE_STRING}
    HEALTH_STATUS = {"key": "HEALTHSTATUS", "type": tlvDataType.DATA_TYPE_ENUM}
    RUNNING_STATUS = {"key": "RUNNINGSTATUS", "type": tlvDataType.DATA_TYPE_ENUM}


class System(PublicAttributes):
    CONFIG_MODEL = {"key": "CONFIGMODEL", "type": tlvDataType.DATA_TYPE_ENUM}


# 控制器属性
class Controller(PublicAttributes):
    CPU_USAGE = {"key": "CPUUSAGE", "type": tlvDataType.DATA_TYPE_UNSIGN_INT}
    LIGHT_STATUS = {"key": "LIGHT_STATUS", "type": tlvDataType.DATA_TYPE_ENUM}


class ScaleOut(PublicAttributes):
    TOTAL_CTRL_NUM = {"key": "totalCtrlNum", "type": tlvDataType.DATA_TYPE_UNSIGN_32INT}
    BASE_IP_ADDR0 = {"key": "baseIpAddr0", "type": tlvDataType.DATA_TYPE_STRING}
    BASE_IP_ADDR1 = {"key": "baseIpAddr1", "type": tlvDataType.DATA_TYPE_STRING}
    NEW_CTR_SN = {"key": "newCtrSn", "type": tlvDataType.DATA_TYPE_JSON}
    NET_WORK_MODE = {"key": "networkMode", "type": tlvDataType.DATA_TYPE_ENUM}
    INTERNAL_MODEL = {
        "key": "internalModel", "type": tlvDataType.DATA_TYPE_STRING
    }
    CUR_STEP = {"key": "curStep", "type": tlvDataType.DATA_TYPE_ENUM}
    REMAIN_TIME = {"key": "remainTime", "type": tlvDataType.DATA_TYPE_STRING}
    STATE = {"key": "state", "type": tlvDataType.DATA_TYPE_STRING}
    POWERSTEP = {"key": "powerOnStep", "type": tlvDataType.DATA_TYPE_STRING}
    ERRCODE = {"key": "errCode", "type": tlvDataType.DATA_TYPE_STRING}


# 框属性
class Enclosure(PublicAttributes):
    LOGIC_TYPE = {"key": "LOGICTYPE", "type": tlvDataType.DATA_TYPE_ENUM}
    MODEL = {"key": "MODEL", "type": tlvDataType.DATA_TYPE_ENUM}


# IBC属性
class IBC():
    PWD_CHANGED = {"key": "passwordChanged", "type": tlvDataType.DATA_TYPE_STRING}
    KEYPAIR_CHANGED = {"key": "keyPairChanged", "type": tlvDataType.DATA_TYPE_STRING}


class ControllerIo():
    ID = {"key": "id", "type": tlvDataType.DATA_TYPE_STRING}
    PORT_TYPE = {"key": "portType", "type": tlvDataType.DATA_TYPE_ENUM}
    PORT_ID = {"key": "portID", "type": tlvDataType.DATA_TYPE_STRING}
    BACKEND_IO = {"key": "backEndIO", "type": tlvDataType.DATA_TYPE_SIGN_INT}
    BACKEND_LIMIT = {"key": "backEndLimit", "type": tlvDataType.DATA_TYPE_SIGN_INT}


class ErrorInfo:
    CODE = {"key": "code", "type": tlvDataType.DATA_TYPE_STRING}
    DESCRIPTION = {"key": "description", "type": tlvDataType.DATA_TYPE_STRING}
    SUGGESTION = {"key": "suggestion", "type": tlvDataType.DATA_TYPE_STRING}


class SfpOpticalTransceiver(PublicAttributes):
    CMO_EXPORT_DB_DATA_DIR = {"key": "CMO_EXPORT_DB_DATA_DIR", "type": tlvDataType.DATA_TYPE_STRING}


class FcPort(PublicAttributes):
    pass


class IntfModule(PublicAttributes):
    MODEL = {"key": "MODEL", "type": tlvDataType.DATA_TYPE_ENUM}


class EthPort(PublicAttributes):
    IPV4_ADDR = {"key": "IPV4ADDR", "type": tlvDataType.DATA_TYPE_STRING}
    IPV6_ADDR = {"key": "IPV6_ADDR", "type": tlvDataType.DATA_TYPE_STRING}
    LOGIC_TYPE = {"key": "LOGICTYPE", "type": tlvDataType.DATA_TYPE_SIGN_INT}


class BaseAddr():
    BASE_ADDR = {"key": "startIp_0", "type": tlvDataType.DATA_TYPE_STRING}


class FcoePort(PublicAttributes):
    pass


class License:
    LICENSE_USAGE_INFO = {"key": "LicenseUsageInfo", "type": tlvDataType.DATA_TYPE_JSON}
    LICENSE_RESOURCE = {"key": "LicenseResource", "type": tlvDataType.DATA_TYPE_JSON}


class LicenseUsageInfo:
    FEATURE_ID = {"key": "FeatureId", "type": tlvDataType.DATA_TYPE_ENUM}
    STATE = {"key": "State", "type": tlvDataType.DATA_TYPE_UNSIGN_32INT}


class LicenseResource:
    FEATURE_ID = {"key": "FeatureId", "type": tlvDataType.DATA_TYPE_ENUM}


class ReplicationPair(PublicAttributes):
    LOCAL_RES_NAME = {"key": "LOCALRESNAME", "type": tlvDataType.DATA_TYPE_STRING}
    REMOTE_RES_NAME = {"key": "REMOTERESNAME", "type": tlvDataType.DATA_TYPE_STRING}
    REMOTE_DEVICE_ID = {"key": "REMOTEDEVICEID", "type": tlvDataType.DATA_TYPE_STRING}
    RECOVERY_POLICY = {"key": "RECOVERYPOLICY", "type": tlvDataType.DATA_TYPE_ENUM}


class PubRemoteDevPortAttr:
    DEVICE_ID = {"key": "DEVICEID", "type": tlvDataType.DATA_TYPE_STRING}
    LOCAL_PORT_ID = {"key": "LOCALPORTID", "type": tlvDataType.DATA_TYPE_STRING}
    HEALTH_STATUS = {"key": "HEALTHSTATUS", "type": tlvDataType.DATA_TYPE_ENUM}
    RUNNING_STATUS = {"key": "RUNNINGSTATUS", "type": tlvDataType.DATA_TYPE_ENUM}


class FcLink(PubRemoteDevPortAttr):
    pass


class IscsiLink(PubRemoteDevPortAttr):
    pass


class ExportData():
    EXPORT_DATA_TYPE = {"key": "exportDataType", "type": tlvDataType.DATA_TYPE_ENUM}
    NODE_ID = {"key": "nodeId", "type": tlvDataType.DATA_TYPE_STRING}
    CMO_EXPORT_DB_TYPE = {"key": "CMO_EXPORT_DB_TYPE", "type": tlvDataType.DATA_TYPE_ENUM}
    CMO_EXPORT_DRIVE_ID = {"key": "CMO_EXPORT_DRIVE_ID", "type": tlvDataType.DATA_TYPE_ENUM}


class Expboard(PublicAttributes):
    WWN = {"key": "WWN", "type": tlvDataType.DATA_TYPE_STRING}


class BackupPower(PublicAttributes):
    pass


class SasPort(PublicAttributes):
    enclosureWWNList = {"key": "ENCLOSURE_WWN_LIST", "type": tlvDataType.DATA_TYPE_STRING}
    WWN = {"key": "WWN", "type": tlvDataType.DATA_TYPE_STRING}
    CURRENT_PEER_PORT_ID = {"key": "CURRENT_PEER_PORT_ID", "type": tlvDataType.DATA_TYPE_STRING}
    SUGGEST_PEER_PORT_ID = {"key": "SUGGEST_PEER_PORT_ID", "type": tlvDataType.DATA_TYPE_STRING}


class Alarm:
    EVENTID = {"key": "eventID", "type": tlvDataType.DATA_TYPE_STRING}
    SUGGESTION = {"key": "suggestion", "type": tlvDataType.DATA_TYPE_STRING}
    STREVENTID = {"key": "strEventID", "type": tlvDataType.DATA_TYPE_STRING}
    DESCRIPTION = {"key": "description", "type": tlvDataType.DATA_TYPE_STRING}
    LEVEL = {"key": "level", "type": tlvDataType.DATA_TYPE_ENUM}
    SOURCEID = {"key": "sourceID", "type": tlvDataType.DATA_TYPE_U64LONG_TYPE}
    EVENTPARAM = {"key": "eventParam", "type": tlvDataType.DATA_TYPE_STRING}
    SEQUENCE = {"key": "sequence", "type": tlvDataType.DATA_TYPE_U64LONG_TYPE}
    RECOVERTIME = {"key": "recoverTime", "type": tlvDataType.DATA_TYPE_U64LONG_TYPE}
    CLEARTIME = {"key": "clearTime", "type": tlvDataType.DATA_TYPE_U64LONG_TYPE}
    DETAIL = {"key": "detail", "type": tlvDataType.DATA_TYPE_STRING}
    SOURCETYPE = {"key": "sourceType", "type": tlvDataType.DATA_TYPE_STRING}
    CLEARNAME = {"key": "clearName", "type": tlvDataType.DATA_TYPE_STRING}
    ROOM = {"key": "room", "type": tlvDataType.DATA_TYPE_STRING}
    LOCATION = {"key": "location", "type": tlvDataType.DATA_TYPE_STRING}
    STARTTIME = {"key": "startTime", "type": tlvDataType.DATA_TYPE_U64LONG_TYPE}
    CONFIRMTIME = {"key": "confirmTime", "type": tlvDataType.DATA_TYPE_U64LONG_TYPE}
    POSITION = {"key": "position", "type": tlvDataType.DATA_TYPE_STRING}
    ALARMOBJTYPE = {"key": "alarmObjType", "type": tlvDataType.DATA_TYPE_STRING}
    TYPE = {"key": "type", "type": tlvDataType.DATA_TYPE_ENUM}
    NAME = {"key": "name", "type": tlvDataType.DATA_TYPE_STRING}


class OperationLog():
    OPER_TYPE = {"key": "operType", "type": tlvDataType.DATA_TYPE_UNSIGN_32INT}
    FILE_TYPE = {"key": "fileType", "type": tlvDataType.DATA_TYPE_ENUM}
    FILE_NAME = {"key": "fileName", "type": tlvDataType.DATA_TYPE_STRING}
    RETURN_VALUE = {"key": "retValue", "type": tlvDataType.DATA_TYPE_UNSIGN_32INT}
    NODE_ID = {"key": "nodeId", "type": tlvDataType.DATA_TYPE_STRING}


class Scaleout():
    OLD_NODE_NUM = {"key": "oldNodeNum", "type": tlvDataType.DATA_TYPE_UNSIGN_32INT}


##--------对象URI配置-------                       
# 单个查询，批量查询和修改的对象
class OBJ():
    SYSTEM = "system/"
    ENCLOSURE = "enclosure"
    CONTROLLER = "controller"
    BAY = "bay"
    EXPANSION_BOARD = "expboard"
    INTERFACE_MODULE = "intf_module"
    DISK = "disk"
    FAN = "fan"
    POWER = "power"
    BACKUP_POWER = "backup_power"
    BASEIPADDR = "get_vlan_inner_ip_segment"
    ETH_PORT = "eth_port"
    PCIE_PORT = "pcie_port"
    SAS_PORT = "sas_port"
    FC_PORT = "fc_port"
    FCoE_PORT = "FCoE_PORT"
    IB_PORT = "ib_port"
    REPLICATIONPAIR = "REPLICATIONPAIR"
    IBC = "check_ibc_password_changed"
    CONTROLLER_IO = "backend_concurrent"
    SFP_OPTICAL_TRANSCEIVER = "SFP_OPTICAL_TRANSCEIVER"
    FC_LINK = "FC_LINK"
    iSCSI_LINK = "iSCSI_LINK"
    EXPORT_DB_CONFIG = "export_db_config"  # 导出配置文件
    CLEAR_EXPORT_DATA = "clear_export_data"  # 清除导出数据
    VM = "vm"  # 虚拟机
    ENABLE_MGMT_PORT_FORWARD = "enable_management_port_forward_function"


# 特殊REST接口，无法在OBJ中实现的接口
class SpecialUri():
    QUERY_USER_INFO = "user"  # 查询用户信息
    QUERY_CURRENT_ALARM_INFO = "alarm/currentalarm"  # 查询系统当前告警列表信息
    COUNT_CURRENT_ALARMS = "alarm/currentalarm/count"  # 查询系统当前告警列表信息
    QUERY_HISTORICAL_ALARMS_INFO = "alarm/historyalarm"  # 查询历史告警和事件
    COUNT_HISTORICA_ALARMS = "alarm/historyalarm/count"  # 查询历史告警和事件个数
    SYNC_REPLICATION_PAIR = "REPLICATIONPAIR/sync"  # 同步远程复制Pair
    ACTIVELICENSE = "license/activelicense"  # 查询license使用情况
    OFFLINE_CONTROLLER = "offline_controller"  # 离线控制器
    OFFLINE_CONTROLLER_SIGNLE = "safe_power_off_system"
    EXP_CTRL_FLOW = 'scaleout/exp_ctrl_flow'  # 触发扩容控制器流程
    QUERY_EXP_CTRL_INFO = 'scaleout/query_exp_ctrl_info'  # 查询扩容控制器流程
    EXPAND_DISK_POOL_CONTROLLER = "expand_disk_pool_controller"  # 触发pool扩容
    GET_ALL_ENGINE_DISK_INFO = 'get_all_engine_diskInfo'  # 获取所有引擎盘信息
    GET_PERFORMANCE_LAYER_DISK_INFO = 'get_all_engine_diskInfo_for_performance_layer'  # 获取所有性能层盘信息


##-----------REST框架使用配置-----------
class RestMethod():
    GET = 0  # 请求主要用于查询存储管理对象
    POST = 1  # 请求主要用于创建存储管理对象
    PUT = 2  # 请求主要用于修改存储管理对象属性和对管理对象的特殊操作
    DELETE = 3  # 主要用于删除存储管理对象


##-----------对象属性的枚举类型-----------
class HealthStatusEnum:
    UNKNOWN = 0
    NORMAL = 1
    FAULT = 2
    PRE_FAIL = 3
    PART_BROKEN = 4
    DEGRADE = 5
    HAS_BAD_BLOCK = 6
    HAS_ERR_CODE = 7
    CONSISTENT = 8
    INCONSISTENT = 9
    BUSY = 10
    POWER_NO_INPUT = 11
    POWER_NOT_ENOUGH = 12
    SINGLE_LINK_FAULT = 13
    INVALID = 14
    WRITE_PROTECT = 15


class RunningStatusEnum:
    UNKNOWN = 0
    NORMAL = 1
    RUNNING = 2
    NOT_RUNNING = 3
    NOT_EXIST = 4
    HIGH_TEMPERATURE_SLEEP = 5
    STARTING = 6
    POWER_FAILURE_PROTECTING = 7
    SLEEPING = 8
    SPINGUP = 9
    LINK_UP = 10
    LINK_DOWN = 11
    POWER_ON = 12
    POWER_OFF = 13
    PRE_COPY = 14
    COPYBACK = 15
    RECONSTRUCTION = 16
    EXPANSION = 17
    NOT_FORMAT = 18
    FORMATTING = 19
    UNMAPPING = 20
    INITIAL_SYNCHRONIZING = 21
    CONSISTENT = 22
    SYNCHRONIZING = 23
    SYNCHRONIZED = 24
    NOT_SYNCHRONIZED = 25
    SPLIT = 26
    ONLINE = 27
    OFFLINE = 28
    LOCKED = 29
    ENABLE = 30
    DISABLED = 31
    LEVELING = 32
    TO_BE_RECOVERD = 33
    INTERRUPTED = 34
    INVALID = 35
    NOSTART = 36
    QUEUING = 37
    STOP = 38
    COPYING = 39
    COMPLETED = 40
    PAUSE = 41
    REVSYNCHRONIZING = 42
    ACTIVATED = 43
    ROLLBACK = 44
    INACTIVATED = 45
    IDLE = 46
    POWERING_OFF = 47
    CHARGING = 48
    CHARGED = 49
    DISCHARGING = 50
    UPGRADING = 51
    POWER_LOST = 52
    INITIALIZING = 53
    APPLY_CONFIG_CHANGE = 54
    ONLINE_DISABLE = 55
    OFFLINE_DISABLE = 56
    ONLINE_FROZEN = 57
    OFFLINE_FROZEN = 58
    CLOSED = 59
    REMOVING = 60
    INSERVICE = 61
    OUTOFSERVICE = 62
    ERASEMENT_RUNNING_NORMAL = 63
    ERASEMENT_RUNNING_FAIL = 64
    ERASEMENT_RUNNING_SUCCESS = 65
    SUCCESS = 66
    FAILED = 67
    WAITING = 68
    CANCELLING = 69
    CANCELLED = 70
    RUNNING_PREPARE_SYNC = 71
    RUNNING_SYNCHRONINING = 72
    RUNNING_SYNC_FAILED = 73
    MIGRATION_FAULT = 74
    MiGRATING = 75
    MIGRATION_COMPLETED = 76

class IbcEnum():
    PWD_CHANGED = "true"
    KEYPAIR_CHANGED = "true"


class EthPortLogicTypeEnum():
    HOST = 0  # 主机端口/业务端口
    EXP = 1  # 级联端口
    MNGT = 2  # 管理端口
    INNER = 3  # 内部端口
    MAINTENANCE = 4  # 维护端口
    MNGT_SRV = 5  # 管理/业务混合口
    MAINTENANCE_SRV = 6  # 维护/业务混合口
    BACKUP_MGR = 7  # 备份管理网口
    PRODUCT_STORAGE = 8  # 生产存储网口
    BACKUP_STORAGE = 9  # 备份存储网口
    ETH_NOT_CONFIG = 10  # 未配置角色网口
    IP_SCALE_OUT = 11  # 用于IP Scale-Out的网口


class CofigModelEnum():
    SINGLE_CTRL = 0  # 单控
    MULTI_CTRL = 1  # 多控


class LightStatusEnum():
    ON = 1
    OFF = 2


class IpTypeEnum():
    IPV4 = 1
    IPV6 = 2


class EncLogicTypeEnum():
    EXP = 0  # 级联框（硬盘框）
    CTRL = 1  # 控制框
    DSW = 2  # 数据交换机
    MSW = 3  # 管理交换机
    SVP = 4  # 管理服务器


class DataTypeEnum():
    CONFIG_DATA = 3  # 配置数据


class ExportTypeEnum():
    MEMORY = 0  # 从内存导出
    DISK = 1  # 从硬盘导出


class DiskEnum():
    DISK0 = "0"
    DISK1 = "1"


class RecoveryPolicyEnum:
    AUTO = 1
    MANUALLY = 2


class OperationTypeEnum():
    EXPORT = 1  # 导出


class FileIdEnum():
    CONFIG_DATA = 50  # 配置数据文件


class OperationResultEnum():
    SUCCESS = 0
    FAIL = 1


class ParentTypeEnum():
    ENCLOSURE = 206  # 框/Enclosure
    CONTROLLER = 207  # 控制器/Controller
    EXPBOARD = 208  # 级联板/Expand Board
    INTF_MODULE = 209  # 接口模块/Interface Module


class EnlosureModelEnum():
    CTRL_BMC = 0  # BMC控制框
    CTRL_SAS2U_12 = 1  # 2U SAS 12盘主控框
    CTRL_SAS2U_24 = 2  # 2U SAS 24盘主控框
    EXPSAS2U_12 = 16  # 2U SAS 12盘级联框
    EXPSAS2U_24 = 17  # 2U SAS 24盘级联框
    EXPSAS4U = 18  # 4U 6Gbit/s SAS 24盘位 3.5英寸 硬盘框
    EXPFC = 19  # 4U FC 24盘级联框
    DSW_PCIe1U = 20  # 1U PCIe数据交换机
    EXPSAS4U_75 = 21  # 4U SAS 75盘级联框
    SVP = 22  # SVP
    CTRL_6U = 97  # 6U 4控独立机头
    CTRL_3U = 96  # 3U 2控独立机头
    EXPSAS2U_25 = 24  # 2U 6Gbit/s SAS 25盘位 2.5英寸 硬盘框
    EXPSAS4U_24_NEW = 25  # 4U SAS 24盘3.5寸磁盘框（新）
    CTRL_12GSAS_2U25_EAR = 26  # 2U 12GSAS 25盘主控框
    CTRL_12GSAS_2U12_EAR = 23  # 2U 12GSAS 12盘主控框
    ARM_2U_12 = 37  # 2U 12GSAS 12盘ARM主控框/
    ARM_2U_25 = 38  # 2U 12GSAS 25盘ARM主控框/
    ENCLOSURE_MODEL_EXPSAS2U_25_12GLINK = 65  # 2U SSD 25盘2.5寸级联框/
    EXP_SAS2U_25 = 67  # 2U SAS 25盘位 2.5英寸 硬盘框
    EXP_SAS4U_24 = 69  # 4U SAS 24盘位 3.5英寸 硬盘框
    EXP_12G_SAS_4U_75 = 39  # 12G 4U SAS 75盘 3.5寸级联框/
    CTRL_12GSAS_2U25_EAR_12GLINK = 40  # 2U 12G SAS 25盘主控框/
    CTRL_NVMe2U_24 = 99  # 2U NVMe 2.5寸主控框/
    EXP2U_JBOF = 101 # 2U JBOF硬盘框/
    CTRL_4U_4C = 112 # 4U 四控 控制框/
    CTRL_SAS2U_2C_25_MID = 113  # 中端 2U 双控 SAS 25盘位 2.5英寸 控制框/
    CTRL_SAS2U_2C_12_MID = 114  # 中端 2U 双控 SAS 12盘位 2.5英寸 控制框/
    CTRL_NVMe2U_2C_36 = 115  # 2U 双控 NVMe 36盘位 控制框/
    CTRL_SAS2U_2C_25_LOW = 116  # 低端 2U 双控 SAS 25盘位 2.5英寸 控制框/
    CTRL_SAS2U_2C_12_LOW = 117  # 低端 2U 双控 SAS 12盘位 2.5英寸 控制框/
    EXP_IPSAS_2U_25 = 118  # 2U IP SAS 25盘位 2.5英寸 硬盘框/
    EXP_IPSAS_2U_12 = 119  # 2U IP SAS 12盘位 3.5英寸 硬盘框/
    EXP_IPNVMe_2U_36 = 120  # 2U IP NVMe 36盘位 硬盘框/


class ObjectEnum():
    FC_PORT = 212  # FC端口
    ETH_PORT = 213  # 以太网口
    SAS_PORT = 214  # SAS端口
    FCoE_PORT = 252  # FCoE端口
    IB_PORT = 16500  # IB端口


class NetModeEnum():
    UNKNOWN = 0  # 无效值
    DIRECT = 1  # 直连组网
    SWITCH = 2  # 交换机组网
    DIRECT2SWITCH = 3  # 直连组网转交换机组网
