# -*- coding: UTF-8 -*-
import re
import traceback
    
CLI_MODE_ADMIN = 'admin:/>'
CLI_MODE_DEVELOPER = 'developer:/>'
CLI_MODE_MINISYSTEM = 'minisystem>'
CLI_MODE_DIAGNOSE = 'diagnose>'

def enterDeveloperMode(devObj, ssh):
    '''
    @summary: 进入developer模式
    @param cliRet: devObj=上下文对象
    @return: True=成功，False=失败
    '''
    try:
        cliRet = ssh.execCmd('change user_mode current_mode user_mode=developer')
        
        if 'developer:' in cliRet:
            devObj.get("logger").info('[cliModeManager]: change to developer mode ok.')
            return True
        
        #Dorado c00进入developer需要进行交互,最多三次
        for _ in range(3):
            if re.search("(y/n)", cliRet, re.IGNORECASE):
                cliRet = ssh.execCmd('y')
                
            if re.search("developer:/>", cliRet, re.IGNORECASE):
                return True
            
            if re.search("Password:", cliRet, re.IGNORECASE):
                break
        
        #若以上操作未进入developer，则需要输入密码，其他场景为错误场景    
        if not re.search("Password:", cliRet, re.IGNORECASE):
            return False
        
        developerPwd = devObj.get("developer")
        #判断developer密码是否为空
        if not developerPwd :
            ssh.execCtrlPlusCCmd(60)
            return False
        
        cliRet = ""
        inputPwdRet = ssh.execCmdNoLogTimout(developerPwd, 60*3)
        if not re.search("developer:", inputPwdRet, re.IGNORECASE):
            return False
    except:
        return False
    else:    
        return True
    finally:
        if 'developerPwd' in locals().keys():
            del developerPwd
        

def enterMinisystemMode(devObj, ssh):
    '''
    @summary: 进入minisystem模式
    @param cliRet: devObj=上下文对象
    @return: True=成功，False=失败
    '''
    try:
        if not enterDeveloperMode(devObj, ssh):
            return False
        
        miniRet = ssh.execCmd('minisystem')
        if miniRet.strip().endswith('minisystem>'):
            devObj.get("logger").info('[cliModeManager]: change to minisystem mode ok.')
            return True
        else:
            developerMode2CliMode(devObj, ssh)
            return False
    except:
        devObj.get("logger").error('[cliModeManager]: change to minisystem exception:' 
                                   + unicode(traceback.format_exc()))
        return False
          
def developerMode2CliMode(devObj, ssh):
    '''
    @summary: developer模式下退回到cli模式
    @param cliRet: devObj=上下文对象
    '''        
    try:
        if isInDeveloperMode(devObj, ssh):
            exitRet = ssh.execCmd("exit")
            if "admin:/>" in exitRet:
                return True
            else:
                return False
    except:
        return False
    
def isInDeveloperMode(devObj, ssh):
    '''
    @summary: 判断当前是否在developer模式下
    @param cliRet: cli回显
    @return: 
        True: 当前在developer模式下
        False: 当前不在developer模式下
    '''
    try:
        testRet = ssh.execCmdWithTimout("show system general", 3*60)
        if re.search('developer:/>', testRet, re.IGNORECASE):
            return True
        else:
            return False
    except:
        return False

def enterDiagnoseMode(devObj, ssh):
    '''
    @summary: 进入diagnose模式
    @param cliRet: devObj=上下文对象
    @return: True=成功，False=失败
    '''
    try:
        if not enterDeveloperMode(devObj, ssh):
            return False
        
        dbgRet = ssh.execCmdWithTimout("debug", 3*60)
        if dbgRet.strip().endswith("diagnose>"):
            return True
        else:
            developerMode2CliMode(devObj, ssh)
            return False
    except:
        return False       
           
def exitDiagnoseOrMinisystem(devObj, ssh):
    '''
    @summary: 从小系统或者diagnose模式下退回到cli模式
    @param cliRet: devObj=上下文对象
    '''
    try:
        exitRet = ssh.execCmd("exit")
        if exitRet.strip().endswith('(y/n)'):
            exitRet = ssh.execCmd("y")
            
        developerMode2CliMode(devObj)
    except:
        return False   
    else:
        return True        
