# -*- coding: UTF-8 -*-
import os
import traceback
from common.util import *
from common.config import config

'''
收集前准备
删除用户选择的路径中的temp目录
'''
def preCollect(devObj):
    try:
        util.refreshProcess(devObj, 1) 
        #检查用户是否为备份管理员（备份管理员进行限制收集）
        loginUserName = devObj.get("username")
        log.info(devObj, "loginUserName is %s" % str(loginUserName))
        isPass = checkLoginUserName(loginUserName)
        if not isPass:
            util.setPyDetailMsg(devObj, "loginUser.name.check.failure")
            return (False, "")
        productModel = device.getDeviceType(devObj)    
        util.refreshProcess(devObj, 50) 
        productTime = util.getCurrentDate()
        localFileFinal = "Data_%s_%s_%s" % (str(productModel).replace(" ", ""), str(productTime),
                                            str(devObj.get("devNode").getDeviceSerialNumber()))
        localDir = util.getLocalDir(devObj) + os.path.sep + localFileFinal + os.path.sep + "DataCollect"
        flag = util.check_contain_chinese(unicode(localDir).encode("utf-8"))
        if flag:
            util.setPyDetailMsg(devObj, "route.exist.ch")
            return False, ""
        if not os.path.exists(localDir):
            os.makedirs(localDir)
        #将保存的路径通知框架，做显示
        devObj["collectRetFileName"] = localFileFinal        
        devObj[config.COLLECT_INFO_LOCAL_PATH] = localDir   
        util.refreshProcess(devObj, 100)                        
        return (True, "")
    except Exception:
        log.error(devObj, "tool: pre_collect except trace back:" + str(traceback.format_exc()))
        return (False, "")

USER_NAME_BLACK_LIST = ["developer", "diagnose", "error", "password", "upgrade", "minisystem", "storage"]
def checkLoginUserName(loginUserName):
    '''
    @summary: 检查工具登录用户名称是否为特殊用户名
    '''
    
    loginUserName = loginUserName.lower()
    
    for keyWords in USER_NAME_BLACK_LIST:
        if loginUserName.endswith(keyWords):
            return False
    
    return True 