# -*- coding: UTF-8 -*-

from common.util import util
from common.util import log
from common.config import config
from common.exportInfo import exportInfo
from common.cliFactory import cli
from cbb.frame.cli.cliUtil import hasCliExecPrivilege


def execute(devObj):
    """
    导出私有日志入口
    :param devObj: 传入的对象名称
    :return: 是否成功，错误信息在isExistDetailMsg中设置
    """
    try:
        util.refreshProcess(devObj, 1)
        util.initPyDetailMsg(devObj)
        is_upgrading = util.isSystemUpgrading(devObj)
        if is_upgrading:
            return False, ""
        is_succ = exportInfo.collect_item(
                devObj, get_support_private_log_type(devObj))
        # 判断错误信息是否已经设置
        is_exist_msg = util.isExistDetailMsg(devObj)
        if is_succ is False and is_exist_msg is False:
            util.setPyDetailMsg(devObj, "failed.collect.information")
        return is_succ, ""
    except Exception as exception:

        log.error(
            devObj, "collect private log "
                    "except: {}".format(exception))
        util.setPyDetailMsg(devObj, "failed.collect.information")
        return False, ""


def get_support_private_log_type(dev_obj):
    """
    获取 private 收集项 的参数类型 private 或 key_log
    背景：private 对客户体现不友好，需要更改为key_log。但部分产品未同步更改，
    所以在代码层面做适配，先判断是否支持key_log命令参数，如果不支持则使用private
    :param dev_obj:
    :return: 收集参数
    """
    cmd = "show file package_result file_type={}".format(
        config.COLLECT_KEY_LOG)
    __, ret = cli.executeCmd(dev_obj, cmd)
    return config.COLLECT_KEY_LOG if hasCliExecPrivilege(ret) else \
        config.COLLECT_PRIVATE_LOG
