# -*- coding: UTF-8 -*-
import sys
import re
import traceback
import time
import cliModeManager

class cli():
    
    CLI_RET_END_FLAG = ":/>"
    CLI_NOT_EXIST_FLAG = "^"
    CLI_SYSTEM_BUSY_FLAG = "The system is busy. Please try again later"
    CLI_BASH_EXPORT_FLAG = "-bash: export"
    CLI_MINISYSTEM_FLAG = "minisystem>"
    CLI_DEVELOPER_MODEL_FLAG = "developer:/>"
    CLI_ENTER_DEVELOPER_MODEL_MAX_RETRYS = 5
    CLI_EXECUTED_SUCCESSFULLY = "Command executed successfully"
    TOOLKIT_SEND_CMD_TIME_OUT='TOOLKIT_SEND_CMD_TIME_OUT'  
    QRY_ENGINE_CMD = 'show enclosure |filterRow column=Logic\sType predict=equal_to value=Engine'  
    PORT_NUM = 22
    
    @staticmethod
    def executeCtrlPlusCCmd(devObj, timeout):
        '''
                       发送CTRL+C中断命令
        '''
        ssh = devObj.get("SSH")
        cli.info(devObj, "Send CTRL+C command now.... ")
        ret = ssh.execCtrlPlusCCmd(timeout)
        cli.info(devObj, "Send CTRL+C command end.... ")
        return ret
    
    @staticmethod
    def executeCmd(devObj, cmd):
        '''
                        执行CLI命令
        '''
        ssh = devObj.get("SSH")
        retryTimes = 0
        while retryTimes < 3:
            try:
                if retryTimes == 0:
                    cliRet = ssh.execCmd(cmd)
                else:
                    cliRet = ssh.execCmdWithTimout(cmd, 3*60)
            except:
                cli.info(devObj, "executeCmd failed because " + str(traceback.format_exc()))
                cli.info(devObj, "executeCmd retrying.... ")
                retryTimes += 1
                time.sleep(10 * retryTimes)
            else:
                isSuccess = True
                return (isSuccess, cliRet)
            
        return (False, cliRet) 
    
    @staticmethod
    def handleCliModeAfterReconnected(devObj, cliMode, ssh): 
        cli.info(devObj, "Switch to specified mode after SSH reconnected:" + cliMode)
        if cliMode == cliModeManager.CLI_MODE_DEVELOPER:
            if not cliModeManager.enterDeveloperMode(devObj, ssh):
                return False
            else:
                return True
        elif cliMode == cliModeManager.CLI_MODE_MINISYSTEM:
            if not cliModeManager.enterMinisystemMode(devObj, ssh):
                return False
            else:
                return True
        elif cliMode == cliModeManager.CLI_MODE_DIAGNOSE:
            if not cliModeManager.enterDiagnoseMode(devObj, ssh):
                return False
            else:
                return True
        return True

    @staticmethod
    def executeCmdWithRetry(devObj, cmd, cliMode=cliModeManager.CLI_MODE_ADMIN):
        '''
                        执行CLI命令
        '''
        (isSuccess, cliRet) = (False, "")
        ssh = devObj.get("SSH")
        retryTimes = 0
        while retryTimes < 3:
            try:
                if retryTimes == 0:
                    cliRet = ssh.execCmd(cmd)
                else:
                    cliRet = ssh.execCmdWithTimout(cmd, 3*60)
            except:
                cli.info(devObj, "executeCmd failed because " + str(traceback.format_exc()))
                cli.info(devObj, "executeCmd retrying.... ")
                isNetworkEnvOk = cli.depressNetworkEvaluation(devObj)
                if not isNetworkEnvOk:
                    return (False, cliRet)
                
                retryTimes += 1
                time.sleep(10 * retryTimes)
                try:
                    ssh.reConnect()
                except:
                    cli.info(devObj, "SSH connection reconnect exception...")
                else:
                    #evaluate current network environment: clear to normal
                    cli.clearNetworkEvaluation2Fluent(devObj)
                    
                    if not cli.handleCliModeAfterReconnected(devObj, cliMode, ssh):
                        cli.info(devObj, "Handle CLI mode failed after cli reconnected.")
                        return False, ''
            else:
                isSuccess = True
                return (isSuccess, cliRet)
            
        return (False, cliRet)

    @staticmethod
    def executeCmdWithTimout(devObj, cmd, timeout):
        '''
                        执行CLI命令
        '''
        cliRet = ""
        ssh = devObj.get("SSH")
        retryTimes = 0
        while retryTimes < 3:
            try:
                cliRet = ssh.execCmdWithTimout(cmd, timeout)
            except:
                cli.info(devObj, "executeCmd failed because " + str(traceback.format_exc()))
                cli.info(devObj, "executeCmd retrying.... ")
                retryTimes += 1
                time.sleep(10 * retryTimes)
            else:
                return (True, cliRet)
            
        return (False, cliRet)
    
    @staticmethod
    def executeCmdWithTimoutAndRetry(devObj, cmd, timeout, cliMode=cliModeManager.CLI_MODE_ADMIN):
        '''
                        执行CLI命令
        '''
        cliRet = ""
        ssh = devObj.get("SSH")
        retryTimes = 0
        while retryTimes < 3:
            try:
                cliRet = ssh.execCmdWithTimout(cmd, timeout)
            except:
                cli.info(devObj, "executeCmd failed because " + str(traceback.format_exc()))
                cli.info(devObj, "executeCmd retrying.... ")
                
                isNetworkEnvOk = cli.depressNetworkEvaluation(devObj)
                if not isNetworkEnvOk:
                    return (False, cliRet)
                
                retryTimes += 1
                time.sleep(10 * retryTimes)
                try:
                    ssh.reConnect()
                except:
                    cli.info(devObj, "SSH connection reconnect exception...")

                else:
                    #evaluate current network environment: clear to normal
                    cli.clearNetworkEvaluation2Fluent(devObj)
                    
                    if not cli.handleCliModeAfterReconnected(devObj, cliMode, ssh):
                        cli.info(devObj, "Handle CLI mode failed after CLI reconnected.")
                        return False, ''
                    else:
                        try:
                            devObj.get("SFTP").reConnect()
                        except:
                            devObj.get('logger').error('SFTP reconnect exception:' 
                                                       + unicode(traceback.format_exc()))
            else:
                return (True, cliRet)
            
        return (False, cliRet)
    
    @staticmethod
    def depressNetworkEvaluation(devObj):    
        '''
        @summary: depress network environment evaluation, plz trigger this while ssh connection is abnormal.
        @return: isNetworkOk2proceed, true/false  if too pool the network evaluation is, shall False be returned
        '''
        #evaluate current network environment: depress
        networkEnvThresHold = devObj.get("networkEnvThresHold","")
        if  networkEnvThresHold == "" or not str(networkEnvThresHold).isdigit():
            cli.info(devObj, "initializing network environment threshold.... ")
            devObj["networkEnvThresHold"] = 10

        cli.info(devObj, "evaluate network connection: depress evaluation.... ")
        devObj["networkEnvThresHold"] -= 1
        cli.info(devObj, "evaluate network connection: now evaluate as:%s "%str(devObj["networkEnvThresHold"] ))    
        if devObj["networkEnvThresHold"] < 1:
            return False
        else :
            return True

    @staticmethod
    def clearNetworkEvaluation2Fluent(devObj):
        '''
        @summary: clear current network evaluation status to fluent(10)
        '''
        devObj["networkEnvThresHold"] = 10
        return 
    
    @staticmethod
    def getNetworkEvaluation(devObj):
        '''
        @summary: clear current network evaluation status to fluent(10)
        '''
        networkEnvThresHold = devObj.get("networkEnvThresHold","")
        cli.info(devObj, "cur environment threshold is %s " % str(networkEnvThresHold) )
        if networkEnvThresHold == "" or not str(networkEnvThresHold).isdigit():
            cli.info(devObj, "initializing network environment threshold.... ")
            devObj["networkEnvThresHold"] = 10

        return int(devObj["networkEnvThresHold"])
    
    @staticmethod
    def executeCmdNoLog(devObj, cmd):
        '''
                        执行CLI命令,不打印日志信息
        '''
        (isSuccess, cliRet) = (False, "")
        ssh = devObj.get("SSH")
        try:
            cliRet = ssh.execCmdNoLog(cmd)
        except:
            cli.info(devObj, "executeCmdNoLog failed because " + str(traceback.format_exc()))
            return (isSuccess, cliRet)
        
        isSuccess = True
        return (isSuccess, cliRet)
    
    @staticmethod
    def executeCmdNoLogTimeout(devObj, cmd, timeOut=4*60):
        '''
                        执行CLI命令，不打印日志信息并且设置相应的超时时间
        '''
        ssh = devObj.get("SSH")
        (isSuccess, cliRet) = (False, "")
        try:
            cliRet = ssh.execCmdNoLogTimout(cmd, timeOut)
        except:
            cli.info(devObj, "executeCmdNoLogTimeout failed because " + str(traceback.format_exc()))
            return (isSuccess, cliRet)
        
        isSuccess = True
        return (isSuccess, cliRet)
        
    @staticmethod
    def isExistCmdForRec(rec):
        '''
                    根据命令回显信息，判断当前命令是否在系统中存在
                    判断标准：若在回显中出现 '^'符号，则当前命令不存在
        '''
        if None == rec:
            return False
        
        if cli.CLI_NOT_EXIST_FLAG in rec:
            return False
        
        return True
    
    @staticmethod
    def getCliTable2DictList(cliRet):
        '''
        @summary: 对表格形式cli回显统一处理
        @param cliRet: cli回显
        @return: 将表格形式cli回显处理为以表头为key，以项值为键的字典集合
        '''
        try:
            headline = ""
            i = 0
            cliRetList = cliRet.splitlines()
            for line in cliRetList:
                reg_headline = re.compile("^\s*-+(\s+-+)*\s*$") 
                match_headline = reg_headline.search(line)
                if match_headline:
                    headline = match_headline.group()
                    break
                i += 1
            if headline == "" or i == 0 or i >= len(cliRetList) - 1:
                return []
            
            #获取标题
            title = cliRetList[i - 1]
            
            #获取字段值
            field_words = cliRetList[(i + 1):]
            
            reg_split = re.compile("\s*-+\s*")
            tuple_idxs = []
            start_pos = 0
            end_pos = 0
            while (start_pos <= len(headline)):
                match = reg_split.search(headline, start_pos)
                if match:
                    end_pos = match.end()
                    tuple_idxs.append((start_pos, end_pos))
                    start_pos = end_pos
                else:
                    break
                
            keys = []
            for item in tuple_idxs:
                key = title[item[0]:item[1]].strip()
                #字段名重复时,自动添加后缀：_{自增长标记}
                if keys.count(key):
                    key += "_" + str(str(keys).count(key + "_") + 1)
                keys.append(key)
            
            dictList = []
            for line in field_words:
                if len(line) != len(headline):
                    break
                vals = []
                for item in tuple_idxs:
                    vals.append(line[item[0]:item[1]].strip())
                dictList.append(dict(zip(keys, vals)))
                
            return dictList
        except:
            return []

    @staticmethod
    def debug(devObj, info):
        """
                    功能：记录调试信息info到工具日志中
                    参数：devObj=工具上下文；info=要记录的信息
                    返回值：True=成功；False=失败
        """
        logInfo = info + cli.getCallerInfo()
        if "logger" in devObj:
            devObj.get("logger").debug('[ToolLog]:' + logInfo)
            return True
        else:
            raise Exception("[failed]: logger is inexisted. info=" + logInfo)

    @staticmethod
    def info(devObj, info):
        """
                    功能：记录信息info到工具日志中
                    参数：devObj=工具上下文；info=要记录的信息
                    返回值：True=成功；False=失败
        """
        logInfo = info + cli.getCallerInfo()
        if "logger" in devObj:
            devObj.get("logger").info('[ToolLog]:' + logInfo)
            return True
        else:
            raise Exception("[failed]: logger is inexisted. info=" + logInfo)

    @staticmethod
    def error(devObj, info):
        """
                    功能：记录错误信息info到工具日志中
                    参数：devObj=工具上下文；info=要记录的信息
                    返回值：True=成功；False=失败
        """
        logInfo = info + cli.getCallerInfo()
        if "logger" in devObj:
            devObj.get("logger").error('[ToolLog]:' + logInfo)
            return True
        else:
            raise Exception("[failed]: logger is inexisted. info=" + logInfo)
    
    @staticmethod
    def getCallerInfo(MAX_CALLER_LEVEL=5, skipLastLevel=True):
        #从堆栈中获取调用函数和行号
        
        #初始化参数
        funcBack = sys._getframe().f_back
        if True == skipLastLevel: #忽略最近的调用关系
            funcBack = funcBack.f_back
            MAX_CALLER_LEVEL -= 1
        
        #生成函数调用关系
        callerInfo = ""    
        for index in range(0, MAX_CALLER_LEVEL):
        
            #获取该级调用函数和行号
            if hasattr(funcBack, "f_code") and hasattr(funcBack, "f_lineno"):
                funcName = funcBack.f_code.co_name
                lineNumber = funcBack.f_lineno
                callerInfo = " [" + str(funcName) + ":" +  str(lineNumber) + "]" + callerInfo
            else:
                break
            
            #刷新Back函数
            if hasattr(funcBack, "f_back"):
                funcBack = funcBack.f_back
            else:
                break
        
        #返回函数调用关系
        return callerInfo
    
    @staticmethod
    def getHorizontalNostandardCliRet(cliRet):
        '''
        @summary: 按逐行字典的方式获取水平表格形式的cli回显集合,此方法用来解析CLI回显未对其情况
        @param cliRet: cli回显
        @return: 将表格形式cli回显处理为以表头为key，以项值为键的字典集合,处理不正常时，返回空集合
        '''
        try:
            headline = ""
            i = 0
            cliRetList = cliRet.encode("utf8").splitlines()
            for line in cliRetList:
                reg_headline = re.compile("^\s*-+(\s+-+)*\s*$")
                match_headline = reg_headline.search(line)
                if match_headline:
                    headline = match_headline.group()
                    break
                i += 1
            if headline == "" or i == 0 or i >= len(cliRetList) - 1:
                return []
    
            title = cliRetList[i - 1]
            field_words = cliRetList[(i + 1):]
            reg_split = re.compile("\s*-+\s*")
            tuple_idxs = []
            start_pos = 0
            end_pos = 0
    
            while (start_pos <= len(headline)):
                match = reg_split.search(headline, start_pos)
                if match:
                    end_pos = match.end()
                    tuple_idxs.append((start_pos, end_pos))
                    start_pos = end_pos
                else:
                    break
    
            keys = []
            for item in tuple_idxs:
                key = title[item[0]:item[1]].strip()
                if keys.count(key):
                    key += "_" + str(str(keys).count(key + "_") + 1)
                keys.append(key.decode("utf8"))
    
            lenkeys = len(keys)
            dictList = []
            for line in field_words:
                if line.find(":/>") >= 0:
                    break
    
                if re.search("^-+(\s+-+)*\s*$", line):
                    continue
    
                if len(line.strip()) == 0:
                    continue
    
                vals = []
                valueList = line.strip().split("  ")
    
                valueSpaceList = []
                for value in valueList:
                    if value != "":
                        vals.append(value.strip().decode("utf8"))
                        valueSpaceList.append(value)
                lenvalue = len(valueSpaceList)
                if lenvalue == lenkeys:
                    dictList.append(dict(zip(keys, vals)))
    
            return dictList
        except:
            return []

