# coding: UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

from com.huawei.ism.tool.infocollect import CollectDataContext

from commonUtils import Log
from config import config
from exportCmd import exportCmd
from util import util


class CliCmdCollector:
    def __init__(self, dev_obj, product_model):
        self.dev_obj = dev_obj
        self.product_model = product_model
        self.log = Log(self.dev_obj)
        self.dev_node = dev_obj.get("devNode")
        self.cli_type = CollectDataContext.getInstance().getDevCollectCliTypeMap().get(self.dev_node)

    def do_collect(self):
        try:
            cil_list = self.get_cli_list()
            is_success = exportCmd.exportCliCmd(self.dev_obj, cil_list, config.COLLECT_TYPE_CLI, True)
            util.refreshProcess(self.dev_obj, 100)
            return is_success
        except Exception as exception:
            self.log.error("collect cli cmd except: {}".format(exception))
            return False

    def get_cli_list(self):
        if self.product_model in config.CLI_TAILORED_DORADO_V3_DEV_TYPES:
            return config.LIST_CLI_CMD_DORADO_V3
        if util.need_tailared_cli_cmd(self.product_model) and self.cli_type in config.LIST_CLI_CMD_COMBO.keys():
            return config.LIST_CLI_CMD_COMBO[self.cli_type]
        if self.product_model in config.DORADO_V6_DEV_TYPES:
            return config.LIST_CLI_CMD_DORADO_V6
        return config.LIST_CLI_CMD
