# -*- coding: UTF-8 -*-
import os
import codecs
import shutil
import traceback
from common.util import log, util
from common.cliFactory import cli
from common.config import config
from common.parseDisk import converSmartInfo
from cbb.frame.util.tar_util import decompress_tar_all_file

G_INFORMATION_SPLIT_STR = "\n" + 20 * "*" + "\n"

def dealSmartInfo(devObj, is_decompress=False):
    """
        处理从阵列侧收集的到得文件，将其转换为日志分析工具需要的格式
    """
    #创建处理后的smart信息的存放路径
    (isSucc, diskSmartInfoFolder) = createDir(devObj)
    if not isSucc:
        errMsgKey = "create.smartDir.failed"
        return (isSucc, errMsgKey)

    #创建basic.txt文件
    (isSucc, errMsgKey, diskInfoCliRet) = createBasicInfoFile(devObj, diskSmartInfoFolder)
    if not isSucc:
        return (isSucc, errMsgKey)

    #创建smart信息文件，sumary.ini文件
    smartInputDir = util.getLocalInfoPathByType(devObj, config.COLLECT_TYPE_SMART)
    tmp_dir = ""
    if is_decompress:
        tmp_dir = os.path.join(devObj[config.COLLECT_INFO_LOCAL_PATH], "temp")
        if not os.path.exists(tmp_dir):
            os.mkdir(tmp_dir)
            if not os.path.exists(tmp_dir):
                return False, "create.smart.file.failed"
        decompress_tar_all_file(os.path.join(smartInputDir, "diskinfo.tar"), tmp_dir, "r")
    logObj = devObj.get("logger")
    #获取所有disk的ID和DHA值
    diskIdList, diskDhaInfo = getDiskIdAndDha(diskInfoCliRet)
    log.info(devObj, "the list of disk id is %s" % str(diskIdList))
    try:
        converSmartInfo(smartInputDir if not is_decompress else tmp_dir, diskSmartInfoFolder, logObj, diskIdList,
                        diskDhaInfo, devObj)
    except:
        isSucc = False
        errMsgKey = "create.smart.file.failed"
        log.info(devObj, "write smart.txt or sumary.ini failed")
        log.info(devObj, "except trace back:" + str(traceback.format_exc()))

    return (isSucc, errMsgKey)


def createBasicInfoFile(devObj, fileBaseDir):
    """
        创建smart分析工具所需的basicinfo.txt文件
    """
    #获取CLI回显，并写入basicinfo.txt中
    (isSucc, errMsgKey, diskInfoCliRet) = writeBasicInfo2File(devObj,fileBaseDir)
    #写文件失败，则删除临时信息
    if not isSucc:
        deleteBaseDir(fileBaseDir)

    return (isSucc, errMsgKey, diskInfoCliRet)


def createDir(devObj):
    """
        创建处理后的smart信息的存放路径
    """
    isSucc = True
    diskSmartInfoFolder = devObj[config.COLLECT_INFO_LOCAL_PATH] + os.path.sep + "disksmartinfo"
    try:
        if os.path.exists(diskSmartInfoFolder):
            shutil.rmtree(diskSmartInfoFolder)

        os.makedirs(diskSmartInfoFolder)
    except:
        log.info(devObj, "except trace back:" + str(traceback.format_exc()))
        isSucc = False

    return (isSucc, diskSmartInfoFolder)


def writeFile(devObj, fileName, info, isAdd = True):
    '''
          向文件basicinfo.txt中写内容：
    '''
    isSucc = True
    try:
        #判断是否为追加内容
        if isAdd:
            localFile = codecs.open(fileName, "a", "utf-8")
        else:
            localFile = codecs.open(fileName, "w", "utf-8")

        localFile.write(info)
        localFile.flush()
        localFile.close()
    except:
        log.info(devObj, "write file failed because " + str(traceback.format_exc()))
        isSucc = False

    return isSucc


def deleteBaseDir(fileBaseDir):
    """
        处理失败，删除临时文件夹
    """
    try:
        shutil.rmtree(fileBaseDir, True)
    except:
        log.info(devObj, "delete base dir of smart disk infomation failed!")
        log.info(devObj, "excute cli.executeCmd failed because " + str(traceback.format_exc()))

def writeBasicInfo2File(devObj,fileBaseDir):
    '''
        回去CLI回显，并写入文件basicinfo.txt中
    '''
    (isSucc, errMsgKey, diskInfoCliRet) = (True, "", "")
    fileName = fileBaseDir + os.sep + "basicinfo.txt"

    #将设备IP写入basic.txt文件
    devIp = util.getDevIp(devObj)
    msgInfo = "smart analyzelog device ip : " + devIp + G_INFORMATION_SPLIT_STR
    isSucc = writeFile(devObj, fileName, msgInfo, False)
    if not isSucc:
        log.info(devObj, "write device ip to basic.txt failed!")

    #写系统信息
    cmd = "show system general"
    (isSucc, cliRet) = cli.executeCmdNoLogTimeout(devObj, cmd)
    if not isSucc:
        errMsgKey = "dev.conn.failure"
        return (isSucc, errMsgKey, diskInfoCliRet)
    else:
        product_model = util.getOEMproductModel(devObj)
        if product_model:
            cli_ret = get_new_cli_ret(cliRet, product_model)
        isSucc = writeFile(devObj, fileName, cli_ret + G_INFORMATION_SPLIT_STR)
        if not isSucc:
            errMsgKey = "create.basicinfo.file.failed"
            return (isSucc, errMsgKey, diskInfoCliRet)

    #写硬盘信息
    cmd = "show disk general |filterColumn include columnList=ID,Serial\sNumber,Type,Manufacturer,Health\sMark"
    (isSucc, diskInfoCliRet) = cli.executeCmd(devObj, cmd)
    if not isSucc:
        errMsgKey = "dev.conn.failure"
        return (isSucc, errMsgKey, diskInfoCliRet)
    else:
        isSucc = writeFile(devObj, fileName, diskInfoCliRet + G_INFORMATION_SPLIT_STR)
        if not isSucc:
            errMsgKey = "create.basicinfo.file.failed"
            return (isSucc, errMsgKey, diskInfoCliRet)

    return (isSucc, errMsgKey, diskInfoCliRet)

def getDiskIdAndDha(diskInfoCliRet):
    diskIdList = []
    diskDhaInfo = {}
    dictList = cli.getCliTable2DictList(diskInfoCliRet)
    for diskInfo in dictList:
        diskId = diskInfo.get("ID")
        diskIdList.append(diskId)

        diskDha = diskInfo.get("Health Mark")
        if diskDha is None or not diskDha.isdigit():
            diskDha = "N/A"
        diskDhaInfo.setdefault(diskId, diskDha)

    return diskIdList, diskDhaInfo


def get_new_cli_ret(cli_ret, product_model):
    """
    @summary: 将深度OEM设备的OEM厂商型号替换为华为型号，硬盘健康分析只能分析华为型号
    """
    new_cli_ret = ""

    for line in cli_ret.splitlines():
        new_line = line
        if "Product Model" in line and ": " in line:
            index = line.find(": ")
            new_line = line[:index] + ": " + product_model
        new_cli_ret += new_line + "\n"

    return new_cli_ret
