# -*- coding: UTF-8 -*-
from java.io import File
from com.huawei.ism.tool.obase.exception import ToolException
from disklogConf import disklogConf
from cliFactory import cli
from config import config
from cbb.frame.cli import cliUtil
from cbb.frame.cli.cliUtil import hasMonitorOrAdminOrSuperAdminPrivilege
from cbb.frame.cli.cliUtil import is_super_administrator
from cbb.frame.cli.cliUtil import PrivilegeType
from cbb.frame.rest import restUtil
from com.huawei.ism.tool.base.utils import FileUtils
from com.huawei.ism.tool.infocollect.service.backgroud import TaskCons
from com.huawei.ism.tool.infocollect.util import QueryUpgradeStates
from utils import Products
import codecs
import os
import stat
import re
import resource
import shutil
import sys
try:
    reload(sys)
    sys.setdefaultencoding('utf-8')
except:
    pass
import time
import threading
import traceback

NEW_DHA_NOT_SUPPORT_VERSION = "6.1.3RC"
CLI_RET_END_FLAG = ":/>"

class systemMode():
    @staticmethod
    def reconnect_ssh(cli, logger):
        try:
            cli.reConnect()
            logger.logInfo(
                "it is afresh to connect to device by ssh gallery.")
            return True
        except (ToolException, Exception):
            logger.logError(str(traceback.format_exc()))
            return False

    @staticmethod
    def enterDeveloperMode(devObj):
        '''
        @summary: 进入developer模式
        @param cliRet: devObj=上下文对象
        @return: True=成功，False=失败
        '''
        
        #打开切换developer模式开关！
        isSuccess,switch = systemMode.openDeveloperSwitch(devObj)
        if not isSuccess:
            return False
        
        devObj["switch"] = switch
        
        #发送命令
        cmd = "change user_mode current_mode user_mode=developer"
        (isSuccess, cliRet) = cli.executeCmd(devObj, cmd)
        if not isSuccess:
            util.setPyDetailMsg(devObj, "dev.conn.failure")
            return False
        
        
        if re.search("developer:", cliRet, re.IGNORECASE):
            return True
        
        #dorado c00进入developer需要进行交互,最多三次
        for times in range(3):
            if re.search("(y/n)", cliRet, re.IGNORECASE):
                (isSuccess, cliRet) = cli.executeCmd(devObj, "y")
                if not isSuccess:
                    util.setPyDetailMsg(devObj, "dev.conn.failure")
                    return False
                
            if re.search("developer:/>", cliRet, re.IGNORECASE):
                return True
            
            if re.search("Password:", cliRet, re.IGNORECASE):
                break
        
        #若以上操作未进入developer，则需要输入密码，其他场景为错误场景    
        if None == re.search("Password:", cliRet, re.IGNORECASE):
            log.info(devObj, "enterDeveloperMode fail")
            return False
        
        developerPwd = util.getDevDeveloperPwd(devObj)
        #判断developer密码是否为空
        if None == developerPwd or "" == developerPwd :
            del developerPwd
            return False
        
        cliRet = ""
        (isSuccess, cliRet) =  cli.executeCmdNoLogTimeout(devObj, developerPwd)
        if not isSuccess:
            util.setPyDetailMsg(devObj, "dev.conn.failure")
            return False
        
        del developerPwd
        if None == re.search("developer:", cliRet, re.IGNORECASE):
            log.info(devObj, "enterDeveloperMode fail")
            return False
        
        return True

    @staticmethod
    def enterMinisystemMode(devObj):
        '''
        @summary: 进入minisystem模式
        @param cliRet: devObj=上下文对象
        @return: True=成功，False=失败
        '''
        #发送命令
        if not systemMode.enterDeveloperMode(devObj):
            return False
        
        (isSuccess, miniRet) = cli.executeCmd(devObj, 'minisystem')
        if not isSuccess:
            util.addPyDetailMsg(devObj, 'enter.minisystem.mode.failed')
            systemMode.developerMode2CliMode(devObj)
            return False
        
        if miniRet.strip().endswith('minisystem>'):
            return True
        else:
            util.addPyDetailMsg(devObj, 'enter.minisystem.mode.failed')
            systemMode.developerMode2CliMode(devObj)
            return False
            
    @staticmethod
    def developerMode2CliMode(devObj):
        '''
        @summary: developer模式下退回到cli模式
        @param cliRet: devObj=上下文对象
        '''        
        (isSuccess, cliRet) = cli.executeCmd(devObj, "show system general")
        if not isSuccess:
            util.setPyDetailMsg(devObj, "dev.conn.failure")
            return
        
        #密码输入错误时及正常情况从developer模式下退出
        if ("Password" in cliRet) or ("developer:/>" in cliRet):
                    
            (isSuccess, cliRet) = cli.executeCmd(devObj, "exit")
            if not isSuccess:
                util.setPyDetailMsg(devObj, "dev.conn.failure")
                return
            if "upgrade:/>" in cliRet :
                log.info(devObj, "change to upgrade:/>")
                return
            cliRet = cli.executeCmd(devObj, "exit")
            log.info(devObj, "Sequence[5] change to cli model")
            index = 0
            while ("admin:/>" not in cliRet) or ("upgrade:/>" not in cliRet):
                index = index + 1
                (isSuccess, cliRet) = cli.executeCmd(devObj, "exit")
                if not isSuccess:
                    util.setPyDetailMsg(devObj, "dev.conn.failure")
                    return
                if "Are you sure to exit?(y/n):" in cliRet:
                    (isSuccess, cliRet) = cli.executeCmd(devObj, "n")
                    if not isSuccess:
                        util.setPyDetailMsg(devObj, "dev.conn.failure")
                        return
                if index > cli.CLI_ENTER_DEVELOPER_MODEL_MAX_RETRYS:
                    break
    
    @staticmethod
    def isInDeveloperMode(devObj):
        '''
        @summary: 判断当前是否在developer模式下
        @param cliRet: cli回显
        @return: 
            True: 当前在developer模式下
            False: 当前不在developer模式下
        '''
        (isSuccess, cliRet) = cli.executeCmdNoLogTimeout(devObj, "show system general")
        if not isSuccess:
            util.setPyDetailMsg(devObj, "dev.conn.failure")
            return False
        
        if re.search(cli.CLI_DEVELOPER_MODEL_FLAG, cliRet, re.IGNORECASE):
            return True
        return False

    @staticmethod
    def openDeveloperSwitch(devObj):
        '''
        @summary:打开切换developer模式开关
        '''
        switch = True
        #兼容Dorado版本，查看切developer模式开关是否打开
        developercmd = "show user_mode enabled"
        (isSuccess, cliRet) = cli.executeCmd(devObj, developercmd)
        if not isSuccess:
            return isSuccess,switch
        
        cliRetDictList = systemMode.getVerticalCliRet(cliRet)
        developerswitch = ""
        for dict in cliRetDictList:
            if "Developer View" in dict:
                developerswitch = dict.get("Developer View","")
                break
            
        if developerswitch == "Disabled":
            switch = False
            #开关关闭则打开 
            opencmd = "change user_mode enabled user_mode=developer enabled=yes"
            (isSuccess, cliRet) = cli.executeCmd(devObj, opencmd)
            if not isSuccess:
                return isSuccess,switch
        
        return isSuccess,switch

    @staticmethod
    def closeDeveloperSwitch(devObj):
        '''
        @summary: 关闭developer视图开关
        '''
        try:
            closecmd = "change user_mode enabled user_mode=developer enabled=no"
            cli.executeCmd(devObj, closecmd)
        except:
            log.error(devObj, traceback.format_exc())
            pass

    @staticmethod
    def getVerticalCliRet(cliRet):
        '''
        @summary: 按逐行字典的方式获取垂直表格形式的cli回显集合
        @param cliRet: cli回显
        @return: 将表格形式cli回显处理为以表头为key，以项值为键的字典集合,处理不正常时，返回空集合
        '''
        cliRetList = cliRet.encode("utf8").splitlines()
        dictList = []
        lineDict = {}
        for line in cliRetList:
            if CLI_RET_END_FLAG in line:
                break
            
            if re.search("^-+\r*\n*$", line):
                dictList.append(lineDict.copy())
                lineDict.clear()
                
            fields = line.split(" : ")
            if len(fields) < 2:
                continue
            
            key = fields[0].strip().decode("utf8")
            value = ":".join(fields[1:len(fields)]).strip().decode("utf8")
            
            if lineDict.has_key(key):
                key += "_" + str(str(lineDict.keys()).count(key + "_") + 1)
            lineDict.setdefault(key, value)
        
        if len(lineDict) > 0:
            dictList.append(lineDict.copy())
        
        return dictList

    @staticmethod
    def enterDiagnoseMode(devObj):
        '''
        @summary: 进入diagnose模式
        @param cliRet: devObj=上下文对象
        @return: True=成功，False=失败
        '''
        if not systemMode.enterDeveloperMode(devObj):
            return False
        
        #发送命令
        (isSuccess, cliRet) = cli.executeCmd(devObj, "debug")
        if not isSuccess:
            util.setPyDetailMsg(devObj, "enter.diagnose.mode.failed")
            systemMode.developerMode2CliMode(devObj)
            return False
        
        if cliRet.strip().endswith("diagnose>"):
            return True
        else:
            log.error(devObj, "Enter in diagnose mode failed")
            util.setPyDetailMsg(devObj, "enter.diagnose.mode.failed")
            systemMode.developerMode2CliMode(devObj)
            return False
             
    @staticmethod
    def exitDiagnoseOrMinisystem(devObj):
        '''
        @summary: 从小系统或者diagnose模式下退回到cli模式
        @param cliRet: devObj=上下文对象
        '''
        (isSuccess, exitRet) = cli.executeCmd(devObj, "exit")
        if not isSuccess:
            util.setPyDetailMsg(devObj, "exit.diagnose.minisystem.failed")
            return
        
        if exitRet.strip().endswith('(y/n)'):
            (isSuccess, exitRet) = cli.executeCmd(devObj, "y")
            
        systemMode.developerMode2CliMode(devObj)
        return        
             
    @staticmethod
    def isScpCmdExist(devObj):
        '''
        @summary: 判断小系统模式下是否存在'scp'命令.
        @param devObj: devObj=上下文对象
        '''
        (isSuccess, scpRet) = cli.executeCmd(devObj, "scp")
        if not isSuccess:
            util.addPyDetailMsg(devObj, "qry.whether.scp.cmd.exist.failed")
            return False, False
        
        if 'usage: scp' in scpRet:
            return True, True
        else:
            return True, False
        
    @staticmethod    
    def deletePath(devObj, pathName):
        toDeletRmtPthCmd = 'rm -rf ' + pathName
        isExeSucc, delRet = cli.executeCmdWithTimout(devObj, toDeletRmtPthCmd, 60)
        while isExeSucc and 'y/n' in delRet:
            isExeSucc, delRet = cli.executeCmdWithTimout(devObj, 'y', 60)    
        
    @staticmethod    
    def deleteDirectory(devObj, pathName):
        sftp = util.getSftp(devObj)
        try:
            sftp.deleteDir(pathName)
        except ToolException, te:
            log.info(devObj, "Delete directory by SFTP exception:" + unicode(te))
            try:
                systemMode.deletePath(devObj, pathName)
            except Exception, e:
                log.error(devObj, 'Delete directory by CLI exception, directory:' + unicode(pathName) + unicode(e))
            
    @staticmethod
    def heartbeatToPeer(devObj, usrPwd):
        '''
                    函数名称: heartbeatToPeer
                    功能说明: 从本端minisystem模式心跳到对端，此方法须在minisystem模式下调用
                    输入参数: devObj, usrPwd
                    输出参数: 无
                    返 回 值: True or False    
        '''
        try:
            (isSuccess, rec) = cli.executeCmdWithTimout(devObj, 'sshtoremote', 60)
            if not isSuccess:
                log.info(devObj, "execute sshtoremote failed.")  
                return False
            
            log.info(devObj, "XXXX:" + rec) 
             
            if "System is not ready" in rec:
                log.info(devObj, "execute sshtoremote failed")  
                return False
            
            if "password:" in rec:
                (isSuccess, rec) = cli.executeCmdNoLogTimeout(devObj, usrPwd, 60)
                if not isSuccess:
                    log.info(devObj, "sshtoremote failed when inputting user password.")
                    return False
                
                if cli.TOOLKIT_SEND_CMD_TIME_OUT == rec:
                    log.info(devObj, "[heartbeatToPeer] execute cmd timeout.")  
                    return False
                
                if  rec.endswith(":/>"):    #对端正常不进行日志 收集,并且退出对端。
                    (isSuccessExit, recExit) = cli.executeCmdWithTimout(devObj, "exit", 60)
                    if not isSuccessExit:
                        log.info(devObj, recExit) 
                        return False
                    
                    (isSuccessY, recY) = cli.executeCmdWithTimout(devObj, "y", 60)
                    if not isSuccessY:
                        log.info(devObj, recY) 
                        return False
                    
                    if "Storage:~ #" in recY:  #兼容debug包
                        (isSuccessExit, recExit) = cli.executeCmdWithTimout(devObj, "exit", 60)
                        if not isSuccessExit:
                            log.info(devObj, recExit) 
                            return False
                    
                    log.info(devObj, "[heartbeatToPeer] the Opposite Equip is right need not to collect")  
                    return "Normal"
                
                if rec.strip().endswith(cli.CLI_RET_END_FLAG): 
                    return True
                
            log.info(devObj, "[heartbeatToPeer] heart to peer failed.")
            return False
        except:
            log.error(devObj, "[heartbeatToPeer] catch trace backxxx:" + unicode(traceback.print_exc()))
            return False

    @staticmethod
    def heartbeatToPeerByCtrlId(devObj, usrPwd, controllerId):
        '''
                    函数名称: heartbeatToPeerByCtrlId
                    功能说明: 从本端minisystem模式心跳到对端，此方法须在minisystem模式下调用
                    输入参数: devObj, usrPwd, controllerId
                    输出参数: 无
                    返 回 值: True or False
        '''
        try:
            if not systemMode.enterMinisystemMode(devObj):
                return False
            (isSuccess, rec) = cli.executeCmdWithTimout(devObj, "sshtoremoteExt %s" % str(controllerId), 60)
            if not isSuccess:
                log.info(devObj, "execute sshtoremote failed.")
                return False

            log.info(devObj, "XXXX:" + rec)

            if "System is not ready" in rec:
                log.info(devObj, "execute sshtoremote failed")
                return False

            if "password:" in rec:
                (isSuccess, rec) = cli.executeCmdNoLogTimeout(devObj, usrPwd, 60)
                if not isSuccess:
                    log.info(devObj, "sshtoremote failed when inputting user password.")
                    return False

                if cli.TOOLKIT_SEND_CMD_TIME_OUT == rec:
                    log.info(devObj, "[heartbeatToPeer] execute cmd timeout.")
                    return False

                if rec.strip().endswith(cli.CLI_RET_END_FLAG):
                    return True

            log.info(devObj, "[heartbeatToPeer] heart to peer failed.")
            return False
        except:
            log.error(devObj, "[heartbeatToPeer] catch trace backxxx:" + unicode(traceback.print_exc()))
            return False

    @staticmethod
    def exitHeartbeatCli(devObj):
        '''
        @summary: Exit from minisystem mode of peer controller to local controller CLI mode.
        @return:None
        '''
        try:
            for _ in xrange(3):
                _, cliRet = cli.executeCmd(devObj, "exit")

                while "(y/n)" in cliRet:
                    _, cliRet = cli.executeCmd(devObj, "y")
                # Compatible for debug version.
                if "Storage:~ #" in cliRet:
                    _, cliRet = cli.executeCmd(devObj, "exit")
        except:
            traceback.format_exc(None)
        
             
class device():
    @staticmethod
    def getEngineNum(devObj):
        (isSuccess, qryEncRet) = cli.executeCmdWithTimout(devObj, cli.QRY_ENGINE_CMD, 60)
        if not isSuccess:
            log.error(devObj, "execute show enclosure failed.")
            util.addPyDetailMsg(devObj, 'query.dev.is.6U4CTRL.dev.failed')
            return False, 0
        else:
            engNum = 0
            for line in qryEncRet.splitlines()[1:]:
                line = line.strip()
                fields = line.split()
                if line and len(fields) > 2 and fields[1].strip() in ['Engine', 'engine']:
                    engNum +=1
                    
        return True, engNum
        
    @staticmethod
    def is6U4CtrlDevice(devObj):
        (isSuccess, qryEncRet) = cli.executeCmdWithTimout(devObj, 'show enclosure', 60)
        if not isSuccess:
            log.error(devObj, "execute show enclosure failed.")
            util.addPyDetailMsg(devObj, 'query.dev.is.6U4CTRL.dev.failed')
            return False, False
        else:
            if re.search('6U 4 Controllers Enclosure', qryEncRet, re.I):
                return True, True
            else:
                return True, False
    
    @staticmethod
    def getDeviceSn(devObj):
        '''
                    获取设备SN号
        '''
        devNode = devObj.get("devNode")
        
        if None == devNode:
            return ""
        
        sn = devNode.getDeviceSerialNumber()
        
        return sn
    
    @staticmethod
    def getDeviceType(devObj):
        '''
                    获取设备具体型号,如S5600T
        '''
        devNode = devObj.get("devNode")
        
        if None == devNode:
            return ""
        
        devType = devNode.getDeviceType()
        
        return devType
    
    @staticmethod
    def isX86Architecture(devObj):
        devType = str(device.getDeviceType(devObj)).strip()
        return devType not in config.ARM_ARCHITECTURE_DEV_TYPE_LIST
    
    @staticmethod
    def getDeviceVersion(devObj):
        '''
                    获取设备版本号,如：V200R002C11
        '''
        
        devNode = devObj.get("devNode")
        
        if None == devNode:
            return ""
        
        version = devNode.getProductVersion()
        
        return version
    @staticmethod
    def parse_upgradePackage(devObj):
        '''
        @summary: 执行show upgrade packge命令，将Software Version与HotPatch Version的
                  回显存放到列表中
        '''    
        cmd = "show upgrade package"
        softwareVersionList = []
        hotPatchVersionList = []    
        
        issucess, cliRet = cli.executeCmdWithRetry(devObj, cmd)
        if issucess !=True:
            return (issucess,softwareVersionList,hotPatchVersionList)
        
        softwareVersionIndex = cliRet.find("Software Version")
        hotPatchVersionIndex = cliRet.find("HotPatch Version")
        softwareVersionList = util.getHorizontalCliRet(cliRet[(softwareVersionIndex):hotPatchVersionIndex])
        hotPatchVersionList = util.getHorizontalCliRet(cliRet[(hotPatchVersionIndex):])
        
        if len(softwareVersionList) == 0 or len(hotPatchVersionList) == 0:
            log.info(devObj, "cannot get product version or hot Patch Version")          
            return (False, softwareVersionList , hotPatchVersionList)

        return (True,softwareVersionList,hotPatchVersionList)

    @staticmethod
    def getCurrentVersion(devObj,softwareVersionList):
        '''
        @summary: 通过software信息字典列表获取版本信息
        '''
        currentVersion = ""
        for controller in softwareVersionList:
            currentVersion = controller["Current Version"]
            return (True, currentVersion)
        
        log.info(devObj, "cannot get product version info")
        return (False,'')     
      
    @staticmethod
    def getDeviceSsh(devObj):
        '''
                    获取设备版本号,如：V200R002C11
        '''
        ssh = devObj.get("SSH")
        
        return ssh
    
    @staticmethod
    def getDevicePassword(devObj):
        '''
                    获取设备密码，心跳连接
        '''
        
        password = devObj.get("password")
        
        if None == password:
            return ""
        
        return password
        
    @staticmethod
    def getBond0IP(devObj):
        '''
                    通过解析ifconfig命令获取控制器心跳IP,，如果获取失败，返回空字符串。
        '''
        qryBond0Cmd = "ifconfig bond0"
        (isCmdExeSucc, bond0Ret) = cli.executeCmdWithTimout(devObj, qryBond0Cmd, 60)
        if not isCmdExeSucc:
            log.error(devObj, "Execute ifconfig bond0 failed.")
            return ''
        
        for line in bond0Ret.splitlines():
            if line.strip().startswith("inet addr:") and '127.127.127' in line:
                return line.split(':')[1].split()[0].strip()
            if line.strip().startswith("inet") and '127.127.127' in line:
                return line.split()[1].strip()
            
        return ''
    
    @staticmethod
    def getPeerBond0IP(devObj):
        '''
                    通过解析ifconfig命令获取控制器心跳IP
        '''
        thisBond0Ip = device.getBond0IP(devObj)
        if not thisBond0Ip:
            return ''
        elif thisBond0Ip == '127.127.127.10':
            return '127.127.127.11'
        elif thisBond0Ip == '127.127.127.11':
            return '127.127.127.10'
        else:
            return ''
        
    @staticmethod
    def getFreeMemInAdmin(devObj):
        '''
        cli模式下查询当前控制器剩余内存,对CLI模式无影响。
        '''
        if not systemMode.enterMinisystemMode(devObj):
            return -1
        
        try:
            (isCmdExeSucc, memRet) = cli.executeCmdWithTimout(devObj, 'free -m', 60)
            if not isCmdExeSucc:
                return -1
            
            for memLine in memRet.splitlines():
                if 'Mem:' in memLine:
                    return int(memLine.split()[3].strip())
        except:
            return -1
        finally:
            systemMode.exitDiagnoseOrMinisystem(devObj)    

    @staticmethod
    def getFreeMemInMinisystem(devObj):
        '''
        minisystem模式下查询当前控制器剩余内存,对CLI模式无影响。
        '''
        try:
            (isCmdExeSucc, memRet) = cli.executeCmdWithTimout(devObj, 'free -m', 60)
            if not isCmdExeSucc:
                return -1
            
            for memLine in memRet.splitlines():
                if 'Mem:' in memLine:
                    return int(memLine.split()[3].strip())
        except:
            return -1
'''
信息收集，基本的工具方法
'''
class util():
    @staticmethod
    def check_contain_chinese(check_str):
        for ch in check_str.decode('utf-8'):
            if u'\u4e00' <= ch <= u'\u9fff':
                return True
        return False

    @staticmethod
    def queryResultWithNoRecord(cliRet):
        '''
        @summary: 判断回显是否为Command executed successfully
        @param cliRet: cli回显
        @return:
            True: cli回显中包含Command executed successfully
            False: cli回显中不包含Command executed successfully
        '''
        CLI_EXECUTE_CMD_SUCCESS = "Command executed successfully"
        if re.search(CLI_EXECUTE_CMD_SUCCESS, cliRet, re.IGNORECASE):
            return True
        return False

    @staticmethod
    def getLoginPasswd(devObj):
        devNode = devObj.get("devNode")
        password = devNode.getLoginUser().getPassword()
        return password

    @staticmethod
    def getPort(devObj):
        devNode = devObj.get("devNode")
        return str(devNode.getPort())
    
    @staticmethod
    def isSystemUpgrading(devObj):
        '''
                    函数名称: isSystemUpgrading
                    功能说明: 检验当前设备是否处于升级中
                    输入参数: devObj
                    输出参数: True, False
        '''
        flag = False
        cmd = "show system general"
        (isSuccess, cliRet) = cli.executeCmdNoLogTimeout(devObj, cmd)
        if not isSuccess:
            util.setPyDetailMsg(devObj, "dev.conn.failure")
            return True
        
        cliList = cliRet.splitlines()
        #只关注最后一行回显
        if config.SYSTEM_RUNNING_STATUS_UPGRADING in cliList[-1] and not devObj.get("isSupportUpgradeCollect", False) \
                and not QueryUpgradeStates.allowCollect(devObj.get("devNode")):
            util.setPyDetailMsg(devObj, 'system.isUpgrading')
            flag = True
        return flag
    @staticmethod
    def isCli4DiskInfoAvaliable(devObj):
        '''
        @summary: V5R7 & V3R6C10 series uses CLI cmd to collect disk information
        @return: isCmdExecutedSuccessfully, isCollectingUsingClientCmd
        '''
        #查询系统版本号
        devNode = devObj.get("devNode")
        sysSpcVersion = devNode.getProductVersion()
        devType = str(devNode.getDeviceType())
        log.info(devObj, "sysSpcVersion:[%s]  devType:[%s]"%(sysSpcVersion, devType))
        if devType in config.DORADO_V6_DEV_TYPES:
            return True, True

        if len(sysSpcVersion) < 11 :
            return False, False
        #通过版本号确定命令是否支持
        if sysSpcVersion >= "V500R007C00":
            return True, True
        elif sysSpcVersion[:4] == "V300" and sysSpcVersion >= "V300R006C10":
                return True, True
        elif "Dorado" in devType and sysSpcVersion >= "V300R002C00":
                return True, True

        return True, False
    
    @staticmethod
    def getOEMproductModel(devObj):
        """
        @summary: 获取深度OEM设备的华为型号（V2R6C10，V5R7及其之后版本show system general获取的是OEM厂商型号）
        """
        product_model = restUtil.CommonRest.getOriginProductModel(devObj.get("devNode"))
        if product_model:
            return product_model
        cmd = "show system general|filterColumn exclude columnList=Product\sModel"
        isSucc, cliRet = cli.executeCmdNoLogTimeout(devObj, cmd)
        if not isSucc:
            return ""
        
        for line in cliRet.splitlines():
            item = line.split(":")
            if len(item) != 2:
                continue
            key = item[0].strip()
            if key == "Internal Product Model":
                productModel = item[1].strip()
                return productModel
        
        return ""

    @staticmethod
    def is18000Series(devObj):
        '''
        @summary: judge whether this  is a 18000 series device
        @return: boolean, boolean  
        '''
        productModel = util.getOEMproductModel(devObj)
        if productModel:
            for HIGH_END_DEV in config.HIGH_END_SERIES_DEV_TYPE_LIST:
                if HIGH_END_DEV in productModel:
                    return True, True
            
        cmd = "show system general"
        isSuccess, cliRet = cli.executeCmdWithTimout(devObj, cmd, 3*60)
        if not isSuccess:
            log.info(devObj, "execute command show system general failed...")
            return isSuccess, False
        for HIGH_END_DEV in config.HIGH_END_SERIES_DEV_TYPE_LIST:
            if HIGH_END_DEV in cliRet:
                return True, True
        
        return True, False

    @staticmethod
    def is_X10(dev_obj):
        '''
        @summary: 判断设备是否是X10设备（版本号里带kunpneg，或Dorado6.0之后）
        @return: isAfter  V5R7C60 Kunpeng or Dorado 6.0.0
        '''
        # 查询系统版本号
        dev_node = dev_obj.get("devNode")
        sys_spc_version = dev_node.getProductVersion()
        dev_type = str(dev_node.getDeviceType())
        if dev_type in config.DORADO_V6_DEV_TYPES:
            return True
        if "kunpeng" in sys_spc_version.lower():
            return True
        return False

    @staticmethod
    def ping(devObj, ipV4):
        '''
        @summary: start ping process
        @param ipV4: IP address in V4 mode
        @return: isReachable : boolean
        '''        
        isParamValid = re.match("((2[0-4]\d|25[0-5]|[01]?\d\d?)\.){3}(2[0-4]\d|25[0-5]|[01]?\d\d?)",ipV4)
        if not isParamValid : 
            return False
        strCmd = "ping -c 5 " + ipV4
        (isSuccess, cliRet) = cli.executeCmdWithTimout(devObj, strCmd, 3*60)
        if not isSuccess:
            return False
        
        if re.search("ttl", cliRet, re.I):
            return True
        
        return False
          
    @staticmethod
    def checkSystemNormal(devObj):
        '''
                    函数名称: checkSystemNormal
                    功能说明: 检验当前设备是否normal
                    输入参数: devObj
                    输出参数: True, False
        '''
        flag = False
        cliRet = ""
        cmd = "show system general"        
        (isSuccess, cliRet) =  cli.executeCmdNoLogTimeout(devObj, cmd)
        if not isSuccess:
            util.setPyDetailMsg(devObj, "dev.conn.failure")
            return False
        
        if re.search("System Name", cliRet, re.IGNORECASE):
            flag = True
        else:
            util.setPyDetailMsg(devObj, 'system.abnormal')
            
        return flag

    @staticmethod
    def check_system_normal(dev_obj):
        flag = False
        cmd = "show system general"
        is_success, cli_ret = cli.executeCmdNoLogTimeout(dev_obj, cmd)
        if not is_success:
            return False, util.getMsg(dev_obj, "dev.conn.failure")
        err_msg = ""
        if re.search("System Name", cli_ret, re.IGNORECASE):
            flag = True
        else:
            err_msg = util.getMsg(dev_obj, "system.abnormal")
        return flag, err_msg

    @staticmethod
    def getUserNameCli(devObj):
        '''
        @summary: 用CLI的方式，获取当前的用户名（当上下文对象中不存在用户名时，用到）
        @param cliRet: devObj=上下文对象
        @return: userName
        '''
        userName = ""        
        (isSuccess, cliRet) = cli.executeCmdNoLogTimeout(devObj, "show system general")
        if not isSuccess:
            return (isSuccess, userName)
        
        #输入CLI回显是否有效
        if None == cliRet or "" == cliRet: 
            return (isSuccess, userName)
        
        #执行命令获取当前登录的用户名      
        lineList = cliRet.splitlines()
        #用户名一定包含在最后一行中
        if lineList[-1].find(cli.CLI_RET_END_FLAG):
            userName = lineList[-1].replace(" ","").replace(cli.CLI_RET_END_FLAG,"")
        return (isSuccess, userName)
    
    @staticmethod
    def getUsername(devObj):
        '''
        @summary: 获取上下文中的用户名
        @param cliRet: devObj=上下文对象
        @return: name
        '''
        isSuccess = True
        name = devObj.get("username")
        
        if None == name or "" == name: 
            (isSuccess, name) = util.getUserNameCli(devObj)
            
        return (isSuccess, name)
        
    @staticmethod
    def getUserPrivilege(devObj):
        '''
        @summary: 获取用户权限级别
        @param cliRet: devObj=上下文对象
        @return: userLevel
        '''
        userLevel = ""
        #首先获取用户名
        (isSuccess, userName) = util.getUsername(devObj)
        
        if not isSuccess:
            (isSuccess, userLevel)
        
        if None == userName or "" == userName:
            return (isSuccess, userLevel)
        
        log.info(devObj, "Get login name is:"+str(userName))
        
        #根据用户名，查询用户权限        
        (isSuccess, cliRet) = cli.executeCmdNoLogTimeout(devObj, "show user user_name=" + userName)
        if not isSuccess:
            util.setPyDetailMsg(devObj, "dev.conn.failure")
            return (isSuccess, userLevel)
        
        rec = cli.getCliTable2DictList(cliRet)
        if len(rec) == 0:
            return (isSuccess, userLevel)
        
        #获取用户权限的行信息
        level = rec[0]
        if "Level" in level:
            userLevel = level["Level"]
        
        return (isSuccess, userLevel)

    @staticmethod
    def is_super_admin(dev_obj):
        '''
        检查用户权限是否为为超级管理员
        :param dev_obj: 上下文对象
        :return: 是否是超级管理员权限
        '''
        log.info(dev_obj, "Start check user privilege.")
        is_success, user_name = util.getUsername(dev_obj)
        if not is_success or not user_name:
            log.info(dev_obj, "check user name failed.")
            return False
        ssh = dev_obj.get("SSH")
        lang = dev_obj.get("lang")
        is_success, is_super_admin_privilege, ret = is_super_administrator(ssh, util.get_user_name(user_name), lang)
        if is_success and is_super_admin_privilege:
            return True
        log.error(dev_obj, "check user is super admin failed. ret is: {}".format(ret))
        return False

    @staticmethod
    def get_user_name(user_name):
        return user_name.replace("domain/", "") if user_name.startswith("domain/") else user_name

    @staticmethod
    def checkUserPrivilege(devObj, type=None):
        '''
        @summary: 检查用户权限，用户权限为["Super_admin" 或  "Admin"],则返回True，否则返回False
        @param cliRet: devObj=上下文对象
        @return: userLevel
        '''
        if util.check_a800_upgrade_mode(devObj):
            return True
        isSuccess, productModel = getProductModel(devObj)
        if not isSuccess:
            util.setPyDetailMsg(devObj, "query.result.abnormal")
            return False
        log.info(devObj, "checkUserPrivilege productModel:%s"%productModel)
        ssh = devObj.get("SSH")
        lang = devObj.get("lang")
        isPrivilege = False
        if productModel in config.CHECK_RIGHT_BY_ROLEID_DEV_TYPES:
            isSuccess, isPrivilege, errMsg = \
                hasMonitorOrAdminOrSuperAdminPrivilege(
                    ssh, lang, PrivilegeType.ROLE_ID)
        else:
            isSuccess, isPrivilege, errMsg = \
                hasMonitorOrAdminOrSuperAdminPrivilege(ssh, lang)
        if not isSuccess:
            util.setPyDetailMsg(devObj, "query.result.abnormal")
            return False
            
        if isPrivilege != True:
            util.setPyDetailMsg(devObj, "user.level.low")
        
        return isPrivilege

    @staticmethod
    def check_a800_upgrade_mode(dev_obj):
        dev_node = dev_obj.get("devNode")
        cmd = "show system general"
        (is_success, cli_ret) = cli.executeCmdNoLogTimeout(dev_obj, cmd)
        if not is_success:
            log.info(dev_obj, "The device is disconnected.")
            return False

        cli_list = cli_ret.splitlines()
        # 升级模式下，如果配置文件为升级中允许收集，或者A800在升级暂停/失败状态，则跳过用户权限检查
        if config.SYSTEM_RUNNING_STATUS_UPGRADING in cli_list[-1] \
                and (dev_obj.get("isSupportUpgradeCollect", False) or QueryUpgradeStates.allowCollect(dev_node)):
            log.info(dev_obj, "In the upgrade mode of the A800, the permission check is skipped.")
            return True
        return False

    @staticmethod
    def check_user_privilege_by_role_id(dev_obj):
        if util.check_a800_upgrade_mode(dev_obj):
            return True
        is_success, product_model = getProductModel(dev_obj)
        if not is_success:
            return False, util.getMsg(dev_obj, "query.result.abnormal")
        ssh = dev_obj.get("SSH")
        lang = dev_obj.get("lang")
        is_success, is_privilege, err_msg = hasMonitorOrAdminOrSuperAdminPrivilege(ssh, lang, PrivilegeType.ROLE_ID)
        if not is_success:
            return False, util.getMsg(dev_obj, "query.result.abnormal")
        err_msg = ""
        if not is_privilege:
            err_msg = util.getMsg(dev_obj, "user.level.low")
        return is_privilege, err_msg
    
    @staticmethod
    def isChinese(devObj):
        '''
        @summary: 判断当前语言类型
        @param lang: 语言lang
        @return: 
            True: 中文
            False: 非中文
        '''
        lang = devObj.get("lang")
        if "zh" == lang:
            return True
        return False
    
    @staticmethod
    def getMsg(devObj, msg, args = ""):
        '''
        @summary: 获取资源信息
        @param cliRet: devObj=上下文对象, msg=资源脚本（resource.py）中对应的Key，args=占位符对应的值
        @return: msg
        '''
        if  None == msg or "" == msg:
            return ""
        
        lang = devObj.get("lang")
        if resource.MESSAGES_DICT.has_key(msg):
            msgDict = resource.MESSAGES_DICT.get(msg)
            msg = msgDict[lang]
        
        #若占位符的值不为”“，则天冲高占位符
        if "" != args:
            msg = msg % args
            
        return msg
    
    @staticmethod
    def setCollectAllInfo(devObj, flag):
        '''
        @summary: 设置是否部分收集成功
        @param flag: flag = True 该项收集成功，flag=False 该项部分收集成功
        '''
        devObj["collectAllInfo"] = flag
    
    @staticmethod
    def isExistDetailMsg(devObj):
        '''
        @summary: 判断错误信息是否已经设置
        @param devObj: 上下文对象
        @return: True or False
        '''
        msg = devObj["py_detail"]
        if None == msg or "" == msg:
            return False
        
        return True
    
    @staticmethod
    def initPyDetailMsg(devObj):
        '''
        @summary: 清除之前设置的错误信息
        @return: 无
        '''
        devObj["py_detail"] = ""
    
    @staticmethod
    def setPyDetailMsg(devObj, msg, args = ""):
        '''
        @summary: 消息国际化
        @param lang: 语言lang
        @param msg: 消息
        @param args: 消息参数
        @return: 经过国际化处理后的消息
        '''
        msg = util.getMsg(devObj, msg, args)
        
        devObj["py_detail"] = msg
        
    @staticmethod
    def addPyDetailMsg(devObj, msg, args = ""):
        '''
        @summary: 消息国际化
        @param lang: 语言lang
        @param msg: 消息
        @param args: 消息参数
        @return: 经过国际化处理后的消息
        '''
        msg = util.getMsg(devObj, msg, args)
        oldMsg = devObj["py_detail"]
        devObj["py_detail"] = (oldMsg + os.linesep + msg) if oldMsg else msg 
        
    @staticmethod
    def getDevIp(devObj):
        '''
        @summary: 根据上下文，获取当前连接的IP
        @param cliRet: devObj=上下文对象
        @return: ip
        '''
        ip = devObj.get("devIp")
        return ip
    
    @staticmethod
    def getSftp(devObj):
        '''
        @summary: 根据上下文，获取sftp对象
        @param cliRet: devObj=上下文对象
        @return: sftp
        '''
        sftp = devObj.get("SFTP")
        return sftp
            
    @staticmethod
    def readFile(filePath):
        try:
            f = None
            f = open(filePath)
            info = f.read()
            return info
        except:
            return None
        finally:
            if None != f:
                f.close()
    
    @staticmethod
    def cleanDir(dir, devObj=None, log=None):
        '''
        @summary: 根据路径，删除路径
        @param cliRet: devObj=上下文对象，dir=路径
        @return: True or False
        '''
        # 增加可删除权限。产品安全整改，降低了压缩包权限为440，工具无法删除
        add_permission(dir)

        if False == os.path.exists(dir):
            return True

        if False == os.path.isdir(dir):
            return False

        # 收集完成DHA日志后，直接立刻移除，会产生OSError: unlink(): an unknown error occurred,需要休眠一段时间
        for i in range(3):
            try:
                shutil.rmtree(dir)
                return True
            except:
                if log and devObj:
                    log.error(devObj, "remove {} error:{}".format(dir, traceback.format_exc()))
                time.sleep(3)
        return False

    @staticmethod
    def deleteDir(dir):
        '''
        @summary: 根据路径，删除路径
        @param dir=路径
        @return: True or False
        '''
        # 增加可删除权限。产品安全整改，降低了压缩包权限为440，工具无法删除
        add_permission(dir)

        if not os.path.exists(dir):
            return True

        if not os.path.isdir(dir):
            return False

        # 收集完成DHA日志后，直接立刻移除，会产生OSError: unlink(): an unknown error occurred,需要休眠一段时间
        for _ in range(5):
            if FileUtils.deleteDirectory(dir):
                return True
            time.sleep(10)
        return FileUtils.deleteDirectory(dir)

    @staticmethod
    def writeFile(filePath, info, isAddFlag):
        try:
            file = None
            openType = "w"
            if True == isAddFlag:
                openType = "a"
            
            file = codecs.open(filePath, openType, "utf-8")
            file.write(info)
            return True
        except:
            return False
        finally:
            if None != file:
                file.close()
    
    @staticmethod
    def getLocalDir(devObj):
        '''
        @summary: 获取用户选择的路径
        @param cliRet:  devObj=上下文对象
        @return: localDir:用户选择的路径
        '''
        # 目录中增加一层temp目录，避免客户将临时文件误认为是收集结果文件
        localDir = devObj.get("collectRetDir") + os.path.sep + "temp"
        return localDir
    
    @staticmethod
    def getLocalInfoPathByType(devObj, type):
        '''
        @summary: 获取信息存放的路径
        @param cliRet: devObj=上下文对象
        @return: localDir
        '''
        localDir = devObj[config.COLLECT_INFO_LOCAL_PATH] + os.path.sep
        localDir = localDir + config.COLLECT_INFO_DIR_NAME[type] + os.path.sep
        if not os.path.exists(localDir):
            os.makedirs(localDir)

        return localDir
    
    @staticmethod
    def getCurrentDate():
        '''
        @summary: 获取本地当前时间
        @param cliRet: devObj=上下文对象
        @return: localDir
        '''
        result = str(time.strftime('%Y%m%d%H%M%S',time.localtime(time.time())))
        return result
    
    @staticmethod
    def getDevDeveloperPwd(devObj):
        '''
        @summary: 获取设备developer密码
        @param cliRet: devObj=上下文对象
        @return: pwd
        '''
        pwd = devObj.get("developer")
        return pwd
    
    @staticmethod
    def getCtrlIds(devObj):
        '''
        @summary: 获取当前环境下，控制器的ID列表
        @param cliRet: devObj=上下文对象
        @return: (Bool,list)，如：(True,[0A,0B])
        '''
        ctrlIds = []
        strCmd = "show controller general"
        (isSuccess, cliRet) = cli.executeCmdWithTimout(devObj, strCmd, 3*60)
        if not isSuccess:
            util.addPyDetailMsg(devObj, "dev.conn.failure")
            return (False, ctrlIds)
        
        list_cliRet = cliRet.splitlines()
        #根据CLI回显信息获取当前环境中，主控的ID
        for field in list_cliRet:
            
            field = field.replace(" ", "")
            if field.startswith("Controller"):
                list_ctrl = field.split(":")
                ctrlIds.append(list_ctrl[1])
        
        #判断是否获取到控制器的ID列表
        if len(ctrlIds) == 0:
            log.error(devObj, "show controller general:recrod " + str(cliRet))
            util.addPyDetailMsg(devObj, "qry.ctrl.id.failed")
            return (False, ctrlIds)
        
        return (True, ctrlIds)

    @staticmethod
    def get_nodes_ids(dev_obj):
        nodes = util.get_controller_info_list(dev_obj)
        if not nodes:
            log.info(dev_obj, "nodes is empty.")
            return False, []
        nodes.extend(util.get_expansion_info_list(dev_obj))
        log.info(dev_obj, "nodes is {}".format(nodes))
        return True, nodes

    @staticmethod
    def get_controller_info_list(dev_obj):
        """
        查询控制器信息，做成列表
        :param dev_obj: dev对象
        :return: 控制器信息列表
        """
        cmd = "show controller general"
        flag, cli_ret = cli.executeCmdWithTimout(dev_obj, cmd, 3 * 60)
        if not flag or util.is_error_cli_ret(cli_ret):
            util.addPyDetailMsg(dev_obj, "dev.conn.failure")
            return []
        info_list = []
        result = dev_obj.get("result")
        controllers = cliUtil.getVerticalCliRet(cli_ret)
        for controller in controllers:
            ctrl = {"ID": controller.get("Controller"), "Type": "controller", "Enclosure": controller.get("Location")}
            result.add(ctrl)
            info_list.append(ctrl)
        return info_list

    @staticmethod
    def is_error_cli_ret(cli_ret):
        return "error:" in cli_ret.lower() or "error :" in cli_ret.lower()

    @staticmethod
    def get_expansion_info_list(dev_obj):
        """
        查询智能框信息，做成列表
        :param dev_obj: dev对象
        :return:智能框信息列表
        """
        cmd = "show expansion_module"
        flag, cli_ret = cli.executeCmdWithTimout(dev_obj, cmd, 3 * 60)
        if not flag or util.is_error_cli_ret(cli_ret):
            util.addPyDetailMsg(dev_obj, "dev.conn.failure")
            return []
        info_list = []
        enclosures = cliUtil.getHorizontalCliRet(cli_ret)
        result = dev_obj.get("result")
        for enclosure in enclosures:
            module = {}
            enclosure_id = enclosure.get("ID")
            enclosure_type = enclosure.get("Type")
            if "smart" in enclosure_type.lower():
                module["ID"] = enclosure_id
                module["Type"] = "smart"
                module["Enclosure"] = enclosure_id.split(".")[0]
                result.add(module)
                info_list.append(module)
        return info_list

    @staticmethod
    def get_all_nodes_id(dev_obj):
        flag = dev_obj.get("collectByNodes")
        if not flag:
            return False, "", ""
        modules_ids = dev_obj.get("modulesIds")
        controller_ids = dev_obj.get("controllerIds")
        return flag, modules_ids, controller_ids

    @staticmethod 
    def getController(devObj):
        if devObj.get("SettingInfo") == None or devObj.get("SettingInfo").get("modeList") == None:
            return (False,0)
        if (devObj.get("SettingInfo").get("modeList")).size() == 0:
            return (False,0)
        else:
            modeList = devObj.get("SettingInfo").get("modeList")            
            return (True, ",".join([modeList.get(i) for i in range(0, modeList.size())]))
   
    @staticmethod
    def changeCliMoreEnabled(devObj):
        '''
        @summary: 关闭回显more功能
        @return: True 命令执行成功
                False 命令执行失败
        '''
        flag = False
        cmd = "change cli more_enabled=no"        
        (isSuccess, cliRet) = cli.executeCmd(devObj, cmd)
        if not isSuccess:
            util.setPyDetailMsg(devObj, "dev.conn.failure")
            return False
        
        if config.CLI_EXECUTE_CMD_SUCCESS in cliRet:
            flag = True
            
        return flag
    
    @staticmethod
    def getDiskNum(devObj):
        '''
        @summary: 获取系统中硬盘的数量
        @return: True|False 成功或者失败
                                        硬盘数量
        '''
        
        cmd = "show disk general|filterColumn include columnList=ID"
        (isSuccess, cliRet) = cli.executeCmd(devObj, cmd)
        if not isSuccess:
            util.setPyDetailMsg(devObj, "dev.conn.failure")
            return (False, 0)
        
        dictList = cli.getCliTable2DictList(cliRet)
        return (isSuccess, len(dictList))

    @staticmethod
    def getVerticalCliRet(cliRet):
        '''
        @summary: 按逐行字典的方式获取垂直表格形式的cli回显集合
        @param cliRet: cli回显
        @return: 将表格形式cli回显处理为以表头为key，以项值为键的字典集合,处理不正常时，返回空集合
        '''
        CLI_RET_END_FLAG = ":/>"
        cliRetList = cliRet.encode("utf8").splitlines()
        dictList = []
        lineDict = {}
        for line in cliRetList:
            if CLI_RET_END_FLAG in line:
                break

            if re.search("^-+\r*\n*$", line):
                dictList.append(lineDict.copy())
                lineDict.clear()

            fields = line.split(" : ")
            if len(fields) < 2:
                continue

            key = fields[0].strip().decode("utf8")
            value = ":".join(fields[1:len(fields)]).strip().decode("utf8")

            if lineDict.has_key(key):
                key += "_" + str(str(lineDict.keys()).count(key + "_") + 1)
            lineDict.setdefault(key, value)

        if len(lineDict) > 0:
            dictList.append(lineDict.copy())

        return dictList

    @staticmethod
    def getHorizontalCliRet(cliRet):
        '''
        @summary: 按逐行字典的方式获取水平表格形式的cli回显集合
        @param cliRet: cli回显
        @return: 将表格形式cli回显处理为以表头为key，以项值为键的字典集合,处理不正常时，返回空集合
        '''
        try:
            headline = ""
            i = 0
            cliRetList = cliRet.encode("utf8").splitlines()
            for line in cliRetList:
                reg_headline = re.compile("^\s*-+(\s+-+)*\s*$") 
                match_headline = reg_headline.search(line)
                if match_headline:
                    headline = match_headline.group()
                    break
                i += 1
            if headline == "" or i == 0 or i >= len(cliRetList) - 1:
                return []
            
            title = cliRetList[i - 1]
            field_words = cliRetList[(i + 1):]
            reg_split = re.compile("\s*-+\s*")
            tuple_idxs = []
            start_pos = 0
            end_pos = 0
            
            while (start_pos <= len(headline)):
                match = reg_split.search(headline, start_pos)
                if match:
                    end_pos = match.end()
                    tuple_idxs.append((start_pos, end_pos))
                    start_pos = end_pos
                else:
                    break
                
            keys = []
            for item in tuple_idxs:
                key = title[item[0]:item[1]].strip()
                if keys.count(key):
                    key += "_" + str(str(keys).count(key + "_") + 1)
                keys.append(key.decode("utf8"))
            
            requiredLineLen = tuple_idxs[-1][0]
            dictList = []
            for line in field_words:
                if cli.CLI_RET_END_FLAG in line:
                    break
                
                #标题换行的场景
                if re.search("^-+(\s+-+)*\s*$", line):
                    continue
                
                if len(line.strip()) == 0:
                    continue
                
                if len(line) <= requiredLineLen:
                    continue
                
                vals = []
                for item in tuple_idxs:
                    vals.append(line[item[0]:item[1]].strip().decode("utf8"))
                dictList.append(dict(zip(keys, vals)))
                
            return dictList
        except:
            return []

    @staticmethod
    def getHorizontalNostandardCliRet(cliRet):
        '''
        @summary: 按逐行字典的方式获取水平表格形式的cli回显集合,此方法用来解析CLI回显未对其情况
        @param cliRet: cli回显
        @return: 将表格形式cli回显处理为以表头为key，以项值为键的字典集合,处理不正常时，返回空集合
        '''
        try:
            headline = ""
            i = 0
            cliRetList = cliRet.encode("utf8").splitlines()
            for line in cliRetList:
                reg_headline = re.compile("^\s*-+(\s+-+)*\s*$")
                match_headline = reg_headline.search(line)
                if match_headline:
                    headline = match_headline.group()
                    break
                i += 1
            if headline == "" or i == 0 or i >= len(cliRetList) - 1:
                return []

            title = cliRetList[i - 1]
            field_words = cliRetList[(i + 1):]
            reg_split = re.compile("\s*-+\s*")
            tuple_idxs = []
            start_pos = 0
            end_pos = 0

            while (start_pos <= len(headline)):
                match = reg_split.search(headline, start_pos)
                if match:
                    end_pos = match.end()
                    tuple_idxs.append((start_pos, end_pos))
                    start_pos = end_pos
                else:
                    break

            keys = []
            for item in tuple_idxs:
                key = title[item[0]:item[1]].strip()
                if keys.count(key):
                    key += "_" + str(str(keys).count(key + "_") + 1)
                keys.append(key.decode("utf8"))

            lenkeys = len(keys)
            dictList = []
            for line in field_words:
                if line.find(":/>") >= 0:
                    break

                if re.search("^-+(\s+-+)*\s*$", line):
                    continue

                if len(line.strip()) == 0:
                    continue

                vals = []
                valueList = line.strip().split("  ")

                valueSpaceList = []
                for value in valueList:
                    if value != "":
                        vals.append(value.strip().decode("utf8"))
                        valueSpaceList.append(value)
                lenvalue = len(valueSpaceList)
                if lenvalue == lenkeys:
                    dictList.append(dict(zip(keys, vals)))

            return dictList
        except:
            return []

    @staticmethod
    def getDiskIds(devObj):
        '''
        @summary: 获取系统中硬盘ID的列表
        @return: True|False 成功或者失败
                                        硬盘ID列表
        '''
    
        cmd = "show disk general|filterColumn include columnList=ID"
        (isSuccess, cliRet) = cli.executeCmd(devObj, cmd)
        if not isSuccess:
            util.setPyDetailMsg(devObj, "qry.all.disk.ID.failed")
            return (False, 0)
        
        dskIdList = []
        for line in cliRet.splitlines():
            idLine = line.strip()
            if idLine.startswith("DAE") or idLine.startswith("ENG") or idLine.startswith('CTE'):
                dskIdList.append(idLine)
                
        return (isSuccess, dskIdList)

    @staticmethod
    def getDiskFwVersionInCliModel(devObj):
        '''
        @summary: 获取系统中硬盘FW,MODE的信息
        @return: True|False 成功或者失败
                                        硬盘ID列表
        '''
        diskFwInfoDict = {}
        cmd = "show disk general|filterColumn include columnList=ID,Firmware\sVersion,Model"
        (isSuccess, cliRet) = cli.executeCmd(devObj, cmd)
        if not isSuccess:
            util.setPyDetailMsg(devObj, "qry.all.disk.ID.failed")
            return (False, {})
        diskInfoList = util.getHorizontalCliRet(cliRet)
        for diskInfo in diskInfoList:
            fw = diskInfo.get("Firmware Version", '')
            diskModel = diskInfo.get("Model", '')
            diskId = diskInfo.get("ID", '')
            diskFwInfoDict[diskId] = {"diskModel":diskModel, "diskId":diskId, "fw":fw}

        return True, diskFwInfoDict

    @staticmethod
    def getAllDiskSNAndId(devObj):
        '''
        @summary: 获取系统中硬盘SN的列表
        @return: True|False 成功或者失败
                                        硬盘ID列表
        '''
    
        cmd = ("show disk general |filterRow column=Health\sStatus predict=not predict2=equal_to value=Fault|"
            + "filterColumn include columnList=Serial\sNumber,ID")
        (isSuccess, cliRet) = cli.executeCmd(devObj, cmd)
        if not isSuccess:
            util.addPyDetailMsg(devObj, "qry.all.disk.SN.failed")
            return (False, [])
        
        dskIDSNTupList = []
        for line in cliRet.splitlines()[1:]:
            if len(line.split()) < 2:
                continue
            try:
                diskId = line.split()[0].strip()
                diskSn = line.split()[1].strip()
                if (not line.strip()) or 'admin' in line or 'Serial' in line or '------' in line:
                    continue
            except:
                log.info(devObj, 'Parse disk ID and SN exception:' + traceback.format_exc(None))
            else:
                dskIDSNTupList.append((diskId, diskSn))
        
        log.info(devObj, 'Query success, disk number is:' + unicode(len(dskIDSNTupList)))    
        return (True, dskIDSNTupList)

    @staticmethod
    def getAllDiskBlkDev(devObj):
        '''
        @summary: 获取系统中硬盘的盘符信息
        @return: 
                                        硬盘ID与盘符映射的字典.
        '''
    
        diskIdToBlkDevDict = {}
        if not systemMode.enterDiagnoseMode(devObj):
            return {}
        else:
            (isSuccess, cliRet) = cli.executeCmd(devObj, disklogConf.QUERY_DISK_DIAGNOSE_CMD)
            if not isSuccess:
                systemMode.exitDiagnoseOrMinisystem(devObj)
                util.setPyDetailMsg(devObj, "query.disk.blkdev.failed")
                return {}
            else:
                for diskLine in cliRet.splitlines():
                    if diskLine.strip().startswith("DAE") or diskLine.strip().startswith("ENG"):
                        diskId = diskLine.split()[0].strip()
                        diskBlkDev = diskLine.strip().split()[-1].strip()
                        diskIdToBlkDevDict[diskId] = diskBlkDev
        
        systemMode.exitDiagnoseOrMinisystem(devObj)
        log.error(devObj, "disklabelmap:" + unicode(diskIdToBlkDevDict))
        return diskIdToBlkDevDict

    @staticmethod
    def getAllDiskFullInfo(devObj):
        '''
        @summary: 获取系统中硬盘全部信息字典，包括盘符信息.
        @return: (True, allDiskInfoDict)
                                        硬盘ID到硬盘信息映射的字典
        '''
        
        qrySucc, allDiskIds = util.getDiskIds(devObj) 
        if not qrySucc:
            return False, {}
        
        diskBlkDevDict = util.getAllDiskBlkDev(devObj)
        if not diskBlkDevDict:
            return False, {}
        
        allDiskInfoDict = {}
        for diskId in allDiskIds:
            qryDiskInfoCmd = 'show disk general disk_id=' + diskId
            (qrySucc, qryDiskInfoRet) = cli.executeCmd(devObj, qryDiskInfoCmd)
            if not qrySucc:
                util.setPyDetailMsg(devObj, "qry.disk.detail.info.failed" % diskId)
                continue
            
            keys = []
            vals = []
            for diskInfoLine in qryDiskInfoRet.splitlines()[:-1]:
                if ":" in diskInfoLine:
                    kvList = diskInfoLine.strip().split(":")
                    keys.append(kvList[0].strip())
                    vals.append(kvList[1].strip())
                    
            if keys and vals:
                diskInfoDict = dict(zip(keys, vals))       
                diskInfoDict['BlkDev'] = diskBlkDevDict.get(diskId)
                allDiskInfoDict[diskId] = diskInfoDict
            
        log.info(devObj, "all dev full info map" + unicode(allDiskInfoDict))        
        return (True, allDiskInfoDict)  

    @staticmethod
    def normalizedDiskLocStr(diskLoc):
        '''
        @summary: 将硬盘位置信息标准化.
        @return: 标准化后的硬盘位置信息。
        @note: 此处是为了统一展示硬盘位置信息、和Java中的硬盘位置信息保持一致等.
        '''
        diskEncNum = diskLoc.strip().split(',')[0].strip().strip('(').strip()
        diskSlotNum = diskLoc.strip().split(',')[1].strip().strip(')').strip()
        return '(' + diskEncNum + ',' + diskSlotNum + ')'

    @staticmethod
    def isEmptyDir(dirname):
        contents = os.listdir(dirname)
        if not contents:
            return True
        else:
            emptyCnt = 0
            for f in contents:
                fn = os.path.join(dirname, f)
                if os.path.isfile(fn):
                    return False
                else:
                    if util.isEmptyDir(fn):
                        emptyCnt += 1
                    else:
                        return False
            return len(contents) == emptyCnt
            
    @staticmethod
    def getAllDiskInfoInAdmin(devObj):
        '''
        @summary: 获取系统中硬盘全部信息字典，包括盘符信息
        @return: (True, allDiskInfoDict)
                                        硬盘ID到硬盘信息映射的字典
        @note: 要求函数调用前在admin视图，调用后退出到admin视图.
        '''
        # 获取设备版本及型号，DoradoV3R2可以跨引擎
        deviceType = device.getDeviceType(devObj)
        deviceVersion = device.getDeviceVersion(devObj)
        password = device.getDevicePassword(devObj)
        currentCtrlNodeId = ""
        currentEngine = ""
        engineCtrlNodeMappingDict = {}
        controllerNumEveryEngine = 0
        hasSensitiveDisks = False
        isQryOk, diskIdSnTupList = util.getAllDiskSNAndId(devObj)
        if not isQryOk:
            return {}, 0, hasSensitiveDisks
        
        diskIdList = map(lambda t: t[0], diskIdSnTupList)
        diskSnList = map(lambda t: t[1], diskIdSnTupList)
        
        sysDisNum = len(diskIdSnTupList)
        if not systemMode.enterDiagnoseMode(devObj):
            return {}, sysDisNum, hasSensitiveDisks
        isSuccess, debugRet = cli.executeCmdWithTimout(devObj, 'sys showcls', 60 * 3)
        if not isSuccess:
            util.addPyDetailMsg(devObj, 'query.result.abnormal')
            systemMode.exitDiagnoseOrMinisystem(devObj)
            return {}, sysDisNum, hasSensitiveDisks
        try:
            ctrlInfoDictList = util.getVerticalCliRet(debugRet)
            engineInfoDictList = util.getHorizontalNostandardCliRet(debugRet)
            for ctrlInfo in ctrlInfoDictList:
                if ctrlInfo.get("local node id", "") != "":
                    currentCtrlNodeId = ctrlInfo.get("local node id", "")
                    break
            if not currentCtrlNodeId:
                devObj.get("logger").error("get node info Failed.")
                return {}, sysDisNum, hasSensitiveDisks
            for engineInfo in engineInfoDictList:
                engine = engineInfo.get("engine", "")
                if engine == "":
                    continue
                ctrlNodeId = engineInfo.get("id", "")
                if ctrlNodeId == "":
                    continue
                tmpList = engineCtrlNodeMappingDict.get(engine, [])
                tmpList.append(ctrlNodeId)
                engineCtrlNodeMappingDict[engine] = tmpList
                if ctrlNodeId == currentCtrlNodeId:
                    currentEngine = engine
            # 当前引擎包含的控制器节点
            currentEngineCtrlIdList = engineCtrlNodeMappingDict.get(currentEngine, [])
            controllerNumEveryEngine = len(currentEngineCtrlIdList)
            if controllerNumEveryEngine == 0:
                return {}, sysDisNum, hasSensitiveDisks
        except Exception:
            devObj.get("logger").error('get all controllers and engines exception:' + unicode(traceback.format_exc()))
        finally:
            systemMode.exitDiagnoseOrMinisystem(devObj)
        tmpHasSensitiveDisksList = []
        allDiskMapDict = {}
        tmpDiskMap, tmpHasSensitiveDisks = util.getDiskInfo(devObj, hasSensitiveDisks, diskSnList, diskIdList)
        tmpHasSensitiveDisksList.append(tmpHasSensitiveDisks)
        allDiskMapDict.update(tmpDiskMap)
        for engineId in engineCtrlNodeMappingDict:
            if engineId == currentEngine:
                continue
            else:
                if not ((str(deviceType).startswith('Dorado') and deviceVersion >= 'V300R002C00') or deviceVersion >= 'V300R006C10'):
                    continue
                needToHeartControllerId = str(int(engineId) * controllerNumEveryEngine + (int(currentCtrlNodeId) % controllerNumEveryEngine))
                if needToHeartControllerId not in engineCtrlNodeMappingDict.get(engineId, []):
                    devObj.get("logger").error("Can not heart to another controller, because controller %s not exist." %
                                               needToHeartControllerId)
                    tmpDiskMap, tmpHasSensitiveDisks = {}, hasSensitiveDisks
                else:
                    execSucc = systemMode.heartbeatToPeerByCtrlId(devObj, password, needToHeartControllerId)
                    if not execSucc:
                        devObj.get("logger").error("Heart beat to controller %s failed." % needToHeartControllerId)
                        tmpDiskMap, tmpHasSensitiveDisks = {}, hasSensitiveDisks
                    else:
                        tmpDiskMap, tmpHasSensitiveDisks = util.getDiskInfo(devObj, hasSensitiveDisks, diskSnList,
                                                                                          diskIdList)
                        systemMode.exitHeartbeatCli(devObj)
            tmpHasSensitiveDisksList.append(tmpHasSensitiveDisks)
            allDiskMapDict.update(tmpDiskMap)
        if True in set(tmpHasSensitiveDisksList):
            hasSensitiveDisks = True

        # 当支持CLI命名收集时可以不查询 sda/adb这种信息。直接使用show disk general命令。
        if not allDiskMapDict and ((str(deviceType).startswith(
                'Dorado') and deviceVersion >= 'V300R002C00') or deviceVersion >= 'V300R006C10'):
            cmdStr = "show disk general |filterColumn include columnList=ID,Manufacturer,Model,Serial\sNumber,Type"
            flag, cliRet = cli.executeCmdWithTimout(devObj, cmdStr, 60 * 3)
            diskInfoDictList = util.getHorizontalCliRet(cliRet)
            for diskInfo in diskInfoDictList:
                diskId = diskInfo.get("ID")
                sn = diskInfo.get("Serial Number", '--')
                vendor = diskInfo.get("Manufacturer", '--')
                model = diskInfo.get("Model", '--')
                name = diskInfo.get("name", "--")
                diskType = diskInfo.get("Type", "--")
                firmwareVer = diskInfo.get("Firmware Version", '--')
                if 'toshiba' == vendor.lower() and (
                        model in disklogConf.TOSHIBA_EXCLUDE_DISK_MODEL_LIST or firmwareVer in disklogConf.TOSHIBA_EXCLUDE_DISK_MODEL_BATCH_MAP.get(
                        model, "")):
                    hasSensitiveDisks = True
                    devObj.get("logger").info(
                        'found disk that is performance sensitive,quit collect this diskId :' + str(diskId))
                else:
                    allDiskMapDict[diskId] = (diskId, sn, vendor, model, name, diskType)

        log.info(devObj, 'All disk num of all engine:' + unicode(len(allDiskMapDict)))
        log.info(devObj, 'All disk info map of all engine: %s' % allDiskMapDict)
        return allDiskMapDict, sysDisNum, hasSensitiveDisks

    @staticmethod
    def getDiskInfo(devObj, hasSensitiveDisks, diskSnList, diskIdList):
        __, isUseCliCmd = util.isCli4DiskInfoAvaliable(devObj)

        if not systemMode.enterMinisystemMode(devObj):
            return {}, hasSensitiveDisks
        (isSuccess, miniRet) = cli.executeCmdWithTimout(devObj, 'showdiskinfo', 60 * 3)
        if not isSuccess:
            util.addPyDetailMsg(devObj, 'qry.disk.info.failed')
            systemMode.exitDiagnoseOrMinisystem(devObj)
            return {}, hasSensitiveDisks
        try:
            idx = miniRet.find('All scsi luns')
            if -1 != idx:
                miniRet = miniRet[:idx]
                
            lines = miniRet.splitlines()
            
            diskMap = {}
            isParsingStart= False
            for line in lines:
                if not line.strip() or not isParsingStart:
                    sn, vendor, model, name, diskType, firmwareVer = '', '', '', '', '', '' 
                
                if line.strip().startswith('id '):
                    isParsingStart = True

                if isParsingStart and line.strip().startswith('DISK'):
                    diskType = line.split('type')[1].split(', port')[0].split('(')[0].strip()                

                if isParsingStart and line.strip().startswith('vendor'):
                    try:
                        keyLine = line.strip()
                        fds = keyLine.split(',')
                        sn = fds[3].strip().split()[1].strip()
                        if sn not in diskSnList:
                            isParsingStart = False
                            continue
                        vendor = fds[0].split()[1].strip()
                        model = fds[1].split()[1].strip()
                        firmwareVer = fds[2].split()[2].strip()
                    except:
                        devObj.get("logger").error('getAllDiskInfoInAdmin vendor/sn/fw line exception:' + unicode(traceback.format_exc()))
                        isParsingStart = False
                        continue
                    
                if isParsingStart and 'name' in line:
                    name = line.split('name')[1].split(',')[0].strip()  
                
                if  isParsingStart and sn and vendor and model and name and diskType:
                    diskId = diskIdList[diskSnList.index(sn)]

                    # CLI命令收集场景，保持原状，全部都屏蔽。
                    if 'toshiba' == vendor.lower() and isUseCliCmd and (
                            model in disklogConf.TOSHIBA_EXCLUDE_DISK_MODEL_LIST or firmwareVer in disklogConf.TOSHIBA_EXCLUDE_DISK_MODEL_BATCH_MAP.get(
                            model, "")):
                        hasSensitiveDisks = True
                        devObj.get("logger").info(
                            'found disk that is performance sensitive, and use cli collect, quit collect this diskId :' + str(
                                diskId))

                    # disktool 收集的版本，需按新方案修改Model 为AL14XXX 且FW版本为0803/0808/0807的硬盘只收集0x01部分
                    # 日志(此处只需先查询出来，后续收集时再判断FW,更改收集命令)
                    elif 'toshiba' == vendor.lower() and not isUseCliCmd and (
                            model in disklogConf.TOSHIBA_EXCLUDE_DISK_MODEL_LIST):
                        hasSensitiveDisks = True
                        devObj.get("logger").info(
                            'use disktool collect, toshiba risk disk, quit collect this diskId :' + str(diskId))
                    else:
                        diskMap[diskId] = (diskId, sn, vendor, model, name, diskType)
                        
                    isParsingStart = False
        except Exception, e:
            devObj.get("logger").error('getAllDiskInfoInAdmin exception:' + unicode(e))
            devObj.get("logger").error('getAllDiskInfoInAdmin exception:' + unicode(traceback.format_exc()))
        finally:
            systemMode.exitDiagnoseOrMinisystem(devObj)
            
        log.info(devObj, 'All disk info map:' + unicode(len(diskMap))) 
        return diskMap, hasSensitiveDisks

    @staticmethod
    def get_current_progress(dev_obj):
        """
        @summary: 获取信息收集当前进度
        """
        observer = dev_obj.get("progressObserver")
        try:
            if observer is not None and dev_obj.get("concurrent") is True:
                return observer.getProgress()
            if observer is not None:
                return observer.getCurrentProgress()
        except (Exception, ToolException):
            log.info(dev_obj, str(traceback.format_exc()))
        return 0

    @staticmethod
    def get_depth_collect_current_process(dev_obj):
        """
        @summary: 获取深度问题分析并发收集项当前进度
        """
        observer = dev_obj.get("progressObserver")
        try:
            return observer.getDepthCollectProgress()
        except (Exception, ToolException):
            log.info(dev_obj, str(traceback.format_exc()))
        return 0

    @staticmethod
    def refresh_progress_by_add(dev_obj, percent_number, max_number=99):
        """
        @summary: 叠加刷新当前进度
        """
        cur = util.get_current_progress(dev_obj)
        total = cur + max(1, int(percent_number))
        if 0 < total <= max_number:
            util.refreshProcess(
                dev_obj,
                total
            )

    @staticmethod
    def refreshProcess(devObj, percentNumber):
        """
        @summary: 设置信息收集当前进度
        """
        observer = devObj.get("progressObserver")
        try:
            cur = util.get_current_progress(devObj)
            set_num = int(percentNumber)
            if set_num < cur:
                return
            if observer != None:
                if devObj.get("concurrent") is True:
                    observer.updateAnothorProgress(set_num, None)
                else:
                    observer.updateProgress(set_num, None)
        except:
            log.error(devObj, str(traceback.format_exc()))

    @staticmethod
    def refresh_depth_collect_process(dev_obj, percent_number, progress_lock):
        """
        @summary: 设置深度问题分析并发收集项当前进度
        """
        log.info(dev_obj, "save depth collect process")
        observer = dev_obj.get("progressObserver")
        with progress_lock:
            try:
                cur_progress = util.get_depth_collect_current_process(dev_obj)
                set_num = int(percent_number)
                if set_num < cur_progress:
                    return
                if observer:
                    observer.updateDepthCollectProgress(set_num, None)
            except (Exception, ToolException):
                log.error(dev_obj, str(traceback.format_exc()))

    @staticmethod
    def refreshProcessByStep(devObj, currentProcess, percentNumber):
        """
        @summary: 用于循环中刷新进度
        """        
        if int(currentProcess + percentNumber) - int(currentProcess) >= 1:            
            util.refreshProcess(devObj, currentProcess + percentNumber) 
             
        currentProcess += percentNumber
        
        return currentProcess

    @staticmethod
    def cli_res_is_support(cli_res):
        """
        判断是否支持的命令回文
        :param cli_res: 回文返回
        :return: True:支持的命令
                False:不支持的命令
        """
        # 检查第2行是否有不支持的标志符
        check_line_num = 2
        line_sep_n = "\n"
        not_support_sign = "^"
        split_list = cli_res.split(line_sep_n, check_line_num)
        if len(split_list) > check_line_num:
            return not (split_list[check_line_num - 1].strip() ==
                        not_support_sign)

        return True

    @staticmethod
    def need_tailared_cli_cmd(model):
        return model in config.DORADO_V6_DEV_TYPES

    @staticmethod
    def is_use_new_method_collect_dha(dev_obj):
        version = str(device.getDeviceVersion(dev_obj))
        dev_type = str(device.getDeviceType(dev_obj))
        log.info(dev_obj, "product_model is {}, version is {}".format(dev_type, version))
        return util.is_ocean_stor_micro_dev(dev_type) or util.is_ocean_stor_compute_dev(dev_type) \
               or util.is_specified_ocean_protect_dev(dev_type, version) \
               or util.is_specified_ocean_stor_dorado_dev(dev_type, version)

    @staticmethod
    def is_ocean_stor_micro_dev(dev_type):
        return Products.isOceanStorMicroDev(dev_type)

    @staticmethod
    def is_ocean_stor_compute_dev(dev_type):
        return Products.isOceanStoComputingDev(dev_type)

    @staticmethod
    def is_specified_ocean_protect_dev(dev_type, version):
        return Products.isOceanProtectDev(dev_type) and Products.compareVersion(version, "1.2.RC1") >= 0

    @staticmethod
    def is_specified_ocean_stor_dorado_dev(dev_type, version):
        return dev_type in TaskCons.DORADO_AND_NEW_DORADO_MODEL \
               and not re.search(NEW_DHA_NOT_SUPPORT_VERSION, version, re.IGNORECASE) \
               and Products.compareVersion(version, "6.1.3") >= 0

class log():
    
    """
            功能：日志记录函数的子函数，用于获取调用函数和调用行号
            参数： MAX_CALLER_LEVEL：最大调用关系层数
            返回值：调用函数信息
    """
    @staticmethod
    def getCallerInfo(MAX_CALLER_LEVEL=5, skipLastLevel=True):
        #从堆栈中获取调用函数和行号
        
        #初始化参数
        funcBack = sys._getframe().f_back
        if True == skipLastLevel: #忽略最近的调用关系
            funcBack = funcBack.f_back
            MAX_CALLER_LEVEL -= 1
        
        #生成函数调用关系
        callerInfo = ""    
        for index in range(0, MAX_CALLER_LEVEL):
        
            #获取该级调用函数和行号
            if hasattr(funcBack, "f_code") and hasattr(funcBack, "f_lineno"):
                funcName = funcBack.f_code.co_name
                lineNumber = funcBack.f_lineno
                callerInfo = " [" + str(funcName) + ":" +  str(lineNumber) + "]" + callerInfo
            else:
                break
            
            #刷新Back函数
            if hasattr(funcBack, "f_back"):
                funcBack = funcBack.f_back
            else:
                break
        
        #返回函数调用关系
        return callerInfo
    
    @staticmethod
    def debug(devObj, info):
        """
                    功能：记录调试信息info到工具日志中
                    参数：devObj=工具上下文；info=要记录的信息
                    返回值：True=成功；False=失败
        """
        logInfo = info + log.getCallerInfo()
        if "logger" in devObj:
            devObj.get("logger").debug('[ToolLog]:' + logInfo)
            return True
        else:
            raise Exception("[failed]: logger is inexisted. info=" + logInfo)
    
    @staticmethod
    def error(devObj, info):
        """
                    功能：记录错误信息info到工具日志中
                    参数：devObj=工具上下文；info=要记录的信息
                    返回值：True=成功；False=失败
        """
        logInfo = info + log.getCallerInfo()
        if "logger" in devObj:
            devObj.get("logger").error('[ToolLog]:' + logInfo)
            return True
        else:
            raise Exception("[failed]: logger is inexisted. info=" + logInfo)
        
    @staticmethod
    def info(devObj, info):
        logInfo = info + log.getCallerInfo()
        if "logger" in devObj:
            devObj.get("logger").info('[ToolLog]:' + logInfo)
            return True
        else:
            raise Exception("[failed]: logger is inexisted. info=" + logInfo)
        
    @staticmethod
    def warn(devObj, info):
        logInfo = info + log.getCallerInfo()
        if "logger" in devObj:
            devObj.get("logger").warn('[ToolLog]:' + logInfo)
            return True
        else:
            raise Exception("[failed]: logger is inexisted. info=" + logInfo)

def getProductModel(devObj):
    '''
    @summary: 获取产品型号
    @param devObj: 上下文对象
    @return: （True/False, productModel）
    '''
    productModel = ""
    
    #从上下文对象中获取产品型号
    productModel = str(device.getDeviceType(devObj))
    if productModel != "":
        return (True, productModel)
    
    #下发CLI命令查询产品型号
    isSuccess, productModel = execCliGetProductModel(devObj)
    return (isSuccess, productModel)


def execCliGetProductModel(devObj):
    '''
    @summary: 下发CLI命令获取产品型号
    @param devObj: 上下文对象
    @return: (True/False, productModel)
    '''
    product_model = restUtil.CommonRest.getOriginProductModel(devObj.get("devNode"))
    if product_model:
        return True, product_model
    cmd = "show system general"        
    isSuccess, cliRet =  cli.executeCmdNoLogTimeout(devObj, cmd)
    
    if not isSuccess:
        util.setPyDetailMsg(devObj, "dev.conn.failure")
        return (False, "")
    
    cliRetList = cliRet.splitlines()
    for line in cliRetList:
        fields = line.split(":")
        if len(fields) < 2:
            continue
        
        fieldName = fields[0].strip()
        fieldValue = fields[1].strip()
        
        if fieldName == "Product Model":
            product_model = fieldValue
            break
            
    if len(product_model) != 0 and product_model != "--":
        return (True, product_model)
        
    #无法获取产品型号
    util.setPyDetailMsg(devObj, "cannot.get.product.model.info")
    return (False, "")


def add_permission(input_path):
    """
    递归增加目标目录下所有权限
    :param input_path:
    :return:
    """
    if not os.path.exists(input_path):
        return
    os.chmod(input_path, stat.S_IRWXU)

    if os.path.isdir(input_path):
        file_dir_list = os.listdir(input_path)
        # 开始解压缩迭代及写入硬盘信息
        for file_dir in file_dir_list:
            file_path = os.path.join(input_path, file_dir)
            add_permission(file_path)


class AsynProgressExecuteCmd(threading.Thread):
    """
    异步执行命令的线程
    目的用于异步执行命令，保持长连接
    """
    def __init__(self, devObj, LOGGER, cmd="show system general"):
        threading.Thread.__init__(self)
        self.stopFlg = False
        self.LOGGER = LOGGER
        self.cmd = cmd
        self.ssh = devObj.get("SSH")
        self.devObj = devObj
        self.timeout = 60*60*2

    def run(self):
        try:
            self.LOGGER.info(self.devObj, "start execute AsynProgressExecuteCmd cmd[%s]." % self.cmd)
            while not self.stopFlg and self.timeout > 0:
                ret = self.ssh.execCmdWithTimout(self.cmd, 10)
                time.sleep(30)
                self.timeout -= 30
                self.LOGGER.info(self.devObj, "execute timeout[%s], cmd[%s], ret:[%s]." % (self.timeout, self.cmd, str(ret)))
        except:
            self.LOGGER.error(self.devObj, str(traceback.format_exc()))

    def setStopFlag(self, stopFlag):
        self.stopFlg = stopFlag
        self.LOGGER.info(self.devObj, "setStopFlag execute cmd[%s], timeout[%s], stopFlag:%s" % (self.timeout, self.cmd, stopFlag))