﻿# coding:utf-8
import time
import os
import stat
import shutil
import traceback
from cbb.common.util.system import clean_permission_on
from common.util import log
from common.util import util
from common.util import device
from frameone.common import copy_file_to_smart_and_rename
from frameone.util import collect_util

OS_OPEN_FLAGS = os.O_WRONLY | os.O_CREAT | os.O_TRUNC  # 写 | 创建并打开 | 截断
OS_OPEN_MODES = stat.S_IWUSR | stat.S_IRUSR  # 拥有者具有读写权限


def execute(devObj):
    try:
        util.refreshProcess(devObj, 1)
        local_dir = util.getLocalDir(devObj)
        collectPath = local_dir + os.path.sep + devObj["collectRetFileName"]
        copy_file_to_smart_and_rename.add_smart_file(devObj)
        #压缩前，增加eServer描述文件
        creatPkginfo(collectPath, devObj)
        util.refreshProcess(devObj, 10)
        #压缩文件
        localFileFinal = devObj["collectRetFileName"] + ".7z"
        # util.getLocalDir里在保存目录新增了一层temp，这里最后结果仍然保存到用户指定路径
        compressFilePath = devObj.get("collectRetDir") + os.path.sep + localFileFinal
        log.info(devObj, "compressFilePath:{}".format(compressFilePath))
        delete_tmp_file_before_compress(devObj)
        collect_util.copy_log_and_ini_to_collect_ret_dir(devObj, collectPath)
        from com.huawei.ism.tool.obase.utils import FileAssistant
        res_list = FileAssistant.compressDirTo7ZFileWithResDump(
            compressFilePath, collectPath + os.path.sep + "*", "-t7z")
        log.info(devObj, "compress res:{}".format(res_list))
        if not check_compress_res(devObj, res_list, compressFilePath):
            # 没有压缩成功时，把临时文件移动到temp外
            shutil.move(collectPath, devObj.get("collectRetDir"))
            # 若temp文件夹为空，删除temp文件夹
            if local_dir.endswith("temp") and not os.listdir(local_dir):
                util.deleteDir(local_dir)
            return False, ""

        devObj["collectRetFileName"] = localFileFinal
        util.refreshProcess(devObj, 50)
        from com.huawei.ism.tool.obase.utils import OSCmdUtils
        OSCmdUtils.executeCmd('cmd.exe /C rd /q /S "{}"'.format(collectPath))
        util.deleteDir(collectPath)
        # 若temp文件夹为空，删除temp文件夹
        if local_dir.endswith("temp") and not os.listdir(local_dir):
            util.deleteDir(local_dir)
        util.refreshProcess(devObj, 80)
        clean_permission_on(compressFilePath, devObj.get("logger"))
        util.refreshProcess(devObj, 99)
        return (True, "")
    except Exception:
        log.info(devObj, "except trace back:" + str(traceback.format_exc()))
        devObj["py_detail"] = "catch except when compress file.~~~over!"
        return (False, "")


def check_compress_res(dev_obj, res_list, result_file):
    """
    检查压缩文件的结果，根据7z的压缩堆栈确认部分根因
    :param dev_obj: 上下文
    :param res_list: 压缩结果
    :param result_file: 目标压缩文件
    :return: 检查结果 True 成功， False 失败。
    """
    if os.path.exists(result_file):
        log.info(dev_obj, "result_file:{} is compress success!".format(result_file))
        return True

    err_msg_key_dict = {
        "Can't allocate required memory": "memory.not.enought.error",
    }
    res_list = list(res_list)
    if len(res_list) != 2:
        util.setPyDetailMsg(dev_obj, "compress.file.error")
        return False

    if str(res_list[0]) == "true":
        return True

    dump_info = str(res_list[1])
    for err_key, msg_key in err_msg_key_dict.items():
        if err_key in dump_info:
            util.setPyDetailMsg(dev_obj, msg_key)
            return False

    util.setPyDetailMsg(dev_obj, "compress.file.error")
    return False


def creatPkginfo(rootPath, devObj):
    '''
    @summary: 创建与datacollect同级的目录pkginfo，用于表示该包是信息收集的包。
        pkginfo下有两个空文件
            type_collect: 信息收集的包
            domain_storage: 存储设备
    '''
    pkginfoPath = rootPath + os.sep + "pkginfo"
    typeFile = pkginfoPath + os.sep + "type_collect"
    domainFile = pkginfoPath + os.sep + "domain_storage"
    descFile = pkginfoPath + os.sep + "desc"
    snFmt = "deviceSN=${%s}\n"
    timeFmt = "fileCreateTime=%s"
    try:
        #如果pkginfo已存在，则需要先删除
        if os.path.exists(pkginfoPath):
            shutil.rmtree(pkginfoPath, True)
            
        os.mkdir(pkginfoPath)
        #先创建type文件，然后拷贝type并重命名为domain文件
        fileObj = os.fdopen(os.open(typeFile, OS_OPEN_FLAGS, OS_OPEN_MODES), 'w')
        fileObj.close()
        shutil.copy(typeFile, domainFile)
        #创建Desc文件并写入SN号和时间（UTC）
        #获取SN号和时间毫秒数
        snInfo = snFmt % str(device.getDeviceSn(devObj))
        timeInfo = timeFmt % str(long(time.time()*1000))
        from com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil import getAllToolVersion
        tool_version = "\ntool-version={{{}}}".format(",\n".join(getAllToolVersion()))
        desc_file = os.fdopen(os.open(descFile, OS_OPEN_FLAGS, OS_OPEN_MODES), 'w')
        seq = [snInfo, timeInfo, tool_version]
        desc_file.writelines(seq)
        desc_file.close()
        log.info(devObj, "[creatPkginfo] Creat the pkginfo succeed!")
    
    except:
        if os.path.exists(pkginfoPath):
            shutil.rmtree(pkginfoPath, True)   
        log.error(devObj, "[creatPkginfo] Creat the pkginfo failed! except trace back: " + str(traceback.format_exc()))


def delete_tmp_file_before_compress(dev_obj):
    """
    删除System_log下的临时目录。循环删除20次，如果子目录已删除则结束循环。
    """
    from com.huawei.ism.tool.base.utils import FileUtils
    system_log_path = util.getLocalDir(dev_obj) + os.path.sep + dev_obj[
        "collectRetFileName"] + os.path.sep + "DataCollect" + os.path.sep + "System_log"
    if not os.path.exists(system_log_path):
        return
    log.info(dev_obj, "system_log_path:{}".format(system_log_path))
    time_out = 20
    while time_out > 0:
        for root, dirs, _ in os.walk(system_log_path):
            if not dirs:
                log.info(dev_obj, "times:{},tmp dirs is empty. clean tmp dir success. ".format(time_out))
                return
            log.info(dev_obj, "times:{},tmp dirs exist. clean tmp dir failed. ".format(time_out))
            for tmp_dir in dirs:
                FileUtils.deleteFile(root + os.sep + tmp_dir)
        time_out -= 1
        time.sleep(5)
