# -*- coding: UTF-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

from common.util import log, util
from fcv_collect_compute_nodes_info import ComputeNodesCollect
from java.lang import Exception as JException


def collect_compute_nodes_info(dev_obj):
    log.info(dev_obj, "Start collect compute nodes info.")
    util.refreshProcess(dev_obj, 1)
    dev_obj["collectAllInfo"] = True
    try:
        util.initPyDetailMsg(dev_obj)
        is_success = ComputeNodesCollect(dev_obj, log).execute_collect()
        return is_success, ""
    except (Exception, JException) as e:
        log.error(dev_obj, "collect compute nodes error! {}".format(e))
        return False, ""
    finally:
        util.refreshProcess(dev_obj, 100)
