# -*- coding: UTF-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

import os
import traceback
from common.config import config
from common.util import log, util, device


def pre_collect(dev_obj):
    try:
        log.info(dev_obj, "Start initializing the device.")
        util.refreshProcess(dev_obj, 1)
        local_file_final = "Data_{}_{}_{}".format(str(device.getDeviceType(dev_obj)).replace(" ", ""),
                                                  util.getCurrentDate(), device.getDeviceSn(dev_obj))
        local_dir = util.getLocalDir(dev_obj) + os.path.sep + local_file_final + os.path.sep + "DataCollect"
        util.refreshProcess(dev_obj, 40)
        # 检查路径是否有中文
        if util.check_contain_chinese(unicode(local_dir).encode("utf-8")):
            util.setPyDetailMsg(dev_obj, "route.exist.ch")
            return False, ""
        # 创建文件夹
        if not os.path.exists(local_dir):
            os.makedirs(local_dir)
        util.refreshProcess(dev_obj, 80)
        # 将收集路径保存到环境中
        dev_obj["collectRetFileName"] = local_file_final
        dev_obj[config.COLLECT_INFO_LOCAL_PATH] = local_dir
        util.refreshProcess(dev_obj, 99)
        log.info(dev_obj, "Complete Device Initialization. \nThe local_file_final is {}. The local_dir is {}.".format(
            local_file_final, local_dir))
        return True, ""
    except Exception as e:
        log.error(dev_obj, "fcv_pre_collect except trace back: {}".format(str(e)))
        return False, ""
    finally:
        util.refreshProcess(dev_obj, 100)
