# coding:utf-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021~ All rights reserved.
import re
from cbb.frame.cli import cliUtil
from com.huawei.ism.tool.obase.exception import ToolException
from common.sshTools import SSHToolUtils
from com.huawei.ism.tool.obase.connection import SftpTransporter
from java.lang import Exception as JException
from cbb.frame.cli.cliUtil import get_system_version_with_ret
from config import config


def create_ctrl_connection(params_dict):
    """
    遍历控制器IP，直到成功创建到控制器的连接
    :param params_dict:
    :return:
    """
    cli = params_dict.get("SSH")
    lang = params_dict.get("lang")
    logger = params_dict.get("logger")

    flag, controller_ip_list = cliUtil.get_controller_ip_list(cli, lang)
    logger.info("controller list {}".format(controller_ip_list))
    for controller_ip in controller_ip_list:
        if create_one_ctrl_connection(params_dict, controller_ip):
            return
    raise ToolException("Error to connected to controller")


def create_one_ctrl_connection(params_dict, controller_ip):
    """
    指定控制器IP，创建CLI和SFTP连接
    :param params_dict:
    :param controller_ip:
    :return:
    """
    ctrl_cli = None
    logger = params_dict.get("logger")
    try:
        logger.info("current controller ip {}".format(controller_ip))
        ssh_utils = SSHToolUtils(params_dict, logger)
        flag, new_cli = ssh_utils.newSshUsingCrntUsrCredential(controller_ip)
        sftp = SftpTransporter(new_cli)
        if flag and sftp:
            logger.info("connected controller ip {}".format(controller_ip))
            backup_connection(params_dict, new_cli, sftp)
            params_dict[config.READ_ONLY_DHA_IP] = controller_ip
            return True
        return False
    except (Exception, JException) as e:
        logger.error("create connection error.{}".format(e))
        if ctrl_cli:
            ctrl_cli.close()
        return False


def backup_connection(params_dict, cli, sftp):
    params_dict["ORIGIN_SSH"] = params_dict.get("SSH")
    params_dict["SSH"] = cli
    params_dict["ORIGIN_SFTP"] = params_dict.get("SFTP")
    params_dict["SFTP"] = sftp


def restore_connection(params_dict):
    if params_dict.get("ORIGIN_SSH") and params_dict.get("SSH"):
        params_dict["SSH"].close()
        params_dict["SSH"] = params_dict["ORIGIN_SSH"]
    if params_dict.get("ORIGIN_SFTP") and params_dict.get("SFTP"):
        params_dict["SFTP"].close()
        params_dict["SFTP"] = params_dict["ORIGIN_SFTP"]


def is_support_read_only_user_enter_debug(product_version, hot_patch):
    """
    判断是否支持只读用户进去debug,如果支持返回true
    :param product_version:
    :param hot_patch:
    :return:
    """
    # 支持的版本列表，后续可以在此列表中新增
    support_read_only_version = {"V300R006C20": 30}
    if product_version in support_read_only_version:
        support_patch = support_read_only_version.get(product_version)

        pattern_hot_patch = re.compile(r"SPH(\d+)", flags=re.IGNORECASE)
        match_hot_path = pattern_hot_patch.search(hot_patch)
        if match_hot_path and support_patch <= int(match_hot_path.group(1)):
            return True
    return False


def can_enter_debug_mode_for_read_only_user(params_dict):
    """
    判断是否支持只读用户采集
    :param params_dict:
    :return: True 非超级管理员并且支持只读用户采集
    """
    cli = params_dict["SSH"]
    lang = params_dict.get("lang")
    logger = params_dict.get("logger")
    flag, product_version, hot_patch, _ = get_system_version_with_ret(
        cli, lang
    )
    if not is_support_read_only_user_enter_debug(product_version, hot_patch):
        return False
    flag, _, level, role_id, _ = cliUtil.get_user_level_and_role_id(cli, lang)
    if not flag:
        logger.error("Query user privilege failed, check terminated!")
        return False
    logger.info(
        "Current user level is {},role_id is {}.".format(level, role_id))
    if level == "Admin" and role_id == "10":
        return True

    return False
