# -*- coding: UTF-8 -*-

class config():
    #**************预定义传输协议名称****************
    PROTOCOL_SFTP = "SFTP"

    #**************DHA配置****************
    DHA_TAR_LOG_FILE_EXTEND = ".tar.bz2"
    COLLECT_TYPE_DHA = "dha"
    COLLECT_INFO_PACKAGE_EXPORT_PATH_HEADER = "Package Path:"
    COLLECT_DHA_MAX_LOOP_TIMES = 5
    
    #********************信息收集类型********************
    EXPORT_TYPE_LOG = "log"
    EXPORT_TYPE_ALLLOG = "all_log"
    EXPORT_TYPE_EVENT = "event"
    EXPORT_TYPE_RUNNING_DATA = "running_data"
    COLLECT_TYPE_CLI = "cli"
    COLLECT_TYPE_ELABLE = "elable"
    COLLECT_TYPE_SMART = "smart"
    COLLECT_TYPE_DISKLOG = "disklog"
    COLLECT_TYPE_HOST_INFO = "host_info"
    COLLECT_TYPE_DIAGNOSTIC = "diagnostic"
    COLLECT_TYPE_POOL_CRITICAL_LOG = 'pool_critical_log'
    COLLECT_TYPE_DHA_LOG = "disk_log"
    COLLECT_TYPE_CLI_FAULT_TREE = "cli_fault_tree"
    EXPORT_TYPE_HISPERFORMANCE_DATA = "history_performance_data"

    SYSTEM_RUNNING_STATUS_UPGRADING = "upgrade:/>"
    
    HIGH_END_SERIES_DEV_TYPE_LIST = ["18500", "18800", "18800F", "HVS88T", "HVS85T"]

    # 相同型号，不同版本可能带SVP或不带SVP。需要用版本判断。
    NO_SVP_PRODUCT = {"18800F V5": "Kunpeng", "18500F V5": "Kunpeng", "18800 V5": "Kunpeng", "18500 V5": "Kunpeng"}

    # 18000SVP设备型号
    SVP_DEV_TYPES = ["HVS85T", "HVS88T", "18500", "18800", "18800F", "18500 V3", "18800 V3", "18500F V3", "18800F V3", "18500 V5", "18800 V5", "18500F V5", "18800F V5"]

    # 信息收集区分IP框 老硬件无IP框。
    OLD_HARDWARE_PRODUCT_VERSION = ["V300R006C61", "V500R007C61"]

    # 18000设备SVP上带有FTP服务的linux VM系统的IP，可用户DHA文件的下载
    SVP_LINUX_VM_IP = "172.17.126.11"

    READ_ONLY_DHA_IP = "read_only_dha_ip"

    DISK_LOG_CLCT_USING_CLI_VERSION = ["V500R007C00", "V300R006C10"]
    #收集到得信息存放的本地路径
    COLLECT_INFO_LOCAL_PATH = "collect_info_local_path"
    
    #判断系统日志是否收集完全
    COLLECT_LOG_FILE_INFO = ["info_log.txt", "file_list.txt"]
    
    #判断导出命令的回显是否正常的标准
    COLLECT_INFO_RECROD_STANDARD = "File Path :"

    #系统日志收集前检查阵列是否存在海量KVM日志小文件的KVM路径
    CHECK_KVM_PATH = "/OSM/coffer_log/log/his_debug/kvm"
    
    #收集信息所存放的目录名称
    COLLECT_INFO_DIR_NAME = {
        EXPORT_TYPE_LOG: "System_log",
        EXPORT_TYPE_ALLLOG: "System_log",
        EXPORT_TYPE_EVENT: "Alarm_log",
        EXPORT_TYPE_HISPERFORMANCE_DATA: "History_Performance_Data",
        EXPORT_TYPE_RUNNING_DATA: "Running_Data",
        COLLECT_TYPE_CLI: "CLI_command_info",
        COLLECT_TYPE_HOST_INFO: "Host_info",
        COLLECT_TYPE_ELABLE: "Electronical_label",
        COLLECT_TYPE_SMART: "Smart_information",
        COLLECT_TYPE_DISKLOG: "Disklog",
        COLLECT_TYPE_DHA: "DHA_information",
        COLLECT_TYPE_DIAGNOSTIC: "Diagnostic_file",
        COLLECT_TYPE_POOL_CRITICAL_LOG: "Pool_"
                                        "Critical_log",
        COLLECT_TYPE_DHA_LOG: "DHA_information",
        COLLECT_TYPE_CLI_FAULT_TREE: "CLI_command_info"
    }
    
    # Arm 架构的存储产品型号列表.
    ARM_ARCHITECTURE_DEV_TYPE_LIST = ['2200 V3', '2600 V3', '2600F V3', '2600 V3 for Video',
                                      "5110 V5", "5110F V5", "5210 V5", "5210F V5", "5300 V5",
                                       "5310 V5", "5510 V5", "5610 V5", "6810 V5", "18510 V5",
                                       "5810 V5","5810F V5", "18810 V5", "18810F V5", "5210 V5 Enhanced",
                                       "5310F V5", "5510F V5", "5610F V5", "6810F V5", "18510F V5","5210F V5 Enhanced"]
    
    #需要判断系统日志，具体信息是否收全的项
    IS_SYSTEM_INFO_FULL = [EXPORT_TYPE_LOG, EXPORT_TYPE_ALLLOG]
    
    #需要判断控制器，是否收全的项
    IS_CONTROLLER_INFO_FULL = [EXPORT_TYPE_LOG, EXPORT_TYPE_ALLLOG,
                               COLLECT_TYPE_SMART,
                               COLLECT_TYPE_POOL_CRITICAL_LOG,
                               COLLECT_TYPE_DHA_LOG]
    
    
    #删除阵列端临时文件判断标准
    DELETE_REMOTE_DATA_STANDARD = [
                                   "System is exporting files"
                                   ]
    
    #********************信息收集类型********************
    
    EXPORT_INFO_TIMEOUT = {
                           EXPORT_TYPE_LOG:23*60,
                           EXPORT_TYPE_ALLLOG:23*60,
                           EXPORT_TYPE_EVENT:23*60,
                           EXPORT_TYPE_RUNNING_DATA:23*60,
                           COLLECT_TYPE_SMART:183*60,
                           COLLECT_TYPE_DISKLOG:3*60,
                           COLLECT_TYPE_DHA:15*60,
                           COLLECT_TYPE_POOL_CRITICAL_LOG: 15*60,
                           COLLECT_TYPE_DHA_LOG: 45*60
                           }
    
    #并行方式收集的超时时间，单位：分
    PARALLEL_EXPORT_INFO_TIMEOUT = {
                           EXPORT_TYPE_LOG:60,
                           EXPORT_TYPE_ALLLOG:60,
                           COLLECT_TYPE_SMART:183,
                           COLLECT_TYPE_DIAGNOSTIC:10,
                           COLLECT_TYPE_POOL_CRITICAL_LOG: 15,
                           COLLECT_TYPE_DHA: 15,
                           COLLECT_TYPE_DHA_LOG: 45
                           }

    # 隔离盘日志收集超时时间，单位：分钟
    FAULT_DISK_LOG_TIMEOUT = 12

    #一般CLI命令的超时时间：2分钟
    COMMON_CMD_TIMEOUT = 2*60
    
    CLI_EXECUTE_CMD_SUCCESS = "Command executed successfully"
    
    #判断新命令执行成功的列表
    ISEXEC_CMD_SUCCESS_FLAG = [
                               "File Path : /OSM/export_import/",
                               "File Path : /OSM/coffer_data/omm/export_import",
                                ]
    
    #CLI回显、电子标签、smart信息收集，对应的文件名称
    CLI_FILE_NAMES_FOR_TYPE = {
        COLLECT_TYPE_CLI: "clicmd.txt",
        COLLECT_TYPE_ELABLE: "elabel_info.txt",
        COLLECT_TYPE_CLI_FAULT_TREE: 'fault_diagnose_info.txt'
    }
    
    #CLI回显收集的命令列表，为满足三板斧需求"show port bit_error"需要间隔收集6次
    LIST_CLI_CMD_DORADONAS = ["show port bit_error",
                    "show alarm",
                    "show bond_port",
                    "show cache_partition general",
                    "show clone general",
                    "show consistency_group general",
                    "show controller general",
                    "show disk_domain general",
                    "show enclosure",
                    "show port bit_error",
                    "show event_restore",
                    "show host general",
                    "show host_group general",
                    "show initiator",
                    "show iostat policy",
                    "show iscsi initiator_name",
                    "show iscsi target",
                    "show iscsi target_name",
                    "show isns server_ip",
                    "show license",
                    "show license_active",
                    "show lun general",
                    "show port bit_error",
                    "show notification trap",
                    "show port general",
                    "show port_group general",
                    "show remote_device general",
                    "show remote_replication general",
                    "show schedule",
                    "show security_rule",
                    "show smartqos_policy general",
                    "show smartqos_template",
                    "show snapshot general",
                    "show snmp context_name",
                    "show snmp usm",
                    "show port bit_error",
                    "show ssd routeswitch",
                    "show storage_engine",
                    "show system general",
                    "show system media_scan",
                    "show system ntp",
                    "show system timezone",
                    "show system manufactory",
                    "show upgrade package",
                    "show user",
                    "show event_config",
                    "show notification syslog",
                    "show notification sms",
                    "show version all",
                    "show lun_migration general",
                    "show lun_destroy_data upgrade_status",
                    "show mapping_view general",
                    "show mirror_lun general",
                    "show remote_lun general array_type=replication",
                    "show remote_lun general array_type=heterogeneity",
                    "show smart_cache_pool general",
                    "show smart_cache_partition general",
                    "show lun dedup_compress",
                    "show logical_port general",
                    "show vlan count",
                    "show vlan general",
                    "show failover_group general",
                    "show disk general",
                    "show port bit_error",
					"show vstore",
                    "show fs_snapshot general",
                    "show file_system general",
                    "show service cifs",
                    "show common_config nfs",
                    "show service nfs",
                    "show vnc safe_policy",
                    "show vhost_initiator general",
                    "show ib_port general",
                    "show hyper_metro_pair general",
					"show storage_pool general",
                    "show port bit_error",
                    "show host lun"
                   ]
    LIST_CLI_CMD = ["show port bit_error",
                    "show alarm",
                    "show bond_port",
                    "show cache_partition general",
                    "show clone general",
                    "show consistency_group general",
                    "show controller general",
                    "show disk_domain general",
                    "show enclosure",
                    "show port bit_error",
                    "show event_restore",
                    "show host general",
                    "show host_group general",
                    "show initiator",
                    "show iostat policy",
                    "show iscsi initiator_name",
                    "show iscsi target",
                    "show iscsi target_name",
                    "show isns server_ip",
                    "show license",
                    "show license_active",
                    "show lun general",
                    "show port bit_error",
                    "show notification trap",
                    "show port general",
                    "show port_group general",
                    "show remote_device general",
                    "show remote_replication general",
                    "show schedule",
                    "show security_rule",
                    "show smartqos_policy general",
                    "show smartqos_template",
                    "show snapshot general",
                    "show snmp context_name",
                    "show snmp usm",
                    "show port bit_error",
                    "show ssd routeswitch",
                    "show storage_engine",
                    "show system general",
                    "show system media_scan",
                    "show system ntp",
                    "show system timezone",
                    "show system manufactory",
                    "show upgrade package",
                    "show user",
                    "show event_config",
                    "show notification syslog",
                    "show notification sms",
                    "show version all",
                    "show lun_migration general",
                    "show lun_destroy_data upgrade_status",
                    "show mapping_view general",
                    "show mirror_lun general",
                    "show remote_lun general array_type=replication",
                    "show remote_lun general array_type=heterogeneity",
                    "show smart_cache_pool general",
                    "show smart_cache_partition general",
                    "show lun dedup_compress",
                    "show logical_port general",
                    "show vlan count",
                    "show vlan general",
                    "show failover_group general",
                    "show disk general",
                    "show port bit_error",
					"show vstore",
                    "show fs_snapshot general",
                    "show file_system general",
                    "show service cifs",
                    "show common_config nfs",
                    "show service nfs",
                    "show virtual_machine general",
                    "show virtual_machine port",
                    "show vnc safe_policy",
                    "show vm_fs general",
                    "show virtual_machine block",
                    "show vm_container general",
                    "show vmtools general",
                    "show vhba general",
                    "show vhost_initiator general",
                    "show ib_port general",
                    "show hyper_metro_pair general",
					"show storage_pool general",
                    "show port bit_error",
                    "show host lun"
                   ]
    
    #需要收集详细信息的CLI列表
    LIST_MULTI_CLI_CMD = {
                          "show enclosure" : ["ID", "enclosure_id="],
                          "show storage_engine" : ["ID", "storage_engine_id="],
                          "show fs_snapshot general" : ["ID", "file_system_id=", "show file_system general"],
                          "show remote_lun general array_type=replication" : ["ID", "remote_device_id=", "show remote_device general array_type=replication"],
                          "show remote_lun general array_type=heterogeneity" : ["ID", "remote_device_id=", "show remote_device general array_type=heterogeneity"],
                          "show host lun" : ["ID", "host_id=", "show host general"]
                        }
    
    #需要进入developer模式发送的命令
    LIST_DEVELOPER_CMD = ["show dha judgeproportion", 
                          "show dha policy", 
                          "show dha servicestatus", 
                          "show mp_mode"
                        ]
    
    #收集电子标签的CLI列表
    LIST_ELABLE_CMD = [
                       "show controller general",
                       "show bbu general",
                       "show fan",
                       "show interface_module",
                       "show expansion_module"
                       ]
    
    #收集电子标签详细信息的CLI列表
    LIST_MULTI_ELABLE_CMD = {
                             "show bbu general" : ["ID", "bbu_id="],
                             "show fan" : ["ID", "fan_id="],
                             "show interface_module" : ["ID", "interface_module_id="],
                             "show expansion_module" : ["ID", "expansion_module_id="]
                             }
    
    #是否包含，收集CLI的详细信息
    MULTI_CLI_COLLECT = {
                         COLLECT_TYPE_CLI : LIST_MULTI_CLI_CMD,
                         COLLECT_TYPE_ELABLE : LIST_MULTI_ELABLE_CMD
                         }
    
    
    #电子标签文件的头信息
    ELABLE_LIST_HEADER = '<?xml version="1.0" encoding="iso-8859-1" standalone="yes" ?>\n'
    
    #电子标签文件的内容，XML格式的标签名称
    LIST_ELABLE_PROPERTY = {
                            "show controller general" : "Device",
                            "show bbu general" : "BBU",
                            "show fan" : "FAN",
                            "show interface_module" : "INTERFACE_MODULE",
                            "show expansion_module" : "EXPANSION_MODULE"
                            }
    #CLI命令的超时时间(部分CLI执行时间不是默认的2min)
    cmdLimitTimeDict = {
                        "show event" : 300,
                        }
    
    RECENT_FAULTLOG_MAX_SIZE = 10L * 1024 * 1024  #10MB
