# -*- coding: UTF-8 -*-
import os
import stat
import gzip
from cbb.frame.util.tar_util import decompress_tar_all_file
import datetime
import traceback
import sys
import shutil
import com.huawei.ism.tool.infocollect.util.DataCollectConstants as dcc
import defusedxml.ElementTree as ET
import re
from common.util import util
from common.util import add_permission
from util import util
from com.huawei.ism.tool.obase.exception import ToolException


global COLLECT_FALG_DICT
COLLECT_FALG_DICT = {}
global ACCESS_DISK_LIST
ACCESS_DISK_LIST = []
global DISK_DHA_DICT
DISK_DHA_DICT = {}
global LOG
global SUCC_DISK_LIST
SUCC_DISK_LIST = []
global FAIL_DISK_LIST
FAIL_DISK_LIST = []
global FIRST_DIR_SUFFIX
FIRST_DIR_SUFFIX = ".tar.bz2"
global ROLE
ROLE = {}
global AFTER_V5R7C60SPC300
AFTER_V5R7C60SPC300 = False
global NOW_CONTROLLER_ID
NOW_CONTROLLER_ID = ""

DISKID_START_FLAG = "Smart of Disk["
SMART_COLLECT_FAIED_FLAG = "Failed to collect"
OS_OPEN_MODES = stat.S_IWUSR | stat.S_IRUSR  # 拥有者具有读写权限


def converSmartInfo(inputPath, outputPath, log, accessDiskList, diskDhaDict, devObj):
    """
    @summary: 
    """
    global ACCESS_DISK_LIST
    ACCESS_DISK_LIST = accessDiskList
    global LOG
    LOG = log
    global DISK_DHA_DICT
    DISK_DHA_DICT = diskDhaDict
    #解压及写入硬盘信息smart，汇总写入的硬盘信息summary.ini
    try:
        if util.is_X10(devObj):
            global FIRST_DIR_SUFFIX
            FIRST_DIR_SUFFIX = ".tgz"
        init_purchased_SSD_role(devObj)
        createSmartTxtFile(inputPath, outputPath)
    except:
        log.error("except trace back:" + str(traceback.format_exc()))

    try:
        createSummryiniFile(outputPath)
    except (Exception, ToolException):
        log.error("except trace back:" + str(traceback.format_exc()))


def createSmartTxtFile(inputPath, outputPath):
    """
    @summary: 将从阵列下载的Smart_information/diskinfo_0A.tar.bz2中的smart信息读取后写入disksmartinfo/smart.txt中
    """
    global NOW_CONTROLLER_ID
    if os.path.isdir(inputPath):
        fileDirList = os.listdir(inputPath)
        #开始解压缩迭代及写入硬盘信息        
        for fileDir in fileDirList:
            createSmartTxtFile(os.path.join(inputPath, fileDir), outputPath)

    fileName = os.path.basename(inputPath)
    #解析压缩包第一层,V5R7C60和Dorado V6 6.0.0之后，为tgz包
    if fileName.startswith("diskinfo_") and fileName.endswith(
            FIRST_DIR_SUFFIX):
        # 记录当前控制器ID
        NOW_CONTROLLER_ID = fileName.replace("diskinfo_", "").replace(
            FIRST_DIR_SUFFIX, "")

        LOG.info("[createSmartTxtFile] find diskinfo_.tar.bz2 file:\n %s" % inputPath)
        tempDir = inputPath[0:inputPath.find(".tar.bz2")]
        LOG.info("[createSmartTxtFile] uncompress diskinfo_.tar.bz2 file to:\n %s" % tempDir)
        uncompressBz2File(inputPath, tempDir)
        createSmartTxtFile(tempDir, outputPath)
        # 增加可删除权限。产品安全整改，降低了压缩包权限为440，工具无法删除
        add_permission(tempDir)
        shutil.rmtree(tempDir, True)

    #解析压缩包之后层级及查看txt文件        
    if fileName.endswith(".tgz") and fileName.startswith("disksmartinfo_"):
        #通过basicInfo 判断返回信息为tgz或txt
        basicInfo = getTgzFileBasicInfo(inputPath)
        if "disksmartinfo_" in basicInfo and ".txt" in basicInfo:
            LOG.info("[createSmartTxtFile] find disksmartinfo_.txt file:\n %s" % inputPath)
            parseSmartTgzFile(inputPath, outputPath)
        else:
            tempDir = inputPath[0:inputPath.find(".tgz")]
            LOG.info("[createSmartTxtFile] uncompress disksmartinfo_.tgz file to :\n %s" % tempDir)
            uncompressTgzfile(inputPath, tempDir)
            createSmartTxtFile(tempDir, outputPath)
            # 增加可删除权限。产品安全整改，降低了压缩包权限为440
            add_permission(tempDir)
            shutil.rmtree(tempDir, True)


def getTgzFileBasicInfo(compressTgzFile):
    """
    @summary: 获取被压缩的tgz文件的基本信息
    """
    tgzFile = None
    try:
        tgzFile = gzip.open(compressTgzFile, 'rb')
        return tgzFile.readline()
    except:
        logException(LOG)
        return ""
    finally:
        if tgzFile is not None:
            tgzFile.close()


def parseSmartTgzFile(gzFilePath, outputPath):
    '''
    @summary: 解析从阵列上收集的smart信息中的内容按硬盘为单位依次写入smart.txt文件中。
    @param gzFilePath: 从阵列收集的类型为tgz的smart信息文件。
    @param outputPath: smart.txt文件的存放路径。
    '''
    tgzFile = openTgzFile(gzFilePath)
    if tgzFile == None:
        return
    
    oneDiskInfo = ""
    while True:
        line = tgzFile.readline()
        if getDiskID(line) or isEnd(line):
            diskID = getDiskID(oneDiskInfo)
            need_disk_health_analyze = True
            # 缓存上一块硬盘的信息
            # 不同控制器系统盘不等同带上此处显示的diskID相同
            # 放开限制后，系统盘需要写入
            if AFTER_V5R7C60SPC300 and "ROOT" in diskID:
                diskID = diskID + "_" + NOW_CONTROLLER_ID

            if diskID and (diskID not in SUCC_DISK_LIST):
                # 未接入系统的盘不做处理(show disk general能查到的盘为
                # 已接入系统的盘),V5R7C30SPC300之后放开限制
                if diskID not in ACCESS_DISK_LIST:
                    if AFTER_V5R7C60SPC300:
                        need_disk_health_analyze = False
                    else:
                        oneDiskInfo = ""
                        oneDiskInfo += line
                        LOG.info(
                            "[parseSmartTgzFile]"
                            "[the disk(%s) is not accessed]" % diskID)
                        continue

                # 硬盘信息收集成功
                if isCollectSucc(oneDiskInfo):
                    # 因硬盘健康分析需使用Device Model做分隔，所以必须判断此字段存在，否则可能导致分析数据错位。
                    if "Device Model" in oneDiskInfo:
                        # 新增对于外购SSD盘的处理
                        oneDiskInfo = purchased_SSD(oneDiskInfo)
                        succDiskNum = len(SUCC_DISK_LIST)
                        smartFilePath = os.path.join(outputPath, "smart%s.txt" % (succDiskNum / 20))
                        collectContent = oneDiskInfo + "\nStart Health Mark\nHealth Mark For DHA : %s\n" % DISK_DHA_DICT.get(
                            diskID, "")
                        # 系统盘，需要在最后拼接控制器信息，
                        # 控制器信息通过压缩包截取
                        if AFTER_V5R7C60SPC300 and "ROOT" in diskID:
                            collectContent = \
                                collectContent + "\nController ID: " + \
                                NOW_CONTROLLER_ID + "\n"

                        writeSmartFile(smartFilePath, collectContent)

                        if need_disk_health_analyze:
                            SUCC_DISK_LIST.append(diskID)
                            if diskID in FAIL_DISK_LIST:
                                FAIL_DISK_LIST.remove(diskID)

                        LOG.info("[parseDisk][getDiskMapInfo][get disk %s success.]" % diskID)
                    else:
                        # 硬盘信息收集失败
                        FAIL_DISK_LIST.append(diskID)
                        LOG.info("[parseDisk][getDiskMapInfo][the disk do not have Device Model (%s)!]" % diskID)

                # 硬盘信息收集失败
                else:
                    if need_disk_health_analyze:
                        FAIL_DISK_LIST.append(diskID)
                    LOG.info("[parseDisk][getDiskMapInfo][get disk %s failed!]" % diskID)
            
            # 一块硬盘信息读取结束，开始缓存下一块硬盘的信息
            oneDiskInfo = ""
        
        oneDiskInfo += line

        # 读取结束
        if isEnd(line):
            LOG.info("[parseDisk][getDiskMapInfo][parse %s end.]" % gzFilePath)
            break
        
    if tgzFile != None:
        tgzFile.close()
    return


def getSmart(line):
    """
    @summary: 解析阵列原始smart文件，逐行获取smart信息
    """
    pass


def openTgzFile(gzFilePath):
    """
    @summary: 打开包含smart信息的tgz文件
    """
    try:
        return gzip.open(gzFilePath, 'rb')
    except:
        logException(LOG)
        return None


def format_traceback():
    '''
    @summary: 格式化输出错误堆栈信息
    '''
    new_extracted_list = []
    etype, value, tb = sys.exc_info()
    extracted_list = traceback.extract_tb(tb)
    for item in extracted_list:
        filename, lineno, name, line = item
        filename = os.path.basename(filename)
        new_extracted_list.append((filename, lineno, name, line))

    return "".join(traceback.format_list(new_extracted_list) + traceback.format_exception_only(etype, value))


def logException(log):
    '''
    @summary: 日志输出错误堆栈信息
    '''
    log.info(format_traceback())


def writeSmartFile(smartFilePath, collectContent):
    '''
    @summary: 生成smart*.txt
    @param smartFilePath: smart*.txt文件路径
    @param collectContent: 要写入的内容
    '''
    smartFile = None
    try:
        os_open_flags = os.O_WRONLY | os.O_CREAT | os.O_APPEND  # 读写 | 创建并打开
        smartFile = os.fdopen(os.open(smartFilePath, os_open_flags, OS_OPEN_MODES), 'a')
        smartFile.write(collectContent)
        smartFile.write("\n")
        smartFile.flush()
    except:
        logException(LOG)
        raise IOError
    finally:
        if smartFile is not None:
            smartFile.close()

def createSummryiniFile(outputPath):
    """
    @summary: 生成summary.ini
    """
    #记录硬盘总次数及成功次数    
    succDiskNum = len(SUCC_DISK_LIST)
    failDiskNum = len(FAIL_DISK_LIST)
    summaryInfo = {"total": succDiskNum + failDiskNum, "success": succDiskNum}
    summaryFileName = "summary.ini"
    summaryFilePath = os.path.join(outputPath, summaryFileName)
    #将内容写入summary.ini    
    writeSummaryiniFile(summaryFilePath, summaryInfo)

    LOG.info("[parseDisk][converSmartInfo][summaryInfo=%s]" % summaryInfo)
    LOG.info("[parseDisk][converSmartInfo][end]")

def writeSummaryiniFile(summaryFilePath, summaryInfo):
    '''
    @summary: 生成summary.ini
    @param summaryFilePath: summary.ini文件路径
    @param collectContent: 要写入的内容
    '''
    summaryFile = None
    try:
        os_open_flags = os.O_WRONLY | os.O_CREAT | os.O_TRUNC  # 写 | 创建并打开 | 截断
        summaryFile = os.fdopen(os.open(summaryFilePath, os_open_flags, OS_OPEN_MODES), 'w')
        summaryFile.write("total=%s" % summaryInfo["total"])
        summaryFile.write("\n")
        summaryFile.write("success=%s" % summaryInfo["success"])
        summaryFile.write("\n")
        currDate = datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S")
        summaryFile.write("date=%s" % currDate)
        summaryFile.write("\n")
        summaryFile.flush()
    except:
        logException(LOG)
        raise IOError
    finally:
        if summaryFile is not None:
            summaryFile.close()


def uncompressFile(todoFile, uncompressPath, openType):
    """
    @summary: 解压缩文件到指定路径
    """
    decompress_tar_all_file(todoFile, uncompressPath, openType)


def uncompressBz2File(bz2File, uncompressPath):
    '''
    @summary: 解压bz2文件到指定路径
    '''
    uncompressFile(bz2File, uncompressPath, "r")

def uncompressTgzfile(tgzFile, uncompressPath):
    """
    @summary: 解压tgz文件到指定路径
    """
    uncompressFile(tgzFile, uncompressPath, "r:gz")
    

def isEnd(line):
    """
    @summary: 判断文件读取是否结束
    """
    if not line:
        return True
    
    return False


def getDiskID(line):
    """
    @summary: 获取硬盘ID
    """
    if DISKID_START_FLAG not in line:
        return ""
    
    temp = line.split(DISKID_START_FLAG)
    if len(temp) < 2:
        return ""
    
    temp = temp[1]
    diskID = temp.split()[0]
    
    if not isDiskID(diskID):
        return ""
    
    return diskID


def isDiskID(diskID):
    """
    @summary: 判断是否为硬盘ID
    """
    if not diskID:
        return False
    
    if diskID.startswith("CTE") or diskID.startswith("ENG") or diskID.startswith("DAE") or diskID.startswith("ROOT"):
        return True
    
    LOG.info("[parseDisk][getDiskMapInfo][unhandled disk_id=%s]" % diskID)
    return False


def isCollectSucc(diskInfo):
    """
    @summary: 判断硬盘smart信息是否收集成功
    """
    if SMART_COLLECT_FAIED_FLAG in diskInfo:
        return False

    return True


def purchased_SSD(one_disk_info):
    """
     判断是否是外购SSD盘，如果是，匹配是否是配置的model，进行相应处理
    :param one_disk_info: 一块硬盘的smart信息
    :return: 解析之后的信息
    """
    if not ROLE:
        LOG.info("ROLE is null")
        return one_disk_info

    # 将oneDiskInfo分为三部分，头，需要处理的smartAttributes，尾
    line_list = one_disk_info.splitlines()
    smart_attributes_start_flag = False
    smart_attributes_end_flag = False
    device_Model = ""
    info_head = ""
    smart_attributes = ""
    info_end = ""
    for line in line_list:
        if "Device Model" in line:
            LOG.info("Device Model line is :" + line)
            device_Model = line.split(":")[1].strip()
        if "ID#" in line and "ATTRIBUTE_NAME" in line:
            smart_attributes_start_flag = True
        if smart_attributes_start_flag and (
                    not line or re.match("^-*$", line.strip())):
            smart_attributes_end_flag = True
        if not smart_attributes_start_flag and not smart_attributes_end_flag:
            info_head += line
            info_head += "\n"
        else:
            if smart_attributes_end_flag:
                info_end += line
                info_end += "\n"
            else:
                smart_attributes += line
                smart_attributes += "\n"

    id_and_name_map = {}
    for model in ROLE:
        if model in device_Model:
            id_and_name_map = ROLE[model]
            break
    if not id_and_name_map:
        LOG.info("This device_Model not in ROLE.")
        return one_disk_info

    # 处理smartAttributes
    disk_smart_list, table_headers = getHorizontal(smart_attributes)
    if not disk_smart_list:
        LOG.info("smart_attributes change dict is error")
        return one_disk_info

    for disk_smart_info_map in disk_smart_list:
        smart_id = disk_smart_info_map.get("ID#")
        if id_and_name_map.get(smart_id):
            disk_smart_info_map["ATTRIBUTE_NAME"] = id_and_name_map.get(
                smart_id)

    sumdisk_info = re_splice_align(disk_smart_list, table_headers)
    new_one_disk_info = info_head + sumdisk_info + info_end
    return new_one_disk_info


def re_splice_align(disk_smart_list, table_headers):
    """
    重新拼接，注意对齐
    :param disk_smart_list: 表数据列表
    :param table_headers: 表头列表
    :return: 重新对齐组合的数据
    """
    table_header_length = {}
    for disk_smart_info_map in disk_smart_list:
        for table_header in table_headers:
            if table_header in table_header_length:
                table_header_length[table_header] = max(
                    len(disk_smart_info_map.get(table_header)),
                    table_header_length.get(table_header))
            else:
                table_header_length[table_header] = max(len(
                    disk_smart_info_map.get(table_header)), len(table_header))
    # 重新将数据汇总
    sumdisk_info = ""
    # 写入表头
    for table_header in table_headers:
        sumdisk_info += table_header.ljust(
            table_header_length.get(table_header) + 2, " ")
    sumdisk_info += "\n"
    # 写入smartAttributes信息
    for basicinfo in disk_smart_list:
        for table_header in table_headers:
            sumdisk_info += basicinfo.get(table_header).ljust(
                table_header_length.get(table_header) + 2, " ")
        sumdisk_info += "\n"

    return sumdisk_info


def init_purchased_SSD_role(devObj):
    """
    初始化需要处理的盘的规则文件
    :param devObj: 上下文
    :return: 无
    """
    # V500R007C60SPC300之后的版本才支持收外购SSD盘（X86和X10都是）
    # 需要对Smart属性做处理
    global AFTER_V5R7C60SPC300
    global ROLE
    dev_node = devObj.get("devNode")
    sys_spc_version = dev_node.getProductVersion()
    if sys_spc_version < "V500R007C60SPC300":
        LOG.info("not suppot Purchased SSD")
        return

    AFTER_V5R7C60SPC300 = True
    LOG.info("Start parsing purchased_SSD_smart_change.xml")
    # 初始化外购SSD盘，Smart信息属性变更规则
    cur_script_path = devObj.get(dcc.COLLECT_PYTHON_SCRIPT_PATH)
    conf_path_name = os.path.join(
        cur_script_path, 'purchased_SSD_smart_change.xml')
    tree = ET.parse(conf_path_name)  # 打开xml文档
    root = tree.getroot()
    conf_map = {}
    for model_tree in root.findall("model"):
        key_list = str(model_tree.attrib["modelIDs"]).split(",")
        val = {}
        for confNode in model_tree.findall("conf"):
            val[confNode.attrib["smartID"]] = confNode.attrib["name"]
        for key in key_list:
            conf_map[key] = val
    ROLE = conf_map


def getHorizontal(smartAttributes):
    '''
    将表格转换成字典
    :param smartAttributes: 表信息
    :return: 字典，表头的列表（用来保持原顺序）
    '''
    keys = []
    dict_list = []
    info_list = smartAttributes.encode("utf8").splitlines()
    key_split = re.compile(r"[a-zA-Z0-9_#]+\s*")
    tuple_idxs = []
    hand_flag = True
    # 最后一列需要特殊处理
    for line in info_list:
        if hand_flag:
            hand_flag = False
            key_line = line
            start_pos = 0
            end_pos = 0
            while (start_pos <= len(key_line)):
                match = key_split.search(key_line, start_pos)
                if match:
                    end_pos = match.end()
                    tuple_idxs.append((start_pos, end_pos))
                    keys.append(
                        line[start_pos:end_pos].strip().decode("utf8"))
                    start_pos = end_pos
                else:
                    break
        else:
            vals = []
            # 最后一列的取值需要特殊处理
            for i in range(len(tuple_idxs) - 1):
                item = tuple_idxs[i]
                vals.append(line[item[0]:item[1]].strip().decode("utf8"))
            last_item = tuple_idxs[len(tuple_idxs) - 1]
            vals.append(line[last_item[0]:].strip().decode("utf8"))
            dict_list.append(dict(zip(keys, vals)))
    return dict_list, keys
