from com.huawei.ism.tool.obase.connection import SshConnection
from com.huawei.ism.tool.obase.connection import SftpTransporter
from com.huawei.ism.tool.obase.connection import SshConnectionManager
from com.huawei.ism.tool.obase.exception import ToolException
from com.huawei.ism.tool.obase.exception import PwdCLIOverrunException

from cbb.business.collect.ssh_tool import build_conn

import traceback


class SSHToolUtils():
    '''
    @summary:  building new SSH/SFTP connection independently
    '''
    
    def __init__(self, devObject, logger):
        
        self.devObj = devObject
        self.log = logger
        
    def newSshUsingCrntUsrCredential(self, destHost, SSH_PORT = 22):
        '''
        @summary: building new SSh  connection to destination 
        @warning:  only 4 connections at most  exists at the same time!
        @return:  status, sshCon(None if not exists!)
        '''
    
        username = self.devObj.get("username") if self.devObj.get("username") else ""
        password = self.devObj.get("password") if self.devObj.get("password") else ""
        context  = self.devObj.get("context")  if self.devObj.get("context")  else ""
        try:
            self.log.info("building SSH connection to host: %s"%str(destHost))
            if not context:
                self.log.error("no context found, can't building SSH connection!")
                return False, None
            ssh_conn = build_conn(destHost, self.devObj)
            if not ssh_conn:
                return False, None
            context.addProtocolForShellCreated(destHost, ssh_conn)
            self.log.info("SSH connection successfully built!")
            return True, ssh_conn
        except PwdCLIOverrunException, pe:
            self.log.error("failed in building SSH connection, too much instance exists!")
            return False, None
        except ToolException, te:
            self.log.error("error occurred while building SSH connection " + unicode(te))
            return False, None
        except Exception, e:
            self.log.error("exception occurred while building SSH connection " + unicode(e))
            return False, None
    
    def deriveSftpTransporter(self, sshCon):
        '''
        @summary: derive SFTP connection using current set ssh connection 
        @return status,sftpConn(None if not exists!)
        '''
        if  None == sshCon or not isinstance(sshCon, SshConnection):
            self.log.error( "current ssh connection is unable to derive!")
            return False, ""
        try:
            self.log.info("building SFTP connection to host...")
            sftpConn = SftpTransporter(sshCon)
            return True, sftpConn
        except :
            self.log.error( "error occured while deriving SFTP transporter " + unicode(traceback.print_exc()))
            return False, None
            
               
    def closeSshConnection(self, sshCon):
        '''
        @summary: close SSH connection 
        '''
        if sshCon is not None and  isinstance(sshCon, SshConnection):
            self.log.info("close SSH Connection...")
            try:
                sshCon.close()

            except:
                self.log.info("Exception occurred: " + unicode(traceback.print_exc()) )
                return
        else:
            self.log.info("current SSH connection is not valid .")
            return 
            
                
        
    def closeSftpConnection(self, sftpTrans):
        '''
        @summary: close SFTP connection 
        '''
        if sftpTrans is not None and isinstance(sftpTrans, SftpTransporter):
            self.log.info("close SFTP Connection...")
            try:
                sftpTrans.close()

            except:
                self.log.info("Exception occurred: " + unicode(traceback.print_exc()) )
                return
        else:
            self.log.info("current SFTP connection is not valid.")
            return 

        