# -*- coding: UTF-8 -*-
import traceback
import com.huawei.ism.tool.infocollect.util.DataCollectConstants as DataConstants
from common.util import util
from common.util import log
from common.sshTools import SSHToolUtils  
from common.commonUtils import CommonUtils
from common.commonUtils import Log
from common.disklogConf import disklogConf
import  re
def execute(devObj):
    '''
    @summary: get device attached disk information
    '''
    try:
        util.initPyDetailMsg(devObj)
        if util.isSystemUpgrading(devObj):
            return (0, {})
        diskMap, sysDiskNum, hasSensitiveDisks, failedEngins = {}, 0, False, ''
        isSucc, isMultiprocess = util.isCli4DiskInfoAvaliable(devObj)
        if isSucc and isMultiprocess:
            logger = Log(devObj)
            commonUtils = CommonUtils(devObj, logger)
            diskInfoCollector = DiskInfoCollector(devObj, commonUtils, logger)
            sysDiskNum, diskMap, hasSensitiveDisks = diskInfoCollector.collectDiskInfoDirectly()
        else:
            isSuccess, is18000 = util.is18000Series(devObj)
            if isSuccess and is18000:
                logger = Log(devObj)
                commonUtils = CommonUtils(devObj, logger)
                diskInfoCollector = DiskInfoCollector(devObj, commonUtils, logger)
                sysDiskNum, diskMap, hasSensitiveDisks, failedEngins = diskInfoCollector.collectDiskInfo()
            else:
                diskMap, sysDiskNum, hasSensitiveDisks = util.getAllDiskInfoInAdmin(devObj)
            #处理从阵列侧收集到的日志文件
        if sysDiskNum == 0 and hasSensitiveDisks:
            sysDiskNum = DataConstants.TOO_MUCH_PERFORMANCE_SENSITIVE_DISKS
                
        if not diskMap:
            diskMap = {}
            sysDiskNum = DataConstants.TOO_MUCH_PERFORMANCE_SENSITIVE_DISKS if hasSensitiveDisks else 0
            log.error(devObj, 'Query all disk info failed.')

        return sysDiskNum, diskMap, failedEngins
    except:
        log.error(devObj, "except trace back:" + str(traceback.format_exc()))
        return (0, {})
    
class DiskInfoCollector():
    '''
    ClassDoc
    @author: 
    @change: add disk log collection on V5R7 series  17-10-20
    '''
    
    def __init__(self, devObject, commonUtil, logger):
        '''
        @summary: collect disk info , including disk id| type| vendor| SN| model number| disk symbol  
        '''
        self.devObj = devObject
        self.util = commonUtil
        self.log = logger
        self.sshToolUtil = None
        self.log.info("initiating disk query job ...")
        
    def collectDiskInfoDirectly(self):
        '''
        @summary: collect disk information using admin mode's show disk general command directly
        @note: some disks of specified vendor's specified firmware version shall be extracted out
        '''

        diskMap = {}
        hasSensitiveDisks = False
        cmd = "show disk general |filterRow column=Health\sStatus predict=not predict2=equal_to value=Fault|filterColumn include columnList=Serial\sNumber,ID,Firmware\sVersion,Type,Manufacturer,Model"
        self.util.initPyDetailMsg()
        isCmdSuccess, errMsg = self.util.checkSystemNormal()
        if not isCmdSuccess:
            self.log.error("qry disk info but found current system is not normal!")
            self.util.addPyDetailMsg(errMsg)
            return False, ""
        isSucc, echoMsg = self.util.execCliWithTimeout(cmd)
        if not isSucc:
            self.log.error("unable to execute show disk general command!")
            return False, ""
        diskInfoList = self.util.getHorizontalCliRet(echoMsg)
        for diskInfo in diskInfoList:
            diskId = diskInfo.get("ID", "")
            diskType = diskInfo.get("Type", "--")
            diskModel = diskInfo.get("Model", "--")
            fmVer = diskInfo.get("Firmware Version", "")
            vendor = diskInfo.get("Manufacturer", "")
            diskSn = diskInfo.get("Serial Number", "--")
            if len(diskId) < 4 or  diskId == "--":
                continue
            if not diskId or not fmVer or not vendor:
                continue
            if 'toshiba' == vendor.lower() \
                    and (diskModel in disklogConf.TOSHIBA_EXCLUDE_DISK_MODEL_LIST or fmVer in disklogConf.TOSHIBA_EXCLUDE_DISK_MODEL_BATCH_MAP.get(diskModel, "")):
                hasSensitiveDisks = True
                self.log.info('found disk that is performance sensitive,quit collect this diskId :' + str(diskId))
            else:
                diskMap[diskId] = (diskId, diskSn, vendor, diskModel, "--", diskType)
        diskCounts = len(diskMap)
        return diskCounts, diskMap, hasSensitiveDisks


    def collectDiskInfo(self):
        '''
        @summary: fetch system disk information
        @return: sysDiskNum, diskMap
        @return:  integer  , {diskId:(diskInfo, tuple)}
        '''
        controllerIp = None
        controllerSsh = None
        try:
            self.util.initPyDetailMsg()
            isSuccess, errMsg = self.util.checkSystemNormal()
            if not isSuccess:
                self.log.error("qry disk info but found current system is not normal!")
                raise Exception, errMsg
            isSuccess, enginCntrIpMap = self.util.getEnginCntrIpMap()
            if not isSuccess or enginCntrIpMap is None:
                self.log.error("cannot fetch controller ip lists!")
                raise Exception, "dev.conn.failure"
            diskMapAll = {}
            hasSensitiveDisksAll = False
            failedEngins = ''
            diskSnIds = self.getDiskBasis()
            sysDiskNumAll = len(diskSnIds)
            for curEngin in  enginCntrIpMap:
                controllerIp = ''
                engineCtlrIps = enginCntrIpMap[curEngin]
                for ctrlrIp in engineCtlrIps:
                    self.log.info("select one of the lists controller %s" % str(ctrlrIp))
                    isSuccess, controllerSsh = self.newControllerSSH(ctrlrIp)
                    if None != controllerSsh :
                        controllerIp = ctrlrIp
                        break
                if not isSuccess or controllerSsh is None:
                    self.log.error("current engine[ %s] has no working controllers!" % curEngin)
                    failedEngins += str(curEngin) + ","
                    continue

                diskMap, hasSensitiveDisks = self.getAllDiskInfo(controllerSsh, controllerIp, diskSnIds)
                diskMapAll = dict(diskMapAll, ** diskMap)
                hasSensitiveDisksAll = hasSensitiveDisksAll or hasSensitiveDisks
                self.log.info("current engine device available disk counts:%s" % str(len(diskMap)))
                self.log.info("current engine device info lists:%s" % str(diskMap))
                if controllerSsh is not None:
                    self.util.tryExitDiagnoseModeOnHost(controllerSsh, controllerIp)
                if self.sshToolUtil is not None:
                    self.sshToolUtil.closeSshConnection(controllerSsh)
            self.log.info("current device available disk counts:%s" % str(sysDiskNumAll))
            self.log.info("current device info lists:%s" % str(diskMapAll))
            if failedEngins:
                failedEngins = failedEngins.rstrip(',')
            return sysDiskNumAll, diskMapAll, hasSensitiveDisksAll, failedEngins
        except BaseException, exp:
            exp = str(exp)
            self.log.error("exception occurred while processing collectDiskInfo -> DiskInfoCollector %s" % exp)
            if re.match("([a-z|A-z]+[.]+)+[a-z|A-Z]+(\|\|)(\S)+", exp):
                self.log.info( "error type is known with params, sealing return message...")
                errMsg = exp.split("||")[0]
                msgParam = exp.split("||")[1]
                self.util.addPyDetailMsg(errMsg, msgParam)
                
            elif re.match("([a-z|A-z]+[.]+)+[a-z|A-Z]+", exp):
                self.log.info( "error type is known, sealing return message...")
                self.util.addPyDetailMsg(exp)

            else:
                self.log.info("unknown exception, using unified err message:%s" % str(exp))
                self.util.addPyDetailMsg("qry.disk.info.failed", controllerIp)
                
            return (0, {}, False, '')
        
        finally:
            if controllerSsh is not None:
                self.util.tryExitDiagnoseModeOnHost(controllerSsh, controllerIp)
            if self.sshToolUtil is not None:
                self.sshToolUtil.closeSshConnection(controllerSsh)
       
        
    def newControllerSSH(self, controllerIp):
        '''
        @summary:create new ssh to remote controller
        @param : controllerIp
        @return:  boolean, ssh instance
        '''
        self.sshToolUtil = SSHToolUtils(self.devObj, self.log)
    
        return self.sshToolUtil.newSshUsingCrntUsrCredential(controllerIp)
    def getDiskBasis(self):
        '''
        @summary: get disk basic information sn + id + total counts
        @return: diskSnMap
        '''
        cmd = "show disk general |filterRow column=Health\sStatus predict=not predict2=equal_to value=Fault|filterColumn include columnList=Serial\sNumber,ID"
        try:
            self.log.info("processing command: %s" % cmd)
            controllerSsh = self.devObj['SSH']
            isCmdSuccess, cmdEcho = self.util.execCliTimeoutGivenSsh(controllerSsh, cmd)
            if not isCmdSuccess or cmdEcho == "":
                self.log.info("error occurred while processing command %s" % cmd)
                raise Exception, "qry.all.disk.SN.failed"

            diskSnList = self.util.getHorizontalCliRet(cmdEcho)
            diskIdSnMap = {}
            if not diskSnList:
                self.log.info("error occurred while parsing show disk general cmd echo %s" % cmd)
                raise Exception, "qry.all.disk.SN.failed"
            for diskSNMap in diskSnList:
                diskId = diskSNMap.get('ID', '')
                serNum = diskSNMap.get('Serial Number', '')
                if not diskId or not serNum:
                    continue
                diskIdSnMap[serNum] = diskId
            return diskIdSnMap
        except BaseException, excp:
            self.log.info("exception occurred while fetching disk basic info: %s" % str(excp))
            return {}

    def getAllDiskInfo(self, controllerSsh, controllerIp, diskIdSnMap):
        '''
        @summary: start to get disk information using cli cmds
        @return: 
        '''
        diskMap = {}
        hasSensitiveDisks = False
        __, isUseCliCmd = util.isCli4DiskInfoAvaliable(self.devObj)
        try:
            self.log.info("entering into mini-system mode...")
            self.util.enterMiniSystemModOnHost(controllerSsh, controllerIp)
            cmd = "showdiskinfo"
            isCmdSuccess, cmdEcho = self.util.execCliTimeoutGivenSsh(controllerSsh, cmd)
            if not isCmdSuccess :
                self.log.error("failed in fetching disk info from showdiskinfo command")
                raise Exception, "qry.disk.info.failed"
            
            idx = cmdEcho.find('All scsi luns')
            if -1 != idx:
                cmdEcho = cmdEcho[:idx]
                
            lines = cmdEcho.splitlines()
            isParsingStart = False
            for line in lines:
                if not line.strip() or not isParsingStart:
                    diskID, serialNum, vendor, model, name, diskType = '', '', '', '', '', ''
                
                if line.strip().startswith('id '):
                    isParsingStart = True

                if isParsingStart and line.strip().startswith('DISK'):
                    diskType = line.split('type')[1].split(', port')[0].split('(')[0].strip()                

                if isParsingStart and line.strip().startswith('vendor'):
                    keyLine = line.strip()
                    fds = keyLine.split(',')
                    serialNum = fds[3].strip().split()[1].strip()
                    diskID = diskIdSnMap.get(serialNum)
                    if not diskID :
                        isParsingStart = False
                        continue
                    vendor = fds[0].split()[1].strip()
                    model = fds[1].split()[1].strip()
                    firmwareVer = fds[2].split()[2].strip()
                    
                if isParsingStart and 'name' in line:
                    name = line.split('name')[1].split(',')[0].strip()  
                
                if  isParsingStart and  serialNum and vendor and model and name and diskType:
                    # CLI命令收集场景，保持原状，全部都屏蔽。
                    if 'toshiba' == vendor.lower() and isUseCliCmd and (model in disklogConf.TOSHIBA_EXCLUDE_DISK_MODEL_LIST or firmwareVer in disklogConf.TOSHIBA_EXCLUDE_DISK_MODEL_BATCH_MAP.get(model, "")):
                        hasSensitiveDisks = True
                        self.log.info('found disk that is performance sensitive, and use cli collect, quit collect this diskId :'+str(diskID))

                    # disktool 收集的版本，需按新方案修改Model 为AL14XXX 且FW版本为0803/0808/0807的硬盘只收集0x01部分
                    # 日志(此处只需先查询出来，后续收集时再判断FW,更改收集命令)
                    elif 'toshiba' == vendor.lower() and not isUseCliCmd and (model in disklogConf.TOSHIBA_EXCLUDE_DISK_MODEL_LIST):
                        hasSensitiveDisks = True
                        self.log.info(
                            'use disktool collect, toshiba risk disk, quit collect this diskId :' + str(diskID))
                    else:
                        diskMap[diskID] = (diskID, serialNum, vendor, model, name, diskType)
                        
                    isParsingStart = False
            
            return diskMap, hasSensitiveDisks
        
        except BaseException, excp:
            self.log.error("Exception occurred while qrying disk info:%s" % str(excp))
            raise Exception, excp
            
            
            
