# -*- coding: UTF-8 -*-
from java.io import File
import com.huawei.ism.tool.infocollect.util.DataCollectConstants as dcc
from common.util import util
from common.util import log
from common.disklogConf import disklogConf
import os

def replaceDisktool(devObj, isX86):
    '''
    @devObj: Java传递给Python脚本的上下文。
    @summary:执行disktool的上传并进行权限修改.
    @return: boolean :上传并修改权限成功.
    @note: 并非是设备对象，而是包含设备对象的一个map。
    ''' 
    
    curScriptPth = devObj.get(dcc.COLLECT_PYTHON_SCRIPT_PATH)
    disktoolPth = os.path.join(curScriptPth , 
                               '..', '..', 
                               'disktool', 
                               'x86_64' if isX86 else 'arm_64', 
                               'disktool')
    sftp = util.getSftp(devObj)
    try:
        sftp.putFile(File(disktoolPth), disklogConf.SFPT_HOME_DIR, None)
        if not sftp.chmod(150, disklogConf.SFPT_HOME_DIR + '/disktool'):
            log.error(devObj, 'Chmod of disktool failed.')
    except Exception, e:
        log.error(devObj, "Upload or chmod of disktool exception:" + unicode(e))
        return False
    else:
        log.info(devObj, "Upload and chmod of disktool success.")
        return True
        