# -*- coding: UTF-8 -*-
import os
import resource
import sys
import shutil
import traceback
from common.constants import VERSION_OLD
from common.constants import COMRESULTFILE
from common.constants import COMPROGRESSFILE
from common.constants import COMIPFILE
from com.huawei.ism.tool.obase.exception import ToolException

'''
信息收集，基本的工具方法
'''


class util():
    @staticmethod
    def getMsg(devObj, msg, args="", param=""):
        '''
        @summary: 获取资源信息
        @param cliRet: devObj = 上下文对象,
                       msg = 资源脚本（resource.py）中对应的Key，
                       args = 占位符对应的值
        @return: msg
        '''
        if not msg:
            return ""
        lang = devObj.get("lang")
        if msg in resource.MESSAGES_DICT:
            msgDict = resource.MESSAGES_DICT.get(msg)
            msg = msgDict[lang]
            # 填充参数值
            if param != "":
                allParam = param.split(',')
                for num in range(0, len(allParam)):
                    msg = msg.replace("##%02d" % (num + 1), allParam[num])

        # 若占位符的值不为”“，则填充高占位符
        if "" != args:
            msg = msg % args

        return msg

    @staticmethod
    def initPyDetailMsg(devObj):
        '''
        @summary: 清除之前设置的错误信息
        @return: 无
        '''
        devObj["py_detail"] = ""

    @staticmethod
    def setPyDetailMsg(devObj, msg, args=""):
        '''
        @summary: 消息国际化
        @param lang: 语言lang
        @param msg: 消息
        @param args: 消息参数
        @return: 经过国际化处理后的消息
        '''
        msg = util.getMsg(devObj, msg, args)

        devObj["py_detail"] = msg

    @staticmethod
    def createDir(devObj, dirPath):
        """
        @summary:创建文件夹，若存在则清空该文件夹再创建
        """
        try:
            if os.path.exists(dirPath):
                shutil.rmtree(dirPath)
            os.makedirs(dirPath)
        except Exception:
            log.info(devObj, "create directory failed!")
            log.info(devObj, "except trace back:%s" % str(traceback.format_exc()))
            return False

        return True

    @staticmethod
    def collMsgCheck(devObj, msg):
        '''
        @summary:依据参数msg判断设备测是否有错误
        @param msg: 消息体
        @return: True:Normal False:Err
        '''
        if not msg:
            return (True, "")
        for line in msg.splitlines():
            if line.find('var.Log.reach.80') >= 0:
                util.setPyDetailMsg(devObj, 'var.Log.reach.80')
                return (False, "")
            if line.find('multi.user.collect') >= 0:
                util.setPyDetailMsg(devObj, 'multi.user.collect')
                return (False, "")
            if line.find('node.name.format.err') >= 0:
                util.setPyDetailMsg(devObj, 'node.name.format.err')
                return (False, "")
            if line.find('order.ini.missing') >= 0:
                util.setPyDetailMsg(devObj, 'order.ini.missing')
                return (False, "")
            if line.find('coll.param.error') >= 0:
                util.setPyDetailMsg(devObj, 'coll.param.error')
                return (False, "")
            if line.find('coll.disk.error') >= 0:
                return (False, "")
            if line.find('CmMonLeader.same.node') >= 0:
                util.setPyDetailMsg(devObj, 'CmMonLeader.same.node')
                return (False, "")
        return (True, "")

    @staticmethod
    def checkPartSuccFlag(devObj, msg):
        '''
        @summary:依据参数msg判断设备测是否有错误
        @param msg: 消息体
        @return: True:Normal False:err
        '''
        if not msg:
            return (True, "")
        ErrorInfoList = ''
        for line in msg.splitlines():
            if line.find('CollectErrorInfo:') >= 0:
                lineSplitStr = line.split(':')
                ErrorInfoList = lineSplitStr[1]
                return (False, ErrorInfoList)
        return (True, "")

    @staticmethod
    def RefreshProcess(devObj, percentNumber, message):
        """
        @summary: 设置信息收集当前进度
        """
        if percentNumber > 100:
            percentNumber = 100
        observer = devObj.get("progressObserver")
        try:
            if observer:
                # percentNumber 相等时更新message信息
                if percentNumber >= observer.getCurrentProgress():
                    observer.updateProgress(int(percentNumber), message)
        except Exception:
            log.info(devObj, str(traceback.format_exc()))

    @staticmethod
    def GetMessageInfo(devObj, msg):
        if not msg:
            return (True, "")

        partErrInfo = ''
        for line in msg.splitlines():
            paramValue = ''
            if line.find('CollectErrorInfo:') >= 0:
                lineInfo = line.split(':')[1:]
                errInfo = lineInfo[0]
                if len(lineInfo) >= 2:
                    paramValue = lineInfo[1]
                errInfo = util.getMsg(devObj, errInfo, param=paramValue)
                partErrInfo = partErrInfo + errInfo + '\n'
            else:
                lineInfo = line.split(':')
                errInfo = lineInfo[0]
                if errInfo not in resource.MESSAGES_DICT:
                    continue

                if len(lineInfo) >= 2:
                    paramValue = lineInfo[1]
                errInfo = util.getMsg(devObj, errInfo, param=paramValue)
                devObj["py_detail"] = errInfo
                return (False, "")

        if partErrInfo.strip() == '':
            devObj["py_detail"] = msg
        else:
            # 部分收集成功
            devObj["py_detail"] = partErrInfo
            devObj["collectAllInfo"] = False
        return (True, "")

    @staticmethod
    def IsOldVersion(version):
        for item in VERSION_OLD:
            if item == version:
                return True
        return False

    @staticmethod
    def GetCollectResult(devObj):
        # 获取收集结果
        cmd = "cat %s 2>/dev/null" % COMRESULTFILE
        strRet = util.execCmdWithTimout(devObj, cmd, 20)
        return strRet

    # 非阻塞执行
    @staticmethod
    def ExecCollectAsyn(devObj, cmd):
        log.info(devObj, "exec asyn,cmd=%s" % cmd)
        strRet = util.execCmdWithTimout(devObj, cmd, 20)
        return strRet

    # 阻塞执行
    @staticmethod
    def ExecCollectSyn(devObj, cmd):
        log.info(devObj, "exec syn,cmd=%s" % cmd)
        ssh = devObj.get("SSH")
        # 3小时
        strRet = str((ssh.execCmdWithKeepAlive(cmd, 30,
                                               60 * 180)).encode("utf-8"))
        return strRet

    # 查询节点数量
    @staticmethod
    def QueryNodeNum(devObj):
        cmd = "cat %s | sed '/^[ ]*$/d' | wc -l" % COMIPFILE
        strRet = util.execCmdWithTimout(devObj, cmd, 10)
        for line in strRet.splitlines():
            if line.isdigit():
                nodenum = int(line)
                break
        else:
            nodenum = 3
        return nodenum

    # 查询主进程是否结束
    @staticmethod
    def CheckCollectProcessExists(devObj):
        cmd = "ps -ef|grep -v grep|grep datacollect |wc -l"
        strRet = util.execCmdWithTimout(devObj, cmd, 10)
        if strRet:
            for line in strRet.splitlines():
                if line.isdigit():
                    return int(line)
        return 1

    # @查询进度
    @staticmethod
    def QueryCollectProcess(devObj):
        cmd = "cat %s | grep CollectProgress: | awk -F':' '{print $2}'" \
              % COMPROGRESSFILE
        strRet = util.execCmdWithTimout(devObj, cmd, 10)
        if strRet:
            for line in strRet.splitlines():
                if line.isdigit():
                    log.info(devObj, "QueryCollectProcess:%s"
                             % str(line).encode("utf-8"))
                    return int(line)
        return 0

    @staticmethod
    def execCmdWithTimout(devObj, cmd, timeout):
        strRet = ""
        ssh = devObj.get("SSH")
        try:
            strRet = str(ssh.execCmdWithTimout(cmd, timeout).encode("utf-8"))
        except ToolException:
            # ssh断连,重新建立连接.
            util.reConnect(devObj)
            log.info(devObj, "retry exec cmd:%s" % cmd)
            strRet = str(ssh.execCmdWithTimout(cmd, timeout).encode("utf-8"))
        except Exception as err:
            log.error(devObj, "catch except:%s" % str(err).encode("utf-8"))
        return strRet

    # ssh重新连接
    @staticmethod
    def reConnect(devObj):
        ssh = devObj.get("SSH")
        ssh.reConnect()
        # 防止设备踢session
        ssh.execCmdWithTimout("TMOUT=0", 20)
        # 重新连接sftp
        sftp = devObj.get("SFTP")
        sftp.reConnect()

    # 获取远端文件大小
    @staticmethod
    def GetFileTotalSize(devObj, remoteFileName):
        fileTotalSize = 0
        cmd = "ls -l %s 2>/dev/null |awk -F' ' '{print $5}'" \
              % (remoteFileName)
        strRet = util.execCmdWithTimout(devObj, cmd, 10)

        if strRet.find("No such file or directory") >= 0:
            log.warn(devObj, strRet)
            return fileTotalSize
        for line in strRet.splitlines():
            if not line.isdigit():
                continue
            try:
                fileTotalSize = int(line)
            except Exception as err:
                log.warn(devObj, "err: %s" % str(err))
        return fileTotalSize


class log():
    """
            功能：日志记录函数的子函数，用于获取调用函数和调用行号
            参数： MAX_CALLER_LEVEL：最大调用关系层数
            返回值：调用函数信息
    """

    @staticmethod
    def getCallerInfo(MAX_CALLER_LEVEL=5, skipLastLevel=True):
        # 从堆栈中获取调用函数和行号

        # 初始化参数
        funcBack = sys._getframe().f_back
        if skipLastLevel:  # 忽略最近的调用关系
            funcBack = funcBack.f_back
            MAX_CALLER_LEVEL -= 1

        # 生成函数调用关系
        callerInfo = ""
        for index in range(0, MAX_CALLER_LEVEL):

            # 获取该级调用函数和行号
            if hasattr(funcBack, "f_code") and hasattr(funcBack, "f_lineno"):
                funcName = funcBack.f_code.co_name
                lineNumber = funcBack.f_lineno
                callerInfo = " [%s:%s]%s" \
                             % (str(funcName), str(lineNumber), callerInfo)
            else:
                break

            # 刷新Back函数
            if hasattr(funcBack, "f_back"):
                funcBack = funcBack.f_back
            else:
                break

        # 返回函数调用关系
        return callerInfo

    @staticmethod
    def debug(devObj, info):
        """
                    功能：记录调试信息info到工具日志中
                    参数：devObj = 工具上下文；info = 要记录的信息
                    返回值：True = 成功；False = 失败
        """
        logInfo = info + log.getCallerInfo()
        if "logger" in devObj:
            devObj.get("logger").debug('[ToolLog]:' + logInfo)
            return True
        else:
            raise Exception("[failed]: logger is inexisted. info=" + logInfo)

    @staticmethod
    def error(devObj, info):
        """
                    功能：记录错误信息info到工具日志中
                    参数：devObj = 工具上下文；info = 要记录的信息
                    返回值：True = 成功；False = 失败
        """
        logInfo = info + log.getCallerInfo()
        if "logger" in devObj:
            devObj.get("logger").error('[ToolLog]:' + logInfo)
            return True
        else:
            raise Exception("[failed]: logger is inexisted. info=" + logInfo)

    @staticmethod
    def info(devObj, info):
        logInfo = info + log.getCallerInfo()
        if "logger" in devObj:
            devObj.get("logger").info('[ToolLog]:' + logInfo)
            return True
        else:
            raise Exception("[failed]: logger is inexisted. info=" + logInfo)

    @staticmethod
    def warn(devObj, info):
        logInfo = info + log.getCallerInfo()
        if "logger" in devObj:
            devObj.get("logger").warn('[ToolLog]:' + logInfo)
            return True
        else:
            raise Exception("[failed]: logger is inexisted. info=" + logInfo)
