#!/usr/bin/python3
# -*- coding: utf-8 -*-
# 版权所有 (c) 华为技术有限公司 2023-2023
import sys
import os
import re
import time
import traceback
import java.lang.Exception as JException

reload(sys)
sys.setdefaultencoding('utf-8')
RETRY_TIME = 180


def execute_prepare(dev_obj):
    ssh = dev_obj.get("SSH")
    # 下载前先清理当前目录日志
    remote_log_file = "/opt/cantian/log_collect_dir"
    ret = ssh.execCmd("ls %s" % remote_log_file)
    if "No such file or directory" not in ret:
        cmd = 'rm -rf %s' % remote_log_file
        ssh.execCmd(cmd)
    # 创建远端日志收集目录
    cmd = 'mkdir -p -m 750 /opt/cantian/log_collect_dir'
    chmod_cmd = 'chown ctmgruser:cantiangroup /opt/cantian/log_collect_dir'
    ssh.execCmd(cmd)
    ssh.execCmd(chmod_cmd)
    return True, ""


def execute(dev_obj):
    log = dev_obj["logger"]
    ssh = dev_obj.get("SSH")

    if not execute_collect_cmd(ssh, log):
        return False, ""

    if not check_progress(ssh, log):
        log.error("Info collect time out.")
        return False, ""

    file_name = get_log_file_name(ssh)
    if not file_name:
        return False, ""

    dev_obj["collectRemotePath"] = "/opt/cantian/log_collect_dir/{}".format(file_name)
    dev_obj["collectRetFileName"] = file_name
    return True, ""


def execute_collect_cmd(ssh, log):
    collect_cmd = "ctctl collection logs log_dir=/opt/cantian/log_collect_dir type=recent"
    cli_ret = ssh.execCmd(collect_cmd)
    if "log collection ends" not in cli_ret and "start log collection successful" not in cli_ret:
        log.error("log collection failed, details: %s", cli_ret)
        return False
    return True


def check_progress(ssh, log):
    query_cmd = "ctctl logs progress query"
    for retry_time in range(1, RETRY_TIME + 1):
        cli_ret = ssh.execCmd(query_cmd)
        log.info("times:{}, response:{}".format(retry_time, cli_ret))
        if "'percentage': '100.00%'" in cli_ret:
            cmd = "chmod 750 /opt/cantian/log_collect_dir/cantian_log_*.tar.gz"
            ssh.execCmd(cmd)
            return True
        time.sleep(10)
    return False


def get_log_file_name(ssh):
    cmd = "ls /opt/cantian/log_collect_dir/cantian_log_*.tar.gz | awk -F '/' '{print $NF}'"
    cli_ret = ssh.execCmd(cmd)
    match = re.findall(r"cantian_log_\d+.tar.gz", cli_ret)
    return match[0] if match else None


def download(dev_obj):
    logger = dev_obj.get("logger")
    try:
        sftp = dev_obj.get("SFTP")
        localpath = os.path.join(dev_obj.get("collectRetDir"), dev_obj.get("collectRetFileName"))
        sftp.getFile(dev_obj.get("collectRemotePath"), localpath, None)
        return True, ""
    except (JException, Exception) as err:
        logger.error("An error occurred: %s", err)
        return False, ""


def clean(dev_obj):
    logger = dev_obj.get("logger")
    try:
        ssh = dev_obj.get("SSH")
        collect_remote_path = dev_obj.get("collectRemotePath")
        if not collect_remote_path:
            logger.error("Collect remote path is not exist.")
            return False, ""
        else:
            ssh.execCmd("rm -rf %s" % collect_remote_path)
            return True, ""
    except (JException, Exception) as err:
        logger.error("[deleteRemoteFile] except trace back:" + str(traceback.format_exc()))
        return False, ""