from java.io import File
import time
import os

def execute(devObj):
    tmp = devObj.get("devIp")
    remotePath = "/tmp/DataCollect_%s.zip" % tmp
    fileName = "DataCollect_%s.zip" % tmp
    try:
        sftp = devObj.get("SFTP")
        path = devObj.get("collectRetDir")
        title = str(time.strftime('%Y%m%d%H%M%S', time.localtime(time.time())))
        new_path = os.path.join(path, title)
        devObj["collectRetDir"] = new_path
        devObj["collectRetFileName"] = fileName
        if not os.path.isdir(new_path):
            os.makedirs(new_path)
        localPath = new_path + File.separator + fileName
        file = File(localPath)
        sftp.getFile(remotePath, file, None)
        return (True, "")
    except:
        return (False, "")
