#coding:utf-8

import sys 
import os
import shutil
import time
import util

# **************************************************************************** #
# 函数名称: execute
# 功能说明: 所有收集项最终打包脚本
# 输入参数: ssh
# 输出参数: 无
# **************************************************************************** # 
def execute(devObj):
    
    logger = devObj["logger"]
    lang = devObj["lang"]
    curCtrlIp = devObj.get("devIp")
    collectManagement = devObj.get("collecManagementObj")
    
    #初始化变量
    systemLogFile = ""
    smartInfoFile = ""

    #获取当前时间
    curTime = time.strftime('%Y%m%d%H%M%S',time.localtime(time.time()))
    
    #获取运行日志收集文件路径
    try:
        systemLogFile = devObj["SystemLogCollectFile"]
    except:
        systemLogFile = ""
    
    logger.info("System log collection file name:" + str(systemLogFile))
    
    #获取Smart信息收集文件路径
    try:
        smartInfoFile = devObj["SmartInfoCollectFile"]
    except:
        smartInfoFile = ""
    
    logger.info("Disk smart info collection file name:" + str(smartInfoFile))
    
    # 修改收集结果文件名 modified 20130925 Begin
    #如果其中有一个为空，则不需要继续打包
    if systemLogFile == "" or systemLogFile == None:
        smartInfoFileName = smartInfoFile.split(os.sep)[-1]
        devObj["collectRetFileName"] = smartInfoFileName
        return (True, "")
    elif smartInfoFile == "" or smartInfoFile == None:
        systemLogFileName = systemLogFile.split(os.sep)[-1]
        devObj["collectRetFileName"] = systemLogFileName
        return (True, "")
    # 修改收集结果文件名 modified 20130925 End

    #将smart信息文件打包到日志收集压缩文件中
    #解压运行日志压缩包
    sysLogDecompressDir = collectManagement.deCompressFile(systemLogFile)
    if sysLogDecompressDir == "":
        logger.error("Decompressing syslog log file Failed:" + str(systemLogFile))
        if lang == "zh":
            devObj["py_detail"] = u"解压系统日志文件失败：" + str(systemLogFile)
        else:
            devObj["py_detail"] = "Decompressing syslog log file Failed:" + str(systemLogFile)
        return (False, "")
        
    #解压Smart信息压缩包
    smarInfoDecompressDir = collectManagement.deCompressFile(smartInfoFile)
    if smarInfoDecompressDir == "":
        logger.error("Decompressing smart information file Failed:" + str(smartInfoFile))
        if lang == "zh":
            devObj["py_detail"] = u"解压smart信息收集文件失败：" + str(smartInfoFile)
        else:
            devObj["py_detail"] = "Decompressing smart information file Failed:" + str(smartInfoFile)
        return (False, "")
    
    #在日志收集压缩包解压文件夹中增加disksmartinfo子文件夹
    oldSmartDir = smarInfoDecompressDir + os.sep + "DataCollect" + os.sep + "disksmartinfo"
    newSmartDir = sysLogDecompressDir + os.sep + "DataCollect" + os.sep + "disksmartinfo"
    if not os.path.exists(newSmartDir):
        logger.info("Running log sub_dir is not exist disksmartinfo dir, need to create.")
        os.makedirs(newSmartDir)
    
    #将Smart压缩文件解压后，所有的文件copy到日志收集解压路径下
    for fileTmp in os.listdir(oldSmartDir):
        shutil.copy(oldSmartDir + os.sep + fileTmp, newSmartDir)

    #创建eServer描述文件
    util.creatPkginfo(sysLogDecompressDir, devObj)
    
    #压缩包更改名称
    newFileName = curCtrlIp + "_" + str(curTime)
    newFile = sysLogDecompressDir + os.sep + newFileName
    
    #整体压缩
    dataCollectPath = sysLogDecompressDir + os.path.sep + "DataCollect"
    pkginfoPath = sysLogDecompressDir + os.path.sep + "pkginfo"
    newFileName = collectManagement.compressFile(newFile, dataCollectPath, pkginfoPath)
    logger.info("[compressFile] compressFile: "+ newFileName)
    
    #将文件拷贝出来
    zipFile = sysLogDecompressDir + os.sep + newFileName
    shutil.copy(zipFile, devObj.get("collectRetDir"))
    
    #删除所有的过程临时文件
    try:
        shutil.rmtree(sysLogDecompressDir, True)
        shutil.rmtree(smarInfoDecompressDir, True)
        os.remove(systemLogFile)
        os.remove(smartInfoFile)
    except:
        logger.error("Delete temp files Error!")
        pass

    # 修改收集结果文件名 modified 20130925 Begin
    #设定最终打包文件名称
    devObj["collectRetFileName"] = newFileName
    # 修改收集结果文件名 modified 20130925 End

    return (True, "")

