#coding: UTF-8
import os
import traceback

# **************************************************************************** #
# 函数名称: execute
# 功能说明: 脚本入口
# 输入参数: devObj
# **************************************************************************** #
def execute(devObj):
    flag = True
    allSshInfo = ""
    iRet = download(devObj)
    flag = iRet[0]
    allSshInfo += iRet[1]
    if flag:
        deleteRemoteFile(devObj)       
    return (flag, allSshInfo)

# **************************************************************************** #
# 函数名称: download
# 功能说明: 下载信息收集文件
# 输入参数: devObj
# **************************************************************************** #
def download(devObj):
    try:
        sftp = devObj.get("SFTP")
        localPath = devObj.get("collectRetDir") + os.path.sep + devObj.get("collectRetFileName")
        sftp.getFile(devObj.get("collecRemotePath"), localPath, None)
        return (True, "")
    except:
        return (False, "")


# **************************************************************************** #
# 函数名称: deleteRemoteFile
# 功能说明: 清理设备临时文件
# 输入参数: devObj
# **************************************************************************** #
def deleteRemoteFile(devObj):
    try:
        sftp = devObj.get("SFTP")
        logger = devObj.get("logger")
        collectRemotePath = devObj.get("collecRemotePath")
        #使用sftp自带接口删除远端临时文件
        if not collectRemotePath:
            logger.error("[deleteRemoteFile] delete file is:" + str(collectRemotePath))
            return False
        else:
            sftp.deleteFile(collectRemotePath)
            return True
    except:
        logger.error("[deleteRemoteFile] except trace back:" + str(traceback.format_exc()))
        return False
