﻿#coding: UTF-8

import re
from time import sleep

#cli命令回文行数判断
G_CLI_INFO_NORMAL_ROW_MIN = 7

# **************************************************************************** #
# 函数名称: changeCli2Developer
# 功能说明: 从Cli模式进入developer模式
# 输入参数: devObj
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** # 
def changeCli2Developer(devObj):

    ssh = devObj.get("SSH")
    developerPwd = ""

    try:
        developerPwd = devObj.get("developer")
    except:
        return False
    
    #如果密码设置为空，则返回False
    if developerPwd == None or developerPwd == "":
        return False

    #Dorado在网全为安全红线后设备
    temp = ssh.execCmd("developer")
    #安全红线后设备进入developer模式
    if re.search("Are you sure", temp, re.IGNORECASE):
        
        temp1 = ssh.execCmd("y")

        if re.search("Enter Password", temp1, re.IGNORECASE):
            temp2 = ssh.execCmdNoLog(developerPwd)
            if re.search("developer:", temp2, re.IGNORECASE):
               return True
        
    #进入developer模式失败，重新回到CLI模式
    changeAnyModel2Cli(ssh)
    return False

# **************************************************************************** #
# 函数名称: changeAnyModel2Cli
# 功能说明: 从任意模式退出到cli命令模式（不适用于心跳连接到对端的情况）
# 输入参数: ssh
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** # 
def changeAnyModel2Cli(ssh):
    
    counter = 0
    while True:
        temp = ssh.execCmd("showsys")
        #非developer模式下，cli回文正确，则认为回到了cli
        if re.search("System Name", temp, re.IGNORECASE) \
            and not re.search("developer", temp, re.IGNORECASE):
                break
        #老版本在minisystem下直接exit会退出连接，需要重连
        elif re.search("minisystem>", temp, re.IGNORECASE):
            temp1 = ssh.execCmd("exit")
            if re.search("Are you sure", temp1, re.IGNORECASE):
                try:
                    ssh.execCmd("y")
                except:
                    ssh.reConnect()
                continue

        #其他情况下，直接exit
        else:
            temp1 = ssh.execCmd("exit")
            if re.search("Are you sure", temp1, re.IGNORECASE):
                ssh.execCmd("y")
        
        #单控的命令模式最多4层
        counter += 1
        if counter >= 4:
            break

# **************************************************************************** #
# 函数名称: changeDeveloper2Minisystem
# 功能说明: 从developer模式进入minisystem模式
# 输入参数: devObj
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** # 
def changeDeveloper2Minisystem(devObj):
    
    ssh = devObj.get("SSH")
    #进入minisystem
    temp = ssh.execCmd("minisystem")
    if re.search("Are you sure", temp, re.IGNORECASE):
        temp1 = ssh.execCmd("y")

        if re.search("minisystem>", temp1, re.IGNORECASE):
            return True

    return False
