﻿#coding: UTF-8

from java.io import File
import traceback

strCmd = "datacollect"

def execute(devObj):
    try:
        logger = devObj.get("logger")
        lang = devObj.get("lang")
        sftp = devObj.get("SFTP")
        ssh = devObj.get("SSH")
        #执行收集前，先删除阵列旧日志：/OSM/export_import/Datacollect_*.tgz
        remoteLogFile = "/OSM/export_import/Datacollect_*.tgz"
        try:
            #获取即将被删除的文件列表,并删除
            willRmFiles = sftp.listFiles(remoteLogFile)
            sftp.deleteFile(remoteLogFile)
            logger.info("success to delete %s" % ", ".join(willRmFiles))
        #删除异常不影响正常流程，仅记录日志 
        except:
            logger.error("Failed to delete /OSM/export_import/Datacollect_*.tgz. except trace back:" + unicode(traceback.format_exc()))
        
        #开始收集
        strRet = str(ssh.execCmd(strCmd))
        '''P11G-5608 增加日志收集执行返回信息  20130114 added Begin'''
        devObj["py_detail"]=strRet
        '''P11G-5608 增加日志收集执行返回信息  20130114 added End'''

        if strRet == None or strRet.find("No such file or directory") != -1: 
            return (False, "")
        
        #如果为系统忙，则需要有提示信息
        if strRet.find("The system is busy") != -1:
            promptMsg = {
                         "zh":u"未成功收集日志，请等待5分钟后重试。如果重试仍然收集失败，请联系技术支持工程师协助处理。命令执行详情：\n",
                         "en":"Logs are not successfully collected. Please wait for five minutes and try again. If log collection still fails, contact technical support engineers. Command output:\n",
                         }
            devObj["py_detail"] =  promptMsg.get(lang) + devObj["py_detail"]
            return (False, "")
        #部分收集成功
        if strRet.find("Part of") != -1:
            devObj["collectAllInfo"] = False

        retPath = getPath(strRet)
        if retPath == None :
            return  (False,"")
        devObj["collecRemotePath"]=retPath
        
        fileName = getFileName(retPath)
        if fileName == None :
            return  (False,"")
        devObj["collectRetFileName"]=fileName
        
        return (True,"")
    except:
        '''P11G-5608 增加日志收集执行返回信息  20130114 added Begin'''
        devObj["py_detail"]='Python script execute Error'
        '''P11G-5608 增加日志收集执行返回信息  20130114 added End'''
        return (False,"")
    
def getPath(strRet):
    strs = strRet.splitlines()
    
    for str in strs:
        if str.find("Path :") != -1:
            str = str.replace("Path :", "")[str.find("Path :"):]
            return str
        
    return

def getFileName(filePath):
    ret = filePath.split("/")
    if len(ret) > 0 :
        return ret[len(ret)-1]
    
    return