﻿#coding: UTF-8

import re
from time import sleep
import modelManager
import os
import secureCollect
import time
import zipfile
import codecs
import stat
import shutil
import util

#获取信息分隔符
G_INFORMATION_SPLIT_STR = "\n********************\n"

#系统支持的硬盘最小个数
G_SYS_DISK_NUMBER_MIN   = 2 

#cli命令回文行数判断
G_CLI_INFO_NORMAL_ROW_MIN = 7

# *************************************************************#
# 函数名称: commonFileWrite
# 功能说明: 文件写入操作（通用函数）
# 其 他   :  无
# *************************************************************#  
def commonFileWrite(fileName, writeInfoStr, ifAddFlag, logger):

    flag = True
    try:
        #判断是否为追加内容
        if True == ifAddFlag:
            localFile = codecs.open(fileName, "a", "utf-8")
        else:
            localFile = codecs.open(fileName, "w", "utf-8")
            
        localFile.write(writeInfoStr)
        localFile.close()
    except Exception,e:
        logger.error("Writing to file error:" + str(e))
        flag = False
    
    return flag

# **************************************************************************** #
# 函数名称: checkWhetherSysNormal
# 功能说明: 查看系统状态是否正常
# 输入参数: systemInfo
# 输出参数: 无
# **************************************************************************** # 
#showsys
#==============================================================================
#                              System Information
#------------------------------------------------------------------------------
#  System Name           | SXXXBBB
#  Device Type           | OceanStor S3900-M200
#  Current System Mode   | Double Controllers Normal
#  Mirroring Link Status | Link Up
#  Location              | CHENGDU
#  Time                  | 2013-06-13 20:08:58
#  Device Serial Number  | 210235G6EBZ0C1000007
#  Product Version       | V100R005C02
#  iSCSI Device Name     | iqn.yyyy-mm.域名倒序:主机名
#==============================================================================
def checkWhetherSysNormal(systemInfo):
    
    flag = False
    
    lineList = systemInfo.splitlines()
    if len(lineList) < G_CLI_INFO_NORMAL_ROW_MIN:
        return False
    
    if re.search("System Information", systemInfo, re.IGNORECASE):
        return True
    else:
        return False

# 收集失败打印硬盘位置信息  modified 20131008 Begin
# **************************************************************************** #
# 函数名称: getDiskCounterAndList
# 功能说明: 通过硬盘物理信息计算硬盘个数和Location的列表
# 输入参数: diskPhysicInfo
# 输出参数: 无
# **************************************************************************** # 
def getDiskCounterAndList(diskPhysicInfo):
    
    location = ""
    diskCounter = 0
    diskLocationList = []
    
    lineList = diskPhysicInfo.splitlines()
    if len(lineList) < G_CLI_INFO_NORMAL_ROW_MIN:
        return (diskCounter, diskLocationList)
    
    for line in lineList[6:]:
        
        field = line.split()
        if len(field) < 4:
            continue
        elif line.find("(") >= 0:
            location = field[0]
            diskLocationList.append(location)
            diskCounter += 1
        else:
            continue
        
    return (diskCounter, diskLocationList)
# 收集失败打印硬盘位置信息  modified 20131008 End

# **************************************************************************** #
# 函数名称: execute
# 功能说明: 脚本执行入口
# 输入参数: ssh
# 输出参数: 无
# **************************************************************************** # 
def execute(devObj):

    filePath = ""
    ssh = devObj.get("SSH")
    lang = devObj.get("lang")
    logger = devObj.get("logger")
    userName = devObj.get("username")

    flag = True
    errMsg = ""

    #查看系统状态是否正常(设置5秒超时：系统未正常开工时CLI命令也能快速返回)
    sysInfoStr = ssh.execCmdWithTimout("showsys", 5)
    checkFlag = checkWhetherSysNormal(sysInfoStr)
    if not checkFlag:
        flag = False
        if lang == "zh":
            devObj["py_detail"] = u"系统状态不正常，不能收集Smart信息。"
        else:
            devObj["py_detail"] = "The status of system is abnormal, and collecting smart information failed." 
        #设置返回信息
        return (flag, "")   

    #限定必须为admin用户才能收集smart信息
    if userName != "admin":
        flag = False
        logger.error("[Smart Info] the login username is:" + userName + ", not admin!")
        #设置错误信息
        if lang == "zh":
            devObj["py_detail"] = u"当前用户权限过低，不能够收集硬盘Smart信息。请使用admin用户收集。"
        else:
            devObj["py_detail"] = "The user logged in with is low-privileged and can not support to collect disk's smart information. " \
                    + "Please login with admin, then collect the disk's smart information."
        
        return (flag, "")           

    logger.info("[Smart Info] Collecting smart information Start!")
   
    #先关闭cli的分页功能
    ssh.execCmd("chgpagination off")

    curTime = time.strftime('%Y%m%d%H%M%S',time.localtime(time.time()))

    #增加文件夹权限
    os.chmod(devObj.get("collectRetDir"), stat.S_IWRITE)
    
    #创建子文件夹并保存信息
    curCtrlIp = devObj.get("devIp")
    fileBaseDir = devObj.get("collectRetDir") + os.sep + curCtrlIp + "_" + str(curTime)
    
    subFileDir = fileBaseDir + os.sep + "DataCollect" + os.sep + "disksmartinfo"

    if not os.path.exists(subFileDir):
        os.makedirs(subFileDir)
    devObj['SmartInfoDir'] = subFileDir     
    
    #保存系统基本信息
    basicInfoStr = ""
    basicInfoStr += sysInfoStr + G_INFORMATION_SPLIT_STR
    basicInfoStr += ssh.execCmd("showrg") + G_INFORMATION_SPLIT_STR
    diskPhysicInfo = ssh.execCmd("showdisk -physic")
    basicInfoStr += diskPhysicInfo + G_INFORMATION_SPLIT_STR
    
    sysBasicInfoFile = subFileDir + os.sep + "basicinfo.txt"
    flag = commonFileWrite(sysBasicInfoFile, basicInfoStr, False, logger)
    if not flag:
        flag = False
        if lang == "zh":
            devObj["py_detail"] = u"创建basicinfo.txt文件失败。"
        else:
            devObj["py_detail"] = "Creating basicinfo.txt file failed." 
        #删除总收集文件夹
        try:
            shutil.rmtree(fileBaseDir, True)
        except:
            pass
        #设置返回信息
        return (flag, "")
    
    # 收集失败打印硬盘位置信息  modified 20131008 Begin
    #通过硬盘物理信息计算硬盘数
    diskCounter = 0
    diskLocationList = []
    iRet = getDiskCounterAndList(diskPhysicInfo)
    diskCounter = iRet[0]
    diskLocationList = iRet[1]
    #保存供后续使用
    devObj["diskLocationList"] = diskLocationList
    # 收集失败打印硬盘位置信息  modified 20131008 End
    
    if diskCounter < G_SYS_DISK_NUMBER_MIN:
        logger.error("[Smart Info] get disk number by disk physic information:" + str(diskCounter))
        
        flag = False
        if lang == "zh":
            devObj["py_detail"] = u"通过硬盘物理信息获取硬盘个数失败。"
        else:
            devObj["py_detail"] = "Getting disk number by disk physic information failed." 
        #删除总收集文件夹
        try:
            shutil.rmtree(fileBaseDir, True)
        except:
            pass
        #设置返回信息
        return (flag, "")   
    
    #记录硬盘总个数
    devObj["TotalDiskNumber"] = diskCounter
    logger.info("[Smart Info] get disk number by disk physic information:" + str(diskCounter))

    logger.info("[Smart Info] Create system basic information file Succeed!")

    #Dorado在网全为安全红线后设备
    iRet = secureCollect.execute(devObj)
    
    #返回信息统一处理
    flag = iRet[0]
    errMsg = iRet[1]
    if False == flag:
        logger.error("[Smart Info] Collecting smart information Failed!")
        #设置返回信息
        devObj["py_detail"] = errMsg
        #删除总收集文件夹
        try:
            shutil.rmtree(fileBaseDir, True)
        except:
            pass
        return (flag, "")
    
    #创建eServer描述文件
    util.creatPkginfo(fileBaseDir, devObj)
    
    #压缩包更改名称,'.7z'框架添加
    newFileName = curCtrlIp + "_" + str(curTime)
    newFile = fileBaseDir + os.sep + newFileName
    
    #最终将日志收集和smart信息、pkginfo整体压缩
    collectManagement = devObj.get("collecManagementObj")
    dataCollectPath = fileBaseDir + os.sep + "DataCollect"
    pkginfoPath = fileBaseDir + os.sep + "pkginfo"
    newFileName = collectManagement.compressFile(newFile, dataCollectPath, pkginfoPath)
    logger.info("[compressFile] compressFile: "+ newFileName)
    if newFileName == "":
        logger.error("[Smart Info] Compress smart information directory Failed!")
        
        flag = False
        if lang == "zh":
            devObj["py_detail"] = u"压缩Smart信息收集文件夹失败。"
        else:
            devObj["py_detail"] = "Compressing smart information directory failed." 
        #删除总收集文件夹
        try:
            shutil.rmtree(fileBaseDir, True)
        except:
            pass
        #设置返回信息
        return (flag, "")

    #移动压缩文件
    newFile = fileBaseDir + os.sep + newFileName
    shutil.copy(newFile, devObj.get("collectRetDir"))
    
    #删除过程文件(不影响最终结果)
    try:
        shutil.rmtree(fileBaseDir, True)
        logger.info("[Smart Info] delete temp files Succeed!")
    except:
        logger.error("[Smart Info] delete temp files Failed!")

    #保存硬盘Smart信息收集文件路径
    SmartInfoFileName = devObj.get("collectRetDir") + os.sep + newFileName
    devObj["SmartInfoCollectFile"] = SmartInfoFileName
    logger.info("[Smart Info] smart info collection file name:" + str(SmartInfoFileName))
    
    #返回信息统一处理
    logger.info("[Smart Info] Collecting smart information End!")
    
    return (True, "")
