# -*- coding: UTF-8 -*-
import os
import stat
import shutil
import traceback
import time

OS_OPEN_FLAGS = os.O_WRONLY | os.O_CREAT | os.O_TRUNC  # 写 | 创建并打开 | 截断
OS_OPEN_MODES = stat.S_IWUSR | stat.S_IRUSR  # 拥有者具有读写权限


def creatPkginfo(rootPath, devObj):
    '''
    @summary: 创建与datacollect同级的目录pkginfo，用于表示该包是信息收集的包。
        pkginfo下有两个空文件
            type_collect: 信息收集的包
            domain_storage: 存储设备
    '''
    logger = devObj["logger"]
    pkginfoPath = rootPath + os.path.sep + "pkginfo"
    typeFile = pkginfoPath + os.path.sep + "type_collect"
    domainFile = pkginfoPath + os.path.sep + "domain_storage"
    descFile = pkginfoPath + os.path.sep + "desc"
    try:
        #如果pkginfo已存在，则需要先删除
        if os.path.exists(pkginfoPath):
            shutil.rmtree(pkginfoPath, True)
            
        os.mkdir(pkginfoPath)
        #先创建type文件，然后拷贝type并重命名为domain文件
        fileObj = os.fdopen(os.open(typeFile, OS_OPEN_FLAGS, OS_OPEN_MODES), 'w')
        fileObj.close()
        shutil.copy(typeFile, domainFile)
        
        #获取设备SN，当前时间
        snStr = "deviceSN=${%s}\n"
        deviceSn = getDeviceSn(devObj)
        snStr = snStr % deviceSn
        dateStr = "fileCreateTime=%d"
        curtime = int(time.time() * 1000)
        dateStr = dateStr % curtime
        
        #创建desc文件，写入SN，时间
        fileObj = os.fdopen(os.open(descFile, OS_OPEN_FLAGS, OS_OPEN_MODES), 'w')
        fileObj.write(snStr)
        fileObj.write(dateStr)
        fileObj.close()
        
        logger.info("[creatPkginfo] Creat the pkginfo succeed!")
         
    except:
        if os.path.exists(pkginfoPath):
            shutil.rmtree(pkginfoPath, True)   
        logger.error("[creatPkginfo] Creat the pkginfo failed! except trace back: " + str(traceback.format_exc()))
    
    
def getDeviceSn(devObj):
    '''
            获取设备SN号
    '''
    devNode = devObj.get("devNode")   
    if None == devNode:
        return ""
        
    sn = devNode.getDeviceSerialNumber() 
    return sn          
        