#coding: UTF-8
import os
import subprocess
import sys
import time
import stat
from java.io import File

OS_OPEN_FLAGS = os.O_WRONLY | os.O_CREAT | os.O_TRUNC  # 写 | 创建并打开 | 截断
OS_OPEN_MODES = stat.S_IWUSR | stat.S_IRUSR  # 拥有者具有读写权限
remotePath = "/var/log/cm/DataCollect_FusionStorageSFS.zip"
fileName = "DataCollect_FusionStorageSFS.zip"

def execute(devObj):
    try:
        ssh = devObj.get("SSH")
        inputdict = devObj.get("SettingInfo")
        
        if inputdict:
            startTime = inputdict.get("startTime")
            endTime = inputdict.get("endTime")
            nodeid = inputdict.get("nodeid")
            modeList = inputdict.get("modeList")
            len = modeList.getSize()
        else:
            startTime = ""
            endTime = ""
            nodeid = ""
            modeList = ''
            len = 0
             
        mod = ""
        for i in range(0, len):
            mod += modeList.getElementAt(i) + ","
        if startTime == "" :
            startTime = "null"

        if endTime == "" :
            endTime = "null"

        if nodeid == "" :
            nodeid = "null"
        
        if mod == "" :
            mod = "DeviceManager_ToolKit,OceanStorOS,OM,MON_BJM,DFS_OBS,RPCUser,Hardware,OS,WorkLoad,DiskInfo"

        ssh.execCmdWithTimout("rm -f /tmp/orderListTemp.ini",60 * 30)   
            
        cmd = 'sudo /opt/huawei/snas/bin/OceanStorSFS_datacollect.sh "%s" "%s" %s %s'%(startTime, endTime, nodeid, mod)

        tempPath = os.path.dirname(__file__)
        tempFile = "orderListTemp.ini"
        filePath = str(tempPath) + "\\" + str(tempFile)
        desPath = "/tmp"
        
        fileHandle = os.fdopen(os.open(os.path.realpath(filePath), OS_OPEN_FLAGS, OS_OPEN_MODES), 'w')
        fileHandle.write("[startTime]=" + str(startTime) + "\n")
        fileHandle.write("[endTime]=" + str(endTime) + "\n")
        fileHandle.write("[nodeID]=" + str(nodeid) + "\n")
        fileHandle.write("[mode]=" + str(mod))
        fileHandle.close()
        
        sftp = devObj.get("SFTP")
        sftp.putFile(File(os.path.dirname(__file__) + r"\\orderListTemp.ini"), desPath , None)
                     
        strRet = str(ssh.execCmdWithKeepAlive(cmd,30,60 * 120)) #工具30秒发一次心跳，收集超时时间2小时
        devObj["py_detail"] = strRet

        devObj["collectRemoteFileName"]=fileName
        devObj["collecRemotePath"]=remotePath
        return (True,"")
    except:
        devObj["py_detail"]='Python script execute Error.'
        return (False,"")
