# -*- coding: UTF-8 -*-
from java.io import File
import os
import resource
import sys
                   
'''
信息收集，基本的工具方法
'''
class util():
    @staticmethod
    def getMsg(devObj, msg, args = ""):
        '''
        @summary: 获取资源信息
        @param cliRet: devObj = 上下文对象, msg = 资源脚本（resource.py）中对应的Key，args = 占位符对应的值
        @return: msg
        '''
        if  None == msg or "" == msg:
            return ""
        lang = devObj.get("lang")
        if resource.MESSAGES_DICT.has_key(msg):
            msgDict = resource.MESSAGES_DICT.get(msg)
            msg = msgDict[lang]
        #若占位符的值不为”“，则填充高占位符
        if "" != args:
            msg = msg % args
            
        return msg
		
    @staticmethod
    def initPyDetailMsg(devObj):
        '''
        @summary: 清除之前设置的错误信息
        @return: 无
        '''
        devObj["py_detail"] = ""
        
    @staticmethod
    def setPyDetailMsg(devObj, msg, args = ""):
        '''
        @summary: 消息国际化
        @param lang: 语言lang
        @param msg: 消息
        @param args: 消息参数
        @return: 经过国际化处理后的消息
        '''
        msg = util.getMsg(devObj, msg, args)
        
        devObj["py_detail"] = msg
