# -*- coding: UTF-8 -*-
import os
import shutil
import traceback
import re
from cbb.frame.util import file_operate_util
from util import log, util

Time = ""
FixedInfo = "smart analyzelog device ip : %s\n********************\nshow system general\r\n\r\nSystem Name         : %s\r\nSN                  : %s\r\nProduct Model       : %s\r\nProduct Version     : %s\r\nTime                : %s\r\nadmin:/>\n********************\nshow disk general |filterColumn include columnList=ID,Serial\sNumber,Type,Manufacturer\r\n\r\n%sadmin:/>\n********************\n"
split_mark = "#######################splitline##########################"
is_parse_rst = False


def smartSum(devObj):
    try:
        #最终文件存放的目录
        finalDirPath = devObj.get("resultPath")
        #创建最终文件存放目录
        if not os.path.exists(finalDirPath):
            os.makedirs(finalDirPath)
        #获取源压缩文件路径
        sourceFilePath = devObj.get("smartSourceFiles")
        #创建临时目录
        tempPath = file_operate_util.get_safe_path(os.path.join(finalDirPath, "temp"))
        if os.path.exists(tempPath):
            shutil.rmtree(tempPath, True)
        os.makedirs(tempPath)
        
        # 解压压缩包
        log.info(devObj, "Begin to Compressed packages %s."%sourceFilePath)
        isSucc = decompressCurPkg(devObj, sourceFilePath, tempPath)
        if not isSucc:
            log.info(devObj, "Compressed packages %s failed"%sourceFilePath)
            return (False, util.getMsg(devObj, "smart.file.sum.compressed.packages.failed", sourceFilePath))
        
        #获取basicinfo_<node_ip>.txt、smart_<node_ip>.txt、summary_<node_ip>.ini文件列表
        log.info(devObj, "Begin to Get Basicinfo_<node_ip>.txt, smart_<node_ip>.txt, Summary_<node_ip>.ini file.")
        (isSucc, basicinfoFileList, smartFileList, summaryFileList) = getSmartFileList(devObj, tempPath)
        if not isSucc or basicinfoFileList == [] or summaryFileList == []:
            log.info(devObj, "Get Basicinfo_<node_ip>.txt, smart_<node_ip>.txt, Summary_<node_ip>.ini file failed,\
            basicinfoFileList:%s smartFileList:%s summaryFileList:%s"%(basicinfoFileList, smartFileList, summaryFileList))
            return (False, util.getMsg(devObj, "smart.file.sum.get.file.failed"))
        
        #解析summaryFileList，合并信息
        log.info(devObj, "Begin to parse Summaryfilelist, Merge summary information.")
        isSucc = creatAndSumSummary(devObj, finalDirPath, summaryFileList)
        if not isSucc:
            log.info(devObj, "Parse Summaryfilelist, Merge summary information failed.")
            return (False, util.getMsg(devObj, "smart.file.sum.creat.summary.failed"))
        
        #解析basicinfoFileList，写入文件头，并拼接文件内信息
        log.info(devObj, "Begin to parse the basicinfoFileList, write to the file header, and stitch the information within the file.")
        isSucc = creatAndSumBasicinfo(devObj, finalDirPath, basicinfoFileList)
        if not isSucc:
            log.info(devObj, "Parse the basicinfoFileList, write to the file header, and stitch the information within the file failed.")
            return (False, util.getMsg(devObj, "smart.file.sum.creat.basicinfo.failed"))
        
        #将smartFileList放入指定目录
        log.info(devObj, "Begin to put smartfile in the specified directory.")
        isSucc = copySmartFile(devObj, finalDirPath, smartFileList)
        if not isSucc:
            log.info(devObj, "Put smartfile in the specified directory failed.")
            return (False, util.getMsg(devObj, "smart.file.sum.copy.smart.failed", finalDirPath))
        
        #合并smart信息完成
        log.info(devObj, "smartSum Success.")
        return (True, "")
    except:
        log.info(devObj, "smartSum failed because %s"%str(traceback.format_exc()))
        return (False, util.getMsg(devObj, "smart.file.sum.exception"))
    finally:
        try:
            shutil.rmtree(tempPath, True)
        except:
            log.info(devObj, "Remove temp dir failed because %s"%str(traceback.format_exc()))


def smart_sum_for_inspect(dev_obj):
    try:
        global is_parse_rst
        is_parse_rst = True
        # 最终文件存放的目录
        final_dir_path = dev_obj.get("resultPath")
        # 创建最终文件存放目录
        if not os.path.exists(final_dir_path):
            os.makedirs(final_dir_path)
        # 获取源压缩文件路径
        source_file_path = dev_obj.get("smartSourceFiles")
        # 获取basicinfo_<node_ip>.txt、smart_<node_ip>.txt、summary_<node_ip>.ini文件列表
        log.info(dev_obj, "Begin to Get Basicinfo_<node_ip>.txt, smart_<node_ip>.txt, Summary_<node_ip>.ini file.")
        is_success, rst_file_list = \
            get_smart_file_list_for_inspect(dev_obj, source_file_path)

        # 解析summaryFileList，合并信息
        log.info(dev_obj, "Begin to parse Summaryfilelist,"
                          " Merge summary information.")
        is_sum_success = creatAndSumSummary(dev_obj,
                                            final_dir_path, rst_file_list)
        if not is_sum_success:
            log.info(dev_obj, "Parse Summaryfilelist, "
                              "Merge summary information failed.")
            return (False, util.getMsg(dev_obj,
                                       "smart.file.sum.creat.summary.failed"))

        # 解析basicinfoFileList，写入文件头，并拼接文件内信息
        log.info(dev_obj, "Begin to parse the basicinfoFileList, "
                          "write to the file header, "
                          "and stitch the information within the file.")
        is_basic_success = creatAndSumBasicinfo(dev_obj,
                                          final_dir_path, rst_file_list)
        if not is_basic_success:
            log.info(dev_obj,
                     "Parse the basicinfoFileList, write to the file header, "
                     "and stitch the information within the file failed.")
            return (False, util.getMsg(
                dev_obj, "smart.file.sum.creat.basicinfo.failed"))

        # 将smartFileList放入指定目录
        log.info(dev_obj, "Begin to put smartfile in the specified directory.")
        is_smart_success = copy_smart_file_for_inspect(dev_obj,
                                                 final_dir_path, rst_file_list)
        if not is_smart_success:
            log.info(dev_obj,
                     "Put smartfile in the specified directory failed.")
            return (False, util.getMsg(dev_obj,
                    "smart.file.sum.copy.smart.failed", final_dir_path))

        # 合并smart信息完成
        log.info(dev_obj, "smartSum Success.")
        return (True, "")
    except:
        log.info(dev_obj, "smartSum failed because {}"
                 .format(str(traceback.format_exc())))
        return (False, util.getMsg(dev_obj, "smart.file.sum.exception"))


def creatAndSumSummary(devObj, finalDirPath, summaryFileList):
    '''
    Time变量用于creatAndSumBasicinfo方法中拼接show system general命令中Time的value值，
         因此该方法要在creatAndSumBasicinfo之前执行。
    '''
    global Time
    try:
        total = 0
        success = 0
        date = ""
        #解析文件内容将total、success字段值求和，date值去最早时间
        for summaryFile in summaryFileList:
            is_success, summary = read_file(devObj, summaryFile, 2)
            if not is_success:
                log.info(devObj, "Read file %s failed."%summaryFile)
                return False
            # 第一个单词total长度为5，即使是空文件也有一个换行符，因此采用长度小于5来判断是否有信息
            if len(str(summary)) < 5:
                continue
            summaryLines = summary.encode("utf8").splitlines()
            for summaryLine in summaryLines:
                summaryLineList = summaryLine.split("=")
                if summaryLineList[0].strip() == "total":
                    total += int(summaryLineList[1].strip())
                if summaryLineList[0].strip() == "success":
                    success += int(summaryLineList[1].strip())
                if summaryLineList[0].strip() == "date":
                    if not date or summaryLineList[1] < date:
                        date = str(summaryLineList[1]).strip()
        #拼接要写入的内容
        sumSummary = "total=%s\nsuccess=%s\ndate=%s\n"%(total, success, date)
        Time = date
        filePath = finalDirPath + "\\" + "summary.ini"
        is_success = util.writeFile(devObj, filePath, sumSummary, False)
        if not is_success:
            log.info(devObj, "Write file %s failed."%filePath)
            return False
        return True
    except:
        log.info(devObj, "Parse Summaryfilelist, Merge summary information failed because %s"%str(traceback.format_exc()))
        return False

def copySmartFile(devObj, finalDirPath, smartFileList):
    smartFile = ""
    try:
        for smartFile in smartFileList:
            temp_path = file_operate_util.get_safe_path(os.path.join(finalDirPath, smartFile.split("\\")[-1]))
            if os.path.exists(temp_path):
                os.remove(temp_path)
            shutil.copy(smartFile, finalDirPath)
        return True
    except:
        log.info(devObj, "Put %s in the specified directory failed because %s"%(smartFile, str(traceback.format_exc())))
        return False
        

def creatAndSumBasicinfo(devObj, finalDirPath, basicinfoFileList):
    # 如果选择的节点不包含存储节点则直接返回成功，并且生成一个空的basicInfo文件
    if devObj.get("isAllSelectedWithoutStorageNodes"):
        log.info(devObj, "All selected nodes do not contain storage nodes!")
        sumBasicinfo = ""
        return generate_basic_info_file_in_target_path(devObj, finalDirPath, sumBasicinfo)
    '''
    Time变量用于拼接show system general命令中Time的value值，由creatAndSumSummary方法进行赋值，
          因此该方法要在creatAndSumSummary之后执行。
    '''
    global Time 
    #获取设备相关信息用于拼接basicinfoFile
    devNode = devObj.get("devNode")
    smartAnalyzelogDeviceIp = str(devNode.getIp())
    systemName = devNode.getDeviceName()
    SN = str(devNode.getDeviceSerialNumber())
    productModel = str(devNode.getProductModel())
    productVersion = str(devNode.getProductVersion())
    try:
        #解析basicinfo文件，获取basicinfo信息和表头
        basicinfoList = []
        tableHeadersList = []
        for basicinfoFile in basicinfoFileList:
            is_success, basicinfo = read_file(devObj, basicinfoFile, 0)
            if not is_success:
                log.info(devObj, "Read file %s info failed."%basicinfoFile)
                return False
            # 表头长度为81个字符，即使是空文件也有一个换行符，因此采用长度小于10来判断是否有信息
            if len(str(basicinfo)) < 10:
                continue
            basicinfo, tableHeaders = util.getHorizontalAddKeysCliRet(basicinfo)
            basicinfoList.extend(basicinfo)
            tableHeadersList.append(tuple(tableHeaders))
        #判断各文件中表头是否一致如果不一致则报错
        if len(set(tableHeadersList)) != 1:
            log.info(devObj, "Failed to get Basicinfo file header because the table header is \
            inconsistent between files or the header is not found.\n basicinfo：%s\n allBasicinfoTHList：%s"\
            %(basicinfoList, tableHeadersList))
            return False
        tableHeaders = tableHeadersList[0]
        #获取表头长度，以表头和value的最大长度稳准
        tableHeaderLength = {}
        for basic in basicinfoList:
            for tableHeader in tableHeaders:
                if tableHeaderLength.has_key(tableHeader):
                    if len(basic.get(tableHeader)) > tableHeaderLength.get(tableHeader):
                        tableHeaderLength[tableHeader] = len(basic.get(tableHeader))
                else:
                    tableHeaderLength[tableHeader] = len(basic.get(tableHeader))
        #数据与表头长度进行比较,如果表头长度大于数据长度，以表头长度为准
        for tableHeader in tableHeaders:
            if len(tableHeader) > tableHeaderLength.get(tableHeader):
                tableHeaderLength[tableHeader] = len(tableHeader)
        sumdiskinfo = ""
        #写入表头
        for tableHeader in tableHeaders:
            spaceNum = tableHeaderLength.get(tableHeader) - len(tableHeader) + 2
            sumdiskinfo += tableHeader + spaceNum*" "
        sumdiskinfo += "\r\n"
        #写入分割符
        for tableHeader in tableHeaders:
            spaceNum = 2
            sumdiskinfo += tableHeaderLength.get(tableHeader)*"-" + spaceNum*" "
        sumdiskinfo += "\r\n"
        #写入basicinfo信息
        for basicinfo in basicinfoList:
            for tableHeader in tableHeaders:
                spaceNum = tableHeaderLength.get(tableHeader) - len(basicinfo.get(tableHeader)) + 2
                sumdiskinfo +=  basicinfo.get(tableHeader) + spaceNum*" "
            sumdiskinfo += "\r\n"
        #拼接写入文件的内容
        sumBasicinfo = FixedInfo%(smartAnalyzelogDeviceIp, systemName, SN, productModel, productVersion, Time, sumdiskinfo)
        return generate_basic_info_file_in_target_path(devObj, finalDirPath, sumBasicinfo)
    except:
        log.info(devObj, "Parse the basicinfoFileList, write to the file header, and stitch the information within the file failed because %s"%str(traceback.format_exc()))
        return False


def generate_basic_info_file_in_target_path(object, final_directory_path, summary_basic_info):
    filePath = final_directory_path + "\\" + "basicinfo.txt"
    isSucc = util.writeFile(object, filePath, summary_basic_info, False)
    if not isSucc:
        log.info(object, "Write file % failed." % filePath)
        return False
    return True


def getSmartFileList(devObj, filePath):
    try:
        basicinfoList = []
        smartList = []
        summaryList = []
        isSucc, basicinfoList = getSpecFileFromDir(devObj, filePath, "basicinfo_.*.txt")
        if not isSucc:
            log.info(devObj, "Get basicinfo File failed.")
            return False, basicinfoList, smartList, summaryList
        isSucc, smartList = getSpecFileFromDir(devObj, filePath, "smart_.*.txt")
        if not isSucc:
            log.info(devObj, "Get smart File failed.")
            return False, basicinfoList, smartList, summaryList
        isSucc, summaryList = getSpecFileFromDir(devObj, filePath, "summary_.*.ini")
        if not isSucc:
            log.info(devObj, "Get summary File failed.")
            return False, basicinfoList, smartList, summaryList
        return True, basicinfoList, smartList, summaryList
    except:
        log.info(devObj, "Get Basicinfo_<node_ip>.txt, smart_<node_ip>.txt, Summary_<node_ip>.ini file failed because %s"%str(traceback.format_exc()))
        return False, basicinfoList, smartList, summaryList

def getSpecFileFromDir(devObj, filePath, fileName):
    '''
          获取路径filePath下所有命名为fileName（支持正则）的文件，返回文件路径列表
    '''
    try:
        fileNameList = []
        for (root, _, files) in os.walk(filePath):
            for file in files:
                if re.match(fileName, file, re.IGNORECASE):
                    fileNameList.append(os.path.join(root, file))
        return True, fileNameList
    except:
        log.info(devObj, "Get %s file failed because %s"%(fileName, str(traceback.format_exc())))
        return False, fileNameList


def decompressCurPkg(devObj, source_file_path, destination_path):
    '''
    解压sourceFilePath目录下，所以的文件，当前需要解压五次，zip，gz，tar，gz，tar
    :param devObj: 上下文
    :param source_file_path: 需要解压的原始文件
    :param destination_path: 解压的目的文件
    :return: 解压是否成功
    '''
    try:
        tar_class = devObj.get("fileAssistant")
        needUnzipped = devObj.get("needUnzipped")
        zip_to_gz_dir = source_file_path
        if needUnzipped:
            zip_to_gz_dir = os.path.join(destination_path, "temp1")
            tar_class.batchDeCompressByFilter(zip_to_gz_dir, source_file_path,
                                              "*.zip")

        gz_to_tar_dir = os.path.join(destination_path, "temp2")
        tar_class.batchDeCompressByFilter(gz_to_tar_dir, zip_to_gz_dir,
                                          "*.gz")

        if needUnzipped:
            shutil.rmtree(zip_to_gz_dir, True)
        tar_to_gz_dir = os.path.join(destination_path, "temp3")
        tar_class.batchDeCompressByFilter(tar_to_gz_dir, gz_to_tar_dir,
                                          "*.tar*")
        shutil.rmtree(gz_to_tar_dir, True)
        gz_to_tar_second_dir = os.path.join(destination_path, "temp4")
        tar_class.batchDeCompressByFilter(gz_to_tar_second_dir, tar_to_gz_dir,
                                          "*.gz")
        shutil.rmtree(tar_to_gz_dir, True)
        tar_to_txt_dir = os.path.join(destination_path, "temp5")
        tar_class.batchDeCompressByFilter(tar_to_txt_dir, gz_to_tar_second_dir,
                                          "*.tar*", "x")
        shutil.rmtree(gz_to_tar_second_dir, True)

        # 部分版本Linux主机压缩的tar.gz文件在window中解压会多出PaxHeaders.XX的文件夹
        # 删除此类文件夹
        file_dir_list = os.listdir(tar_to_txt_dir)
        for file_dir_name in file_dir_list:
            if "PaxHeaders" in file_dir_name:
                shutil.rmtree(os.path.join(tar_to_txt_dir, file_dir_name),
                              True)
        return True
    except:
        log.info(devObj, "Compressed packages failed because %s"%str(traceback.format_exc()))
        return False


def get_smart_file_list_for_inspect(dev_obj, file_path):
    """
    通过巡检获取的smart信息，basicinfo、smart和summary都在同一个文件中
    :param dev_obj: 收集设备
    :param file_path: 原始文件
    :return: 分类结果，basicinfo列表，smart列表，summary列表
    """
    is_success, rst_file_list = getSpecFileFromDir(dev_obj,
                                                   file_path, ".*.sh.rst")
    if not is_success:
        log.error(dev_obj, "Get collect_disk_smart_info.sh.rst File failed.")
    result = (is_success, rst_file_list)
    return result


def read_file(dev_obj, source_file, part=0):
    if not is_parse_rst:
        return util.readFile(dev_obj, source_file)
    else:
        return read_rst_file(dev_obj, source_file, part)


def read_rst_file(dev_obj, source_file, part=0):
    """
    801,810的samrt信息通过巡检完成。输出结果为rst文件,整合了3个文件内容
    文件构成：
    basicinfo
    #######################splitline##########################
    smart
    #######################splitline##########################
    symmary
    #######################splitline##########################
    :param dev_obj: 收集设备
    :param source_file: 原始文件
    :param part: 0代表获取basicinfo，1代表获取smart，2代表获取summary
    :return: 指定的文件内容
    """
    is_success, summary = util.readFile(dev_obj, source_file)
    if not is_success:
        log.error(dev_obj, "Read file {} failed.".format(source_file))
        return False, ""
    all_parts = summary.encode("utf8").split(split_mark)
    if len(all_parts) < part + 1:
        log.error(dev_obj, "Read file {} for part {} failed.".format(source_file, part))
        return False, ""
    return True, all_parts[part]


def copy_smart_file_for_inspect(dev_obj, final_dir_path, smart_file_list):
    """
    读取节点的smart信息并写入结果文件
    节点名称在父目录，截取拼接为smart_ip.txt
    :param dev_obj: 收集设备
    :param final_dir_path: 结果目录
    :param smart_file_list: smart信息文件列表
    :return: 复制结果
    """
    write_result = True
    for smart_file in smart_file_list:
        is_success, smart = read_file(dev_obj, smart_file, 1)
        if not is_success:
            continue
        paths = smart_file.split(os.sep)
        parent_name = paths[len(paths) - 2]
        temp_name = "smart_{}.txt".format(parent_name)
        temp_path = os.path.join(final_dir_path, temp_name)
        if not util.writeFile(dev_obj, temp_path, smart, False):
            write_result = False
    return write_result
