# -*- coding: UTF-8 -*-
import sys
import resource
import re
import os
import codecs
import traceback
class log():
    
    """
            功能：日志记录函数的子函数，用于获取调用函数和调用行号
            参数： MAX_CALLER_LEVEL：最大调用关系层数
            返回值：调用函数信息
    """
    @staticmethod
    def getCallerInfo(MAX_CALLER_LEVEL=5, skipLastLevel=True):
        #从堆栈中获取调用函数和行号
        
        #初始化参数
        funcBack = sys._getframe().f_back
        if True == skipLastLevel: #忽略最近的调用关系
            funcBack = funcBack.f_back
            MAX_CALLER_LEVEL -= 1
        
        #生成函数调用关系
        callerInfo = ""    
        for index in range(0, MAX_CALLER_LEVEL):
        
            #获取该级调用函数和行号
            if hasattr(funcBack, "f_code") and hasattr(funcBack, "f_lineno"):
                funcName = funcBack.f_code.co_name
                lineNumber = funcBack.f_lineno
                callerInfo = " [" + str(funcName) + ":" +  str(lineNumber) + "]" + callerInfo
            else:
                break
            
            #刷新Back函数
            if hasattr(funcBack, "f_back"):
                funcBack = funcBack.f_back
            else:
                break
        
        #返回函数调用关系
        return callerInfo
    
    @staticmethod
    def debug(devObj, info):
        """
                    功能：记录调试信息info到工具日志中
                    参数：devObj = 工具上下文；info = 要记录的信息
                    返回值：True = 成功；False = 失败
        """
        logInfo = info + log.getCallerInfo()
        if "logger" in devObj:
            devObj.get("logger").debug('[ToolLog]:' + logInfo)
            return True
        else:
            raise Exception("[failed]: logger is inexisted. info=" + logInfo)
    
    @staticmethod
    def error(devObj, info):
        """
                    功能：记录错误信息info到工具日志中
                    参数：devObj = 工具上下文；info = 要记录的信息
                    返回值：True = 成功；False = 失败
        """
        logInfo = info + log.getCallerInfo()
        if "logger" in devObj:
            devObj.get("logger").error('[ToolLog]:' + logInfo)
            return True
        else:
            raise Exception("[failed]: logger is inexisted. info=" + logInfo)
        
    @staticmethod
    def info(devObj, info):
        logInfo = info + log.getCallerInfo()
        if "logger" in devObj:
            devObj.get("logger").info('[ToolLog]:' + logInfo)
            return True
        else:
            raise Exception("[failed]: logger is inexisted. info=" + logInfo)
        
    @staticmethod
    def warn(devObj, info):
        logInfo = info + log.getCallerInfo()
        if "logger" in devObj:
            devObj.get("logger").warn('[ToolLog]:' + logInfo)
            return True
        else:
            raise Exception("[failed]: logger is inexisted. info=" + logInfo)
        
class util():
    @staticmethod
    def getMsg(devObj, msg, args = ""):
        '''
        @summary: 获取资源信息
        @param cliRet: devObj = 上下文对象, msg = 资源脚本（resource.py）中对应的Key，args = 占位符对应的值
        @return: msg
        '''
        if  None == msg or "" == msg:
            return ""
        
        lang = devObj.get("lang")
        if resource.MESSAGES_DICT.has_key(msg):
            msgDict = resource.MESSAGES_DICT.get(msg)
            msg = msgDict[lang]
        
        #若占位符的值不为”“，则天冲高占位符
        if "" != args:
            msg = msg % args
            
        return msg
    @staticmethod
    def getHorizontalAddKeysCliRet(cliRet):
        '''
        @summary: 按逐行字典的方式获取水平表格形式的cli回显集合
        @param cliRet: cli回显
        @return: 将表格形式cli回显处理为以表头为key，以项值为键的字典集合,处理不正常时，同时返回表头列表(可以获得表头的原始顺序)，返回空集合
        '''
        try:
            headline = ""
            i = 0
            cliRetList = cliRet.encode("utf8").splitlines()
            for line in cliRetList:
                reg_headline = re.compile("^\s*-+(\s+-+)*\s*$")
                match_headline = reg_headline.search(line)
                if match_headline:
                    headline = match_headline.group()
                    break
                i += 1
            if headline == "" or i == 0 or i > len(cliRetList) - 1:
                return [], []
    
            title = cliRetList[i - 1]
            field_words = cliRetList[(i + 1):]
            reg_split = re.compile("\s*-+\s*")
            tuple_idxs = []
            start_pos = 0
            end_pos = 0
    
            while (start_pos <= len(headline)):
                match = reg_split.search(headline, start_pos)
                if match:
                    end_pos = match.end()
                    tuple_idxs.append((start_pos, end_pos))
                    start_pos = end_pos
                else:
                    break
    
            keys = []
            for item in tuple_idxs:
                key = title[item[0]:item[1]].strip()
                if keys.count(key):
                    key += "_" + str(str(keys).count(key + "_") + 1)
                keys.append(key.decode("utf8"))
    
            requiredLineLen = tuple_idxs[-1][0]
            dictList = []
            for line in field_words:
                #标题换行的场景
                if re.search("^-+(\s+-+)*\s*$", line):
                    continue
    
                if len(line.strip()) == 0:
                    continue
    
                if len(line) <= requiredLineLen:
                    continue
    
                vals = []
                for item in tuple_idxs:
                    vals.append(line[item[0]:item[1]].strip().decode("utf8"))
                dictList.append(dict(zip(keys, vals)))
    
            return dictList, keys
        except:
            return [], []
    @staticmethod    
    def writeFile(devObj, fileName, info, isAdd = True):
        '''
              向fileName文件中写入info内容,如果fileName不存在则创建该文件，
        isAdd表示打开方式，True为追加方式打开，False为覆盖方式打开。
        '''    
        try:
            #判断是否为追加内容
            if isAdd:
                fileHandle = codecs.open(fileName, "a", "utf-8")
            else:
                fileHandle = codecs.open(fileName, "w", "utf-8")
            fileHandle.write(info)
            fileHandle.flush()
            return True
        except:
            log.info(devObj, "write file failed because %s"%str(traceback.format_exc()))
            return False
        finally:
            try:
                fileHandle.close()
            except:
                log.info(devObj, "Close file handle failed because %s"%str(traceback.format_exc()))
    @staticmethod
    def readFile(devObj, fileName):
        '''
              打开fileName文件并读取文件内容：
        '''    
        try:
            fileInfo = ""
            fileHandle = codecs.open(fileName, "r", "utf-8")
            fileInfo = fileHandle.read()
            return (True, fileInfo)
        except:
            log.info(devObj, "Read file failed because %s"%str(traceback.format_exc()))
            return (False, fileInfo)
        finally:
            try:
                fileHandle.close()
            except:
                log.info(devObj, "Close file handle failed because %s"%str(traceback.format_exc()))   