#coding: UTF-8

from java.io import File
import time
import traceback
import re
from time import sleep

# **************************************************************************** #
# 函数名称: isChinese
# 功能说明: 判断当前语言是否为中文
# 输入参数: devObj
# 输出参数: True or False
# **************************************************************************** # 
def isChinese(devObj):
    
    lang = devObj.get("lang")
    if "zh" == lang:
        return True
        
    return False

# **************************************************************************** #
# 函数名称: getMasterIp
# 功能说明: 获取阵列主控IP地址
# 输入参数: ssh
# 输出参数: 阵列主控IP地址
# **************************************************************************** # 
def getMasterIp(ssh):
    masterId=""
    ipAddress = "--"
    
    #获取主控ID信息
    cliRet = ssh.execCmd("show controller general") 
    list = cliRet.splitlines()
    for field in list:
        field = field.replace(" ","")
        if -1 != field.find("Controller:"):
            ControllerId = field.split("Controller:")[1]
        
        if -1 != field.find("Role:"):
            ctlRole = field.split("Role:")[1]
            if "Primary" == ctlRole:
                masterId = ControllerId
            break
        
    #获取主控IP信息 
    cliRet = ssh.execCmd("show controller ip "+masterId)
    list = cliRet.splitlines()
    for field in list:
        field = field.replace(" ","")
        if -1 != field.find("Address:"):
            temp = field.split("Address:")[1]
            if -1 == temp.find("--") or  -1 == temp.find(""):
                ipAddress = temp
    return ipAddress
     
# **************************************************************************** #
# **************************************************************************** #
# 函数名称: getIpList(ssh)
# 功能说明: 获取阵列的IP地址列表
# 输入参数: ssh
# 输出参数: 阵列IP地址列表
# **************************************************************************** # 
def getIpList(ssh):
    
    cliRet = ssh.execCmd("show controller ip") 
    list = cliRet.splitlines()
    
    #初始化过程变量
    ctrlId = ""
    ipv4Add = ""
    
    #返回信息
    nodeIpsDictList = []
    nodeIpsDict = {"node": "", "ipList": []}
    
    #获取控制器ID与ip的map关系
    for line in list:
        #获取控制器ID
        if re.search("Controller", line, re.IGNORECASE):
            ctrlId = line.split()[-1].strip()
            continue
        #获取IPV4地址
        elif re.search("IPv4 Address", line, re.IGNORECASE):
            ipv4Add = line.split()[-1].strip()
            #获取控制器ID与Ip对应关系，并保存到列表中
            if ipv4Add and len(ctrlId) == 2:
                #获取节点ID
                nodeId = ctrlId[0]
                
                #初始化信息
                nodeExist = False
                nodeIpsDict = {"node": "", "ipList": []}
                
                #更新已存在的节点信息
                for index in range(len(nodeIpsDictList)):
                    if nodeIpsDictList[index]["node"] == nodeId:
                        nodeExist = True
                        nodeIpsDictList[index]["ipList"].append(ipv4Add)
                        break
                #节点不存在，创建节点信息
                if not nodeExist:
                    nodeIpsDict["node"] = nodeId
                    nodeIpsDict["ipList"].append(ipv4Add)
                    nodeIpsDictList.append(nodeIpsDict)
                
                #初始化信息
                ctrlId = ""
                ipv4Add = ""                   
        else:
            continue
    
    return nodeIpsDictList

# **************************************************************************** #
# 函数名称: changeDeveloper2Debug(ssh)
# 功能说明: 从developer模式进入debug模式
# 输入参数: devObj
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** # 
def changeDeveloper2Debug(ssh,logger):
    logger.info("[Smart Info] try to chg to debug")
    flag = False
    temp = ssh.execCmd("debug")
    logger.info("[Smart Info] tmp ret is :"+temp)

    #判断是否进入到了debug模式
    if re.search(":/diagnose>", temp, re.IGNORECASE):
        logger.info("[Smart Info] debug come in")
        return True
    
    logger.info("[Smart Info] debug come in failed!")
    #切换失败重新回到CLI模式
    changeAnyModel2Cli(ssh)
    logger.info("[Smart Info] chg to CLI Suc")
    return False

# **************************************************************************** #
# 函数名称: changeDebug2Developer(ssh)
# 功能说明: 从debug模式退回到debug模式
# 输入参数: ssh
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** # 
def changeDebug2Developer(ssh):
    
    flag = False
    temp = ssh.execCmd("exit")
    #判断是否进入到了debug模式
    if re.search("developer:", temp, re.IGNORECASE):
        return True

    return False

# **************************************************************************** #
# 函数名称: changeCli2Developer
# 功能说明: 从CLI模式进入developer模式（需要确定使用之前为CLI模式）
# 输入参数: devObj
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** # 
def changeCli2Developer(devObj, ssh):
    flag = False
    developerPwd = devObj.get("developer")
    logger = devObj.get("logger")
    
    if developerPwd == None or developerPwd == "":
        return False

    temp=ssh.execCmd("change user_mode current_mode user_mode=developer")

    #判断是否已经developer模式
    if re.search("Password:", temp, re.IGNORECASE):
        temp2 = ssh.execCmdNoLog(developerPwd)
        if re.search("developer:", temp2, re.IGNORECASE):
            return True
    
    #进入developer模式失败，重新回到CLI模式
    changeAnyModel2Cli(ssh)
    return False

# **************************************************************************** #
# 函数名称: changeAnyModel2Cli
# 功能说明: 从任意模式退出到cli命令模式（不适用于心跳连接到对端的情况）
# 输入参数: ssh
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** # 
def changeAnyModel2Cli(ssh):
    counter = 0
    
    while True:
        temp = ssh.execCmdWithTimout("show system general", 180)
        #非developer模式下，cli回文正确，则认为回到了cli
        if re.search("System Name", temp, re.IGNORECASE) \
            and not re.search("developer:", temp, re.IGNORECASE):
                break
            
        #最小系统下要用login admin命令，exit会直接退出连接
        elif re.search("minisystem", temp, re.IGNORECASE):
            temp1 = ssh.execCmd("exit")
            if re.search("Are you sure", temp1, re.IGNORECASE):
                try:
                    ssh.execCmd("y")
                except:
                    ssh.reConnect()
        #os_only模式下直接退出
        elif re.search("-bash", temp, re.IGNORECASE):
            break
        #其他情况下，直接exit
        else:
            temp1 = ssh.execCmd("exit")
            if re.search("Are you sure", temp1, re.IGNORECASE):
                ssh.execCmd("y")
        
        #单控的命令模式最多4层
        counter += 1
        if counter >= 4:
            break

# **************************************************************************** #
# 函数名称: changeDeveloper2Minisystem
# 功能说明: 从developer模式进入minisystem模式（需要确定使用之前为developer模式）
# 输入参数: devObj
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** # 
def changeDeveloper2Minisystem(ssh):
    
    #进入minisystem
    temp = ssh.execCmdWithTimout("minisystem", 5)

    if re.search("minisystem>", temp, re.IGNORECASE):
        return True
    
    if re.search("Are you sure", temp, re.IGNORECASE):
        temp1 = ssh.execCmd("y")

        if re.search("minisystem>", temp1, re.IGNORECASE):
            return True

    return False

######################################################################
# 函数名称：deleteRemoteFile
# 功能说明：删除远端阵列上的文件
# 传入参数：devObj对象；type信息收集类型
# 返  回  值：True:执行成功；False:执行失败
######################################################################
def deleteRemoteFile(devObj, type):
    try:
        ssh = devObj.get("SSH")
        if type == "SYSCONFIG":
            del_type = "running_data"
        elif type == "ALM":
            del_type = "event"
        elif type == "DB":
            del_type = "configuration_data"
        elif type == "LOG" or type == "ALLLOG":
            del_type = "log"
        #delete export file in memory of device
        strCmd = "delete file " + "filetype=" + del_type
        ssh.execCmd(strCmd)
        return True
    except:
        devObj["py_detail"] = "catch except when delete remote file " + devObj.get("collecRemotePath") + "~~~over!"
        return False

def isValidCLIinfo(devObj, cliRet, type):       
    index_1 = cliRet.find("Error: Sftp put file failed")
    index_2 = cliRet.find("Error: Collection succeeded but the Sftp put file failed")
    index_3 = cliRet.find("Command executed successfully.")
    index_4 = cliRet.find("Collection succeeded and the command was successfully executed")
    index_5 = cliRet.find("Error: Part of information was successfully collected but the Sftp put file failed")
    index_6 = cliRet.find("Part of infomration was successfully collected and the command was successfully executed")
    index_7 = cliRet.find("Error: Sftp get file failed.")
    index_8 = cliRet.find("File Path : /OSM/export_import/")
    #系统未在正确模式下
    if -1 == cliRet.find(":/>"):
        return False
    
    if(-1 != cliRet.find("The system is busy. Please try again later")):
        return False
        
    if((-1 != cliRet.find("-bash: export")) or (-1 != cliRet.find("minisystem"))):
        return False
    
    if ((index_1 == -1) and (index_2 == -1) and (index_3 == -1) and (index_4 == -1) and (index_5 == -1) and (index_6 == -1) and (index_7 == -1)) and (index_8 == -1):
        deleteRemoteFile(devObj, type)
        return False
    return True