# -*- coding: UTF-8 -*-
from java.io import File
import codecs
import socket
import os
import shutil
import zipfile
import traceback
import tarfile
import re
import collectSmartInfo
import modelManager
from cbb.frame.util import public_ip_address_utils

#  使用ISM导出日志的时候失败 begin
G_STRCMD = "export "
PATH = "File Path :"
#  使用ISM导出日志的时候失败 end

G_ITEM_ALM = str("ALM")
G_ITEM_LOG = str("LOG")
G_ITEM_ALLLOG = str("ALLLOG")
G_ITEM_SYS = str("SYSCONFIG")
G_ITEM_DB = str("DB")
G_ITEM_ELABLE = str("ELABLE")
G_ITEM_CLICMD = str("CLICMD")
G_ITEM_SMART = str("SMART")
G_LOG_TIMO = 25 * 60

list_cli_cmd = ["show alarm",
                   "show bbu general",
                   "show bond_port",
                   "show cache_partition general",
                   "show clone general",
                   "show consistency_group general",
                   "show controller general",
                   "show disk general",
                   "show disk_domain general",
                   "show domain configuration",
                   "show enclosure",
                   "show event",
                   "show event_restore",
                   "show expansion_module",
                   "show fan",
                   "show host general",
                   "show host_group general",
                   "show initiator",
                   "show interface_module",
                   "show iostat policy",
                   "show iscsi initiator_name",
                   "show iscsi target",
                   "show iscsi target_name",
                   "show isns server_ip",
                   "show license",
                   "show license_active",
                   "show lun general",
                   "show lun_copy general",
                   "show lun_group general",
                   "show mapping_view general",
                   "show notification trap",
                   "show port general",
                   "show port_group general",
                   "show power_supply",
                   "show remote_device general",
                   "show remote_replication general",
                   "show schedule",
                   "show security_rule",
                   "show smartqos_policy general",
                   "show smartqos_template",
                   "show snapshot general",
                   "show snmp context_name",
                   "show snmp usm",
                   "show ssd routeswitch",
                   "show storage_engine",
                   "show storage_pool general",
                   "show system general",
                   "show system media_scan",
                   "show system ntp",
                   "show system timezone",
                   "show system manufactory",
                   "show upgrade package",
                   "show user",
                   "show version all"
                   ]

#需要进入developer模式发送的命令
list_developer_cmd = ["show dha judgeproportion", 
                      "show dha policy", 
                      "show dha servicestatus", 
                      "show mp_mode"
                    ]
list_multi_cli_cmd = ["show bbu general",
                      "show disk general",
                      "show enclosure",
                      "show expansion_module",
                   "show fan",
                   "show host general",
                   "show interface_module",
                   "show lun_copy general",
                   "show lun_group general",
                   "show mapping_view general",
                   "show power_supply",
                   "show storage_engine",
                   "show storage_pool general"
                   ]


list_elable_cmd = ["show controller general",
                   "show bbu general",
                   "show fan",
                   "show interface_module",
                   "show expansion_module"]
list_elable_property = ["Devive",
                        "BBU",
                        "FAN",
                        "INTERFACE_MODULE",
                        "EXPANSION_MODULE"]
list_multi_elable_cmd = ["show bbu general",
                  "show fan",
                  "show interface_module",
                  "show expansion_module"]

MAX_RETRYS = 5
CLI_RET_END_FLAG = ":/>"

myname = socket.getfqdn(socket.gethostname())
myaddr = socket.gethostbyname(myname)

# *************************************************************#
# 函数名称: changeDeveloperMode2Cli
# 功能说明: 从developer模式退回到Cli
# 其 他   :  无
# *************************************************************# 
def changeDeveloperMode2Cli(ssh):
    
    index =0
    cliRet = ssh.execCmdNoLog("show system general")
    #密码输入错误时及正常情况从developer模式下退出
    if -1 != cliRet.find("Password") or -1 != cliRet.find("developer:/>"):
        cliRet = ssh.execCmd("exit")
        PY_LOGGER.info("Sequence[5] change to cli model")
        while(-1 == cliRet.find("admin:/>")):
            index+=1
            cliRet = ssh.execCmd("exit")
            if -1!=cliRet.find("Are you sure to exit?(y/n):"):
                cliRet = ssh.execCmd("n")
            if index>MAX_RETRYS:
                break


# **************************************************************************** #
# 函数名称: CheckSystemNormal
# 功能说明: 检验当前设备是否normal
# 输入参数: devObj
# 输出参数: True, False
# **************************************************************************** # 
def CheckSystemNormal(devObj):
    
    flag = False
    ssh = devObj.get("SSH")
    
    cliRet = ssh.execCmd("show system general")
    if re.search("System Name", cliRet, re.IGNORECASE):
        flag = True
        
    return flag


# **************************************************************************** #
# 函数名称: getUserNameByCli
# 功能说明: 根据CLI回显获取用户名
# 输入参数: cli
# 输出参数: userName
# **************************************************************************** # 
def getUserNameByCli(cli):
    userName = ""

    #执行命令获取当前登录的用户名      
    cliRet = cli.execCmdNoLog("show system general")
    
    #输入CLI回显是否有效
    if None == cliRet or "" == cliRet: 
        return userName
    
    #执行命令获取当前登录的用户名      
    lineList = cliRet.splitlines()
    
    #用户名一定包含在最后一行中
    if -1 != lineList[-1].find(CLI_RET_END_FLAG):
        userName = lineList[-1].replace(" ","").replace(CLI_RET_END_FLAG,"")
    return userName


# **************************************************************************** #
# 函数名称: getUserName
# 功能说明: 获取登录用户名的权限级别
# 输入参数: devObj
# 输出参数: super_admin,guest或admin
# **************************************************************************** # 
def getUserPrivilege(devObj):
    
    userLevel = ""
    ssh = devObj.get("SSH")
    userName = devObj.get("username")
    if None == userName or "" == userName: 
        userName = getUserNameByCli(ssh)
    
    PY_LOGGER.info("Get login name is:"+str(userName))
    
    #获取权限级别
    cliRet = ssh.execCmd("show user user_name="+userName)
    lineList = cliRet.splitlines()
    
    #用户名一定包含在最后几行中
    for line in lineList[4:-1]:
        columnList = line.split()
        if len(columnList)>2:
            if userName == columnList[0]:
                userLevel = columnList[1]
                return userLevel
    return userLevel


# *************************************************************#
# 函数名称: changeCli2DeveloperMode
# 功能说明: 从cli进入developer模式的接口
# 其 他   :  无
# *************************************************************#  
def changeCli2DeveloperMode(ssh, developerPwd):

    #判断developer密码是否为空
    if None == developerPwd or "" == developerPwd :
        return False
    
    #发送命令
    cliRet = ssh.execCmd("change user_mode current_mode user_mode=developer")
    if not re.search("Password:", cliRet, re.IGNORECASE):
        return False
    
    cliRet = ssh.execCmdNoLog(developerPwd)
    if not re.search("developer:", cliRet, re.IGNORECASE):
        return False
    
    #模式切换成功
    return True

def func_fail_after_download(devObj, step):
    try:
        tar_class = devObj.get("PYENGINE.PY_ZIP")
        PY_LOGGER.info("handle failed. error code is " + step)
        if step == "step11":
            os.renames(devObj.get("collectRetDir") + "\\temp\\" + devObj["collectRetFileName"].replace(".tgz", ""), devObj.get("collectRetDir") + "\\temp\\DataCollect")
            write_version_file(devObj, "OceanStor 18000 V100R001C00")
            tar_class.compressFile(devObj.get("collectRetDir") + "\\" + devObj["collectRetFileName"].replace(".tgz", ".7z"), devObj.get("collectRetDir") + "\\temp")
            CleanDir(devObj, devObj.get("collectRetDir") + "\\temp")
        return (False, "")
    except:
        devObj["py_detail"] = "do compress file error. step : " + step
        return (False, "")

def write_version_file(devObj, verInfo):
    try:
        localDir = devObj.get("collectRetDir") + os.sep + "temp" + os.sep
        if not os.path.exists(localDir):
            os.mkdir(localDir)
        f = open(localDir + "DataCollect" + os.sep + "version", "w")
        
        f.write(verInfo)
        f.flush()
        f.close()
        return True
    except:
        lang = devObj.get("lang")
        if lang == "zh":
            devObj["py_detail"] = u"写版本文件失败。"
        else:
            devObj["py_detail"] = "Failed to write version to file."
        PY_LOGGER.info("[module1] catch except when write version info to file.")
        return False

# **************************************************************************** #
# 函数名称: adjustLogMessages
# 功能说明: 调整日志中的Messages文件夹内容：比如解压里面的部分压缩包
# 输入参数: 设备对象，Messages文件夹路径
# 输出参数: True:调整成功；False:调整失败
# **************************************************************************** #
def adjustLogMessages(devObj, pathOfMessages):
    lang = devObj.get("lang")
    TarTool = devObj.get("PYENGINE.PY_ZIP")

    try:
        #参数校验
        if not os.path.exists(pathOfMessages):
            PY_LOGGER.info("There is no path named:" + pathOfMessages)
            if lang == "zh":
                devObj["py_detail"] = u"路径" + pathOfMessages + u"不存在。"
            else:
                devObj["py_detail"] = "The path " + pathOfMessages + " does not exist."
            return False

        #将Messages目录下的子目录下的内容拷贝到Messages目录，以及将message压缩包解压并将包内的文件放到Messages目录
        listOfMessages = os.listdir(pathOfMessages)
        for elem in listOfMessages:
            elemInMessages = pathOfMessages + os.sep + elem
            #如果当前元素是目录，则将里面的内容拷贝到Messages目录下，然后删除该目录
            if os.path.isdir(elemInMessages):
                listInElem = os.listdir(elemInMessages)
                for fieldFile in listInElem:
                    shutil.copy(elemInMessages + os.sep + fieldFile, pathOfMessages)
                # add 20140217 Begin
                shutil.rmtree(elemInMessages, True)
                # add 20140217 End
                continue

            #过滤掉文件，只剩下压缩包
            pattern = "tgz"
            if not re.search(pattern, elem, re.IGNORECASE):
                continue
            
            #不是message压缩包不予解压
            if not elem.startswith("message_"):
                continue
                
            result = TarTool.decompressTarGzFile(elemInMessages, pathOfMessages)
            if not result:
                if lang == "zh":
                    devObj["py_detail"] = u"解压" + elemInMessages + u"失败。"
                else:
                    devObj["py_detail"] = "Failed to decompress package " + elemInMessages + "."
                return False
            
            #删除message压缩包
            os.remove(elemInMessages)
        
        return True
    except:
        PY_LOGGER.error("Catch except when adjust log file, trace back:" + traceback.format_exc())
        if lang == "zh":
            devObj["py_detail"] = u"调整日志文件出现异常。"
        else:
            devObj["py_detail"]= "Catch except when adjust log file."
        return False

def adjust_log_other(devObj, localDir_fourth_other):
    try:
        return (True, "")
    except:
        PY_LOGGER.info("catch except when adjust log file over!")
        return (False, "")

def adjust_log_file(devObj, localDir_third):
    try:
        passwd = devObj.get("decomp_pwd_new")
        PY_LOGGER.info("start to adjust log file:" + localDir_third)
        if os.path.exists(localDir_third + "\\msg_other.zip") != True:
            PY_LOGGER.info("have no log zip file, exit it.")
            return (True, "")
        localDir_fourth_message = localDir_third + "\\Messages"
        localDir_fourth_other = localDir_third + "\\Other"
        tar_class = devObj.get("PYENGINE.PY_ZIP")

        PY_LOGGER.info("decompress with password start~~")
        result = tar_class.decompressZipFile(localDir_third + "\\msg_other.zip", localDir_third, str(passwd))
        PY_LOGGER.info("decompress with password end~~")
        if result == False:
            step = "step4"
            func_fail_after_download(devObj, step)
            return (False, "")

        if os.path.exists(localDir_third + "msg_other.tar.bz2") != True:
            step = "step5"
            func_fail_after_download(devObj, step)
            return (False, "")
        
        PY_LOGGER.info("decompress with msg other.bz2 start~~")
        result = tar_class.decompressTarBz2File(localDir_third + "\\msg_other.tar.bz2", localDir_third)
        PY_LOGGER.info("decompress with msg other.bz2 end~~")
        if result == False:
            step = "step6"
            func_fail_after_download(devObj, step)
            return (False, "")

        if os.path.exists(localDir_fourth_message) != True:
            step = "step7"
            func_fail_after_download(devObj, step)
            return (False, "")
        if os.path.exists(localDir_fourth_other) != True:
            step = "step8"
            func_fail_after_download(devObj, step)
            return (False, "")
        PY_LOGGER.info("adjust log messages start~~")
        result = adjustLogMessages(devObj, localDir_fourth_message)
        PY_LOGGER.info("adjust log messages end~~")
        if result == False:
            step = "step9"
            func_fail_after_download(devObj, step)
            return (False, "")
        result = adjust_log_other(devObj, localDir_fourth_other)
        if result == False:
            step = "step9"
            func_fail_after_download(devObj, step)
            return (False, "")
        PY_LOGGER.info("del msg_other.zip start~~")
        os.remove(localDir_third + "\\msg_other.tar.bz2")
        os.remove(localDir_third + "\\msg_other.zip")
        PY_LOGGER.info("del msg_other.zip end~~")
        
        return (True, "")
    except Exception, exception:
        PY_LOGGER.error("catch except when adjust log file over! except trace back: {}".format(traceback.format_exc()))
        devObj["py_detail"]= "catch except when adjust log file over!"
        return (False, "")

def CleanDir(devObj,Dir):
    try:
        if os.path.isdir(Dir):
            paths = os.listdir(Dir)
            for path in paths:
                filePath = os.path.join(Dir, path)
                if os.path.isfile(filePath):
                    try:
                        os.remove(filePath)
                    except os.error:
                        PY_LOGGER.info("remove " + filePath + " error.")
                        return (False, "")
                elif os.path.isdir(filePath):
                    if filePath[-4:].lower() == ".svn".lower():
                        continue
                    shutil.rmtree(filePath, True)
            os.rmdir(Dir)
        else:
            return (False, "")
        return (True, "")
    except:
        devObj["py_detail"]= "clean dirs error."
        return (False, "")

def download_File(devObj, type):
    try:
        sftp = devObj.get("SFTP")
        localDir = devObj.get("collectRetDir") + "\\temp\\"
        flag = True
        try:
            #如果本地临时目录不存在，则创建
            if os.path.exists(localDir) != True:
                os.mkdir(localDir)
        except Exception, exception:
            flag = False
            PY_LOGGER.error("catch except when make local dir:" + localDir + " for downloading ~~~over!")
            PY_LOGGER.error("except arguement:" + str(exception.args) + "~~~over!")
            PY_LOGGER.error("except messages:" + str(exception))
            PY_LOGGER.error("except trace back:" + str(traceback.print_exc()))
            lang = devObj.get("lang")
            if lang == "zh":
                devObj["py_detail"] = u"在下载文件过程中创建目录：" + localDir + u"出现异常，请确认该目录可写！"
            else:
                devObj["py_detail"] = "Catch except when make local dir:" + localDir + \
                    " for downloading file, please check the dir writable"
        localPath = localDir + devObj.get("collectRetFileName")
        if True == flag:
            if "SVPLOG" == type:
                file = File(localDir + "svplog.zip")
                sftp.getFile("/OSM/export_import/svplog.zip", file, None)
            else:
                file = File(localPath)
                sftp.getFile(devObj.get("collecRemotePath"), file, None)
                PY_LOGGER.info("remote path is:" + devObj.get("collecRemotePath"))
        if "SYSCONFIG" == type:
            #将已经下载到本地的系统配置文件重命名
            if os.path.exists(localPath) == True:
                os.renames(localPath, localDir + "Config.txt")
        
        if False == flag:
            return False
        else:
            return True
    except:
        PY_LOGGER.info("except trace back:" + str(traceback.format_exc()))
        PY_LOGGER.info("catch except when download file " + devObj.get("collecRemotePath") + "~~~over!")
        lang = devObj.get("lang")
        if lang == "zh":
            devObj["py_detail"] = u"下载文件失败。"
        else:
            devObj["py_detail"] = "Failed to download file."
        return False

    
def func_after_download(devObj, type):
    try:
        if str(type) == str("ALM") or str(type) == str("ELABLE") or str(type) == str("DB") or str(type) == str("CLICMD"):
            PY_LOGGER.info("no need handle log collect.")
            return True
        lang = devObj.get("lang")
        flag_logexist = False
        flag_logdir_exist = False
        result = False
        third_dir_name_list = []
        localDir_third_list = []
        step = "default"
        tar_class = devObj.get("PYENGINE.PY_ZIP")
        localPath = "default"
        localFile_final = "default"
        #search tgz file in the temp dir to decompress it
        localDir = devObj.get("collectRetDir") + "\\temp\\"

        PY_LOGGER.info("local path of towar is:" + localDir)
        list = os.listdir(localDir)
        for field in list:
            if field.find(".tgz") != -1:
                flag_logexist = True
                localPath = localDir + field
                localFile_final = devObj.get("collectRetDir") + "\\" + field
                PY_LOGGER.info("path is:" + localFile_final)
                second_dir_name = field.replace(".tgz", "")
                break
            if field.find("Datacollect") != -1:
                if os.path.isdir(localDir + field) == True:
                    flag_logdir_exist = True
                    break

        if flag_logdir_exist == True:
            localDir_third_list_get = devObj.get("localDir_third")
            if localDir_third_list_get:
                for dir_name_get in localDir_third_list_get:
                    if type == "SYSCONFIG":
                        #文件保存路径不存在，则需要创建
                        if not os.path.exists(dir_name_get + "Config"):
                            os.mkdir(dir_name_get + "Config")
                        shutil.copy(localDir + "Config.txt", dir_name_get + "Config" + os.path.sep + "Config.txt")
            return True
            
        #if exist log dir, need to copy txt or dat file to correspond dir("\temp\second")
        if flag_logexist != True:
            PY_LOGGER.info("log zip file is not exist, may be user do not collect system log.")
            return True
        
        localDir_second = localDir + second_dir_name + "\\"
        if os.path.exists(localDir_second) != True:
            os.mkdir(localDir_second)
                
        #decompress tgz file to "\temp\second" dir
        result = tar_class.decompressZipFile(localPath, localDir_second)
        if result == False:
            #decompress fail, then compress temp dir to a new tgz file
            step = "step1"
            func_fail_after_download(devObj, step)
            return False
        os.remove(localPath)
        
        #search  "\temp\second" dir to find bz2 file and decompress it
        list2 = os.listdir(localDir_second)
        flag_bz2_exist = False
        for field_second in list2:
            if field_second.find(".bz2") != -1:
                flag_bz2_exist = True
                third_dir_name_list.append(field_second.replace(".tar.bz2", ""))
                PY_LOGGER.info("list in tar is:" + str(field_second.replace(".tar.bz2", "")))
                
        if flag_bz2_exist != True:
            step = "step2"
            func_fail_after_download(devObj, step)
            shutil.rmtree(localDir_second)
            PY_LOGGER.info("System log does not exist!")
            if lang == "zh":
                devObj["py_detail"] = u"系统日志不存在。"
            else:
                devObj["py_detail"] = "System log does not exist."
            return False
        
        infoLogFile = 'info_log.txt'
        #部分收集失败的信息
        collectFailInfo = ''
        #部分收集失败的项目编号
        item = 1        
        for third_dir_name in third_dir_name_list:

            #if find bz2 file, start to decompress to "\temp\second\third" dir
            localDir_third = localDir_second + third_dir_name + "\\"
            localDir_third_list.append(localDir_third)
            if os.path.exists(localDir_third) != True:
                os.mkdir(localDir_third)
            result = tar_class.decompressTarBz2File(localDir_second + third_dir_name + ".tar.bz2", localDir_third)

            if result == False:
                step = "step3"
                func_fail_after_download(devObj, step)
                return False
            #delete tar file
            os.remove(localDir_second + third_dir_name + ".tar.bz2")
            if type == "SYSCONFIG":
                #文件保存路径不存在，则需要创建
                if not os.path.exists(localDir_third + "Config"):
                    os.mkdir(localDir_third + "Config")
                shutil.copy(localDir + "Config.txt", localDir_third + "Config" + os.path.sep + "Config.txt")
                PY_LOGGER.info("copy " + localDir + "Config.txt to " + localDir_third + "Config\\")
            #adjust log file to messages dictionary
            adjust_log_file(devObj, localDir_third)
        #如果是系统日志收集，检查收集是否完全            
            if str(type) == str("LOG") or str(type) == str("ALLLOG"):
                if third_dir_name.endswith('_MAIN'):
                    controllerIP = third_dir_name[:-5]
                else:
                    controllerIP = third_dir_name
                #存在info_log.txt文件
                if infoLogFile in os.listdir(localDir_third):
                    fileTmp = open(localDir_third + infoLogFile)
                    collectLog = fileTmp.read()
                    fileTmp.close()
                    lines = collectLog.splitlines()
                    collectFailList = ''
                    for line in lines:
                        #如果某项收集结果不是ok，则表示该项收集失败
                        if line.strip().startswith("Slot ID is"):
                            break
                        if not line.strip().lower().endswith(" ok"):
                            if collectFailList == '':
                                collectFailList = line.split()[0]
                            else:
                                collectFailList += ', ' + line.split()[0]
                                
                    if collectFailList != '':
                        if lang == "zh":
                            collectFailInfo += str(item) + u' 控制器' + controllerIP + u'信息收集失败的项为：' + collectFailList + u'。\n'
                        else:
                            if len(collectFailList.split(',')) == 1:
                                collectFailInfo += str(item) + ' Controller ' + controllerIP + ' failed to collect information about item: ' +  collectFailList + '.\n'
                            else:
                                collectFailInfo += str(item) + ' Controller ' + controllerIP + ' failed to collect information about items: ' +  collectFailList + '.\n'
                        item +=1
                #不存在info_log.txt文件
                else:
                    if lang == "zh":
                        collectFailInfo += str(item) + u' 控制器' + controllerIP + u'信息收集失败。\n'
                    else:
                        collectFailInfo += str(item) + ' Failed to collect information of controller ' + controllerIP + '.\n'
                    item +=1        
        devObj["localDir_third"] = localDir_third_list
        
        #如果是系统日志收集，检查收集是否完全
        contrlOffLineInfo = ''
        svpLogInfo = ''
        ctrlCount = int(devObj.get("ctrlCount"))
        if str(type) == str("LOG") or str(type) == str("ALLLOG"):
            #检查是否有控制器不在位的情况
            if len(third_dir_name_list) != ctrlCount:
                if 0 == ctrlCount:
                    if lang == "zh":
                        contrlOffLineInfo = str(item) + u' 网络通信连接异常，无法判断所有控制器的系统日志是否都收集完成，请稍后重新收集。\n'
                    else:
                        contrlOffLineInfo = str(item) + ' The network communication is abnormal. Failed to check whether the system logs of all controllers are collected. Please collect system logs of controllers again later.\n'
                else:
                    if lang == "zh":
                        contrlOffLineInfo = str(item) + u' 部分控制器系统日志收集失败：可能存在离线控制器，控制器异常，或者网络通信连接异常。\n'
                    else:
                        contrlOffLineInfo = str(item) + ' Failed to collect the system logs of some controllers. Those controllers may go offline or become abnormal, or the network communication with those controllers is abnormal.\n' 
                item += 1
            if not os.path.exists(localDir + 'svplog.zip'):
                if lang == "zh":
                    svpLogInfo = str(item) + u' svp日志收集失败。\n'
                else:
                    svpLogInfo = str(item) + ' Failed to collect svp logs.\n'
                    
            allFailInfo = collectFailInfo + contrlOffLineInfo + svpLogInfo
            if allFailInfo != '':
                #设置部分收集成功
                devObj["collectAllInfo"] = False
                devObj["py_detail"] =  allFailInfo
        
        #调整交换机日志目录结构
        for field_second in list2:
            PY_LOGGER.info("enter switch log adjust method")
            if field_second.find("DSW") != -1:
                PY_LOGGER.info("switch log collected, switch log is:"+str(field_second))
                third_dir_name = field_second.replace(".tgz", "")
                PY_LOGGER.info("switch log list:" + str(field_second.replace(".tgz", "")))
                
                localDir_third = localDir_second + third_dir_name + "\\"
                if os.path.exists(localDir_third) != True:
                    PY_LOGGER.info("enter make dir localDir_third")
                    os.mkdir(localDir_third)
                    PY_LOGGER.info("make dir localDir_third success")
                localDir_DSW_messages =localDir_third +"messages\\"
                if os.path.exists(localDir_DSW_messages) != True:
                    PY_LOGGER.info("enter make dir localDir_DSW_messages")
                    os.mkdir(localDir_DSW_messages)
                    PY_LOGGER.info("make dir localDir_DSW_messages success")
                PY_LOGGER.info("file to decompress:"+str(localDir_second +field_second))
                PY_LOGGER.info("topath:"+localDir_DSW_messages)
                result = tar_class.decompressTarGzFile(localDir_second +field_second, localDir_DSW_messages)
                if result == False:
                    step = "step3"
                    func_fail_after_download(devObj, step)
                    return False
                PY_LOGGER.info("switch log adjust success")
                os.remove(localDir_second + field_second)
        return True
    except Exception, exception:
        PY_LOGGER.error("catch except when handle after download~~~!")
        PY_LOGGER.error("except arguement:" + str(exception.args) + "~~~over!")
        PY_LOGGER.error("except messages:" + str(exception))
        PY_LOGGER.error("except trace back:" + str(traceback.print_exc()))
        devObj["py_detail"] = "catch except when handle after download~~~!"
        return False

def is_multi_cmd(strCmd, type):
    try:
        flag = False
        list_cmd = None
        if type == str("ELABLE"):
            list_cmd = list_multi_elable_cmd
        elif type == str("CLICMD"):
            list_cmd = list_multi_cli_cmd
            
        for field in list_cmd:
            if field == strCmd or field.find(strCmd + "|") != -1:
                flag = True
                PY_LOGGER.info("multi cmd")
                return flag
        PY_LOGGER.info("single cmd")
        return flag
    except:
        flag = False
        PY_LOGGER.info("catch except when check if multi command~~~over!")
        return flag

def get_multi_cmd(devObj, strCmd, type):
    try:
        list_multi_cmd = []
        list_cmd = None
        ssh = devObj.get("SSH")
        if type == str("ELABLE"):
            list_cmd = list_multi_elable_cmd
        elif type == str("CLICMD"):
            list_cmd = list_multi_cli_cmd

        for element in list_cmd:
            PY_LOGGER.info("element is:" + element + ", " + strCmd)
            if element.find(strCmd) != -1:
                PY_LOGGER.info("comm element is:" + element + ", " + strCmd)
                if element.find("|") != -1:
                    PY_LOGGER.info("right is:" + element + ", " + strCmd)
                    list_tmp = element.split("|")
                    strCmd = list_tmp[1]
                    PY_LOGGER.info("strCmd is:" + strCmd)
                    break
        PY_LOGGER.info("final is:" + strCmd)
        cliRet = ssh.execCmd(strCmd)
        if cliRet == None:
            return strCmd
        if type == str("CLICMD"):
            flag = write_clicmd_file(devObj, cliRet)
        list_cliRet = cliRet.splitlines()
        i = 0
        for field in list_cliRet:
            i = i + 1
            if i < 5:
                continue
            if field.find("admin:/>") != -1 or field.find("developer:/>") != -1:
                continue
            list_field = field.split()
            list_multi_cmd.append(list_field[0])
        return list_multi_cmd
    except:
        PY_LOGGER.info("catch except when get multi command~~~over!")
        return strCmd

def get_product_info(devObj, strCmd, type):
    try:
        result = ""
        list_multi_cmd = []
        if strCmd == None:
            PY_LOGGER.info("get cmd is none")
            return result
        ssh = devObj.get("SSH")
        if False == is_multi_cmd(strCmd, type):
            result = ssh.execCmd(strCmd)
        else:
            list_multi_cmd = get_multi_cmd(devObj, strCmd, type)
        for field_cmd in list_multi_cmd:
            if strCmd.find("bbu") != -1:
                result = result + ssh.execCmd(strCmd + " " + "bbu_id=" + field_cmd)
            if strCmd.find("disk") != -1:
                result = result + ssh.execCmd(strCmd + " " + "disk_id=" + field_cmd)
            if strCmd.find("enclosure") != -1:
                result = result + ssh.execCmd(strCmd + " " + "enclosure_id=" + field_cmd)
            if strCmd.find("fan") != -1:
                result = result + ssh.execCmd(strCmd + " " + "fan_id=" + field_cmd)
            if strCmd.find("host") != -1:
                 result = result + ssh.execCmd(strCmd + " " + "host_id=" + field_cmd)
            if strCmd.find("interface_module") != -1:
                result = result + ssh.execCmd(strCmd + " " + "interface_module_id=" + field_cmd)
            if strCmd.find("expansion_module") != -1:
                result = result + ssh.execCmd(strCmd + " " + "expansion_module_id=" + field_cmd) 
            if strCmd.find("lun_copy") != -1:
                result = result + ssh.execCmd(strCmd + " " + "lun_copy_id=" + field_cmd) 
            if strCmd.find("lun_group") != -1:
                result = result + ssh.execCmd(strCmd + " " + "lun_group_id=" + field_cmd)
            if strCmd.find("mapping_view") != -1:
                result = result + ssh.execCmd(strCmd + " " + "mapping_view_id=" + field_cmd)
            if strCmd.find("power_supply") != -1:
                result = result + ssh.execCmd(strCmd + " " + "power_supply_id=" + field_cmd)
            if strCmd.find("storage_engine") != -1:
                result = result + ssh.execCmd(strCmd + " " + "storage_engine_id=" + field_cmd)
            if strCmd.find("storage_pool") != -1:
                result = result + ssh.execCmd(strCmd + " " + "pool_id=" + field_cmd)                       
        PY_LOGGER.info("execute result is:" + result)
        return result
    except:
        result = "default"
        PY_LOGGER.info("catch except when get product elable " + strCmd)
        return result

def write_elable_file(devObj, elableInfo):
    try:
        localTmpDir = devObj.get("collectRetDir") + os.sep + "temp" + os.sep
        if not os.path.exists(localTmpDir):
            os.mkdir(localTmpDir)
        
        f = codecs.open(localTmpDir + 'elable_info.txt', 'a', 'UTF-8')
        f.write(elableInfo)
        f.flush()
        f.close()
        return True
    except:
        PY_LOGGER.info("catch except when write elable info to file." + traceback.format_exc())
        lang = devObj.get("lang")
        if lang == "zh":
            devObj["py_detail"] = u"写电子标签文件失败。"
        else:
            devObj["py_detail"] = "Failed to write elabel to file."
        return False

def write_clicmd_file(devObj, cmdRet):
    try:
        localDir = devObj.get("collectRetDir") + os.sep + "temp" + os.sep
        if not os.path.exists(localDir):
            os.mkdir(localDir)
        
        f = codecs.open(localDir + 'clicmd.txt', 'a', 'UTF-8')
        f.write(cmdRet)
        f.flush()
        f.close()
        return True
    except:
        PY_LOGGER.info("catch except when write CLI info to file." + traceback.format_exc())
        lang = devObj.get("lang")
        if lang == "zh":
            devObj["py_detail"] = u"写CLI回显文件失败。"
        else:
            devObj["py_detail"] = "Failed to write CLI information to file."
        return False

def find_in_list(list_src, strInfo):
    try:
        i = 0
        for field in list_src:
            if field == strInfo:
                return i
            i = i + 1
        return -1
    except:
        PY_LOGGER.info("catch except when find info in list~~~over!")
        return -1

def get_field_type(atrribute_name):
    try:
        field_type = "string"
        return field_type
    except:
        PY_LOGGER.info("catch except when get field type~~~over!")
        return field_type

def parse_elable_info(strInfo, strProperty):
    try:
        result = "    <TABLE attribute=\"" + strProperty + "\">\n"
        result = result + "        <METADATA>\n"
        result = result + "        <FIELDS>\n"
        flag_start = False
        list_elable_key = []
        list_elable_value = []
        list = strInfo.splitlines()
        list_elable_value_num = 0
        for field in list:
            if field.find("Electronic Label") != -1:
                list_elable_value_num = list_elable_value_num + 1
                flag_start = True
            elif field.find(':/>') != -1: #包含':/>'说明该行已经是一条命令的结尾
                flag_start = False
            if flag_start == True:
                if field.find("=") != -1:
                    list_temp = field.split("=")
                    if -1 == find_in_list(list_elable_key, list_temp[0].replace(" ", "")):
                        list_elable_key.append(list_temp[0].replace(" ", ""))
                    list_elable_value.append(list_temp[1])
        if len(list_elable_key) == 0:
            result = result + "        </FIELDS>\n        </METADATA>\n    </TABLE>\n"
            return result
        i = 0
        j = 0
        value_max = 0
        for field in list_elable_key:
            result = result + "            <FIELD attribute = \"" + field
            for j in range(list_elable_value_num):
                if len(list_elable_value[i]) > value_max:
                    value_max = len(list_elable_value[i])
            result = result + "\" fieldtype = \"" + get_field_type(field) + "\" width = \"" + str(value_max) + "\" required=\"true\" />\n"
            i = i + 1
            value_max = 0
        result = result + "        </FIELDS>\n        </METADATA>\n        <ROWDATA>\n"
        i = 0
        for i in range(list_elable_value_num):
            result = result + "            <ROW "
            j = 0
            for field in list_elable_key:
                result = result + field + "=\""
                if list_elable_value[j + i * len(list_elable_key)] == None:
                    result = result + "\""
                    j = j + 1
                    continue
                result = result + list_elable_value[j + i * len(list_elable_key)] + "\" "
                j = j + 1
            result = result + " />\n"
        result = result + "        </ROWDATA>\n    </TABLE>\n"
        return result
    except:
        PY_LOGGER.error('[module1]parse_elable_info error:' + traceback.format_exc())
        return result


def export_elable(devObj, type):
    PY_LOGGER.info('Start to export elable file...')
    lang = devObj.get("lang")
    try:
        result = "default"
        flag = True
        list_header = ["<?xml version=\"1.0\" encoding=\"iso-8859-1\" standalone=\"yes\" ?> ",
                 "<DATAPACKET Version=\"2.0\">",
                 "<FILELABEL>",
                 "<VERDESC Ver=\"1.4\" />",
                 "</FILELABEL>",
                 "<TABLES>"]
        for field_header in list_header:
            flag = write_elable_file(devObj, field_header + "\n")
            if not flag:
                PY_LOGGER.error("[module1]Write elabel header to file failed")
                return False
        
        # 断网后电子标签显示收集成功 modified 20131221 Begin
        #添加cli回文是否正常判断标识位
        isCliRetNormal = False
        i = 0
        for field in list_elable_cmd:
            result = get_product_info(devObj, field, type)
            if result == "default":
                flag = False
                PY_LOGGER.info("[module1]get fail info by " + field)
                continue
            i = i + 1
            if len(list_elable_property) >= i:
                result = parse_elable_info(result, list_elable_property[i - 1])
            else:
                result = parse_elable_info(result, "default")
            flag = write_elable_file(devObj, result)
            if not flag:
                PY_LOGGER.error("[module1]Write elabel body to file failed by " + field)
                return False
            else:
                if not re.search("Error:", result, re.IGNORECASE):
                    isCliRetNormal = True
                elif re.search("license", result, re.IGNORECASE):
                    isCliRetNormal = True
        flag = write_elable_file(devObj, "</TABLES>\n</DATAPACKET>")
        if not flag:
            PY_LOGGER.error("[module1]Write elabel footer to file failed")
            return False
        flag = isCliRetNormal and flag
        # 断网后电子标签显示收集成功 modified 20131221 End
        return flag
    except:
        PY_LOGGER.info("catch except when export elable~~~over!" + traceback.format_exc())
        if lang == "zh":
            devObj["py_detail"] = u"获取电子标签失败。"
        else:
            devObj["py_detail"] = "Failed to obtain elabel."
        return False

def export_clicmd(devObj, type):
    PY_LOGGER.info('Start to export cli info file...')
    lang = devObj.get("lang")
    try:
        result = "admin:/>"
        flag = write_clicmd_file(devObj, result)
        if flag == False:
            PY_LOGGER.info("write to file fail by " + field)
            return flag
        
        #获取所有Cli模式下命令回文
        for field in list_cli_cmd:
            result = get_product_info(devObj, field, type)
            PY_LOGGER.info("result is:" + result)
            if result == "default":
                flag = False
                PY_LOGGER.info("get fail info by " + field)
                continue
            flag = write_clicmd_file(devObj, result)
            if flag == False:
                PY_LOGGER.info("write to file fail by " + field)
                return False
        #进入developer模式
        ssh = devObj.get("SSH")
        developerPwd = devObj.get("developer")
        changeFlag = changeCli2DeveloperMode(ssh, developerPwd)
        #切换到developer模式失败
        if not changeFlag:
            changeDeveloperMode2Cli(ssh)
            if lang == "zh":
                devObj["py_detail"] = u"【失败原因】：收集Cli命令回显信息成功。但是工具登录developer模式失败，导致不能收集developer命令回文。\n" \
                        + u"【操作建议】：请修改设备，输入正确的developer密码，并且确认当前登录的用户级别或者角色ID是否支持收集操作。"
            else:
                devObj["py_detail"] = "[Failure reason]: Collecting cli command information succeed. But logged in developer model failed and could not collect developer command information.\n" \
                        + "[Process suggestion]: Modify the device information, enter the correct password for logging in to the developer mode, and check whether the login user level or role ID supports information collection."
            return False
        
        #获取所有developer模式下命令回文
        for field in list_developer_cmd:
            result = get_product_info(devObj, field, type)
            PY_LOGGER.info("result is:" + result)
            if result == "default":
                flag = False
                PY_LOGGER.info("get fail info by " + field)
                continue
            flag = write_clicmd_file(devObj, result)
            if flag == False:
                PY_LOGGER.info("write to file fail by " + field)
                return False
        
        #收集完成，需要退回到Cli模式
        changeDeveloperMode2Cli(ssh)
        return flag
    except:
        PY_LOGGER.info("catch except when export clicmd~~~over!" + traceback.format_exc())
        devObj["py_detail"] = "catch except when execute module1~~~over~"
        if lang == "zh":
            devObj["py_detail"] = u"获取cli回显失败。"
        else:
            devObj["py_detail"] = "Failed to obtain cli information."
        return False

'''
下载系统config.txt文件，从文件中获取系统标配控制器个数
'''
def getCtrlCount(devObj, ssh):
    lang = devObj.get("lang")
    ctrlCount = 0
    confFile = devObj.get("collectRetDir") + "\\temp\\Config.txt"   
    try:
        ipAddr = public_ip_address_utils.get_export_config_used_ip()
        ipList = modelManager.getIpList(ssh)
        ipList.append(myaddr)   
        if ipAddr in ipList:
            ipAddr = public_ip_address_utils.get_export_event_used_ip()
                             
        cliRet = ssh.execCmd("show file export_path file_type=running_data")
        if -1 != cliRet.find("^"):
            strCmd_old = "export running_data ip=" + ipAddr + " user=admin password=****** running_data_file=/collect_sysconfig.txt clean_device_file=no"
            PY_LOGGER.info("The cli order is not supported by current divice, try old cli order:" + strCmd_old)
            cliRet = ssh.execCmd(strCmd_old)

        strRet = modelManager.isValidCLIinfo(devObj, cliRet, "SYSCONFIG")
        #导出文件失败，控制器个数置为0
        if strRet == False:
            PY_LOGGER.info("[getCtrlCount] Failed to get config file.")
            devObj["py_detail"] = cliRet
            return ctrlCount
        
        devObj["collecRemotePath"] = "/OSM/export_import/OSM_sysconfig.txt"
        devObj["collectRetFileName"] = "OSM_sysconfig.txt"
        strRet = download_File(devObj, "SYSCONFIG") 
        modelManager.deleteRemoteFile(devObj, "SYSCONFIG")       
        if strRet == False:
            return ctrlCount
        fileTmp = open(confFile)
        collectConfig = fileTmp.read()
        fileTmp.close()
        lines = collectConfig.splitlines()
        for line in lines:
            if line.find("Number of total controllers") != -1:
                ctrlCount = line.split(':')[1].strip()
                break
        return ctrlCount
    except:
        PY_LOGGER.info("[getCtrlCount] except trace back:" + str(traceback.format_exc()))
        return ctrlCount
    finally:
        #删除配置文件
        if os.path.exists(confFile):
            os.remove(confFile)

def execute(devObj, type):
    try:
        #为防止前一个收集项失败但错误信息未清空而后一个收集项也失败却没有写错误信息，导致错误信息误报
        devObj["py_detail"] = ""
        ssh = devObj.get("SSH")
        sftp = devObj.get("SFTP")
        lang = devObj.get("lang")
        flag = False
        isOldVersion = False
        
        strCmd_old = ""
        strCmd = ""
        cliRet = ""
        ipAddr = public_ip_address_utils.get_export_config_used_ip()
        ipList = modelManager.getIpList(ssh)
        ipList.append(myaddr)   
        if ipAddr in ipList:
            ipAddr = public_ip_address_utils.get_export_event_used_ip()
        
        #  使用ISM导出日志的时候失败 begin
        if type == "ALM":
            strCmd = "show file export_path file_type=event"
            strCmd_old = G_STRCMD + "event event_type=event " + "ip=" + ipAddr + " user=admin password=****** path=/collect_alm.tgz clean_device_file=no"
        if type == "LOG":
            strCmd = "show file export_path file_type=log"
            strCmd_old = G_STRCMD + "event event_type=log " + "ip=" + ipAddr + " user=admin password=****** path=/collect_log.tgz clean_device_file=no"
        if type == "ALLLOG":
            PY_LOGGER.info("CMD : show file export_path file_type=all_log")
            strCmd = "show file export_path file_type=all_log"
            
        if type == "SYSCONFIG":
            strCmd = "show file export_path file_type=running_data"
            strCmd_old = G_STRCMD + "running_data " + "ip=" + ipAddr + " user=admin password=****** running_data_file=/collect_sysconfig.txt clean_device_file=no"
        if type == "DB":
            strCmd = "show file export_path file_type=configuration_data"
            strCmd_old = G_STRCMD + "configuration_data " + "ip=" + ipAddr + " user=admin password=****** db_file=/collect_db.dat clean_device_file=no"
        
        
        if type == "ELABLE":
            strRet = export_elable(devObj, type)
            if strRet == False:
                return (False, "")
            else:
                return (True, "")
        if type == "CLICMD":
            strRet = export_clicmd(devObj, type)
            if strRet == False:
                return (False, "")
            else:
                return (True, "")
        #导出smart信息
        if type == "SMART":
            PY_LOGGER.info("[module] collect smart info start")
            strRet = collectSmartInfo.execute(devObj)
            if strRet == False:
                PY_LOGGER.info("[module] collect smart info failed")
                return (False, "")
            else:
                PY_LOGGER.info("[module] collect smart info successful")
                return (True, "")
            
        if type == "LOG":
            PY_LOGGER.info("collect recent log")
            cliRet = ssh.execCmdWithTimout(strCmd, G_LOG_TIMO)
        elif type == "ALLLOG":
            PY_LOGGER.info("collect all log")
            cliRet = ssh.execCmdWithTimout(strCmd, G_LOG_TIMO)
        else:
            cliRet = ssh.execCmd(strCmd)

        #The cli order is not supported by current divice, try old cli order
        if -1 != cliRet.find("^"):
            PY_LOGGER.info("The cli order is not supported by current divice, try old cli order")
            isOldVersion = True
            if type == "LOG":
                PY_LOGGER.info("collect recent log by old order: " + strCmd_old)
                cliRet = ssh.execCmdWithTimout(strCmd_old, G_LOG_TIMO)
            #如果收集所有日志的命令不存在则说明该版本不支持
            elif type == "ALLLOG":
                if lang == "zh":
                    devObj["py_detail"] = u"设备版本不支持所有日志收集。"
                else:
                    devObj["py_detail"] = "The device version does not support all log information collection."  
                return (False, "")
            
            else:
                PY_LOGGER.info("collect log by old order: " + strCmd_old)
                cliRet = ssh.execCmd(strCmd_old)

        
        strRet = modelManager.isValidCLIinfo(devObj, cliRet, type)
        if strRet == False:
            devObj["py_detail"] = cliRet
            return (False, "")
        
        if type == "ALM":
            devObj["collecRemotePath"] = "/OSM/export_import/event_export.tar"
            devObj["collectRetFileName"] = "event_export.tar"
        if type == "LOG" or type == "ALLLOG":
            #查询控制器个数
            devObj["ctrlCount"] = getCtrlCount(devObj, ssh)
            if isOldVersion:
                listInfo = sftp.listFiles("/OSM/export_import")
                for field in listInfo:
                    PY_LOGGER.info("file name in export_import is:" + field)
                    if field.find("Datacollect") != -1:
                        devObj["collecRemotePath"] = "/OSM/export_import/" + field        
                        devObj["collectRetFileName"] = field                   
            else:
                listInfo = cliRet.splitlines()
                for field in listInfo:
                    if (field.find("Datacollect") != -1):
                        controlLogPath = field.split("/")
                        PY_LOGGER.info("controlLog path:" + str(controlLogPath))
                        logName = controlLogPath[3]
                        PY_LOGGER.info("log name:" + logName)
                        devObj["collecRemotePath"] = "/OSM/export_import/" + logName        
                        devObj["collectRetFileName"] = logName
                    
        if type == "SYSCONFIG":
            devObj["collecRemotePath"] = "/OSM/export_import/OSM_sysconfig.txt"
            devObj["collectRetFileName"] = "OSM_sysconfig.txt"
        if type == "DB":
            devObj["collecRemotePath"] = "/OSM/export_import/db.dat"
            devObj["collectRetFileName"] = "db.dat"
        
        strRet = download_File(devObj, type)
        if type == "LOG" or type == "ALLLOG":
            download_File(devObj, "SVPLOG")
            
        #下载文件完后从阵列上删除对应文件
        modelManager.deleteRemoteFile(devObj, type)
        # 信息收集失败部分临时文件未删除  modified 20131201 End
        if strRet == False:
            return (False, "")

        strRet = func_after_download(devObj, type)
        if strRet == False:
            return (False, "")
        
        return (True, "")
    except Exception, exception:
        PY_LOGGER.error("catch except when execute module1~~~over~")
        PY_LOGGER.error("except arguement:" + str(exception.args) + "~~~over!")
        PY_LOGGER.error("except messages:" + str(exception))
        PY_LOGGER.error("except trace back:" + str(traceback.print_exc()))
        devObj["py_detail"] = "catch except when execute module1~~~over~"
        return (False, "")
        
def execute_alm(devObj):
    
    lang = devObj.get("lang")
    #检查系统是否Normal
    if not CheckSystemNormal(devObj):
        if lang == "zh":
            devObj["py_detail"] = u"当前系统状态异常，不能执行收集操作"
        else:
            devObj["py_detail"] = "The system is abnormal, can not support to collect"
        return (False, "")
    
    #guest用户不支持
    if getUserPrivilege(devObj) in ["Super_admin", "Admin"]:
        return execute(devObj, G_ITEM_ALM)
    else:
        if lang == "zh":
            devObj["py_detail"] = u"当前登录的用户级别不支持导出告警文件"
        else:
            devObj["py_detail"] = "The level of current user does not support to export alarm"
        return (False, "")
    
def execute_log(devObj):
    lang = devObj.get("lang")
    #检查系统是否Normal
    if not CheckSystemNormal(devObj):
        if lang == "zh":
            devObj["py_detail"] = u"当前系统状态异常，不能执行收集操作"
        else:
            devObj["py_detail"] = "The system is abnormal, can not support to collect"
        return (False, "")

    #guest用户不支持
    if getUserPrivilege(devObj) in ["Super_admin", "Admin"]:
        return execute(devObj, G_ITEM_LOG)
    else:
        if lang == "zh":
            devObj["py_detail"] = u"当前登录的用户级别不支持导出近期日志"
        else:
            devObj["py_detail"] = "The level of current user does not support to export recent log"
        return (False, "")

def execute_allLog(devObj):
    lang = devObj.get("lang")
    #检查系统是否Normal
    if not CheckSystemNormal(devObj):
        if lang == "zh":
            devObj["py_detail"] = u"当前系统状态异常，不能执行收集操作"
        else:
            devObj["py_detail"] = "The system is abnormal, can not support to collect"
        return (False, "")

    #guest用户不支持
    if getUserPrivilege(devObj) in ["Super_admin", "Admin"]:
        return execute(devObj, G_ITEM_ALLLOG)
    else:
        if lang == "zh":
            devObj["py_detail"] = u"当前登录的用户级别不支持导出所有日志"
        else:
            devObj["py_detail"] = "The level of current user does not support to export all log"
        return (False, "")

def execute_sysconfig(devObj):
    lang = devObj.get("lang")
    #检查系统是否Normal
    if not CheckSystemNormal(devObj):
        if lang == "zh":
            devObj["py_detail"] = u"当前系统状态异常，不能执行收集操作"
        else:
            devObj["py_detail"] = "The system is abnormal, can not support to collect"
        return (False, "")

    #guest用户不支持
    if getUserPrivilege(devObj) in ["Super_admin", "Admin"]:
        return execute(devObj, G_ITEM_SYS)
    else:
        if lang == "zh":
            devObj["py_detail"] = u"当前登录的用户级别不支持导出系统配置数据"
        else:
            devObj["py_detail"] = "The level of current user does not support to export system configuration"
        return (False, "")

def execute_db(devObj):
    lang = devObj.get("lang")
    #检查系统是否Normal
    if not CheckSystemNormal(devObj):
        if lang == "zh":
            devObj["py_detail"] = u"当前系统状态异常，不能执行收集操作"
        else:
            devObj["py_detail"] = "The system is abnormal, can not support to collect"
        return (False, "")

    #guest用户不支持
    if getUserPrivilege(devObj) in ["Super_admin"]:
        return execute(devObj, G_ITEM_DB)
    else:
        if lang == "zh":
            devObj["py_detail"] = u"当前登录的用户级别不支持导出DB数据"
        else:
            devObj["py_detail"] = "The level of current user does not support to export DB data"
        return (False, "")

def execute_elable(devObj):
    lang = devObj.get("lang")
    #检查系统是否Normal
    if not CheckSystemNormal(devObj):
        if lang == "zh":
            devObj["py_detail"] = u"当前系统状态异常，不能执行收集操作"
        else:
            devObj["py_detail"] = "The system is abnormal, can not support to collect"
        return (False, "")

    return execute(devObj, G_ITEM_ELABLE)

def execute_clicmd(devObj):
    lang = devObj.get("lang")
    #检查系统是否Normal
    if not CheckSystemNormal(devObj):
        if lang == "zh":
            devObj["py_detail"] = u"当前系统状态异常，不能执行收集操作"
        else:
            devObj["py_detail"] = "The system is abnormal, can not support to collect"
        return (False, "")
    
    return execute(devObj, G_ITEM_CLICMD)

def execute_smart(devObj):
    return execute(devObj, G_ITEM_SMART)
