#coding:utf-8

from java.io import File
import time
import traceback
import os
import shutil
from module1 import CleanDir

def get_product_pro(devObj,type):
    try:
        ssh = devObj.get("SSH")
        strCmd = "show system general"
        product_model="S5000T"
        product_sn = " 210235G"
        cliRet = str(ssh.execCmd(strCmd))
        list = cliRet.splitlines()
        for field in list:
            if type == "product_model":
                field = field.replace(" ", "")
                if field.find("ProductModel") != -1:
                    field = field.replace("ProductModel:", "")
                    product_model = field
                    return product_model
            if type == "product_sn":
                if field.find("SN") != -1:
                    field = field.replace(" ","")
                    field = field.replace("SN:", "")
                    product_sn = field
                    return product_sn
        return "default"
    except:
        result = "default"
        return result

def get_product_date():
    try:
        result = str(time.strftime('%Y%m%d%H%M%S',time.localtime(time.time())))
        return result
    except:
        PY_LOGGER.error("catch except when get current time.~~~over!")
        result = "20120512150000"
        return result

def write_version_file(devObj, strCmd):
    try:
        flag = True
        localDir = devObj.get("collectRetDir")+"\\temp\\"
        if True != os.path.exists(localDir):
            os.mkdir(localDir)
        f = open(localDir+"\\DataCollect\\version", "w")
        
        f.write(strCmd)
        f.close()
        return flag
    except:
        flag = False
        PY_LOGGER.error("catch except when write elable info to file.")
        return flag

def adjustSingleExportFile(devObj):
    try:
        localDir = devObj.get("collectRetDir")+"\\temp\\"
        curCtrlId = "default"
        masterCtrlId = "default"
        list_file = os.listdir(localDir)
        #CloudService工具收集四控设备的配置信息，收集到了8个IP信息 begin
        ssh = devObj.get("SSH")
        strCmd = "show controller general"
        cliRet = str(ssh.execCmd(strCmd))
        list_cliRet = cliRet.splitlines()
        for field in list_cliRet:
            if len(field) < 1:
                continue
            if field.find(" ") != -1:
                field = field.replace(" ", "")
            if field.startswith("Controller"):
                list_ctrl = field.split(":")
                PY_LOGGER.info("1 is:"+list_ctrl[0])
                curCtrlId = list_ctrl[1]
            if field.startswith("Role"):
                list_role = field.split(":")
                if(list_role[1] == "Master"):
                    masterCtrlId = curCtrlId
                    PY_LOGGER.info("master id is:"+masterCtrlId)
                    
        strCmd = "show upgrade package"
        list_controller = []
        list_cliRetRow = []
        cliRet = str(ssh.execCmd(strCmd))
        list_cliRet = cliRet.splitlines()
        PY_LOGGER.info("show upgrade package cli return~~~"+str(list_cliRet))
        i = 0
        for field in list_cliRet:
            i = i + 1
            if i>5 and i < (len(list_cliRet)+1):
                if str(field).find("HotPatch Version")!=-1:
                    break
                PY_LOGGER.info("show upgrade package every column"+field)  
                if len(field) < 1:
                    continue
                list_cliRetRow = field.split(" ")  
                PY_LOGGER.info("find a controller~~~"+str(list_cliRetRow))          
                curCtrlId = list_cliRetRow[4]
                ctrlIp = list_cliRetRow[8]
                PY_LOGGER.info("find a controller ip and role~~~"+ctrlIp+curCtrlId)
                if curCtrlId == masterCtrlId:
                    ctrlIp = ctrlIp+"_MAIN"
                    PY_LOGGER.info("find a main controller~~~"+ctrlIp)
                list_controller.append(ctrlIp)
        #CloudService工具收集四控设备的配置信息，收集到了8个IP信息 end        
        for field in list_controller:       
            if os.path.exists(localDir+"\\DataCollect") == False:
                os.mkdir(localDir+"\\DataCollect")
            if os.path.exists(localDir+"\\DataCollect\\"+field) == False:
                os.mkdir(localDir+"\\DataCollect\\"+field)
            if os.path.exists(localDir+"\\DataCollect\\"+field+"\\Event") == False:
                os.mkdir(localDir+"\\DataCollect\\"+field+"\\Event")
            if os.path.exists(localDir+"\\DataCollect\\"+field+"\\Config") == False:
                os.mkdir(localDir+"\\DataCollect\\"+field+"\\Config")
            if os.path.exists(localDir+"\\DataCollect\\"+field+"\\Other") == False:
                os.mkdir(localDir+"\\DataCollect\\"+field+"\\Other")
            for field_file in list_file:
                if field_file == "event_export.tar":
                    shutil.copy(localDir+field_file, localDir+"\\DataCollect\\"+field+"\\Event\\")
                    continue
                if field_file == "Config.txt":
                    shutil.copy(localDir+field_file, localDir+"\\DataCollect\\"+field+"\\Config\\")
                    continue
                shutil.copy(localDir+field_file, localDir+"\\DataCollect\\"+field+"\\Other\\")

        flag = write_version_file(devObj, "OceanStor " + str(devObj.get("devNode").getDeviceType()) + " " + str(devObj.get("devNode").getProductVersion()))
        if flag == False:
            PY_LOGGER.info("write version file in single mode failed.")
 
        for field_file in list_file:
            os.remove(localDir+field_file)
            
        return True
    except Exception, exception:
        PY_LOGGER.error("catch except when adjust single export file. except trace back: {}"
                        .format(traceback.format_exc()))
        devObj["py_detail"] = "catch except when adjust single export file"
        return False

def creatPkginfo(rootPath, devObj):
    '''
    @summary: 创建与datacollect同级的目录pkginfo，用于表示该包是信息收集的包。
        pkginfo下有两个空文件
            type_collect: 信息收集的包
            domain_storage: 存储设备
    '''
    pkginfoPath = rootPath + os.sep + "pkginfo"
    typeFile = pkginfoPath + os.sep + "type_collect"
    domainFile = pkginfoPath + os.sep + "domain_storage"
    descFile = pkginfoPath + os.sep + "desc"
    snFmt = "deviceSN=${%s}\n"
    timeFmt = "fileCreateTime=%s"
    try:
        #如果pkginfo已存在，则需要先删除
        if os.path.exists(pkginfoPath):
            shutil.rmtree(pkginfoPath, True)
            
        os.mkdir(pkginfoPath)
        #先创建type文件，然后拷贝type并重命名为domain文件
        fileObj = open(typeFile, "w")  
        fileObj.close()
        shutil.copy(typeFile, domainFile)

        #创建Desc文件并写入SN号和时间（UTC）
        #获取SN号和时间毫秒数
        snInfo = snFmt % str(getDeviceSn(devObj))
        timeInfo = timeFmt % str(long(time.time()*1000))
        desc_file = open(descFile, "w")
        seq = [snInfo,timeInfo]
        desc_file.writelines(seq)
        desc_file.close()

        PY_LOGGER.info( "[creatPkginfo] Creat the pkginfo succeed!")
    
    except:
        if os.path.exists(pkginfoPath):
            shutil.rmtree(pkginfoPath, True)
            
        PY_LOGGER.error( "[creatPkginfo] Creat the pkginfo failed! except trace back: " + str(traceback.format_exc()))

def getDeviceSn(devObj):
        '''
        获取设备SN号
        '''
        devNode = devObj.get("devNode")
        if None == devNode:
            return ""

        sn = devNode.getDeviceSerialNumber()
        return sn
    
def execute(devObj):
    try:
        localDir = devObj.get("collectRetDir")+"\\temp\\"
        flag_logexist = False
        localFile_final = "\\Datacollect_S5000T_21035000000.tgz"
        tar_class = devObj.get("PYENGINE.PY_ZIP")
        list = os.listdir(localDir)
        for field in list:
            PY_LOGGER.info("file name is:"+field)
            if field.find("Datacollect") != -1:
                PY_LOGGER.info("name is:"+field)
                flag_logexist = True
                if field.find(".tgz") != -1:
                    localFile_final = field.replace(".tgz", ".7z")
                else:
                    localFile_final = field+".7z"
                    os.renames(localDir+field, localDir+"DataCollect")
                PY_LOGGER.info("path is:"+localFile_final)
                break
        if flag_logexist == False:
            adjustSingleExportFile(devObj)
            product_model = get_product_pro(devObj, "product_model")
            product_sn = get_product_pro(devObj, "product_sn")
            product_time = get_product_date()
            localFile_final = "Datacollect_"+product_model+"_"+product_sn+"_"+product_time+".7z"
            PY_LOGGER.info("tar file is:"+localFile_final)
        else:
            list_file_tempDir = os.listdir(localDir)
            list_file_DatacollectDir = os.listdir(localDir+"DataCollect")
            for field in list_file_tempDir:
                PY_LOGGER.info("tar file is:"+field)
                PY_LOGGER.info("tar file is:"+str(list_file_tempDir))
                if field.find("DataCollect") != -1:
                    continue
                if (field.find("svplog.zip") != -1):
                    PY_LOGGER.info("copy svplog to DataCollect dir:"+str(field))
                    shutil.move(localDir+field, localDir+"DataCollect")
                    continue
                for field_temp in list_file_DatacollectDir:
                    if (field_temp.find("DSW") != -1):
                        PY_LOGGER.info("Ignore Switch dir:"+str(field_temp))
                        continue
                    PY_LOGGER.info("tar file is:"+field_temp)
                    PY_LOGGER.info("tar file is:"+str(list_file_DatacollectDir))
                    if field == "event_export.tar":
                        if os.path.exists(localDir+"\\DataCollect\\"+field_temp+"\\Event\\"+field) == False:
                            shutil.copy(localDir+field, localDir+"\\DataCollect\\"+field_temp+"\\Event\\")
                            continue
                    if field == "Config.txt":
                        if os.path.exists(localDir+"\\DataCollect\\"+field_temp+"\\Config\\"+field) == False:
                            shutil.copy(localDir+field, localDir+"\\DataCollect\\"+field_temp+"\\Config\\")
                            continue
                    if os.path.exists(localDir+"\\DataCollect\\"+field_temp+"\\Other\\"+field) == False:
                        shutil.copy(localDir+field, localDir+"\\DataCollect\\"+field_temp+"\\Other\\")
                os.remove(localDir+field)

            flag = write_version_file(devObj, "OceanStor " + str(devObj.get("devNode").getDeviceType()) + " " + str(devObj.get("devNode").getProductVersion()))
            if flag == False:
                PY_LOGGER.info("write version file in regular mode failed.")
        
        creatPkginfo(localDir,devObj)
        result = tar_class.compressFile(devObj.get("collectRetDir") + "\\" + localFile_final, localDir)
        CleanDir(devObj, localDir)
        devObj["collectRetFileName"] = localFile_final

        return (True, "")
    except Exception, exception:
        PY_LOGGER.error("catch except when compress file.~~~over!")
        PY_LOGGER.error("except arguement:"+str(exception.args)+"~~~over!")
        PY_LOGGER.error("except messages:"+str(exception))
        PY_LOGGER.error("except trace back:"+str(traceback.print_exc()))
        devObj["py_detail"] = "catch except when compress file.~~~over!"
        return (False, "")
