﻿# -*- coding: UTF-8 -*-
from java.io import File
import time
import traceback
import modelManager
from cbb.frame.util import public_ip_address_utils


G_RETRY_TIMES = 5

def get_product_pro(devObj,type):
    try:
        ssh = devObj.get("SSH")
        strCmd = "show system general"
        product_model="S5000T"
        product_sn = " 210235G"
        cliRet = ssh.execCmd(strCmd)
        list = cliRet.splitlines()
        for field in list:
            if type == "product_model":
                field = field.replace(" ", "")
                if field.find("ProductModel") != -1:
                    field = field.replace("ProductModel:", "")
                    product_model = field
                    return product_model
            if type == "product_sn":
                if field.find("SN") != -1:
                    field = field.replace(" ","")
                    field = field.replace("SN:", "")
                    product_sn = field
                    return product_sn
        return "default"
    except Exception, e:
        PY_LOGGER.error("[compress] get_product_pro catch except:"+str(e))
        result = "default"
        return result


# **************************************************************************** #
# 函数名称: getDevIpList
# 功能说明: 获取阵列IP地址列表
# 输入参数: devObj
# 输出参数: 阵列IP地址列表
# **************************************************************************** #
def getDevIpList(devObj):
    ipList = []
    ssh = devObj.get("SSH")
    
    masterIp = modelManager.getMasterIp(ssh)
    PY_LOGGER.info("[compress] Get master ip address is:"+masterIp)
    if "--" !=masterIp:
        ipList.append(masterIp+"_MAIN")
        
        devIpList = modelManager.getIpList(ssh)
        for ipInfo in devIpList:
            if masterIp != ipInfo:
                PY_LOGGER.info("[compress] Insert ip address is:"+ipInfo)
                ipList.append(ipInfo)
    
    if 0 == len(ipList):
        PY_LOGGER.info("[compress] Get null ip address")
        ipList.append(
            public_ip_address_utils.get_default_ip_by_126_100() + "_MAIN")
        ipList.append(public_ip_address_utils.get_default_ip_by_127_101())
    return ipList

def get_product_date():
    try:
        result = str(time.strftime('%Y%m%d%H%M%S',time.localtime(time.time())))
        return result
    except Exception, e:
        PY_LOGGER.error("[compress] catch except when get current time.~~~over!"+str(e))
        result = "20120512150000"
        return result

def write_version_file(devObj, strCmd):
    try:
        flag = True
        localDir = devObj.get("collectRetDir")+"\\temp\\"
        if True != os.path.exists(localDir):
            os.mkdir(localDir)
        f = open(localDir+"\\DataCollect\\version", "w")
        
        f.write(strCmd)
        f.close()
        return flag
    except:
        flag = False
        PY_LOGGER.error("[compress] catch except when write elable info to file. {}".fromat(traceback.format_exc()))
        return flag

def adjustSingleExportFile(devObj):
    try:
        #存放日志的临时目录
        tempDir = devObj.get("collectRetDir")+"\\temp\\"
        list_temp_dir = os.listdir(tempDir)
        ip_list = getDevIpList(devObj)
        
        for field in ip_list:
            PY_LOGGER.info("[compress] Collect file path is:"+str(tempDir+"\\DataCollect\\"+field))
            if os.path.exists(tempDir+"\\DataCollect") == False:
                os.mkdir(tempDir+"\\DataCollect")
            if os.path.exists(tempDir+"\\DataCollect\\"+field) == False:
                os.mkdir(tempDir+"\\DataCollect\\"+field)
            if os.path.exists(tempDir+"\\DataCollect\\"+field+"\\Event") == False:
                os.mkdir(tempDir+"\\DataCollect\\"+field+"\\Event")
            if os.path.exists(tempDir+"\\DataCollect\\"+field+"\\Config") == False:
                os.mkdir(tempDir+"\\DataCollect\\"+field+"\\Config")
            if os.path.exists(tempDir+"\\DataCollect\\"+field+"\\Other") == False:
                os.mkdir(tempDir+"\\DataCollect\\"+field+"\\Other")
            for field_file in list_temp_dir:
                if field_file == "event_export.tar":
                    shutil.copy(tempDir+field_file, tempDir+"\\DataCollect\\"+field+"\\Event\\")
                    continue
                if field_file == "Config.txt":
                    shutil.copy(tempDir+field_file, tempDir+"\\DataCollect\\"+field+"\\Config\\")
                    continue
                if field_file == "disksmartinfo":
                    if os.path.exists(tempDir+field_file):
                        shutil.move(tempDir+field_file, tempDir+os.path.sep+"DataCollect"+os.path.sep+"disksmartinfo")
                    continue
                try:
                    shutil.copy(tempDir+field_file, tempDir+os.path.sep+"DataCollect"+os.path.sep+field+os.path.sep+"Other"+os.path.sep)
                except Exception,exception:
                    PY_LOGGER.error("[compress] Copy file[" + str(tempDir+field_file) + "] to [" + str(tempDir+os.path.sep + "DataCollect" + os.path.sep+field+os.path.sep + "Other" + os.path.sep) + "] catch exception")
                    PY_LOGGER.error("[compress] catch except when copy file, arguement:"+str(exception.args))
                    PY_LOGGER.error("[compress] catch except when copy file, messages:"+str(exception))
                    PY_LOGGER.error("[compress] catch except when copy file, trace back:"+str(traceback.print_exc()))
                    continue

        flag = write_version_file(devObj, "HVS V100R001C99")
        if flag == False:
            PY_LOGGER.info("[compress] write version file in single mode failed.")

        for field_file in list_temp_dir:
            if -1==(tempDir+field_file).find("disksmartinfo"):
                os.remove(tempDir+field_file)
        return True
    
    except Exception, exception:
        PY_LOGGER.error("[compress] catch except when adjust single export file. [compress] except trace back: {}"
                        .format(traceback.format_exc()))
        return False

def creatPkginfo(rootPath, devObj):
    '''
    @summary: 创建与datacollect同级的目录pkginfo，用于表示该包是信息收集的包。
        pkginfo下有两个空文件
            type_collect: 信息收集的包
            domain_storage: 存储设备
    '''
    pkginfoPath = rootPath + os.sep + "pkginfo"
    typeFile = pkginfoPath + os.sep + "type_collect"
    domainFile = pkginfoPath + os.sep + "domain_storage"
    descFile = pkginfoPath + os.sep + "desc"
    snFmt = "deviceSN=${%s}\n"
    timeFmt = "fileCreateTime=%s"
    try:
        #如果pkginfo已存在，则需要先删除
        if os.path.exists(pkginfoPath):
            shutil.rmtree(pkginfoPath, True)
            
        os.mkdir(pkginfoPath)
        #先创建type文件，然后拷贝type并重命名为domain文件
        fileObj = open(typeFile, "w")  
        fileObj.close()
        shutil.copy(typeFile, domainFile)

        #创建Desc文件并写入SN号和时间（UTC）
        #获取SN号和时间毫秒数
        snInfo = snFmt % str(getDeviceSn(devObj))
        timeInfo = timeFmt % str(long(time.time()*1000))
        desc_file = open(descFile, "w")
        seq = [snInfo,timeInfo]
        desc_file.writelines(seq)
        desc_file.close()

        PY_LOGGER.info( "[creatPkginfo] Creat the pkginfo succeed!")
    
    except:
        if os.path.exists(pkginfoPath):
            shutil.rmtree(pkginfoPath, True)
            
        PY_LOGGER.error( "[creatPkginfo] Creat the pkginfo failed! except trace back: " + str(traceback.format_exc()))

def getDeviceSn(devObj):
        '''
        获取设备SN号
        '''
        devNode = devObj.get("devNode")
        if None == devNode:
            return ""

        sn = devNode.getDeviceSerialNumber()
        return sn
    
def execute(devObj):
    try:
        tempDir = devObj.get("collectRetDir")+"\\temp\\"
        flag_logexist = False
        
        #收集的压缩包名字
        collectPagName = "\\Datacollect_S5000T_21035000000.tgz"
        tar_class = devObj.get("PYENGINE.PY_ZIP")
        list = os.listdir(tempDir)
        PY_LOGGER.info("[compress] Collect temp file path is:"+tempDir)
        
        for field in list:
            PY_LOGGER.info("[compress] File name is:"+field)
            
            #判断是否收集到了系统日志信息
            if field.find("Datacollect") != -1:
                flag_logexist = True
                if field.find(".tgz") != -1:
                    collectPagName = field.replace(".tgz", ".7z")
                else:
                    collectPagName = field+".7z"
                    renameResult= False
                    PY_LOGGER.info("[compress] "+str(tempDir+field)+": rename to :"+str(tempDir)+"DataCollect")
                    for index in range(0, G_RETRY_TIMES):
                        if renameResult==True:
                            break
                        else:
                           time.sleep(2) 
                        
                        PY_LOGGER.info("[compress] start to rename file:"+str(index))
                        try:
                            os.renames(tempDir+field, tempDir+"DataCollect")
                        except Exception,exception:
                            PY_LOGGER.error("[compress] [Compress.py] Catch except reason:"+str(exception))
                            continue
                        renameResult = True
                    if False==renameResult:
                        devObj["py_detail"] = "Rename file failed, please try it again."
                        return (False, "")
                    
                PY_LOGGER.info("[compress] path is:"+collectPagName)
                break
        if flag_logexist == False:
            adjustSingleExportFile(devObj)
            product_model = get_product_pro(devObj, "product_model")
            product_sn = get_product_pro(devObj, "product_sn")
            product_time = get_product_date()
            collectPagName = "Datacollect_"+product_model+"_"+product_sn+"_"+product_time+".7z"
            PY_LOGGER.info("[compress] tar file is:"+collectPagName)
        else:
            list_file_tempDir = os.listdir(tempDir)
            list_file_DatacollectDir = os.listdir(tempDir+"DataCollect")
            for field in list_file_tempDir:
                if field.find("DataCollect") != -1:
                    continue
                if field.find("disksmartinfo") != -1:
                    shutil.move(tempDir+field, tempDir+os.path.sep+"DataCollect"+os.path.sep+"disksmartinfo")
                    continue
                for field_temp in list_file_DatacollectDir:
                    if field == "event_export.tar":
                        if os.path.exists(tempDir+"\\DataCollect\\"+field_temp+"\\Event\\"+field) == False:
                            shutil.copy(tempDir+field, tempDir+"\\DataCollect\\"+field_temp+"\\Event\\")
                            continue
                    if field == "Config.txt":
                        if os.path.exists(tempDir+"\\DataCollect\\"+field_temp+"\\Config\\"+field) == False:
                            shutil.copy(tempDir+field, tempDir+"\\DataCollect\\"+field_temp+"\\Config\\")
                            continue
                    if os.path.exists(tempDir+"\\DataCollect\\"+field_temp+"\\Other\\"+field) == False:
                        shutil.copy(tempDir+field, tempDir+"\\DataCollect\\"+field_temp+"\\Other\\")
                if -1==field.find("disksmartinfo"):
                    os.remove(tempDir+field)

            flag = write_version_file(devObj, "HVS V100R001C99")
            if flag == False:
                PY_LOGGER.info("[compress] write version file in regular mode failed.")
        #创建pkginfo
        creatPkginfo(tempDir,devObj)

        for index in range(0, G_RETRY_TIMES):
            result = True
            PY_LOGGER.info("[compress] start to compress collect info.TIMES:"+str(index))
            try:
                result = tar_class.compressFile(devObj.get("collectRetDir") + "\\" + collectPagName, tempDir)
            except Exception,exception:
                PY_LOGGER.error("[compress] except reason:"+str(exception))
                continue
            PY_LOGGER.info("[compress] end to compress collect info. result:"+str(result))
            if result == True:
                break
            else:
                os.remove(devObj.get("collectRetDir") + "\\" + collectPagName)
                time.sleep(2)
                continue
        if result == False:
            os.remove(devObj.get("collectRetDir") + "\\" + collectPagName)
            devObj["py_detail"] = "Compress file failed, please try it again."
            result (False, "")
        CleanDir(tempDir)
        devObj["collectRetFileName"] = collectPagName

        return (True, "")
    except Exception, exception:
        PY_LOGGER.error("[compress] catch except when compress file.~~~over!")
        PY_LOGGER.error("[compress] except arguement:"+str(exception.args)+"~~~over!")
        PY_LOGGER.error("[compress] except messages:"+str(exception))
        PY_LOGGER.error("[compress] except trace back:"+str(traceback.print_exc()))
        return (False, "")
