﻿# -*- coding: UTF-8 -*-

from java.io import File
import time
import traceback
import re
from time import sleep

# **************************************************************************** #
# 函数名称: isChinese
# 功能说明: 判断当前语言是否为中文
# 输入参数: devObj
# 输出参数: True or False
# **************************************************************************** # 
def isChinese(devObj):
    
    lang = devObj.get("lang")
    if "zh" == lang:
        return True
        
    return False

# **************************************************************************** #
# 函数名称: getMasterIp
# 功能说明: 获取阵列主控IP地址
# 输入参数: ssh
# 输出参数: 阵列主控IP地址
# **************************************************************************** # 
def getMasterIp(ssh):
    masterId=""
    ipAddress = "--"
    
    #获取主控ID信息
    cliRet = ssh.execCmd("show controller general") 
    list = cliRet.splitlines()
    for field in list:
        field = field.replace(" ","")
        if -1 != field.find("Controller:"):
            ControllerId = field.split("Controller:")[1]
        
        if -1 != field.find("Role:"):
            ctlRole = field.split("Role:")[1]
            if "Primary" == ctlRole:
                masterId = ControllerId
            break
        
    #获取主控IP信息 
    cliRet = ssh.execCmd("show controller ip "+masterId)
    list = cliRet.splitlines()
    for field in list:
        field = field.replace(" ","")
        if -1 != field.find("Address:"):
            temp = field.split("Address:")[1]
            if -1 == temp.find("--") or  -1 == temp.find(""):
                #粗略进行IP地址有效性判断
                if 3==temp.count("."):
                    ipAddress = temp
    return ipAddress
     
# **************************************************************************** #
# 函数名称: getIpList
# 功能说明: 获取阵列的IP地址列表
# 输入参数: ssh
# 输出参数: 阵列IP地址列表
# **************************************************************************** # 
def getIpList(ssh):
    
    ipList =[]  
    cliRet = ssh.execCmd("show controller ip") 
    list = cliRet.splitlines()
    for field in list:
        field = field.replace(" ","")
        if -1 != field.find("Address:"):
            ipAddress = field.split("Address:")[1]
            if -1 == ipAddress.find("--") or  -1 == ipAddress.find(""):
                #粗略进行IP地址有效性判断
                if 3==ipAddress.count("."):
                    ipList.append(ipAddress)
    
    return ipList

# **************************************************************************** #
# 函数名称: changeCli2Developer
# 功能说明: 从CLI模式进入developer模式（需要确定使用之前为CLI模式）
# 输入参数: devObj
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** # 
def changeCli2Developer(devObj, ssh):
    flag = False
    developerPwd = devObj.get("developer")
    logger = devObj.get("logger")
    
    if developerPwd == None or developerPwd == "":
        return False

    temp=ssh.execCmd("developer")

    #判断是否已经developer模式
    if re.search("Password:", temp, re.IGNORECASE):
        temp2 = ssh.execCmdNoLog(developerPwd)
        if re.search("developer:", temp2, re.IGNORECASE):
            return True
    
    #进入developer模式失败，重新回到CLI模式
    changeAnyModel2Cli(ssh)
    return False

# **************************************************************************** #
# 函数名称: changeAnyModel2Cli
# 功能说明: 从任意模式退出到cli命令模式（不适用于心跳连接到对端的情况）
# 输入参数: ssh
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** # 
def changeAnyModel2Cli(ssh):
    
    counter = 0
    while True:
        temp = ssh.execCmdWithTimout("show system general", 10)
        #非developer模式下，cli回文正确，则认为回到了cli
        if re.search("System Name", temp, re.IGNORECASE) \
            and not re.search("developer:", temp, re.IGNORECASE):
                break
        #最小系统下要用login admin命令，exit会直接退出连接
        elif re.search("minisystem", temp, re.IGNORECASE):
            temp1 = ssh.execCmd("logincli")
        #os_only模式下直接退出
        elif re.search("-bash", temp, re.IGNORECASE):
            break
        #其他情况下，直接exit
        else:
            temp1 = ssh.execCmd("exit")
            if re.search("Are you sure", temp1, re.IGNORECASE):
                ssh.execCmd("y")
        
        #单控的命令模式最多4层
        counter += 1
        if counter >= 4:
            break

# **************************************************************************** #
# 函数名称: changeDeveloper2Minisystem
# 功能说明: 从developer模式进入minisystem模式（需要确定使用之前为developer模式）
# 输入参数: devObj
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** # 
def changeDeveloper2Minisystem(ssh):
    
    #进入minisystem
    temp = ssh.execCmdWithTimout("minisystem", 5)

    if re.search("minisystem>", temp, re.IGNORECASE):
        return True
    
    if re.search("Are you sure", temp, re.IGNORECASE):
        temp1 = ssh.execCmd("y")

        if re.search("minisystem>", temp1, re.IGNORECASE):
            return True

    return False
