#coding: UTF-8
from cbb.frame.util import file_operate_util
from java.io import File
import subprocess
import os
import sys
import time

strCmd = "sudo /opt/huawei/snas/bin/OceanStor9000_datacollect.sh"
remotePath = "/var/log/cm/DataCollect_OceanStor9000.zip"
fileName = "DataCollect_OceanStor9000.zip"

def execute_with_output(command):
    inputStream = os.popen(file_operate_util.get_safe_path(command), 'r')
    res = inputStream.read().strip("\n")
    status = inputStream.close()
    retVal = 0
    if None != status:
        retVal = os.WEXITSTATUS(status)
    return [retVal, res]
    
def runCmd(cmd):
    subproc = subprocess.Popen([cmd], stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.PIPE, shell=False)
    stdout = subproc.stdout
    stderr = subproc.stderr
    outinfo = stdout.readlines()
    errinfo = stderr.readlines()
    stdout.close()
    stderr.close()

    allinfo = []
    allinfo.extend(outinfo)
    allinfo.extend(errinfo)
    return allinfo

def execute(devObj):
    try:
        ssh = devObj.get("SSH")
        inputdict = devObj.get("SettingInfo")
        
        if inputdict:
            startTime = inputdict.get("startTime")
            endTime = inputdict.get("endTime")
            nodeid = inputdict.get("nodeid")
            modeList = inputdict.get("modeList")
            len = modeList.getSize()
        else:
            startTime = ""
            endTime = ""
            nodeid = ""
            modeList = ''
            len = 0
             
        mod = ""
        for i in range(0, len):
            mod += modeList.getElementAt(i) + ","
        if startTime == "" :
            startTime = "null"
        if endTime == "" :
            endTime = "null"
        if nodeid == "" :
            nodeid = "null"
        if mod == "" :
            mod = "kernel,platform,rpc,monitor,protocal"
        cmd = "sudo /opt/huawei/snas/bin/OceanStor9000_datacollect.sh '"+startTime+"' '"+endTime+"' '"+nodeid+"' \""+mod+"\" >> /tmp/result.txt"
        ssh.execCmdWithTimout(strCmd,60 * 120)
        strRet = str(ssh.execCmdWithTimout(cmd,60 * 120)) #瓒呮椂璁剧疆涓�0鍒嗛挓
        strRet = str(ssh.execCmdWithTimout("cat /tmp/result.txt",10))
        devObj["py_detail"] = strRet

        devObj["collectRemoteFileName"]=fileName
        devObj["collecRemotePath"]=remotePath
        return (True,"")
    except:
        devObj["py_detail"]='Python script execute Error.'
        return (False,"")