#!/usr/bin/env python
#coding: UTF-8
import os
import shutil
import traceback
import subprocess as subp


def execute(devObj):
    mylog = devObj.get("logger")
    try:
        sftp = devObj.get("SFTP")
        ssh = devObj.get("SSH")
        ssh.execCmdWithTimout("TMOUT=0", 60 * 30)
        localPath = os.path.join(devObj.get("collectRetDir"), devObj.get("collectRetFileName"))
        sftp.setRetryTimes(2)
        sftp.getFile(devObj.get("collecRemotePath"), localPath, None)
        if devObj.get("isTiming"):
            filter_disk_valid_info(devObj, localPath)
        mylog.info("the Timing collect End the log cutting")
        return (True, "")
    except Exception, e:
        mylog.error(str(e))
        return (False, "")


def filter_disk_valid_info(devObj, z_path):
    def remove_data(data_path):
        if os.path.isdir(data_path):
            try:
                shutil.rmtree(data_path, True)
            except:
                rm_cmd = "rd/s/q "+ data_path
                if os.path.isdir(data_path):
                    subp.call(rm_cmd)
                
        elif os.path.isfile(data_path):
            os.remove(data_path)

    def zip_extractall(z_path, unzip_dir):
        tar_class = devObj.get("PYENGINE.PY_ZIP")
        tar_class.decompressZipFile(z_path, unzip_dir)

    mylog = devObj.get("logger")
    mylog.info("the Timing collect start the log cutting")
    if os.path.exists(z_path):
        unzip_dir = os.path.dirname(z_path)
        unzip_data_dir = os.path.join(unzip_dir, "DataCollect")
        remove_data(unzip_data_dir)

        zip_extractall(z_path, unzip_dir)
        os.remove(z_path)

        # Cutting log
        if os.path.isdir(unzip_data_dir):
            # \DataCollect
            for dir_name in os.listdir(unzip_data_dir):
                if dir_name != "disksmartinfo":
                    remove_data(os.path.join(unzip_data_dir, dir_name))

        # repack
        z_exe_path = devObj.get("7z_command")
        cmd = z_exe_path+" a "+z_path+" "+unzip_data_dir
        subp.call(cmd)
        remove_data(unzip_data_dir)
