#coding: UTF-8
from java.io import File
import os
import sys
import time

remotePath = "/var/log/cm/DataCollect_OceanStorUDS.zip"
fileName = "DataCollect_OceanStorUDS.zip"

def execute(devObj):
    try:
        ssh = devObj.get("SSH")
        inputdict = devObj.get("SettingInfo")
        
        if inputdict:
            startTime = inputdict.get("startTime")
            endTime = inputdict.get("endTime")
            nodeid = inputdict.get("nodeid")
            modeList = inputdict.get("modeList")
            len = modeList.getSize()
        else:
            startTime = ""
            endTime = ""
            nodeid = ""
            modeList = ''
            len = 0
             
        mod = ""
        for i in range(0, len):
            mod += modeList.getElementAt(i) + ","
        if startTime == "" :
            startTime = "null"

        if endTime == "" :
            endTime = "null"

        if nodeid == "" :
            nodeid = "null"
        
        if mod == "" :
            mod = "DeviceManager_ToolKit,OceanStorOS,OM,MON_BJM,DFS_OBS,OSS,RPCUser,Hardware,OS,WorkLoad"

        ssh.execCmdWithTimout("rm -f /home/omuser/orderListTemp.ini",60 * 30)
        ssh.execCmdWithTimout("TMOUT=7500",60 * 30)
        
        cmd = 'sudo /opt/huawei/snas/bin/OceanStorUDS_datacollect.sh "%s" "%s" %s %s'%(startTime, endTime, "TestNode", mod)

        tempPath = os.path.dirname(__file__)
        tempFile = "orderListTemp.ini"
        filePath = str(tempPath) + "\\" + str(tempFile)
        desPath = "/home/omuser"
        
        fileHandle = open(filePath, 'w' ) 
        fileHandle.write("[startTime]=" + str(startTime) + "\n")
        fileHandle.write("[endTime]=" + str(endTime) + "\n")
        fileHandle.write("[nodeID]=" + str(nodeid) + "\n")
        fileHandle.write("[mode]=" + str(mod))
        fileHandle.close()
        
        sftp = devObj.get("SFTP")
        sftp.putFile(File(os.path.dirname(__file__) + r"\\orderListTemp.ini"), desPath , None)
                     
        strRet = str(ssh.execCmdWithKeepAlive(cmd,30,60 * 120))
        ErrorInfoList=''
        for line in strRet.splitlines():
            if line.find('CollectErrorInfo:')>=0:
                lineSplitStr = line.split(':')
                ErrorInfoList = ErrorInfoList + '\n' + lineSplitStr[1]

        if ErrorInfoList.strip()=='':
            devObj["py_detail"] = strRet
        else:
            devObj["py_detail"] = ErrorInfoList
            devObj["collectAllInfo"] = False

        devObj["collectRemoteFileName"]=fileName
        devObj["collecRemotePath"]=remotePath
        return (True,"")
    except:
        devObj["py_detail"]='Python script execute Error.'
        return (False,"")
