﻿#coding:utf-8
import codecs
from cbb.frame.util.tar_util import decompress_tar_all_file
import socket
import os
import time
from java.io import File
import re


#命令执行已经连续超时次数
SEND_CMD_TIME_OUT_COUNT = 0
#默认超时次数限制
SEND_CMD_TIME_OUT_COUNT_LIMIT = 2
#已经发生过执行命令连续超时的场景
SEND_CMD_TIME_OUT_EXCEPTION = False

#设备型号
#S5000系列
DeviceModelList4S5000 = ["S5300", "S5500", "S5600", "S6800E"]
#S2600系列
DeviceModelList4S2600 = ["S2600"]
#S2000系列
DeviceModelList4S2000 = ["S2100", "S2300", "S2300E"]


#S2000的版本都是102开头的
S2000_VERSION = "102"
#S2600的版本都是104开头的
S2600_VERSION = "104"
#S5000的版本都是103开头的
S5000_VERSION = "103"

#S5000V1R1的版本都是10301开头的
S5000R1_VERSION = "10301"
    
#1020125101之前的版本是OSM版本；1020125101及之后的版本，是ISM版本
#S2000R1的ISM版本,导出告警和导出日志都用exportalm命令
S2000R1_ISM_VERSION = "1020125101"

#1030115001之前的版本是OSM版本；1030115001及之后的版本，是ISM版本
#S5000R1的ISM版本,导出告警和导出日志都用exportalm命令
S5000R1_ISM_VERSION = "1030115001"  #1030115001之前的版本是OSM版本；1030115001及之后的版本，是ISM版本
    
#S2600 R2 的1.04.02.108.T01及后续版本, 对于告警和日志,使用TAR后缀
S2600R2_NEW_VERSION = "1040210801"

#基于设备类型和版本号，将设备分为几种类型
#相同的类型，对于export命令的处理方式相同
class DevVersionType:
    
    TypeUnKnown = ""
    #S2000型号
    S2000OSM = "S2000_OSM"    #OSM版本,导出告警和日志是不同的命令,无参数-t
    S2000ISM = "S2000_ISM"    #ISM版本,导出告警和日志是一条命令,要加参数-t
    
    #S2600型号
    S2600OLD = "S2600_OLD"  #S2600 R2 的1.04.02.108.T01之前的版本, 对于告警和日志,使用txt后缀
    S2600NEW = "S2600_NEW"  #S2600 R2 的1.04.02.108.T01及后续版本, 对于告警和日志,使用TAR后缀  
    
    #S5000型号
    S5000OSM = "S5000_OSM"    #OSM版本,导出告警和日志是不同的命令,无参数-t
    S5000ISM = "S5000_ISM"    #ISM版本,导出告警和日志是一条命令,要加参数-t

# **************************************************************************** #
# 函数名称: isChinese
# 功能说明: 判断当前语言是否为中文
# 输入参数: 设备对象
# 输出参数: True or False
# **************************************************************************** # 
def isChinese(devObj):
    
    lang = devObj.get("lang")
    if "zh" == lang:
        return True
        
    return False

# **************************************************************************** #
# 函数名称: getDeviceVersion
# 功能说明: 获取设备版本号
# 输入参数: ssh
# 输出参数: deviceVer
# **************************************************************************** # 
def getDeviceVersion(ssh):
    
    deviceVer = ""
    
    cliRet = execCmd(ssh, "showctrlinfo")
    if not re.search("Software Version", cliRet, re.IGNORECASE):
        return deviceVer
    
    lineList = cliRet.splitlines()
    for line in lineList:
        if re.search("Software Version", line, re.IGNORECASE):
            field = line.split("|")
            deviceVer = field[-1].strip()
            break
    
    #标准版本号转换
    deviceVer = deviceVer.replace(".", "").replace("T", "")
        
    return deviceVer


# **************************************************************************** #
# 函数名称: getDeviceType
# 功能说明: 获取设备型号
# 输入参数: ssh
# 输出参数: deviceType
# **************************************************************************** # 
def getDeviceType(ssh):
    
    deviceType = ""
    systemInfo = execCmd(ssh, "showsys")
    if not re.search("System Name", systemInfo, re.IGNORECASE):
        return deviceType
    
    #获取设备型号信息
    for line in systemInfo.splitlines():
        if re.search("Device Model", line, re.IGNORECASE):
            deviceType = line.split()[-1]
        
    return deviceType

# **************************************************************************** #
# 函数名称: getProductVersion
# 功能说明: 获取产品版本（到R版本）
# 输入参数: ssh
# 输出参数: productVersion
# **************************************************************************** # 
def getProductVersion(ssh):
    
    productVersion = ""
    systemInfo = execCmd(ssh, "showsys")
    if not re.search("System Name", systemInfo, re.IGNORECASE):
        return productVersion
    
    #获取设备型号信息
    for line in systemInfo.splitlines():
        if re.search("Product Version", line, re.IGNORECASE):
            productVersion = line.split()[-1][0:8]
        
    return productVersion


# **************************************************************************** #
# 函数名称: switchDeviceType
# 功能说明: 将设备型号归类（S2000、S2600、S5000）
# 输入参数: devObj
# 输出参数: True, False
# **************************************************************************** # 
def switchDeviceType(deviceType):
    
    if deviceType in DeviceModelList4S2000:
        deviceType = "S2000"
    elif deviceType in DeviceModelList4S2600:
        deviceType = "S2600"
    elif deviceType in DeviceModelList4S5000:
        deviceType = "S5000"
    else:
        deviceType = ""
        
    return deviceType


# **************************************************************************** #
# 函数名称: checkDeviceVersionType
# 功能说明: 获取设备的版本号类型
# 输入参数: devObj
# 输出参数: deviceType
# **************************************************************************** # 
def checkDeviceVersionType(devObj):
    
    deviceVer = ""
    versionType = DevVersionType.TypeUnKnown
    
    ssh = devObj.get("SSH")
    logger = devObj.get("logger")
    
    #获取设备版本号
    deviceVer = getDeviceVersion(ssh)
    logger.info("Got device version is:" + deviceVer)
    if not deviceVer:
        return versionType
    
    #根据设备类型和版本号归类
    #S5000
    if deviceVer.startswith(S5000_VERSION):
        #S5000 V1R1需要区分OSM版本和ISM版本
        if deviceVer.startswith(S5000R1_VERSION):
            if deviceVer >= S5000R1_ISM_VERSION:
                versionType = DevVersionType.S5000ISM
            else:
                versionType = DevVersionType.S5000OSM
        #特殊的：S5000 V1R2版本与OSM版本处理一致
        else:
            versionType = DevVersionType.S5000OSM

    #S2000（只有V1R1版本）
    elif deviceVer.startswith(S2000_VERSION):
        if deviceVer >= S2000R1_ISM_VERSION:
            versionType = DevVersionType.S2000ISM
        else:
            versionType = DevVersionType.S2000OSM
    #S2600    
    elif deviceVer.startswith(S2600_VERSION):
        if deviceVer >= S2600R2_NEW_VERSION:
            versionType = DevVersionType.S2600NEW
        else:
            versionType = DevVersionType.S2600OLD
    #未知
    else:
        versionType = DevVersionType.TypeUnKnown
    
    return versionType

# **************************************************************************** #
# 函数名称: writeInfoToFile
# 功能说明: 将信息写入到文件（isAppend=True为追加，False=覆盖）
# 输入参数: 文件路径，要写入的信息，追加(or覆盖)
# 输出参数: ""（表示无异常） 或 异常原因
# **************************************************************************** # 
def writeInfoToFile(filePath, info, isAppend):
    try:
        #按指定的文件写类型创建文件
        if isAppend:
            localFile = codecs.open(filePath, "a", "utf-8")
        else:
            localFile = codecs.open(filePath, "w", "utf-8")
            
        localFile.write(info)
        localFile.close()
        
        return ""
        
    except BaseException, e:
        return str(e)
    
    
# **************************************************************************** #
# 函数名称: getFailedInfoInWritingFile
# 功能说明: 获取需要显示的失败信息
# 输入参数: 设备对象，错误信息
# 输出参数: 需要显示的失败信息
# **************************************************************************** # 
def getDisplayFailedInfoInWritingFile(devObj, filePath, errMsg):
    errInfo = ""
    logger = devObj.get("logger")
    logger.error("[common] An anomaly occurs in writing file" + str(filePath) + ", the reason is:" + str(errMsg))

    if isChinese(devObj):
        errInfo = u"[错误] 写文件" + filePath + u"异常。"
    else:
        errInfo = "[ERROR] An anomaly occurs in writing file " + filePath + "."
    return errInfo


# **************************************************************************** #
# 函数名称: downloadFile
# 功能说明: 下载文件
# 输入参数: 设备对象，需要下载的文件目标路径，远端文件名称，远端文件所在目录
# 输出参数: 无
# **************************************************************************** # 
def downloadFile(devObj, localHostDir, fileName, remoteAlmDir):
    sftp = devObj.get("SFTP")
    logger = devObj.get("logger")
    localPath = localHostDir + os.path.sep + fileName
    file = File(localPath)
    ret = sftp.getFile(remoteAlmDir + fileName, file, None)
    logger.info("[SIC] The result of downloaded file is " + str(ret))
    return


# **************************************************************************** #
# 函数名称: decompressPkg
# 功能说明: 解压压缩(or归档)包
# 输入参数: 包路径，目标目录
# 输出参数: 成功与否，错误消息
# **************************************************************************** # 
def decompressPkg(pkgPath, destDir):
    return decompress_tar_all_file(pkgPath, destDir, "r"), ""

    
# **************************************************************************** #
# 函数名称: getHostIp
# 功能说明: 获取本机IP
# 输入参数: 无
# 输出参数: 本机IP
# **************************************************************************** #
def getHostIp():
    hostName = socket.getfqdn(socket.gethostname())
    hostIp = socket.gethostbyname(hostName)
    return hostIp


# **************************************************************************** #
# 函数名称: getCurTime
# 功能说明: 获取当前时间
# 输入参数: 显示格式
# 输出参数: 当前时间
# **************************************************************************** #
def getCurTime(formart=False):
    try:
        if not formart:
            strTime = time.strftime('%Y%m%d%H%M%S', time.localtime(time.time()))
        else:
            strTime = time.strftime(formart, time.localtime(time.time()))
        return strTime
    except BaseException, e:
        return ""

    
class TimeOutException(Exception):
    pass


def getCmdTimeOutErrMsg(devObj):
    if isChinese(devObj):
        devObj["py_detail"] = u"[错误] 连续多条命令执行超时。"
    else:
        devObj["py_detail"] = "[ERROR] Continuously executing multiple commands times out."
    return devObj["py_detail"]
            
            
def execCmd(ssh, cmd, timeOutLimit=SEND_CMD_TIME_OUT_COUNT_LIMIT):
    global SEND_CMD_TIME_OUT_COUNT
    global SEND_CMD_TIME_OUT_EXCEPTION
    #如果之前已经发生过超时异常，直接抛出异常
    if SEND_CMD_TIME_OUT_EXCEPTION:
        raise TimeOutException()
    temp = ssh.execCmd(cmd)
    if temp == "TOOLKIT_SEND_CMD_TIME_OUT" :
        SEND_CMD_TIME_OUT_COUNT += 1
        #执行命令后，确认当前发生了连续超时现象,大于等于timeOutLimit
        if SEND_CMD_TIME_OUT_COUNT >= timeOutLimit:
            SEND_CMD_TIME_OUT_EXCEPTION = True
            raise TimeOutException()
    else:#命令执行未超时，清零连续超时次数
        SEND_CMD_TIME_OUT_COUNT = 0
    return temp
    
    
def execCmdNoLog(ssh, cmd, timeOutLimit=SEND_CMD_TIME_OUT_COUNT_LIMIT):
    global SEND_CMD_TIME_OUT_COUNT
    global SEND_CMD_TIME_OUT_EXCEPTION
    #如果之前已经发生过超时异常，直接抛出异常
    if SEND_CMD_TIME_OUT_EXCEPTION:
        raise TimeOutException()
    temp = ssh.execCmdNoLog(cmd)
    if temp == "TOOLKIT_SEND_CMD_TIME_OUT" :
        SEND_CMD_TIME_OUT_COUNT += 1
        #执行命令后，确认当前发生了连续超时现象,大于等于timeOutLimit
        if SEND_CMD_TIME_OUT_COUNT >= timeOutLimit:
            SEND_CMD_TIME_OUT_EXCEPTION = True
            raise TimeOutException()
    else:#命令执行未超时，清零连续超时次数
        SEND_CMD_TIME_OUT_COUNT = 0
    return temp


def execCmdNoLogTimout(ssh, cmd, timeout, timeOutLimit=SEND_CMD_TIME_OUT_COUNT_LIMIT):
    global SEND_CMD_TIME_OUT_COUNT
    global SEND_CMD_TIME_OUT_EXCEPTION
    #如果之前已经发生过超时异常，直接抛出异常
    if SEND_CMD_TIME_OUT_EXCEPTION:
        raise TimeOutException()
    temp = ssh.execCmdNoLogTimout(cmd, timeout)
    if temp == "TOOLKIT_SEND_CMD_TIME_OUT" :
        SEND_CMD_TIME_OUT_COUNT += 1
        #执行命令后，确认当前发生了连续超时现象,大于等于timeOutLimit
        if SEND_CMD_TIME_OUT_COUNT >= timeOutLimit:
            SEND_CMD_TIME_OUT_EXCEPTION = True
            raise TimeOutException()
    else:#命令执行未超时，清零连续超时次数
        SEND_CMD_TIME_OUT_COUNT = 0
    return temp


def execCmdWithTimout(ssh, cmd, timeout, timeOutLimit=SEND_CMD_TIME_OUT_COUNT_LIMIT):
    global SEND_CMD_TIME_OUT_COUNT
    global SEND_CMD_TIME_OUT_EXCEPTION
    #如果之前已经发生过超时异常，直接抛出异常
    if SEND_CMD_TIME_OUT_EXCEPTION:
        raise TimeOutException()
    temp = ssh.execCmdWithTimout(cmd, timeout)
    if temp == "TOOLKIT_SEND_CMD_TIME_OUT" :
        SEND_CMD_TIME_OUT_COUNT += 1
        #执行命令后，确认当前发生了连续超时现象,大于等于timeOutLimit
        if SEND_CMD_TIME_OUT_COUNT >= timeOutLimit:
            SEND_CMD_TIME_OUT_EXCEPTION = True
            raise TimeOutException()
    else:#命令执行未超时，清零连续超时次数
        SEND_CMD_TIME_OUT_COUNT = 0
    return temp



            
        
    
    
    
    
    