#!/bin/bash
#########################################
#űܣ ϵͳпڴ,ڴ㹻0㷵1
#űΣ
#űߣ
#ű汾1.0
#########################################

#S5000R2(S6800E) ڴ飬㹻0㹻1
function S5000R2_check()
{
	echo freepages timeout=15> /proc/osp/bsp
	Mount_Point_Local=OSM/log_conf_local
	declare -i FREE_MEM=`free -m|grep ^Mem|awk '{print $4}'`
	declare -i L_COFFER_LOG_SIZE=$(du -sm  /$Mount_Point_Local | awk '{print $1}')
	
	declare -i L_LOG_MIN_SIZE=90
	
	declare -i L_LOG_DOUBLE_SIZE=150
	
	if (($L_LOG_DOUBLE_SIZE < $L_LOG_MIN_SIZE + $L_COFFER_LOG_SIZE));then
		L_LOG_DOUBLE_SIZE=$((L_LOG_MIN_SIZE+L_COFFER_LOG_SIZE))
	fi
	
	#ӼӡϢ
	echo "Check Standard: $L_LOG_DOUBLE_SIZE"
	echo "Actual Data : $FREE_MEM"
	if (($FREE_MEM < $L_LOG_DOUBLE_SIZE));then
	  return 1
	else
		return 0
	fi
}

#S5000R1S2000V1000 ڴ飬㹻0㹻1
function S5000R1_check()
{
	echo freepages timeout=15> /proc/osp/bsp
	Mount_Point_Local=OSM/log_conf_local
	declare -i FREE_MEM=0
	declare -i M_COFFER_LOG_SIZE=100
	declare -i DMESG_SIZE=10
	
	FREE_MEM=`free -m|grep ^Mem|awk '{print $4}'`
	typeset -i L_COFFER_LOG_SIZE=$(du -sm  /$Mount_Point_Local | awk '{print $1}')
	typeset -i L_LOG_SIZE=$(du -sm  /OSM/log | awk '{print $1}')
	MIN_MEM=`expr $DMESG_SIZE + $L_COFFER_LOG_SIZE + $L_LOG_SIZE`
	SINGLE_MEM=`expr $MIN_MEM + $M_COFFER_LOG_SIZE`
	
	#ӼӡϢ
	echo "Check Standard: $SINGLE_MEM"
	echo "Actual Data : $FREE_MEM"
	if [ $FREE_MEM -lt $SINGLE_MEM ];then
		return 1
	else
		return 0
	fi
}

#S2600R2 ڴ飬㹻0㹻1
function S2600R2_check()
{
	G_MOUNT_COFFER_LOG=/OSM/coffer_log
	echo freepages timeout=15> /proc/osp/bsp
	typeset -i L_FREE_MEM=$(free -m | grep Mem | awk '{print $4}')
	typeset -i L_COFFER_LOG_SIZE=$(du -sm $G_MOUNT_COFFER_LOG | awk '{print $1}')
	
	#ӼӡϢ
	declare -i L_CheckStandard=0
	L_CheckStandard=`expr $L_COFFER_LOG_SIZE + 40`
	echo "Check Standard: $L_CheckStandard"
	echo "Actual Data : $L_FREE_MEM"
	if ((L_FREE_MEM<L_CheckStandard)) ;then
	  return 1
	else
	  return 0
	fi
}

#S2600R1 ڴ飬㹻0㹻1
function S2600R1_check()
{
	typeset -i L_FREE_MEM=$(free -m | grep Mem | awk '{print $4}')
	
	#ӼӡϢ
	echo "Check Standard: 50"
	echo "Actual Data : $L_FREE_MEM"
	if ((L_FREE_MEM<50)) ;then
	  return 1
	else
	  return 0
	fi
}

#жS5000 R汾(
os_ver=`cat /proc/osp/bsp | grep Version | awk '{print $2}'`
os_ver=`echo ${os_ver:0:5}`
if [ $os_ver == 10101 ]; then
	S5000R1_check
	iRet=$?
	echo "Check Result: $iRet"
	exit  $iRet
elif [ $os_ver == 10201 ]; then
	S5000R1_check
	iRet=$?
	echo "Check Result: $iRet"
	exit $iRet
elif [ $os_ver == 10301 ]; then
	S5000R1_check
	iRet=$?
	echo "Check Result: $iRet"
	exit $iRet
elif [ $os_ver == 10302 ]; then
	S5000R2_check
	iRet=$?
	echo "Check Result: $iRet"
	exit $iRet
elif [ $os_ver == 10303 ]; then
	S5000R2_check
	iRet=$?
	echo "Check Result: $iRet"
	exit $iRet
else
  iRet=0	 	
fi

#жS2600R1汾
os_ver=`cat /proc/osp/bsp | grep Os_Version | awk '{print $2}'`
os_ver=`echo ${os_ver:0:5}`
if [ $os_ver == 10401 ]; then
	S2600R1_check
	iRet=$?
	echo "Check Result: $iRet"
	exit $iRet
fi

#жS2600R2汾
os_ver=`os_version.sh | grep Version | awk '{print $2}'`
os_ver=`echo ${os_ver:0:7}`
if [ $os_ver == "1.04.02" ]; then
	S2600R2_check
	iRet=$?
	echo "Check Result: $iRet"
	exit $iRet
fi

#汾ڴ㹻 
echo 0
exit 0
