﻿#coding: UTF-8

import traceback

#判断当前语言是否为中文
def isChinese(devObj):
    
    lang = devObj.get("lang")
    if "zh" == lang:
        return True
        
    return False

# **************************************************************************** #
# 函数名称: execute
# 功能说明: 清理设备临时文件
# 输入参数: devObj
# **************************************************************************** #
def execute(devObj):

    sftp = devObj.get("SFTP")
    logger = devObj.get("logger")
    
    try:
        collectRemotePath = devObj.get("collecRemotePath")
        
        #使用sftp自带接口删除远端临时文件
        if not collectRemotePath:
            logger.error("[deleteRemoteFile] delete file is:" + str(collectRemotePath))
            if isChinese(devObj):
                devObj["py_detail"] = u"[错误]文件名异常。"
            else:
                devObj["py_detail"] = "[Error] The name of file is error."
            return (False, devObj["py_detail"])
        else:
            sftp.deleteFile(collectRemotePath)
            return (True, "")
    except:
        logger.error("[deleteRemoteFile] except trace back:" + str(traceback.format_exc()))
        if isChinese(devObj):
            devObj["py_detail"] = u"[错误] 删除设备临时文件异常。"
        else:
            devObj["py_detail"] = "[Error] An exception occurred during cleanning the temporary files of the device."
        return (False, devObj["py_detail"])

