﻿#coding: UTF-8
import os
import stat
import time
import common
import shutil
import traceback
import modelManager
from common import TimeOutException
#所有数据存放顶层目录名称
G_ALL_DATA_DIRNAME = "DataCollect"

#BST信息收集目录名称
G_BST_DIRNAME = 'BSTinfo'
OS_OPEN_FLAGS = os.O_WRONLY | os.O_CREAT | os.O_TRUNC  # 写 | 创建并打开 | 截断
OS_OPEN_MODES = stat.S_IWUSR | stat.S_IRUSR  # 拥有者具有读写权限
isGeneralInfoCollSuc = True

# **************************************************************************** #
# 函数名称: initDataSaveDir
# 功能说明: 初始化数据存放目录
# 输入参数: 设备对象
# 输出参数: ""（初始化失败） 或BST信息存放路径
# **************************************************************************** # 
def initDataSaveDir(devObj):
    #获取或构造临时数据存放目录路径
    tmpDataCollectDir = devObj.get("tmpDataCollectDir")
    curTime = str(time.strftime('%Y%m%d%H%M%S',time.localtime(time.time())))
    tmpRootDir = devObj.get("collectRetDir") + os.sep + "tmpdir@" + curTime

    global isGeneralInfoCollSuc
    if not tmpDataCollectDir:
        #临时目录不存在时则创建并记入设备对象
        tmpDataCollectDir = tmpRootDir
        isGeneralInfoCollSuc = False
    
    #保证临时数据收集目录存在
    if not os.path.exists(tmpDataCollectDir):
        os.mkdir(tmpDataCollectDir)
        if not os.path.exists(tmpDataCollectDir):
            if common.isChinese(devObj):
                devObj["py_detail"] = u"[错误] 创建数据收集目录" + tmpDataCollectDir + u"失败。"
            else:
                devObj["py_detail"] = "[ERROR] Creating the data collect directory " + tmpDataCollectDir + " failed."
            return ""
    
    devObj["tmpDataCollectDir"] = tmpDataCollectDir
    #生成数据存放根目录
    tmpDir = tmpDataCollectDir + os.sep + G_ALL_DATA_DIRNAME
    if not os.path.exists(tmpDir):
        #如果目录不存在则创建
        os.mkdir(tmpDir)
        #如果创建不成功则返回
        if not os.path.exists(tmpDir):
            if common.isChinese(devObj):
                devObj["py_detail"] = u"[错误] 创建数据收集目录" + tmpDir + u"失败。"
            else:
                devObj["py_detail"] = "[ERROR] Creating the data save directory " + tmpDir + " failed."
            return ""
    
    #生成BST信息存放目录
    tmpDir = tmpDir + os.sep + G_BST_DIRNAME
    if not os.path.exists(tmpDir):
        #如果目录不存在则创建
        os.mkdir(tmpDir)
        #如果创建不成功则返回
        if not os.path.exists(tmpDir):
            if common.isChinese(devObj):
                devObj["py_detail"] = u"[错误] 创建BST信息收集目录" + tmpDir + u"失败。"
            else:
                devObj["py_detail"] = "[ERROR] Creating the BST information save directory " + tmpDir + " failed."
            return ""
    
    return tmpDir

# **************************************************************************** #
# 函数名称: handleBeforeErrorExit
# 功能说明: 收集错误退出前处理
# 输入参数: 设备对象，初始系统模式
# 输出参数: 无
# **************************************************************************** # 
def handleBeforeErrorExit(devObj):
    global isGeneralInfoCollSuc
    tmpDataCollectDir = str(devObj.get("tmpDataCollectDir"))
    if not isGeneralInfoCollSuc:    #系统信息收集失败或者未进行系统信息收集
        if "" != tmpDataCollectDir and os.path.exists(tmpDataCollectDir):
            shutil.rmtree(tmpDataCollectDir, True)
    else:
        if "" != tmpDataCollectDir and os.path.exists(tmpDataCollectDir):
            bstInfoDir = tmpDataCollectDir + os.sep + G_ALL_DATA_DIRNAME + os.sep + G_BST_DIRNAME
            shutil.rmtree(bstInfoDir, True)
    return

def execute(devObj):
    ssh = devObj.get("SSH")
    logger = devObj.get("logger")
    bstInfo = ''
    bstInfoFileObj = ''
    try:
        if not modelManager.changeMode2MML(devObj):
            return (False, '')
        bstInfo = common.execCmdNoLog(ssh,'bst enable 3')          #查看BST开关
        bstInfo += '\n' + common.execCmdNoLog(ssh,'bst showbst')   #查看阵列BST信息
        
        #初始化本地BST信息收集目录
        bstInfoDir = initDataSaveDir(devObj)
        if not bstInfoDir:
            logger.error("[Collect Information] BST information directory does not exist!")
            handleBeforeErrorExit(devObj)
            return (False, '')
        bstInfoFile = bstInfoDir + os.sep + 'BST_information.txt'
        
        bstInfoFileObj = os.fdopen(os.open(bstInfoFile, OS_OPEN_FLAGS, OS_OPEN_MODES), 'w')
        bstInfoFileObj.write(bstInfo)
        return (True, '')
    except TimeOutException:
        logger.error("[Collect BST Information] Execute command timeout:" + traceback.format_exc())
        return (False, common.getCmdTimeOutErrMsg(devObj))
    except:
        logger.error("[Collect Information] catch except of trace back:" + str(traceback.format_exc()))
        
        if common.isChinese(devObj):
            devObj["py_detail"] = u"[错误] 收集BST信息失败。"
        else:
            devObj["py_detail"] = "[Error] Failed to collect BST information."
        return (False, '')
    finally:
        try:
            modelManager.changeMode2CLI(devObj, False)     #切换到CLI模式
        except:
            logger.error("[Collect Information] change mode fail:{}".
                         format(str(traceback.format_exc())))
        if bstInfoFileObj:
            bstInfoFileObj.close() 
