﻿#coding: UTF-8
import os
import re
import time
import common
import shutil
import traceback
from common import TimeOutException

#所有数据存放顶层目录名称
G_ALL_DATA_DIRNAME = "DataCollect"

#系统日志收集目录名称
G_SYSLOG_DIRNAME = 'systemlogs'

isGeneralInfoCollSuc = True

# **************************************************************************** #
# 函数名称: initDataSaveDir
# 功能说明: 初始化数据存放目录
# 输入参数: 设备对象
# 输出参数: ""（初始化失败） 或系统日志存放路径
# **************************************************************************** # 
def initDataSaveDir(devObj):
    #获取或构造临时数据存放目录路径
    tmpDataCollectDir = devObj.get("tmpDataCollectDir")
    curTime = str(time.strftime('%Y%m%d%H%M%S',time.localtime(time.time())))
    tmpRootDir = devObj.get("collectRetDir") + os.sep + "tmpdir@" + curTime

    global isGeneralInfoCollSuc
    if not tmpDataCollectDir:
        #临时目录不存在时则创建并记入设备对象
        tmpDataCollectDir = tmpRootDir
        isGeneralInfoCollSuc = False
    
    #保证临时数据收集目录存在
    if not os.path.exists(tmpDataCollectDir):
        os.mkdir(tmpDataCollectDir)
        if not os.path.exists(tmpDataCollectDir):
            if common.isChinese(devObj):
                devObj["py_detail"] = u"[错误] 创建数据收集目录" + tmpDataCollectDir + u"失败。"
            else:
                devObj["py_detail"] = "[ERROR] Creating the data collect directory " + tmpDataCollectDir + " failed."
            return ""
    
    devObj["tmpDataCollectDir"] = tmpDataCollectDir
    #生成数据存放根目录
    tmpDir = tmpDataCollectDir + os.sep + G_ALL_DATA_DIRNAME
    if not os.path.exists(tmpDir):
        #如果目录不存在则创建
        os.mkdir(tmpDir)
        #如果创建不成功则返回
        if not os.path.exists(tmpDir):
            if common.isChinese(devObj):
                devObj["py_detail"] = u"[错误] 创建数据收集目录" + tmpDir + u"失败。"
            else:
                devObj["py_detail"] = "[ERROR] Creating the data save directory " + tmpDir + " failed."
            return ""
    
    #生成系统日志存放目录
    tmpDir = tmpDir + os.sep + G_SYSLOG_DIRNAME
    if not os.path.exists(tmpDir):
        #如果目录不存在则创建
        os.mkdir(tmpDir)
        #如果创建不成功则返回
        if not os.path.exists(tmpDir):
            if common.isChinese(devObj):
                devObj["py_detail"] = u"[错误] 创建系统日志收集目录" + tmpDir + u"失败。"
            else:
                devObj["py_detail"] = "[ERROR] Creating the system log save directory " + tmpDir + " failed."
            return ""
    
    r = r'tmpdir@[0-9]+\\' + G_ALL_DATA_DIRNAME + r'\\' + G_SYSLOG_DIRNAME
    tempDirNoRoot = re.findall(r, tmpDir)[-1]
    return tempDirNoRoot

# **************************************************************************** #
# 函数名称: handleBeforeErrorExit
# 功能说明: 收集错误退出前处理
# 输入参数: 设备对象，初始系统模式
# 输出参数: 无
# **************************************************************************** # 
def handleBeforeErrorExit(devObj):
    global isGeneralInfoCollSuc
    tmpDataCollectDir = str(devObj.get("tmpDataCollectDir"))
    if not isGeneralInfoCollSuc:    #系统信息收集失败或者未进行系统信息收集
        if "" != tmpDataCollectDir and os.path.exists(tmpDataCollectDir):
            shutil.rmtree(tmpDataCollectDir, True)
    else:
        if "" != tmpDataCollectDir and os.path.exists(tmpDataCollectDir):
            systemlogDir = tmpDataCollectDir + os.sep + G_ALL_DATA_DIRNAME + os.sep + G_SYSLOG_DIRNAME
            shutil.rmtree(systemlogDir, True)
    return

def execute(devObj):
    strError = ""
    ssh = devObj.get("SSH")
    userName = devObj.get('username')
    userPwd = devObj.get('password')
    logger = devObj.get("logger")
    command = 'exportalm -i 127.0.0.1' + ' -u ' + userName + ' -p ' + userPwd + ' -f /tmp/system_logs -t 2'
    remotePath = '/tmp/system_logs.tar'
    try:
        strRet = unicode(common.execCmdNoLog(ssh,command))
        r = "File was transfered successful"      #正确收集到系统日志的回显信息  
        if re.search(r, strRet, re.IGNORECASE):
            logger.info("[Collect Information] export system logs is successful!")
            #初始化本地系统日志收集目录
            localHostDir = initDataSaveDir(devObj)
            if not localHostDir:
                logger.error("[Collect Information] system log directory does not exist!")
                handleBeforeErrorExit(devObj)
                return (False, '')
            devObj["collectRetFileName"] = localHostDir + os.sep + 'system_logs.tar'
            devObj["collecRemotePath"] = remotePath            
            return (True, '')
        else:
            logger.error("[Collect Information] failed to export system logs.")
            replaceStr = " -p " + userPwd
            strRet = strRet.replace(replaceStr, " -p ******")
            if common.isChinese(devObj):
                strError = u'系统日志收集失败，请联系技术支持工程师协助处理。\n命令执行原始信息为：\n'
            else:
                strError = 'Failed to collect the system logs, please contacts the technical support engineer for help.\
                \nThe original information:\n'
            devObj["py_detail"] = strError + strRet
            return (False, '')
    except TimeOutException:
        logger.error("[Collect SysLog] Execute command timeout:" + traceback.format_exc())
        return (False, common.getCmdTimeOutErrMsg(devObj)) 
    except:
        strError = str(traceback.format_exc())
        logger.error("[Collect Information] catch except of trace back:" + strError)
        
        if common.isChinese(devObj):
            devObj["py_detail"] = u"[错误] 执行数据收集异常。"
        else:
            devObj["py_detail"] = "[ERROR] An exception occurred during executing data collecting."
        return (False, '')
