﻿#coding:utf-8
import codecs
from cbb.frame.util.tar_util import decompress_tar_all_file
import socket
import os
import time
from java.io import File
import traceback

#命令执行已经连续超时次数
SEND_CMD_TIME_OUT_COUNT = 0
#默认超时次数限制
SEND_CMD_TIME_OUT_COUNT_LIMIT = 2
#已经发生过执行命令连续超时的场景
SEND_CMD_TIME_OUT_EXCEPTION = False


# **************************************************************************** #
# 函数名称: isChinese
# 功能说明: 判断当前语言是否为中文
# 输入参数: 设备对象
# 输出参数: True or False
# **************************************************************************** # 
def isChinese(devObj):
    
    lang = devObj.get("lang")
    if "zh" == lang:
        return True
        
    return False


# **************************************************************************** #
# 函数名称: writeInfoToFile
# 功能说明: 将信息写入到文件（isAppend=True为追加，False=覆盖）
# 输入参数: 文件路径，要写入的信息，追加(or覆盖)
# 输出参数: ""（表示无异常） 或 异常原因
# **************************************************************************** # 
def writeInfoToFile(filePath, info, isAppend):
    try:
        #按指定的文件写类型创建文件
        if isAppend:
            localFile = codecs.open(filePath, "a", "utf-8")
        else:
            localFile = codecs.open(filePath, "w", "utf-8")
            
        localFile.write(info)
        localFile.close()
        
        return ""
        
    except BaseException, e:
        return str(e)
    
    
# **************************************************************************** #
# 函数名称: getFailedInfoInWritingFile
# 功能说明: 获取需要显示的失败信息
# 输入参数: 设备对象，错误信息
# 输出参数: 需要显示的失败信息
# **************************************************************************** # 
def getDisplayFailedInfoInWritingFile(devObj, filePath, errMsg):
    errInfo = ""
    logger = devObj.get("logger")
    logger.error("[common] An anomaly occurs in writing file " + filePath + ":" + str(errMsg))

    if isChinese(devObj):
        errInfo = u"[错误] 写文件" + filePath + u"异常。"
    else:
        errInfo = "[ERROR] An anomaly occurs in writing file " + filePath + "."

    return errInfo


# **************************************************************************** #
# 函数名称: downloadFile
# 功能说明: 下载文件
# 输入参数: 设备对象，需要下载的文件目标路径，远端文件名称，远端文件所在目录
# 输出参数: 无
# **************************************************************************** # 
def downloadFile(devObj, localHostDir, fileName, remoteAlmDir):
    sftp = devObj.get("SFTP")
    logger = devObj.get("logger")
    localPath = localHostDir + os.path.sep + fileName
    file = File(localPath)
    ret = sftp.getFile(remoteAlmDir + fileName, file, None)
    logger.info("[SIC] The result of downloaded file is " + str(ret))
    return


# **************************************************************************** #
# 函数名称: decompressPkg
# 功能说明: 解压压缩(or归档)包
# 输入参数: 包路径，目标目录
# 输出参数: 成功与否，错误消息
# **************************************************************************** # 
def decompressPkg(pkgPath, destDir):
    return decompress_tar_all_file(pkgPath, destDir, "r"), ""
    
    
# **************************************************************************** #
# 函数名称: getHostIp
# 功能说明: 获取本机IP
# 输入参数: 无
# 输出参数: 本机IP
# **************************************************************************** #
def getHostIp():
    hostName = socket.getfqdn(socket.gethostname())
    hostIp = socket.gethostbyname(hostName)
    return hostIp


# **************************************************************************** #
# 函数名称: getCurTime
# 功能说明: 获取当前时间
# 输入参数: 显示格式
# 输出参数: 当前时间
# **************************************************************************** #
def getCurTime(formart=False):
    try:
        if not formart:
            strTime = time.strftime('%Y%m%d%H%M%S', time.localtime(time.time()))
        else:
            strTime = time.strftime(formart, time.localtime(time.time()))
        return strTime
    except BaseException, e:
        return ""
    
class TimeOutException(Exception):
    pass


def getCmdTimeOutErrMsg(devObj):
    if isChinese(devObj):
        devObj["py_detail"] = u"[错误] 连续多条命令执行超时。"
    else:
        devObj["py_detail"] = "[ERROR] Continuously executing multiple commands times out."
    return devObj["py_detail"]
            
def execCmd(ssh, cmd, timeOutLimit=SEND_CMD_TIME_OUT_COUNT_LIMIT):
    global SEND_CMD_TIME_OUT_COUNT
    global SEND_CMD_TIME_OUT_EXCEPTION
    #如果之前已经发生过超时异常，直接抛出异常
    if SEND_CMD_TIME_OUT_EXCEPTION:
        raise TimeOutException()
    temp = ssh.execCmd(cmd)
    if temp == "TOOLKIT_SEND_CMD_TIME_OUT" :
        SEND_CMD_TIME_OUT_COUNT += 1
        #执行命令后，确认当前发生了连续超时现象,大于等于timeOutLimit
        if SEND_CMD_TIME_OUT_COUNT >= timeOutLimit:
            SEND_CMD_TIME_OUT_EXCEPTION = True
            raise TimeOutException()
    else:#命令执行未超时，清零连续超时次数
        SEND_CMD_TIME_OUT_COUNT = 0
    return temp
    
    
def execCmdNoLog(ssh, cmd, timeOutLimit=SEND_CMD_TIME_OUT_COUNT_LIMIT):
    global SEND_CMD_TIME_OUT_COUNT
    global SEND_CMD_TIME_OUT_EXCEPTION
    #如果之前已经发生过超时异常，直接抛出异常
    if SEND_CMD_TIME_OUT_EXCEPTION:
        raise TimeOutException()
    temp = ssh.execCmdNoLog(cmd)
    if temp == "TOOLKIT_SEND_CMD_TIME_OUT" :
        SEND_CMD_TIME_OUT_COUNT += 1
        #执行命令后，确认当前发生了连续超时现象,大于等于timeOutLimit
        if SEND_CMD_TIME_OUT_COUNT >= timeOutLimit:
            SEND_CMD_TIME_OUT_EXCEPTION = True
            raise TimeOutException()
    else:#命令执行未超时，清零连续超时次数
        SEND_CMD_TIME_OUT_COUNT = 0
    return temp


def execCmdNoLogTimout(ssh, cmd, timeout, timeOutLimit=SEND_CMD_TIME_OUT_COUNT_LIMIT):
    global SEND_CMD_TIME_OUT_COUNT
    global SEND_CMD_TIME_OUT_EXCEPTION
    #如果之前已经发生过超时异常，直接抛出异常
    if SEND_CMD_TIME_OUT_EXCEPTION:
        raise TimeOutException()
    temp = ssh.execCmdNoLogTimout(cmd, timeout)
    if temp == "TOOLKIT_SEND_CMD_TIME_OUT" :
        SEND_CMD_TIME_OUT_COUNT += 1
        #执行命令后，确认当前发生了连续超时现象,大于等于timeOutLimit
        if SEND_CMD_TIME_OUT_COUNT >= timeOutLimit:
            SEND_CMD_TIME_OUT_EXCEPTION = True
            raise TimeOutException()
    else:#命令执行未超时，清零连续超时次数
        SEND_CMD_TIME_OUT_COUNT = 0
    return temp


def execCmdWithTimout(ssh, cmd, timeout, timeOutLimit=SEND_CMD_TIME_OUT_COUNT_LIMIT):
    global SEND_CMD_TIME_OUT_COUNT
    global SEND_CMD_TIME_OUT_EXCEPTION
    #如果之前已经发生过超时异常，直接抛出异常
    if SEND_CMD_TIME_OUT_EXCEPTION:
        raise TimeOutException()
    temp = ssh.execCmdWithTimout(cmd, timeout)
    if temp == "TOOLKIT_SEND_CMD_TIME_OUT" :
        SEND_CMD_TIME_OUT_COUNT += 1
        #执行命令后，确认当前发生了连续超时现象,大于等于timeOutLimit
        if SEND_CMD_TIME_OUT_COUNT >= timeOutLimit:
            SEND_CMD_TIME_OUT_EXCEPTION = True
            raise TimeOutException()
    else:#命令执行未超时，清零连续超时次数
        SEND_CMD_TIME_OUT_COUNT = 0
    return temp
